//World.h
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _WORLD_H
#define _WORLD_H

#include <string>
#include <vector>
#include <SocketHandler.h>

	typedef std::vector<std::string> string_v;
	
class World
{
	struct CELL
	{
		CELL(int x,int y,const std::string& name) : m_x(x)
			,m_y(y),m_name(name)
			,m_n(false),m_s(false),m_e(false),m_w(false) {
//			printf("New cell@(%d,%d): %s\n",x,y,name.c_str());
		}
		int m_x;
		int m_y;
		std::string m_name;
		bool m_n;
		bool m_s;
		bool m_e;
		bool m_w;
	};
	typedef std::vector<CELL *> cell_v;

public:
	World(SocketHandler& );
	~World();

	void GetRandomLocation(int&,int&,std::string&);
	bool FindAt(int,int,std::string& );
	bool GetAt(int,int,std::string&,bool&,bool&,bool&,bool&);

	void AddAt(int,int,const std::string& );
	SocketHandler& Handler() { return m_handler; }

	void Open(int,int,const std::string& );

private:
	SocketHandler& m_handler;
	cell_v m_cells;
};




#endif // _WORLD_H
