//World.cpp
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//#include <stdio.h>

#include "World.h"




World::World(SocketHandler& h) : m_handler(h)
{
	CELL *p = new CELL(1000,1000,"The Beginning");
	m_cells.push_back(p);
}


World::~World()
{
	for (cell_v::iterator it = m_cells.begin(); it != m_cells.end(); it++)
	{
		CELL *p = *it;
		delete p;
	}
}


bool World::FindAt(int x,int y,std::string& str)
{
	for (cell_v::iterator it = m_cells.begin(); it != m_cells.end(); it++)
	{
		CELL *p = *it;
		if (p -> m_x == x && p -> m_y == y)
		{
			str = p -> m_name;
			return true;
		}
	}
	return false;
}


void World::GetRandomLocation(int& x,int& y,std::string& name)
{
	int i = random() % m_cells.size();
	CELL *p = m_cells[i];
	x = p -> m_x;
	y = p -> m_y;
	name = p -> m_name;
}


void World::AddAt(int x,int y,const std::string& name)
{
	CELL *p = new CELL(x,y,name);
	m_cells.push_back(p);
}


bool World::GetAt(int x,int y,std::string& str,bool& n,bool& s,bool& e,bool& w)
{
	for (cell_v::iterator it = m_cells.begin(); it != m_cells.end(); it++)
	{
		CELL *p = *it;
		if (p -> m_x == x && p -> m_y == y)
		{
			str = p -> m_name;
			n = p -> m_n;
			s = p -> m_s;
			e = p -> m_e;
			w = p -> m_w;
			return true;
		}
	}
	return false;
}


void World::Open(int x,int y,const std::string& dir)
{
	for (cell_v::iterator it = m_cells.begin(); it != m_cells.end(); it++)
	{
		CELL *p = *it;
		if (p -> m_x == x && p -> m_y == y)
		{
			if (dir == "north")
				p -> m_n = true;
			else
			if (dir == "south")
				p -> m_s = true;
			else
			if (dir == "east")
				p -> m_e = true;
			else
			if (dir == "west")
				p -> m_w = true;
			break;
		}
	}
}


