//SmallHandler.cpp
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//#include <stdio.h>

#include "SmallSocket.h"
#include "SmallHandler.h"




SmallHandler::SmallHandler()
:SocketHandler()
,m_world(*this)
,m_mob(m_world)
{
	m_persist.push_back(&m_pf);
}


SmallHandler::~SmallHandler()
{
}


void SmallHandler::Who(SmallSocket *p2)
{
	for (socket_m::iterator it = m_sockets.begin(); it != m_sockets.end(); it++)
	{
		Socket *p0 = (*it).second;
		SmallSocket *p = dynamic_cast<SmallSocket *>(p0);
		if (p)
		{
			p2 -> Send(p -> GetName() + "\n");
		}
	}
}


void SmallHandler::SecTick(time_t t)
{
	if (random() % 120 == 0)
	{
		m_mob.Spawn();
	}
	else
	if (random() % 5 == 0)
	{
		m_mob.RandomAction();
	}
}


void SmallHandler::ShowCell(SmallSocket *p)
{
	int x = p -> GetX();
	int y = p -> GetY();
	std::string name;
	bool n,s,e,w;
	m_world.GetAt(x,y,name,n,s,e,w);
	p -> Send(name + "\n");
	m_mob.ShowNamesAt(p,x,y,"Here is ");
	if (n && m_world.FindAt(x,y - 1,name))
	{
		p -> Send("To the north you see... " + name + "\n");
		m_mob.ShowNamesAt(p,x,y - 1);
	}
	if (s && m_world.FindAt(x,y + 1,name))
	{
		p -> Send("To the south you see... " + name + "\n");
		m_mob.ShowNamesAt(p,x,y + 1);
	}
	if (e && m_world.FindAt(x + 1,y,name))
	{
		p -> Send("To the east you see... " + name + "\n");
		m_mob.ShowNamesAt(p,x + 1,y);
	}
	if (w && m_world.FindAt(x - 1,y,name))
	{
		p -> Send("To the west you see... " + name + "\n");
		m_mob.ShowNamesAt(p,x - 1,y);
	}
	p -> Send("\n");
}


void SmallHandler::Event(int x,int y,const std::string& line,SmallSocket *from,bool bAll)
{
	for (socket_m::iterator it = m_sockets.begin(); it != m_sockets.end(); it++)
	{
		Socket *p0 = (*it).second;
		SmallSocket *p = dynamic_cast<SmallSocket *>(p0);
		if (p && p != from)
		{
			if (bAll || p -> IsAt(x,y))
			{
				p -> Send("\n" + line);
				p -> SendPrompt();
			}
		}
	}
}


void SmallHandler::Load()
{
	for (ipersist_v::iterator it = m_persist.begin(); it != m_persist.end(); it++)
	{
		IPersist *p = *it;
		p -> Load();
	}
}


