#ifndef _PLAYERFACTORY_H
#define _PLAYERFACTORY_H

#include <string>
#include <vector>
#include "IPersist.h"


class PlayerFactory : public IPersist
{
public:
	struct PLAYER
	{
		PLAYER(long l,const std::string& n,const std::string& p) : nr(l),name(n),passwd(p) {}
		long nr;
		std::string name;
		std::string passwd;
	};
	typedef std::vector<PLAYER *> player_v;

public:
	PlayerFactory();
	virtual ~PlayerFactory();

	void Load();
	void Save();

	PLAYER *FindPlayer(const std::string& n,const std::string& p);
	PLAYER *AddPlayer(const std::string& n,const std::string& p);

private:
	player_v m_players;
};




#endif // _PLAYERFACTORY_H
