//#include <stdio.h>

#include "PlayerFactory.h"



PlayerFactory::PlayerFactory()
:IPersist()
{
}


PlayerFactory::~PlayerFactory()
{
}


void PlayerFactory::Load()
{
	FILE *fil = fopen("players.txt","rt");
	if (fil)
	{
		char slask[1000];
		fgets(slask,1000,fil);
		while (!feof(fil))
		{
			while (strlen(slask) && (slask[strlen(slask) - 1] == 13 || slask[strlen(slask) - 1] == 10))
			{
				slask[strlen(slask) - 1] = 0;
			}
			long nr = atol(slask);
			fgets(slask,1000,fil);
			while (strlen(slask) && (slask[strlen(slask) - 1] == 13 || slask[strlen(slask) - 1] == 10))
			{
				slask[strlen(slask) - 1] = 0;
			}
			std::string name = slask;
			fgets(slask,1000,fil);
			while (strlen(slask) && (slask[strlen(slask) - 1] == 13 || slask[strlen(slask) - 1] == 10))
			{
				slask[strlen(slask) - 1] = 0;
			}
			std::string passwd = slask;
			PLAYER *p = new PLAYER(nr,name,passwd);
			m_players.push_back(p);
			//
			fgets(slask,1000,fil);
		}
	}
}


void PlayerFactory::Save()
{
	FILE *fil = fopen("players.0","wt");
	if (fil)
	{
		for (player_v::iterator it = m_players.begin(); it != m_players.end(); it++)
		{
			PLAYER *p = *it;
			fprintf(fil,"%ld\n",p -> nr);
			fprintf(fil,"%s\n",p -> name.c_str());
			fprintf(fil,"%s\n",p -> passwd.c_str());
		}
		fclose(fil);
		unlink("players.old");
		rename("players.txt","players.old");
		rename("players.0","players.txt");
	}
}


PlayerFactory::PLAYER *PlayerFactory::FindPlayer(const std::string& n,const std::string& p)
{
	for (player_v::iterator it = m_players.begin(); it != m_players.end(); it++)
	{
		PLAYER *p = *it;
		if (p -> name == n) // && p -> passwd == p)
		{
			return p;
		}
	}
	return NULL;
}


PlayerFactory::PLAYER *PlayerFactory::AddPlayer(const std::string& n,const std::string& pw)
{
	PLAYER *p = new PLAYER(0,n,pw);
	m_players.push_back(p);
	p -> nr = m_players.size(); // never delete any player
	return p;
}


