/**
 **	File:	gclass.cpp
 **
 **	Published / author: 2004-04-14 / grymse@alhem.net
 **/

/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifdef _WIN32
#pragma warning(disable:4786)
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "sql2class.h"
#include "utils.h"

#include "gclass.h"

void generate_class(TBLS *table,short overwrite,char *dbname,short global,char *defdir)
{
	FILE *fil;
	time_t ti = time(NULL);
	struct tm *tp = localtime(&ti);
	char *ptrtotable;
	int i;
	short first;
	char c;
	char classname[200];
	char filename[200];
	char define[200];
	char slask[200];
	char cclassname[200];	// container class name
	char cstruct[200];	// container struct
	char lwrclassname[200];
	char slask2[200];

	strcpy(classname,table -> name.c_str());
	strlwr(classname);
	strcpy(lwrclassname,classname);
	if (*classname >= 'a' && *classname <= 'z')
		*classname -= 32;

	if (global)
		sprintf(filename,"%s/",defdir);
	else
		*filename = 0;
	if (*dbname)
	{
		sprintf(filename + strlen(filename),"sqlTbl%s%s.h",dbname,classname);
		sprintf(define,"_sqltbl%s%s_H",dbname,table -> name.c_str());
		strupr(define);
	} else
	{
		sprintf(filename + strlen(filename),"sqlTbl%s.h",classname);
		sprintf(define,"_sqltbl%s_H",table -> name.c_str());
		strupr(define);
	}
	if ((fil = fopen(filename,"rt")) != NULL)
	{
		fclose(fil);
		if (!overwrite)
		{
			printf("'%s' already exists - not replaced\n",filename);
			return;
		}
//		printf("'%s' already exists - replacing\n",filename);
	}
	if ((fil = fopen(filename,"wt")) == NULL)
	{
		printf("Couldn't create '%s'...\n",filename);
		return;
	}

	fprintf(fil,"/*\n");
	fprintf(fil," *\t %s\n",filename);
	fprintf(fil," *\t Generated by sql2class by (C) AH 2000-2006\n");
	fprintf(fil," *\t %s",asctime(tp));
	fprintf(fil," */\n");
	fprintf(fil,"\n");

	fprintf(fil,"/*"
"Copyright (C) 2001  Anders Hedstrom (grymse@alhem.net)"
""
"This program is free software; you can redistribute it and/or"
"modify it under the terms of the GNU General Public License"
"as published by the Free Software Foundation; either version 2"
"of the License, or (at your option) any later version."
""
"This program is distributed in the hope that it will be useful,"
"but WITHOUT ANY WARRANTY; without even the implied warranty of"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
"GNU General Public License for more details."
""
"You should have received a copy of the GNU General Public License"
"along with this program; if not, write to the Free Software"
"Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA."
"*/\n");
	fprintf(fil,"\n");

	fprintf(fil,"#ifndef %s\n",define);
	fprintf(fil,"#define %s\n",define);
	fprintf(fil,"\n");
//	fprintf(fil,"#include <Query.h>\n");
//	fprintf(fil,"\n");

	fprintf(fil,"class %s {\n",classname);
	fprintf(fil,"public:\n");

// empty constructor
/*
	fprintf(fil,"\t%s::%s(void) {\n",classname,classname);
	fprintf(fil,"\t\tdatabase = NULL;\n");
	fprintf(fil,"\t\tnew_object = 0;\n");
	fprintf(fil,"\t\tclear();\n");
	fprintf(fil,"\t}\n");
*/

// empty constructor + database
	fprintf(fil,"\t%s::%s(Database *db) {\n",classname,classname);
	fprintf(fil,"\t\tdatabase = db;\n");
	fprintf(fil,"\t\tnew_object = 1;\n");
	fprintf(fil,"\t\tclear();\n");
	fprintf(fil,"\t}\n");

// data fetch constructor + database
	fprintf(fil,"\t%s::%s(Database *db,long ix) {\n",classname,classname);
	fprintf(fil,"\t\tchar sql[80];\n");
	fprintf(fil,"\t\tdatabase = db;\n");
	fprintf(fil,"\t\tnew_object = 1;\n");
	{
		fields_l::iterator it = table -> fieldsbase.begin();
		FIELDS *f = *it;
		fprintf(fil,"\t\tsprintf(sql,\"select * from %s where %s=%%ld\",ix);\n",table -> name.c_str(),f -> column);
	}
	// call spawn here
	fprintf(fil,"\t\tspawn(sql);\n");
	fprintf(fil,"\t}\n");

// data fetch constructor + database
	fprintf(fil,"\t%s::%s(Database *db,char *sql) {\n",classname,classname);
	fprintf(fil,"\t\tdatabase = db;\n");
	fprintf(fil,"\t\tnew_object = 1;\n");
	// call spawn here
	fprintf(fil,"\t\tspawn(sql);\n");
	fprintf(fil,"\t}\n");

// data fetch constructor from query
	fprintf(fil,"\t%s::%s(Database *db,Query *qd) {\n",classname,classname);
	fprintf(fil,"\t\tdatabase = db;\n");
	fprintf(fil,"\t\tnew_object = 0;\n");
	// call spawn here
	fprintf(fil,"\t\tspawn(qd);\n");
	fprintf(fil,"\t}\n");

// destructor
	fprintf(fil,"\t%s::~%s(void) {\n",classname,classname);
	for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
	{
		FIELDS *t = *it;
		if (!strcmp(t -> ctype,"text"))
		{
			fprintf(fil,"\t\tif (%s)\n",t -> column);
			fprintf(fil,"\t\t\tdelete %s;\n",t -> column);
		}
	}
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");


// void Class::select(char *) 'spawn_wrapper'
//	numera ersatt av Class::Class(db,sql)...
	fprintf(fil,"\tvoid %s::select(char *sql) {\n",classname);
	fprintf(fil,"\t\tspawn(sql);\n");
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");


// long Class::insert(void)
//	'insert into ...(...) values(...)'
	fprintf(fil,"\tlong %s::insert(void) {\n",classname);
	fprintf(fil,"\t\tQuery q(database);\n");
	fprintf(fil,"\t\tchar *sql = new char[32000];\n");
	fprintf(fil,"\n");

//	safestr
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (!strcmp(t -> ctype,"double"));
			else
			if (!strcmp(t -> ctype,"long"));
			else
			if (!strcmp(t -> ctype,"text"))
				fprintf(fil,"\t\tq.safestr(%s);\n",t -> column);
			else
			if (*t -> ctype)
				fprintf(fil,"\t\tq.safestr(%s);\n",t -> column);
		}
	}
	fprintf(fil,"\t\tsprintf(sql,\"insert into %s(",table -> name.c_str());
	*slask = 0;
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			fprintf(fil,"%s%s",slask,t -> column);
			strcpy(slask,",");
		}
	}
	fprintf(fil,")\"\n\t\t\" values(");
	*slask = 0;
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (!strcmp(t -> ctype,"double"))
				fprintf(fil,"%s%%f",slask);
			else
			if (!strcmp(t -> ctype,"long"))
				fprintf(fil,"%s%%ld",slask);
			else
			if (!strcmp(t -> ctype,"text"))
				fprintf(fil,"%s'%%s'",slask);
			else
			if (*t -> ctype)
				fprintf(fil,"%s'%%s'",slask);
			else
				fprintf(fil,"%s''",slask);	// unsupported data type
			strcpy(slask,",");
		}
	}
	fprintf(fil,")\"%s",(table -> fieldsbase.size() > 1) ? ",\n" : ");\n");
	if (table -> fieldsbase.size() > 1)
	{
		fprintf(fil,"\t\t ");
		first = 0;
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (*t -> ctype)
			{
				if (first)
				{
					fprintf(fil,",");
					if (first % 4 == 0)
						fprintf(fil,"\n\t\t ");
				}
				if (!strcmp(t -> ctype,"text"))
					fprintf(fil,"%s ? %s : \"\"",t -> column,t -> column);
				else
					fprintf(fil,"%s",t -> column);
				first++;
			}
		}
		fprintf(fil,");\n");
	}
	fprintf(fil,"\t\tq.execute(sql);\n");
	fprintf(fil,"\t\tnew_object = 0;\n");

	//	unsafestr
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (!strcmp(t -> ctype,"double"));
			else
			if (!strcmp(t -> ctype,"long"));
			else
			if (!strcmp(t -> ctype,"text"))
				fprintf(fil,"\t\tq.unsafestr(%s);\n",t -> column);
			else
			if (*t -> ctype)
				fprintf(fil,"\t\tq.unsafestr(%s);\n",t -> column);
		}
	}
	fprintf(fil,"\t\tdelete sql;\n");
	{
		fields_l::iterator it = table -> fieldsbase.begin();
		FIELDS *f = *it;
		fprintf(fil,"\t\treturn %s = q.insert_id();\n",f -> column);
	}
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");


// void Class::update(void)
	fprintf(fil,"\tvoid %s::update(void) {\n",classname);
	{
		fields_l::iterator it = table -> fieldsbase.begin();
		FIELDS *f = *it;
		fprintf(fil,"\t\t%s::update(%s);\n",classname,f -> column);
	}
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

// void Class::update(long num)
//	'update ... set ... where ...'
	fprintf(fil,"\tvoid %s::update(long ix) {\n",classname);
	fprintf(fil,"\t\tQuery q(database);\n");
	fprintf(fil,"\t\tchar *sql = new char[32000];\n");

//	safestr
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (!strcmp(t -> ctype,"double"));
			else
			if (!strcmp(t -> ctype,"long"));
			else
			if (!strcmp(t -> ctype,"text"))
				fprintf(fil,"\t\tq.safestr(%s);\n",t -> column);
			else
			if (*t -> ctype)
				fprintf(fil,"\t\tq.safestr(%s);\n",t -> column);
		}
	}
	fprintf(fil,"\t\tsprintf(sql,\"update %s set",table -> name.c_str());
	c = ' ';
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (!strcmp(t -> ctype,"double"))
			{
				fprintf(fil,"%c%s=%%f",c,t -> column);
				c = ',';
			} else
			if (!strcmp(t -> ctype,"long"))
			{
				fprintf(fil,"%c%s=%%ld",c,t -> column);
				c = ',';
			} else
			if (*t -> ctype)
			{
				fprintf(fil,"%c%s='%%s'",c,t -> column);
				c = ',';
			}
		}
	}
	{
		fields_l::iterator it = table -> fieldsbase.begin();
		FIELDS *f = *it;
		fprintf(fil," where %s = %%ld\",\n\t\t",f -> column);
	}
	first = 0;
	c = ' ';
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (first && first % 4 == 0)
			{
				fprintf(fil,",\n\t\t");
				c = ' ';
			}
			if (!strcmp(t -> ctype,"double"))
			{
				fprintf(fil,"%c%s",c,t -> column);
				c = ',';
			} else
			if (!strcmp(t -> ctype,"long"))
			{
				fprintf(fil,"%c%s",c,t -> column);
				c = ',';
			} else
			if (*t -> ctype)
			{
				fprintf(fil,"%c%s",c,t -> column);
				c = ',';
			}
			first++;
		}
	}
	fprintf(fil,"%cix);\n",c);
	fprintf(fil,"\t\tq.execute(sql);\n");

	//	unsafestr
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (!strcmp(t -> ctype,"double"));
			else
			if (!strcmp(t -> ctype,"long"));
			else
			if (!strcmp(t -> ctype,"text"))
				fprintf(fil,"\t\tq.unsafestr(%s);\n",t -> column);
			else
			if (*t -> ctype)
				fprintf(fil,"\t\tq.unsafestr(%s);\n",t -> column);
		}
	}
	fprintf(fil,"\t\tdelete sql;\n");
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

// void Class::save(void)
	fprintf(fil,"\tvoid %s::save(void) {\n",classname);
	fprintf(fil,"\t\tif (new_object)\n");
	fprintf(fil,"\t\t\tinsert();\n");
	fprintf(fil,"\t\telse\n");
	fprintf(fil,"\t\t\tupdate();\n");
	fprintf(fil,"\t}\n");

// variables
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (!strcmp(t -> ctype,"double"))
				fprintf(fil,"\t%s %s;",t -> ctype,t -> column);
			else
			if (!strcmp(t -> ctype,"long"))
				fprintf(fil,"\t%s %s;",t -> ctype,t -> column);
			else
			if (!strcmp(t -> ctype,"text"))
				fprintf(fil,"\tchar *%s;",t -> column);
			else
			if (*t -> ctype)
				fprintf(fil,"\tchar %s[%d];",t -> column,t -> length + 1);
			else
				fprintf(fil,"\t// %d - %s %s",t -> num,t -> column,t -> typ);
 			if (*t -> comment)
				fprintf(fil," /* %s */",t -> comment);
			fprintf(fil,"\n");

			if (*t -> comment && (ptrtotable = strstr(t -> comment,"ptrtotable: ")) != NULL)
			{
				strcpy(slask,ptrtotable + 12);	// ptrtoclass
				strlwr(slask);
				strcpy(slask2,slask);
				if (*slask >= 'a' && *slask <= 'z')
					*slask -= 32;
				fprintf(fil,"\tclass %s *_%s;\n",slask,t -> column);
			}
		}
	}
	fprintf(fil,"\n");


// private
	fprintf(fil,"private:\n");

	fprintf(fil,"\tDatabase *database;\n");
	fprintf(fil,"\tshort new_object;\n");

// clear fields
	fprintf(fil,"\tvoid %s::clear(void) {\n",classname);
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (!strcmp(t -> ctype,"double"))
				fprintf(fil,"\t\t%s = 0;\n",t -> column);
			else
			if (!strcmp(t -> ctype,"long"))
				fprintf(fil,"\t\t%s = 0;\n",t -> column);
			else
			if (!strcmp(t -> ctype,"text"))
				fprintf(fil,"\t\t%s = NULL;\n",t -> column);
			else
			if (*t -> ctype)
			{
				fprintf(fil,"\t\t*%s = 0;\n",t -> column);
				if (t -> length == 1) // char
					fprintf(fil,"\t\t%s[1] = 0;\n",t -> column);
			} else
				fprintf(fil,"\t\t// %d - %s %s\n",t -> num,t -> column,t -> typ);

			if (*t -> comment && (ptrtotable = strstr(t -> comment,"ptrtotable: ")) != NULL)
			{
				strcpy(slask,ptrtotable + 12);	// ptrtoclass
				strlwr(slask);
				fprintf(fil,"\t\t_%s = NULL;\n",t -> column);
			}
		}
	}
	fprintf(fil,"\t}\n");

// spawn from query
	fprintf(fil,"\tvoid %s::spawn(char *sql) {\n",classname);
	fprintf(fil,"\t\tQuery q(database);\n");
	fprintf(fil,"\t\tchar *temp = new char[32000];\n");
	fprintf(fil,"\n");

	fprintf(fil,"\t\tif (!strncasecmp(sql,\"select * \",9))\n");
	fprintf(fil,"\t\t{\n");
	fprintf(fil,"\t\t\tsprintf(temp,\"");
	strcpy(slask,"select ");
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			fprintf(fil,"%s%s",slask,t -> column);
			strcpy(slask,",");
		}
	}
	fprintf(fil," %%s\",sql + 9);\n");
	fprintf(fil,"\t\t} else\n");
	fprintf(fil,"\t\t\tstrcpy(temp,sql);\n");

	fprintf(fil,"\t\tq.get_result(temp);\n");
	fprintf(fil,"\t\tif (q.fetch_row())\n");
	fprintf(fil,"\t\t{\n");
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (*t -> ctype)
			{
				if (!strcmp(t -> ctype,"double"))
				{
					fprintf(fil,"\t\t\t%s = q.getnum(%d);",t -> column,t -> num);
					sprintf(slask,"%d",t -> num);
					i = strlen(t -> column) + strlen(slask);
				} else
				if (!strcmp(t -> ctype,"long"))
				{
					fprintf(fil,"\t\t\t%s = q.getval(%d);",t -> column,t -> num);
					sprintf(slask,"%d",t -> num);
					i = strlen(t -> column) + strlen(slask);
				} else
				if (!strcmp(t -> ctype,"text"))
				{
					fprintf(fil,"\t\t\t%s = new char[strlen(q.getstr(%d)) + 1000];\n",t -> column,t -> num);
					fprintf(fil,"\t\t\tstrcpy(%s,q.getstr(%d));",t -> column,t -> num);
					sprintf(slask,"%d",t -> num);
					i = strlen(t -> column) + strlen(slask) + 6;
				} else
				{
					fprintf(fil,"\t\t\tstrcpy(%s,q.getstr(%d));",t -> column,t -> num);
					sprintf(slask,"%d",t -> num);
					i = strlen(t -> column) + strlen(slask) + 6;
				}
				strcpy(slask,"																				");
				slask[40 - i] = 0;
				fprintf(fil,"%s// %d - %s %s\n",slask,t -> num,t -> column,t -> typ);
			} else
			{
				fprintf(fil,"\t\t\t// %d - %s %s\n",t -> num,t -> column,t -> typ);
			}
		}
	}
	fprintf(fil,"\t\t\tnew_object = 0;\n");
	fprintf(fil,"\t\t} else\n");
	fprintf(fil,"\t\t\tclear();\n");
	fprintf(fil,"\t\tq.free_result();\n");

	fprintf(fil,"\t\tdelete temp;\n");
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

// spawn from query
	fprintf(fil,"\tvoid %s::spawn(Query *qd) {\n",classname);
	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			if (*t -> ctype)
			{
				if (!strcmp(t -> ctype,"double"))
				{
					fprintf(fil,"\t\t%s = qd -> getnum(%d);",t -> column,t -> num);
					sprintf(slask,"%d",t -> num);
					i = strlen(t -> column) + strlen(slask);
				} else
				if (!strcmp(t -> ctype,"long"))
				{
					fprintf(fil,"\t\t%s = qd -> getval(%d);",t -> column,t -> num);
					sprintf(slask,"%d",t -> num);
					i = strlen(t -> column) + strlen(slask);
				} else
				if (!strcmp(t -> ctype,"text"))
				{
					fprintf(fil,"\t\t%s = new char[strlen(qd -> getstr(%d)) + 1000];\n",t -> column,t -> num);
					fprintf(fil,"\t\tstrcpy(%s,qd -> getstr(%d));",t -> column,t -> num);
					sprintf(slask,"%d",t -> num);
					i = strlen(t -> column) + strlen(slask) + 6;
				} else
				{
					fprintf(fil,"\t\tstrcpy(%s,qd -> getstr(%d));",t -> column,t -> num);
					sprintf(slask,"%d",t -> num);
					i = strlen(t -> column) + strlen(slask) + 6;
				}
				strcpy(slask,"																				");
				slask[40 - i] = 0;
				fprintf(fil,"%s// %d - %s %s\n",slask,t -> num,t -> column,t -> typ);
			} else
			{
				fprintf(fil,"\t\t// %d - %s %s\n",t -> num,t -> column,t -> typ);
			}
		}
	}
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

	fprintf(fil,"}; // End of class '%s'\n",classname);
	fprintf(fil,"\n");

/*
 * Create container class (see container.h for an example)
 */

/*
typedef enum {
		TK_OPTION_BOOLEAN,
		TK_OPTION_INT,
		TK_OPTION_DOUBLE,
		TK_OPTION_STRING,
		TK_OPTION_STRING_TABLE,
		TK_OPTION_COLOR,
		TK_OPTION_FONT,
		TK_OPTION_BITMAP,
		TK_OPTION_BORDER,
		TK_OPTION_RELIEF,
		TK_OPTION_CURSOR,
		TK_OPTION_JUSTIFY,
		TK_OPTION_ANCHOR,
		TK_OPTION_SYNONYM,
		TK_OPTION_PIXELS,
		TK_OPTION_WINDOW,
		TK_OPTION_END
} Tk_OptionType;
*/

	sprintf(cclassname,"c%s",classname);	// container class name
	if (!strcmp(classname + strlen(classname) - 2,"ss"))
		sprintf(cstruct,"c%struct",classname);
	else
		sprintf(cstruct,"c%sstruct",classname); // container struct

	fprintf(fil,"\ttypedef struct %s\n",cstruct);
	fprintf(fil,"\t{\n");
	fprintf(fil,"\t\tstruct %s *next;\n",cstruct);
	fprintf(fil,"\t\t%s *%s;\n",classname,lwrclassname);
	fprintf(fil,"\t};\n");
	fprintf(fil,"\n");

	fprintf(fil,"#ifndef _LISTTYPE\n");
	fprintf(fil,"#define _LISTTYPE\n");
	fprintf(fil,"\ttypedef enum { Direct, InDirect } ListType;\n");
	fprintf(fil,"#endif\n");
	fprintf(fil,"\n");

	fprintf(fil,"class %s {\n",cclassname);
	fprintf(fil,"public:\n");

	// constructor cclassname(db) - empty list
	fprintf(fil,"\t%s::%s(Database *db,ListType lt) {\n",cclassname,cclassname);
	fprintf(fil,"\t\tdatabase = db;\n");
	fprintf(fil,"\t\tbase = NULL;\n");
	fprintf(fil,"\t\t%ss = NULL;\n",lwrclassname);
	fprintf(fil,"\t\tqty = 0;\n");
	fprintf(fil,"\t\t_lt = lt;\n");
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

	// constructor cclassname(db,sql)
	fprintf(fil,"\t%s::%s(Database *db,char *sql,ListType lt) {\n",cclassname,cclassname);
	fprintf(fil,"\t\tQuery q(db);\n");
	fprintf(fil,"\t\t%s *item,*p;\n",cstruct);
	fprintf(fil,"\t\tlong l;\n");
	fprintf(fil,"\n");
	fprintf(fil,"\t\tdatabase = db;\n");
	fprintf(fil,"\t\tbase = NULL;\n");
	fprintf(fil,"\t\t%ss = NULL;\n",lwrclassname);
	fprintf(fil,"\t\tqty = 0;\n");
	fprintf(fil,"\t\t_lt = lt;\n");
	fprintf(fil,"\n");
	fprintf(fil,"\t\tq.get_result(sql);\n");
	fprintf(fil,"\t\twhile (q.fetch_row())\n");
	fprintf(fil,"\t\t{\n");
	fprintf(fil,"\t\t\titem = new %s;\n",cstruct);
	fprintf(fil,"\t\t\titem -> next = NULL;\n");
	fprintf(fil,"\t\t\titem -> %s = new %s(db,q.getval());\n",lwrclassname,classname);
	fprintf(fil,"\t\t\tif (!base)\n");
	fprintf(fil,"\t\t\t\tbase = item;\n");
	fprintf(fil,"\t\t\telse\n");
	fprintf(fil,"\t\t\t{\n");
	fprintf(fil,"\t\t\t\tp = base;\n");
	fprintf(fil,"\t\t\t\twhile (p -> next)\n");
	fprintf(fil,"\t\t\t\t\tp = p -> next;\n");
	fprintf(fil,"\t\t\t\tp -> next = item;\n");
	fprintf(fil,"\t\t\t}\n");
	fprintf(fil,"\t\t\tqty++;\n");
	fprintf(fil,"\t\t}\n");
	fprintf(fil,"\t\tq.free_result();\n");
	fprintf(fil,"\n");
	fprintf(fil,"\t\t%ss = new %s *[qty];\n",lwrclassname,classname);
	fprintf(fil,"\t\tl = 0;\n");
	fprintf(fil,"\t\tfor (p = base; p; p = p -> next)\n");
	fprintf(fil,"\t\t\t%ss[l++] = p -> %s;\n",lwrclassname,lwrclassname);
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

	// destructor
	fprintf(fil,"\t%s::~%s(void) {\n",cclassname,cclassname);
	fprintf(fil,"\t\t%s *q,*tmp;\n",cstruct);
	fprintf(fil,"\t\tfor (q = base; q; q = tmp)\n");
	fprintf(fil,"\t\t{\n");
	fprintf(fil,"\t\t\tif (_lt == Direct)\n");
	fprintf(fil,"\t\t\t\tdelete q -> %s;\n",lwrclassname);
	fprintf(fil,"\t\t\ttmp = q -> next;\n");
	fprintf(fil,"\t\t\tdelete q;\n");
	fprintf(fil,"\t\t}\n");
	fprintf(fil,"\t\tdelete %ss;\n",lwrclassname);
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

	// save()
	fprintf(fil,"\tvoid %s::save(void) {\n",cclassname);
	fprintf(fil,"\t\t%s *q;\n",cstruct);
	fprintf(fil,"\t\tfor (q = base; q; q = q -> next)\n");
	fprintf(fil,"\t\t\tq -> %s -> save();\n",lwrclassname);
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

	// baseptr()
	fprintf(fil,"\t%s *%s::baseptr(void) {\n",cstruct,cclassname);
	fprintf(fil,"\t\treturn base;\n");
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

	// get...()
	fprintf(fil,"\t%s *%s::get%s(long ix) {\n",classname,cclassname,lwrclassname);
	fprintf(fil,"\t\treturn %ss[ix];\n",lwrclassname);
	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

	// add(classname *)
	fprintf(fil,"\tvoid %s::add(%s *ix) {\n",cclassname,classname);
	fprintf(fil,"\t\t%s *p,*item = new %s;\n",cstruct,cstruct);
	fprintf(fil,"\t\tlong l;\n");
	fprintf(fil,"\n");
	fprintf(fil,"\t\titem -> next = NULL;\n");
	fprintf(fil,"\t\titem -> %s = ix;\n",lwrclassname);
	fprintf(fil,"\t\tif (!base)\n");
	fprintf(fil,"\t\t\tbase = item;\n");
	fprintf(fil,"\t\telse\n");
	fprintf(fil,"\t\t{\n");
	fprintf(fil,"\t\t\tp = base;\n");
	fprintf(fil,"\t\t\twhile (p -> next)\n");
	fprintf(fil,"\t\t\t\tp = p -> next;\n");
	fprintf(fil,"\t\t\tp -> next = item;\n");
	fprintf(fil,"\t\t}\n");
	fprintf(fil,"\t\tqty++;\n");
	fprintf(fil,"\t\tdelete %ss;\n",lwrclassname);

	fprintf(fil,"\t\t%ss = new %s *[qty];\n",lwrclassname,classname);
	fprintf(fil,"\t\tl = 0;\n");
	fprintf(fil,"\t\tfor (p = base; p; p = p -> next)\n");
	fprintf(fil,"\t\t\t%ss[l++] = p -> %s;\n",lwrclassname,lwrclassname);

	fprintf(fil,"\t}\n");
	fprintf(fil,"\n");

	// find_...()
	fprintf(fil,"\t// find_xxx()\n\n");

	{
		for (fields_l::iterator it = table -> fieldsbase.begin(); it != table -> fieldsbase.end(); it++)
		{
			FIELDS *t = *it;
			strcpy(slask,typestring(t));
			if (*slask)
			{
				fprintf(fil,"\t%s *%s::find_%s(%six) {\n",classname,cclassname,t -> column,slask);
				fprintf(fil,"\t\t%s *q;\n",cstruct);
				fprintf(fil,"\t\tfor (q = base; q; q = q -> next)\n");
				if (!strcmp(t -> ctype,"long") || !strcmp(t -> ctype,"double"))
					fprintf(fil,"\t\t\tif (q -> %s -> %s == ix)\n",lwrclassname,t -> column);
				else
					fprintf(fil,"\t\t\tif (!strcasecmp(q -> %s -> %s,ix))\n",lwrclassname,t -> column);
				fprintf(fil,"\t\t\t\tbreak;\n");
				fprintf(fil,"\t\treturn q ? q -> %s : NULL;\n",lwrclassname);
				fprintf(fil,"\t}\n");
				fprintf(fil,"\n");
			}
		}
	}

	// private
	fprintf(fil,"private:\n");
	fprintf(fil,"\tDatabase *database;\n");
	fprintf(fil,"\t%s *base;\n",cstruct);
	fprintf(fil,"\t%s **%ss;\n",classname,lwrclassname);
	fprintf(fil,"\tlong qty;\n");
	fprintf(fil,"\tListType _lt;\n");
	fprintf(fil,"\n");
	fprintf(fil,"}; // End of class '%s'\n",cclassname);
	fprintf(fil,"\n");

	fprintf(fil,"#endif // %s\n",define);
	fclose(fil);
}


/*
 * End of class generation
 */


/*
class Example {
public:
	Example::Example(void) { 
	}
	Example::Example(Database *db,long ix) {
		Query q(db);
		char sql[200];
		sprintf(sql,"select * from example where num=%ld",ix);
		q.get_result(sql);
		while (q.fetch_row())
		{
			num = q.getval(0);
			strcpy(name,q.getstr(1));
		}
		q.free_result();
	}
	Example::~Example(void) { 
	}
// variables are public
	long num;
	char name[200];
};

*/



