/**
 **	File ......... DChatMinionSocket.h
 **	Published ....  2004-04-19
 **	Author ....... grymse@alhem.net
**/
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _DCHATMINIONSOCKET_H
#define _DCHATMINIONSOCKET_H

#include <MinionSocket.h>
#include <NullCrypt.h>
#include "key.h"


class DChatMinionSocket : public MinionSocket
{
public:
	DChatMinionSocket(SocketHandler& );
	DChatMinionSocket(SocketHandler& ,const std::string& ,ipaddr_t,port_t);
	~DChatMinionSocket();

	ICrypt *AllocateCrypt() { return new NullCrypt; }
	int GetMaxConnections() { return 3; }
	unsigned char *GetKey_m2minion() { return k1; }

	void Notify(const std::string& str) { printf("%s\n",str.c_str()); }

	bool OnVerifiedLine(const std::string& cmd,Parse& pa);

};




#endif // _DCHATMINIONSOCKET_H
