//InSocket.cpp
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//#include <stdio.h>

#include <SocketHandler.h>
#include "OutSocket.h"
#include "InSocket.h"




InSocket::InSocket(SocketHandler& h)
:TcpSocket(h)
{
}


InSocket::~InSocket()
{
}


void InSocket::OnAccept()
{
	printf(" *** Remote Address: '%s'\n",GetRemoteHostname().c_str());
	m_remote = new OutSocket(Handler());
//	m_remote -> Open("159.153.197.91",8888);
	m_remote -> Open("159.153.196.60",8888);
	m_remote -> SetDeleteByHandler();
	m_remote -> SetRemote(this);
	sleep(1);
	Handler().Add(m_remote);
}


#define BUFSIZE 16384

void InSocket::OnRead()
{
	if (!Handler().Valid(m_remote) || !m_remote -> Ready() )
		return;
	TcpSocket::OnRead();
	size_t n = ibuf.GetLength();
printf(">%d bytes\n",n);
	if (n)
	{
		char tmp[BUFSIZE];

		n = (n >= BUFSIZE) ? BUFSIZE - 1 : n;
		ibuf.Read(tmp,n);
		m_remote->SendBuf(tmp,n);
	}
}


void InSocket::OnDelete()
{
	if (Handler().Valid(m_remote))
	{
		m_remote -> SetCloseAndDelete();
	}
}


