/**
 **	File ......... winmain.cpp
 **	Published ....  2004-09-27
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#define STL_USING_MAP
#define STL_USING_STRING
#define STL_USING_VECTOR
#define STL_USING_LIST
#include "stlhelper.h"
#ifdef _WIN32
#pragma warning(disable:4786)
#endif
#include <config-win.h>
#include <mysql.h>
#include <libmysqlwrapped.h>
#include <stdio.h>
#include <windows.h>
//#include <shellapi.h>
#include "resource.h"
#include <socket_include.h>
#include <SocketHandler.h>
#include <HttpGetSocket.h>
#include <process.h>
#include "MinderSocket.h"
//#include <commctrl.h>
#include "MyErrlog.h"
#include "dbd.h"

#include "MyApp.h"


int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
  const char *server_groups[] = {"test_libmysqld_SERVER","embedded","server",NULL};
/*
  const char *server_argv[] = {"main",
    "--datadir=.",
    "--set-variable=key_buffer_size=32M"};
  int server_argc = sizeof(server_argv) / sizeof(char *);
*/
  //
  {
    int i;
    char *argv[10];
    char temp_path[1000];
    ::GetTempPath(1000, temp_path);

    for (i = 0; i < 10; i++)
      argv[i] = NULL;

    argv[0] = new char[100];
    strcpy(argv[0], "duct-" _VERSION ".exe");
    argv[1] = new char[1000];
    sprintf(argv[1], "--datadir=%s", temp_path);
    argv[2] = new char[100];
    strcpy(argv[2], "--language=.");
    argv[3] = new char[100];
    strcpy(argv[3], "--skip-innodb");
    argv[4] = new char[100];
    strcpy(argv[4], "--set-variable=key_buffer_size=8M");
    argv[5] = new char[100];
    strcpy(argv[5], "--set-variable=sort_buffer_size=1M");

    int argc = 6;
    if (mysql_server_init(argc, argv, (char **)server_groups))
    {
      ::MessageBox(NULL, "mysql_server_init() failed", "MySQL", MB_OK);
      return -1;
    }

    //
    if (!mysql_thread_safe())
    {
      ::MessageBox(NULL, "You are using a non thread safe libmysqld", "Warning", MB_OK);
    }

    // Database instances get their own scope, not one must live when we call
    // mysql_server_end() below
    {
      MyErrlog log;
      {
        Database db("fd",&log);
        if (!db.Connected())
        {
          // Create a temporary Database and create our 'finder' database
          Database db("",&log);
          Query q(db);

          if (!q.Connected())
          {
            ::MessageBox(NULL, "Not connected", "Query", MB_OK);
          }

          q.execute("create database fd");
          q.execute("use fd");

          // database was created, now create tables then exit
          q.execute("CREATE TABLE category ("
"  num int(11) NOT NULL auto_increment,"
"  name varchar(255) default NULL,"
"  PRIMARY KEY  (num)"
") TYPE=MyISAM;");

          q.execute("CREATE TABLE item ("
"  num int(11) NOT NULL auto_increment,"
"  typ enum('File','URL') NOT NULL default 'File',"
"  category int(11) NOT NULL default '0',"
"  name varchar(255),"
"  data mediumtext NOT NULL,"
"  sz integer,"
"  sha1 char(40),"
"  PRIMARY KEY  (num),"
"  KEY typ (typ,category),"
"  KEY category (category),"
"  UNIQUE(sz,sha1)"
") TYPE=MyISAM;");

          q.execute("CREATE TABLE linkitemtag ("
"  item int(11) NOT NULL default '0',"
"  tag int(11) NOT NULL default '0',"
"  PRIMARY KEY  (item,tag),"
"  KEY tag (tag)"
") TYPE=MyISAM;");

          q.execute("CREATE TABLE tag ("
"  num int(11) NOT NULL auto_increment,"
"  name varchar(255) default NULL,"
"  PRIMARY KEY  (num)"
") TYPE=MyISAM;");

          q.execute("create table node ( num integer auto_increment not null,"
            "uid char(40) default '' not null,"
            "primary key(num),"
            "unique(uid)) TYPE=MyISAM;");

          q.execute("create table linkitemnode ( item integer default 0 not null,"
            "node integer default 0 not null,"
            "primary key(item,node),"
            "index(node)) TYPE=MyISAM;");
        } // if (!db.Connected)
      }
      // Start application
      {
        Database db("fd", &log);
        // database update scope
        {
          Query q(db);
          if (!q.execute("select uid from node"))
          {
            q.execute("create table node ( num integer auto_increment not null,"
              "uid char(40) default '' not null,"
              "primary key(num),"
              "unique(uid)) TYPE=MyISAM;");
            q.execute("create table linkitemnode ( item integer default 0 not null,"
              "node integer default 0 not null,"
              "primary key(item,node),"
              "index(node)) TYPE=MyISAM;");
          }
        } // end of database update scope
        MyApp app(hInstance, hPrevInstance, db);
        app.Init(lpCmdLine, nCmdShow);
      }
    } // scope of mysql connections
    mysql_server_end();

    // clean up
    for (i = 0; i < 10; i++)
    {
      if (argv[i])
        delete[] argv[i];
    }
  }

  return 0;
}


