/**
 **	File ......... MyErrlog.cpp
 **	Published ....  2004-09-27
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#ifdef _WIN32
#define STL_USING_MAP
#define STL_USING_STRING
#define STL_USING_VECTOR
#define STL_USING_LIST
#include "stlhelper.h"
#pragma warning(disable:4786)
#endif

#include <string>
#include <map>
#ifdef WIN32
#include <config-win.h>
#include <mysql.h>
#include <time.h>
#else
#include <mysql/mysql.h>
#endif

#include "MyErrlog.h"


#define D2(x) { \
  FILE *fil = fopen("c:\\deb.log","at"); \
  x; \
  fclose(fil); \
}


void MyErrlog::error(Database& ,const std::string& str)
{
	time_t t = time(NULL);
	struct tm *tp = localtime(&t);
  char errstr[1000];
	sprintf(errstr,"%d-%02d-%02d %02d:%02d:%02d :: Database: %s\n",
		tp -> tm_year + 1900,tp -> tm_mon + 1,tp -> tm_mday,
		tp -> tm_hour,tp -> tm_min, tp -> tm_sec,
		str.c_str());
#ifdef _DEBUG
  ::MessageBox(NULL, errstr, "MySQL", MB_OK);
#endif
  D2(fprintf(fil,"%s",errstr);)
}


void MyErrlog::error(Database& ,Query& q,const std::string& str)
{
	time_t t = time(NULL);
	struct tm *tp = localtime(&t);
  char errstr[1000];
	sprintf(errstr,"%d-%02d-%02d %02d:%02d:%02d :: Query: %s: %s(%d)\n",
		tp -> tm_year + 1900,tp -> tm_mon + 1,tp -> tm_mday,
		tp -> tm_hour,tp -> tm_min, tp -> tm_sec,
		str.c_str(),q.GetError().c_str(),q.GetErrno());
	sprintf(errstr + strlen(errstr)," (QUERY: \"%s\")\n",q.GetLastQuery().c_str());
#ifdef _DEBUG
  ::MessageBox(NULL, errstr, "MySQL", MB_OK);
#endif
  D2(fprintf(fil,"%s",errstr);)
}


