/**
 **	File ......... MyApp.h
 **	Published ....  2004-09-27
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#pragma once

#include <string>
#include <vector>
#include <list>
#include <io.h>
#include "WinApp.h"

// custom window messages
enum {
  WM_SHELLNOTIFY = WM_USER + 100,
  WM_SHOW_SETTINGS,
  WM_CHANGE_ICON,
};


class Database;
class Query;
class FinderSocket;
class FinderHandler;

class MyApp : public WinApp
{
public:
  MyApp(HINSTANCE, HINSTANCE, Database& );
  ~MyApp();

  Database& GetDatabase() { return m_db; }

  int Init(LPSTR lpCmdLine, int nCmdShow);

  void SetDialogData();
  void GetDialogData();
  void ShowTaskBar(BOOL show);

  void SetQuit(bool x = true) { m_quit = x; }
  int GetLocalPort() { return m_local_port; }
  bool BindLocal() { return m_bind_local; }

  void check_thread_status();
  void view_thread_status(FinderSocket& );
  void settings_form(FinderSocket& );

  void reg_minder(FinderHandler& ,const std::string& cmd);
  void minion_connect(FinderHandler& h);
  int GetMinionPort() { return m_minion_port; }
  void ApplyChanges();
  bool NoMinder() { return m_no_minder; }

  bool CreateTop() { return m_create_top; }
  void SetCreateTop(bool x = true) { m_create_top = x; }

  void SetValues(int local_port,
    bool bind_local,const std::string& minder_host,int minder_port,
    bool no_minder,bool create_top,
    const std::string& join_group,bool use_password,const std::string& group_password);
  void SetDrop(bool x = true);

  BOOL ShowBalloonTip(const std::string& title,
    const std::string& msg);
  void ChangeIcon(int id);
  int MemoryUsage();
  //
  bool get_dc() { return m_dc; }
  std::string get_dc_host() { return m_dc_host; }
  int get_dc_port() { return m_dc_port; }

private:
  Database& m_db;
  bool m_quit;
  // dialog
  int m_local_port;
  bool m_bind_local;
  std::string m_minder_host;
  int m_minder_port;
  int m_minion_port;
  bool m_no_minder;
  std::string m_new_minder_host;
  int m_new_minder_port;
  bool m_new_no_minder;
  bool m_create_top;
  std::string m_join_group;
  bool m_use_password;
  std::string m_group_password;
  std::string m_new_join_group;
  bool m_new_use_password;
  std::string m_new_group_password;
  std::string m_node_id;
  bool m_dc;
  std::string m_dc_host;
  int m_dc_port;
};

extern        MyApp *g_app;
extern        HWND g_hwndMain;


