/**
 **	File ......... MenuHandler.h
 **	Published ....  2004-10-05
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#pragma once

#include <list>
#include <map>
#include <windows.h>

#include "Menu.h"

typedef std::map<int,Menu *> intmenu_m;


class MenuHandler
{
public:
  MenuHandler();
  virtual ~MenuHandler();

  void Add(Menu *);
  void Remove(Menu *);

  void OnInitMenu(HMENU);
  void OnInitPopupMenu(HMENU,int relpos,bool winmenu);
  void OnMenuSelect(HMENU,int index,int flags);
  bool OnCommand(int id);

  int get_next_id(Menu *);
  bool Valid(Menu *);

private:
  menu_v m_menulist;
  intmenu_m m_id;
static m_next_id;
};
