/**
 **	File ......... Menu.h
 **	Published ....  2004-10-05
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#pragma once

#include <list>
#include <windows.h>

class MenuHandler;

typedef std::list<class Menu *> menu_v;

class Menu
{
public:
  Menu(MenuHandler& ,HMENU);
  virtual ~Menu();

  MenuHandler& Handler() { return m_handler; }
  HMENU Handle() { return m_h; }

  virtual void OnInitMenu() {}
  virtual void OnInitPopupMenu(int relpos, bool winmenu);
  virtual void OnMenuSelect(int index,int flags) {}
  virtual void OnCommand(int id) {}

  void SetParent(Menu *x) { m_parent = x; }
  Menu *GetParent() { return m_parent; }

  int AddMenuitem(UINT flags,LPCTSTR = NULL,UINT_PTR id = NULL);
  void AddSubmenu(Menu *);
  void Enable(int id,bool bEnable = true);

protected:
  virtual void Init() {}

private:
  MenuHandler& m_handler;
  HMENU m_h;
  bool m_bInit;
  Menu *m_parent;
  menu_v m_submenulist;
};


