/**
 **	File ......... Menu.cpp
 **	Published ....  2004-10-05
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <windows.h>
#include "MenuHandler.h"
#include "Menu.h"



Menu::Menu(MenuHandler& h,HMENU handle) : m_handler(h)
,m_h(handle)
,m_bInit(false)
,m_parent(NULL)
{
  h.Add( this );
}


Menu::~Menu()
{
  for (menu_v::iterator it = m_submenulist.begin(); it != m_submenulist.end(); it++)
  {
    Menu *p = *it;
    Handler().Remove(p);
    delete p;
  }
  Handler().Remove( this );
}


void Menu::OnInitPopupMenu(int relpos, bool winmenu) 
{
  if (!m_bInit)
  {
    Init();
    m_bInit = true;
  }
}


void Menu::AddSubmenu(Menu *x) 
{ 
  m_submenulist.push_back(x); 
  x->SetParent( this );
}


int Menu::AddMenuitem(UINT flags,LPCTSTR item,UINT_PTR id_in)
{
  int id = id_in;
  if (!id && item)
  {
    id = Handler().get_next_id(this);
  }
  AppendMenu(Handle(), flags, id, item);
  return id;
}


void Menu::Enable(int id,bool bEnable)
{
  if (bEnable)
  {
    ::EnableMenuItem(Handle(), id, MF_ENABLED);
  }
  else
  {
    ::EnableMenuItem(Handle(), id, MF_DISABLED|MF_GRAYED);
  }
}


