// utils.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifdef WIN32
#include <Config-win.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <mysql/mysql.h>
#include <libmysqlwrapped.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <ctype.h>
#include <stdarg.h>

#include "utils.h"
#include "dbd.h"

void zap(char *s,char c)
{
	int i;
	
	for (i = 0; i < (int)strlen(s); i++)
		if (s[i] == c)
			s[i] = 0;
}

char *fget(char *s,int l,FILE *f)
{
	char *i = fgets(s,l,f);
	s[strlen(s) - 1] = 0;
	return i;
}

char *datetime(void)
{
static	char dt[40];
	time_t t = time(NULL);
	struct tm * tp = localtime(&t);

	sprintf(dt,"%04d-%02d-%02d %02d:%02d:%02d",
	 tp -> tm_year + 1900,
	 tp -> tm_mon + 1,
	 tp -> tm_mday,
	 tp -> tm_hour,
	 tp -> tm_min,
	 tp -> tm_sec);
	return dt;
}

char *expiredatetime(void)
{
static	char dt[80];
static	char *days[7] = {"Sunday","Monday",
	 "Tuesday","Wednesday","Thursday","Friday","Saturday"};
static	char *months[12] = {"Jan","Feb","Mar","Apr","May",
	 "Jun","Jul","Aug","Sep","Oct","Nov","Dev"};
	time_t t = time(NULL);
	struct tm * tp = localtime(&t);

	sprintf(dt,"%s, %02d-%s-%04d %02d:%02d:%02d GMT",
	 days[tp -> tm_wday],
	 tp -> tm_mday,
	 months[tp -> tm_mon],
	 tp -> tm_year + 1910,
	 tp -> tm_hour,
	 tp -> tm_min,
	 tp -> tm_sec);
	return dt;
}

#ifndef WIN32
void strlwr(char *s)
{
	int i = 0;
	while (s[i])
	{
		if (s[i] >= 'A' && s[i] <= 'Z')
			s[i] += 32;
		i++;
	}
}
#endif

void set_cookie(Cookies *cs,char *n,char *v)
{
// set-cookie response
/*
	fprintf(out,"Set-Cookie: %s=%s; domain=%s; path=%s; expires=%s\n",
	 n,v,
	 COOKIE_DOMAIN,
	 COOKIE_PATH,
	 expiredatetime());
*/
	cs -> replacevalue(n,v);
}

void set_cookie(Cookies *cs,char *n,long v)
{
	char slask[20];

	sprintf(slask,"%ld",v);
	set_cookie(cs,n,slask);
}


/*
void dbsafestr2(char *s)
{
	char *slask;
	int i,j = 0;

	if (s)
	{
		slask = new char[strlen(s) + 144]; //(char *)malloc(strlen(s) + 144);
		*slask = 0;
		for (i = 0; i < (int)strlen(s); i++)
		{
			if (s[i] == '\'' || s[i] == 34)
				slask[j++] = '\\';
			slask[j++] = s[i];
		}
		slask[j] = 0;
		if (strlen(s) != strlen(slask))
		{
//printf("dbsafestr2('%s' ==> '%s')\n",s,slask);
			strcpy(s,slask);
		}
		delete slask;//free(slask);
	}
}
*/


#ifndef WIN32
void strupr(char *s)
{
	int i;

	for (i = 0; i < (int)strlen(s); i++)
		if (s[i] > 96 && s[i] <= 'z')
			s[i] -= 32;
}
#endif

void strupr(std::string& str)
{
	for (size_t i = 0; i < str.size(); i++)
	{
		if (str[i] >= 'a' && str[i] <= 'z')
		{
			str[i] -= 32;
		}
	}
}

int syscall(char *s)
{
	int r;

//	printf("\nmaking syscall('%s')<br>\n",s);
//	fflush(out);
	
//	strcat(s," > /dev/null 2>/dev/null");
	r = system(s);

//	if (r)
//		printf("System call '%s' returned status %d<br>\n",s,r);
	return r;
}

int name_ok(char *s)
{
	int r = 0;
	int i;

	if (isalpha(*s) || *s == '_')
	{
		r = 1;
		for (i = 0; i < (int)strlen(s); i++)
			if (!isalnum(s[i]) && s[i] != '_')
				return 0;
	}
	return r;
}


// ta emot text fran textareain
//  (aaoAAO -> &.....;

void textareain(char *s)
{
	char *s2 = new char[strlen(s) + 1440];
	int i;
fflush(out);

	*s2 = 0;
	for (i = 0; i < (int)strlen(s); i++)
	{
		switch ( (unsigned char)s[i])
		{
		case 0xe5:
			strcat(s2,"&aring;");
			break;
		case 0xe4:
			strcat(s2,"&auml;");
			break;
		case 0xf6:
			strcat(s2,"&ouml;");
			break;
		case 0xc5:
			strcat(s2,"&Aring;");
			break;
		case 0xc4:
			strcat(s2,"&Auml;");
			break;
		case 0xd6:
			strcat(s2,"&Ouml;");
			break;
		default:
			sprintf(s2 + strlen(s2),"%c",s[i]);
		}
	}
	strcpy(s,s2);
/*
	char *slask = new char[strlen(s) * 2 + 144];
	int i,cr = 0;

	*slask = 0;
	for (i = 0; i < (int)strlen(s); i++)
		if ((s[i] == 13 || s[i] == 10) && !cr)
		{
			sprintf(slask + strlen(slask),"<br>");
			cr++;
		} else
		{
			sprintf(slask + strlen(slask),"%c",s[i]);
			cr = 0;
		}
	strcpy(s,slask);
	delete slask;
*/
}


// forbered text for visning i textarea

void remove_br(char *s)
{
	char *s2 = new char[strlen(s) + 1440];
	int i;
fflush(out);

//	for (j = 0; j < (int)strlen(s); j++)
//	{
//		while (!strncasecmp(s + j,"<br>",4))
//			memmove(s + j,s + j + 4,strlen(s + j) + 1);
//	}
	*s2 = 0;
	for (i = 0; i < (int)strlen(s); i++)
	{
		if (!strncmp(s + i,"&aring;",7))
		{
			sprintf(s2 + strlen(s2),"%c",0xe5);
			i += 6;
		} else
		if (!strncmp(s + i,"&auml;",6))
		{
			sprintf(s2 + strlen(s2),"%c",0xe4);
			i += 5;
		} else
		if (!strncmp(s + i,"&ouml;",6))
		{
			sprintf(s2 + strlen(s2),"%c",0xf6);
			i += 5;
		} else
		if (!strncmp(s + i,"&Aring;",7))
		{
			sprintf(s2 + strlen(s2),"%c",0xc5);
			i += 6;
		} else
		if (!strncmp(s + i,"&Auml;",6))
		{
			sprintf(s2 + strlen(s2),"%c",0xc4);
			i += 5;
		} else
		if (!strncmp(s + i,"&Ouml;",6))
		{
			sprintf(s2 + strlen(s2),"%c",0xd6);
			i += 5;
		} else
		if (s[i] == '&')
		{
			strcat(s2,"&amp;");
		} else
		{
			sprintf(s2 + strlen(s2),"%c",s[i]);
		}
	}
//printf("strlen(s)=%d  strlen(s2)=%d<br>\n",strlen(s),strlen(s2));
fflush(out);
	strcpy(s,s2);
	delete s2;
}


/*
void nbprintf(char *format, ...)
{
	char slask[5000];
	va_list ap;

	va_start(ap, format);
	vsnprintf(slask, 5000, format, ap);
	va_end(ap);

	for (size_t i = 0; i < strlen(slask); i++)
	{
		if (slask[i] == ' ')
			printf("&nbsp;");
		else
			printf("%c",slask[i]);
	}
}
*/


void pack_and_set_cookies(Cookies *cs)
{
//FILE *fil = fopen("/tmp/dbdlog","at");
	std::string packed;
	cgi::Base64 b('@');
	for (cookie_v::iterator it = cs -> GetCookies().begin(); it != cs -> GetCookies().end(); it++)
	{
		COOKIE *p = *it;
		if (strcmp(p -> name, "dbpacked"))
		{
			std::string key = p -> name;
			std::string valx = p -> value;
			std::string val = b.encode_buffer(valx.size() ? valx : " null");
//fprintf(fil,"%s(%s)%s\n",p -> name,p -> value,val.c_str());
			if (packed.size())
				packed += ":";
			packed += key + ":" + val;
		}
	}
//fprintf(fil,"---------\n%s\n", packed.c_str());
	fprintf(out,"Set-Cookie: %s=%s; domain=%s; path=%s; expires=%s\r\n",
	 "fdc",packed.c_str(),
	 COOKIE_DOMAIN,
	 COOKIE_PATH,
	 expiredatetime());
//fprintf(fil,"\n");
//fclose(fil);
}


void unpack_cookie(Cookies *cs)
{
	char slask[10000];
	if (cs && cs -> getvalue("fdc",slask,10000))
	{
		cgi::Parse pa(slask,":");
		char key[100];
		char value[1000];
		cgi::Base64 b('@');
		pa.getword(key);
		pa.getword(value);
		while (*key)
		{
			b.decode_to_buffer(value, slask, 10000);
			if (!strcmp(slask," null"))
				*slask = 0;
			cs -> replacevalue(key, slask);
			//
			pa.getword(key);
			pa.getword(value);
		}
	}
}


