/*
 *	 /usr/devel/src/libfd/libfd.cpp
 *	 Generated by sql2class by (C) AH 2000
 *	 Fri Feb 11 09:16:14 2005
 */

/*
Copyright (C) 2001  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifdef WIN32
#include <Config-win.h>
#endif
#include <libfd.h>

namespace db {

/**
 **  Begin class 'Category'
 **/

Category::Category(Database *db)
{
	database = db;
	new_object = 1;
	clear();
}


Category::Category(Database *db,const std::string& sql)
{
	database = db;
	new_object = 1;
	spawn(sql);
}


Category::Category(Database *db,Query *qd,int offset)
{
	database = db;
	new_object = 0;
	spawn(qd, offset);
}


Category::Category(Database& db,long i_num):database(&db),new_object(1)
{
	Query q(*database);
	std::string sql = "select * from category where ";
	{
		char slask[100];
		sprintf(slask,"num='%ld'",i_num);
		sql += slask;
	}
	spawn(sql);
}


Category::~Category()
{
}


void Category::select(const std::string& sql)
{
	spawn(sql);
}


my_ulonglong Category::insert()
{
	Query q(*database);
	std::string sql;

	sql = "insert into category(num,name)";
	{
		char slask[100];
		sprintf(slask," values(%ld",this -> num);
		sql += slask;
	}
	sql += ", '" + q.safestr(this -> name) + "'";
	sql += ")";
	q.execute(sql);
	new_object = 0;
	my_ulonglong inserted_id = q.insert_id();
	num = inserted_id;
	return inserted_id;
}


void Category::update()
{
	update(this -> num);
}


void Category::update(long i_num)
{
	Query q(*database);
	std::string sql;
	{
		char slask[200];
		sprintf(slask,"update category set num=%ld",this -> num);
		sql += slask;
	}
	sql += ", name='" + q.safestr(this -> name) + "'";
	{
		char slask[200];
		sprintf(slask," where num='%ld'",i_num);
		sql += slask;
	}
	q.execute(sql);
}


void Category::save()
{
	if (new_object)
		insert();
	else
		update();
}


void Category::erase()
{
	if (!new_object)
	{
		std::string sql = "delete from category where";
		Query q(*database);
		{
			char slask[200];
			sprintf(slask," num='%ld'",this -> num);
			sql += slask;
		}
		q.execute(sql);
	}
}


std::string Category::xml()
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<CATEGORY>";
	sprintf(slask,"<NUM>%ld</NUM>",this -> num);
	dest += slask;
	dest += "<NAME>" + q.xmlsafestr(this -> name) + "</NAME>";
	dest += "</CATEGORY>";
	return dest;
}


std::string Category::xml(const std::string& tag,const std::string& xvalx)
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<CATEGORY " + tag + "=\"" + xvalx + "\">";
	sprintf(slask,"<NUM>%ld</NUM>",this -> num);
	dest += slask;
	dest += "<NAME>" + q.xmlsafestr(this -> name) + "</NAME>";
	dest += "</CATEGORY>";
	return dest;
}


size_t Category::num_cols()
{
	return 2;
}


void Category::clear()
{
	num = 0;
	// 1 - name varchar(255)
}


void Category::spawn(const std::string& sql)
{
	Query q(*database);
	std::string temp;

	clear();

	if (!strncasecmp(sql.c_str(),"select * ",9))
	{
		temp = "select num,name " + sql.substr(9);
	} else
		temp = sql;
	q.get_result(temp);
	if (q.fetch_row())
	{
		num = q.getval(0);                                    // 0 - num int(11)
		name = q.getstr(1);                                   // 1 - name varchar(255)
		new_object = 0;
	} else
		clear();
	q.free_result();
}


void Category::spawn(Query *qd,int offset)
{
	clear();

	num = qd -> getval(0 + offset);                                    // 0 - num int(11)
	name = qd -> getstr(1 + offset);                                   // 1 - name varchar(255)
}


// End of implementation of class 'Category'

} // End of namespace
namespace db {

/**
 **  Begin class 'Item'
 **/

Item::Item(Database *db):typ(mmap_typ)
{
	database = db;
	new_object = 1;
	clear();
}


Item::Item(Database *db,const std::string& sql):typ(mmap_typ)
{
	database = db;
	new_object = 1;
	spawn(sql);
}


Item::Item(Database *db,Query *qd,int offset):typ(mmap_typ)
{
	database = db;
	new_object = 0;
	spawn(qd, offset);
}


Item::Item(Database& db,long i_num):typ(mmap_typ),database(&db),new_object(1)
{
	Query q(*database);
	std::string sql = "select * from item where ";
	{
		char slask[100];
		sprintf(slask,"num='%ld'",i_num);
		sql += slask;
	}
	spawn(sql);
}


Item::Item(Database& db,long i_sz,const std::string&  i_sha1):typ(mmap_typ),database(&db),new_object(1)
{
	Query q(*database);
	std::string sql = "select * from item where ";
	{
		char slask[100];
		sprintf(slask,"sz='%ld'",i_sz);
		sql += slask;
	}
	sql += " and sha1='" + q.safestr(i_sha1) + "'";
	spawn(sql);
}


Item::~Item()
{
}


void Item::select(const std::string& sql)
{
	spawn(sql);
}


my_ulonglong Item::insert()
{
	Query q(*database);
	std::string sql;

	sql = "insert into item(num,typ,category,name,data,sz,sha1)";
	{
		char slask[100];
		sprintf(slask," values(%ld",this -> num);
		sql += slask;
	}
	sql += ", '" + q.safestr(this -> typ.String()) + "'";
	{
		char slask[100];
		sprintf(slask,", %ld",this -> category);
		sql += slask;
	}
	sql += ", '" + q.safestr(this -> name) + "'";
	{
		size_t i = 1;
		sql += ", '";
		for (std::vector<std::string>::iterator it = this -> data.begin(); it != this -> data.end(); it++,i++)
		{
			sql += q.safestr(*it);
			if (i < this -> data.size())
				sql += "\n";
		}
		sql += "'";
	}
	{
		char slask[100];
		sprintf(slask,", %ld",this -> sz);
		sql += slask;
	}
	sql += ", '" + q.safestr(this -> sha1) + "'";
	sql += ")";
	q.execute(sql);
	new_object = 0;
	my_ulonglong inserted_id = q.insert_id();
	num = inserted_id;
	return inserted_id;
}


void Item::update()
{
	update(this -> num);
}


void Item::update(long i_num)
{
	Query q(*database);
	std::string sql;
	{
		char slask[200];
		sprintf(slask,"update item set num=%ld",this -> num);
		sql += slask;
	}
	sql += ", typ='" + q.safestr(this -> typ.String()) + "'";
	{
		char slask[200];
		sprintf(slask,", category=%ld",this -> category);
		sql += slask;
	}
	sql += ", name='" + q.safestr(this -> name) + "'";
	{
		size_t i = 1;
		sql += ", data='";
		for (std::vector<std::string>::iterator it = this -> data.begin(); it != this -> data.end(); it++,i++)
		{
			sql += q.safestr(*it);
			if (i < this -> data.size())
				sql += "\n";
		}
		sql += "'";
	}
	{
		char slask[200];
		sprintf(slask,", sz=%ld",this -> sz);
		sql += slask;
	}
	sql += ", sha1='" + q.safestr(this -> sha1) + "'";
	{
		char slask[200];
		sprintf(slask," where num='%ld'",i_num);
		sql += slask;
	}
	q.execute(sql);
}


void Item::save()
{
	if (new_object)
		insert();
	else
		update();
}


void Item::erase()
{
	if (!new_object)
	{
		std::string sql = "delete from item where";
		Query q(*database);
		{
			char slask[200];
			sprintf(slask," num='%ld'",this -> num);
			sql += slask;
		}
		q.execute(sql);
	}
}


std::string Item::xml()
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<ITEM>";
	sprintf(slask,"<NUM>%ld</NUM>",this -> num);
	dest += slask;
	dest += "<TYP>" + q.xmlsafestr(this -> typ.String()) + "</TYP>";
	sprintf(slask,"<CATEGORY>%ld</CATEGORY>",this -> category);
	dest += slask;
	dest += "<NAME>" + q.xmlsafestr(this -> name) + "</NAME>";
	sprintf(slask,"<SZ>%ld</SZ>",this -> sz);
	dest += slask;
	dest += "<SHA1>" + q.xmlsafestr(this -> sha1) + "</SHA1>";
	dest += "</ITEM>";
	return dest;
}


std::string Item::xml(const std::string& tag,const std::string& xvalx)
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<ITEM " + tag + "=\"" + xvalx + "\">";
	sprintf(slask,"<NUM>%ld</NUM>",this -> num);
	dest += slask;
	dest += "<TYP>" + q.xmlsafestr(this -> typ.String()) + "</TYP>";
	sprintf(slask,"<CATEGORY>%ld</CATEGORY>",this -> category);
	dest += slask;
	dest += "<NAME>" + q.xmlsafestr(this -> name) + "</NAME>";
	sprintf(slask,"<SZ>%ld</SZ>",this -> sz);
	dest += slask;
	dest += "<SHA1>" + q.xmlsafestr(this -> sha1) + "</SHA1>";
	dest += "</ITEM>";
	return dest;
}


size_t Item::num_cols()
{
	return 7;
}


void Item::clear()
{
	mmap_typ["File"] = 1;
	mmap_typ["URL"] = 2;
	num = 0;
	// 1 - typ enum('File','URL')
	category = 0;
	// 3 - name varchar(255)
	sz = 0;
	// 6 - sha1 varchar(40)
}


void Item::spawn(const std::string& sql)
{
	Query q(*database);
	std::string temp;

	clear();

	if (!strncasecmp(sql.c_str(),"select * ",9))
	{
		temp = "select num,typ,category,name,data,sz,sha1 " + sql.substr(9);
	} else
		temp = sql;
	q.get_result(temp);
	if (q.fetch_row())
	{
		num = q.getval(0);                                    // 0 - num int(11)
		typ = q.getstr(1);                                    // 1 - typ enum('File','URL')
		category = q.getval(2);                               // 2 - category int(11)
		name = q.getstr(3);                                   // 3 - name varchar(255)
		{
			std::string s = q.getstr(4);
			std::string tmp;
			for (size_t i = 0; i < s.size(); i++)
			{
				if (s[i] == '\n')
				{
					data.push_back(tmp);
					tmp = "";
				}
				else
				{
					tmp += s[i];
				}
			}
			if (tmp.size())
				data.push_back(tmp);
		}
		sz = q.getval(5);                                     // 5 - sz int(11)
		sha1 = q.getstr(6);                                   // 6 - sha1 varchar(40)
		new_object = 0;
	} else
		clear();
	q.free_result();
}


void Item::spawn(Query *qd,int offset)
{
	clear();

	num = qd -> getval(0 + offset);                                    // 0 - num int(11)
	typ = qd -> getstr(1 + offset);                                    // 1 - typ enum('File','URL')
	category = qd -> getval(2 + offset);                               // 2 - category int(11)
	name = qd -> getstr(3 + offset);                                   // 3 - name varchar(255)
	{
		std::string s = qd -> getstr(4 + offset);
		std::string tmp;
		for (size_t i = 0; i < s.size(); i++)
		{
			if (s[i] == '\n')
			{
				data.push_back(tmp);
				tmp = "";
			}
			else
			{
				tmp += s[i];
			}
		}
		if (tmp.size())
			data.push_back(tmp);
	}
	sz = qd -> getval(5 + offset);                                     // 5 - sz int(11)
	sha1 = qd -> getstr(6 + offset);                                   // 6 - sha1 varchar(40)
}


// End of implementation of class 'Item'

} // End of namespace
namespace db {

/**
 **  Begin class 'Linkitemnode'
 **/

Linkitemnode::Linkitemnode(Database *db)
{
	database = db;
	new_object = 1;
	clear();
}


Linkitemnode::Linkitemnode(Database *db,const std::string& sql)
{
	database = db;
	new_object = 1;
	spawn(sql);
}


Linkitemnode::Linkitemnode(Database *db,Query *qd,int offset)
{
	database = db;
	new_object = 0;
	spawn(qd, offset);
}


Linkitemnode::Linkitemnode(Database& db,long i_item,long i_node):database(&db),new_object(1)
{
	Query q(*database);
	std::string sql = "select * from linkitemnode where ";
	{
		char slask[100];
		sprintf(slask,"item='%ld'",i_item);
		sql += slask;
	}
	{
		char slask[100];
		sprintf(slask," and node='%ld'",i_node);
		sql += slask;
	}
	spawn(sql);
}


Linkitemnode::~Linkitemnode()
{
}


void Linkitemnode::select(const std::string& sql)
{
	spawn(sql);
}


my_ulonglong Linkitemnode::insert()
{
	Query q(*database);
	std::string sql;

	sql = "insert into linkitemnode(item,node)";
	{
		char slask[100];
		sprintf(slask," values(%ld",this -> item);
		sql += slask;
	}
	{
		char slask[100];
		sprintf(slask,", %ld",this -> node);
		sql += slask;
	}
	sql += ")";
	q.execute(sql);
	new_object = 0;
	my_ulonglong inserted_id = q.insert_id();
	item = inserted_id;
	return inserted_id;
}


void Linkitemnode::update()
{
	update(this -> item,this -> node);
}


void Linkitemnode::update(long i_item,long i_node)
{
	Query q(*database);
	std::string sql;
	{
		char slask[200];
		sprintf(slask,"update linkitemnode set item=%ld",this -> item);
		sql += slask;
	}
	{
		char slask[200];
		sprintf(slask,", node=%ld",this -> node);
		sql += slask;
	}
	{
		char slask[200];
		sprintf(slask," where item='%ld'",i_item);
		sql += slask;
	}
	{
		char slask[200];
		sprintf(slask," and node='%ld'",i_node);
		sql += slask;
	}
	q.execute(sql);
}


void Linkitemnode::save()
{
	if (new_object)
		insert();
	else
		update();
}


void Linkitemnode::erase()
{
	if (!new_object)
	{
		std::string sql = "delete from linkitemnode where";
		Query q(*database);
		{
			char slask[200];
			sprintf(slask," item='%ld'",this -> item);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," and node='%ld'",this -> node);
			sql += slask;
		}
		q.execute(sql);
	}
}


std::string Linkitemnode::xml()
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<LINKITEMNODE>";
	sprintf(slask,"<ITEM>%ld</ITEM>",this -> item);
	dest += slask;
	sprintf(slask,"<NODE>%ld</NODE>",this -> node);
	dest += slask;
	dest += "</LINKITEMNODE>";
	return dest;
}


std::string Linkitemnode::xml(const std::string& tag,const std::string& xvalx)
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<LINKITEMNODE " + tag + "=\"" + xvalx + "\">";
	sprintf(slask,"<ITEM>%ld</ITEM>",this -> item);
	dest += slask;
	sprintf(slask,"<NODE>%ld</NODE>",this -> node);
	dest += slask;
	dest += "</LINKITEMNODE>";
	return dest;
}


size_t Linkitemnode::num_cols()
{
	return 2;
}


void Linkitemnode::clear()
{
	item = 0;
	node = 0;
}


void Linkitemnode::spawn(const std::string& sql)
{
	Query q(*database);
	std::string temp;

	clear();

	if (!strncasecmp(sql.c_str(),"select * ",9))
	{
		temp = "select item,node " + sql.substr(9);
	} else
		temp = sql;
	q.get_result(temp);
	if (q.fetch_row())
	{
		item = q.getval(0);                                   // 0 - item int(11)
		node = q.getval(1);                                   // 1 - node int(11)
		new_object = 0;
	} else
		clear();
	q.free_result();
}


void Linkitemnode::spawn(Query *qd,int offset)
{
	clear();

	item = qd -> getval(0 + offset);                                   // 0 - item int(11)
	node = qd -> getval(1 + offset);                                   // 1 - node int(11)
}


// End of implementation of class 'Linkitemnode'

} // End of namespace
namespace db {

/**
 **  Begin class 'Linkitemtag'
 **/

Linkitemtag::Linkitemtag(Database *db)
{
	database = db;
	new_object = 1;
	clear();
}


Linkitemtag::Linkitemtag(Database *db,const std::string& sql)
{
	database = db;
	new_object = 1;
	spawn(sql);
}


Linkitemtag::Linkitemtag(Database *db,Query *qd,int offset)
{
	database = db;
	new_object = 0;
	spawn(qd, offset);
}


Linkitemtag::Linkitemtag(Database& db,long i_item,long i_tag):database(&db),new_object(1)
{
	Query q(*database);
	std::string sql = "select * from linkitemtag where ";
	{
		char slask[100];
		sprintf(slask,"item='%ld'",i_item);
		sql += slask;
	}
	{
		char slask[100];
		sprintf(slask," and tag='%ld'",i_tag);
		sql += slask;
	}
	spawn(sql);
}


Linkitemtag::~Linkitemtag()
{
}


void Linkitemtag::select(const std::string& sql)
{
	spawn(sql);
}


my_ulonglong Linkitemtag::insert()
{
	Query q(*database);
	std::string sql;

	sql = "insert into linkitemtag(item,tag)";
	{
		char slask[100];
		sprintf(slask," values(%ld",this -> item);
		sql += slask;
	}
	{
		char slask[100];
		sprintf(slask,", %ld",this -> tag);
		sql += slask;
	}
	sql += ")";
	q.execute(sql);
	new_object = 0;
	my_ulonglong inserted_id = q.insert_id();
	item = inserted_id;
	return inserted_id;
}


void Linkitemtag::update()
{
	update(this -> item,this -> tag);
}


void Linkitemtag::update(long i_item,long i_tag)
{
	Query q(*database);
	std::string sql;
	{
		char slask[200];
		sprintf(slask,"update linkitemtag set item=%ld",this -> item);
		sql += slask;
	}
	{
		char slask[200];
		sprintf(slask,", tag=%ld",this -> tag);
		sql += slask;
	}
	{
		char slask[200];
		sprintf(slask," where item='%ld'",i_item);
		sql += slask;
	}
	{
		char slask[200];
		sprintf(slask," and tag='%ld'",i_tag);
		sql += slask;
	}
	q.execute(sql);
}


void Linkitemtag::save()
{
	if (new_object)
		insert();
	else
		update();
}


void Linkitemtag::erase()
{
	if (!new_object)
	{
		std::string sql = "delete from linkitemtag where";
		Query q(*database);
		{
			char slask[200];
			sprintf(slask," item='%ld'",this -> item);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," and tag='%ld'",this -> tag);
			sql += slask;
		}
		q.execute(sql);
	}
}


std::string Linkitemtag::xml()
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<LINKITEMTAG>";
	sprintf(slask,"<ITEM>%ld</ITEM>",this -> item);
	dest += slask;
	sprintf(slask,"<TAG>%ld</TAG>",this -> tag);
	dest += slask;
	dest += "</LINKITEMTAG>";
	return dest;
}


std::string Linkitemtag::xml(const std::string& tag,const std::string& xvalx)
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<LINKITEMTAG " + tag + "=\"" + xvalx + "\">";
	sprintf(slask,"<ITEM>%ld</ITEM>",this -> item);
	dest += slask;
	sprintf(slask,"<TAG>%ld</TAG>",this -> tag);
	dest += slask;
	dest += "</LINKITEMTAG>";
	return dest;
}


size_t Linkitemtag::num_cols()
{
	return 2;
}


void Linkitemtag::clear()
{
	item = 0;
	tag = 0;
}


void Linkitemtag::spawn(const std::string& sql)
{
	Query q(*database);
	std::string temp;

	clear();

	if (!strncasecmp(sql.c_str(),"select * ",9))
	{
		temp = "select item,tag " + sql.substr(9);
	} else
		temp = sql;
	q.get_result(temp);
	if (q.fetch_row())
	{
		item = q.getval(0);                                   // 0 - item int(11)
		tag = q.getval(1);                                    // 1 - tag int(11)
		new_object = 0;
	} else
		clear();
	q.free_result();
}


void Linkitemtag::spawn(Query *qd,int offset)
{
	clear();

	item = qd -> getval(0 + offset);                                   // 0 - item int(11)
	tag = qd -> getval(1 + offset);                                    // 1 - tag int(11)
}


// End of implementation of class 'Linkitemtag'

} // End of namespace
namespace db {

/**
 **  Begin class 'Node'
 **/

Node::Node(Database *db)
{
	database = db;
	new_object = 1;
	clear();
}


Node::Node(Database *db,const std::string& sql)
{
	database = db;
	new_object = 1;
	spawn(sql);
}


Node::Node(Database *db,Query *qd,int offset)
{
	database = db;
	new_object = 0;
	spawn(qd, offset);
}


Node::Node(Database& db,long i_num):database(&db),new_object(1)
{
	Query q(*database);
	std::string sql = "select * from node where ";
	{
		char slask[100];
		sprintf(slask,"num='%ld'",i_num);
		sql += slask;
	}
	spawn(sql);
}


Node::Node(Database& db,const std::string&  i_uid):database(&db),new_object(1)
{
	Query q(*database);
	std::string sql = "select * from node where ";
	sql += "uid='" + q.safestr(i_uid) + "'";
	spawn(sql);
}


Node::~Node()
{
}


void Node::select(const std::string& sql)
{
	spawn(sql);
}


my_ulonglong Node::insert()
{
	Query q(*database);
	std::string sql;

	sql = "insert into node(num,uid)";
	{
		char slask[100];
		sprintf(slask," values(%ld",this -> num);
		sql += slask;
	}
	sql += ", '" + q.safestr(this -> uid) + "'";
	sql += ")";
	q.execute(sql);
	new_object = 0;
	my_ulonglong inserted_id = q.insert_id();
	num = inserted_id;
	return inserted_id;
}


void Node::update()
{
	update(this -> num);
}


void Node::update(long i_num)
{
	Query q(*database);
	std::string sql;
	{
		char slask[200];
		sprintf(slask,"update node set num=%ld",this -> num);
		sql += slask;
	}
	sql += ", uid='" + q.safestr(this -> uid) + "'";
	{
		char slask[200];
		sprintf(slask," where num='%ld'",i_num);
		sql += slask;
	}
	q.execute(sql);
}


void Node::save()
{
	if (new_object)
		insert();
	else
		update();
}


void Node::erase()
{
	if (!new_object)
	{
		std::string sql = "delete from node where";
		Query q(*database);
		{
			char slask[200];
			sprintf(slask," num='%ld'",this -> num);
			sql += slask;
		}
		q.execute(sql);
	}
}


std::string Node::xml()
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<NODE>";
	sprintf(slask,"<NUM>%ld</NUM>",this -> num);
	dest += slask;
	dest += "<UID>" + q.xmlsafestr(this -> uid) + "</UID>";
	dest += "</NODE>";
	return dest;
}


std::string Node::xml(const std::string& tag,const std::string& xvalx)
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<NODE " + tag + "=\"" + xvalx + "\">";
	sprintf(slask,"<NUM>%ld</NUM>",this -> num);
	dest += slask;
	dest += "<UID>" + q.xmlsafestr(this -> uid) + "</UID>";
	dest += "</NODE>";
	return dest;
}


size_t Node::num_cols()
{
	return 2;
}


void Node::clear()
{
	num = 0;
	// 1 - uid char(40)
}


void Node::spawn(const std::string& sql)
{
	Query q(*database);
	std::string temp;

	clear();

	if (!strncasecmp(sql.c_str(),"select * ",9))
	{
		temp = "select num,uid " + sql.substr(9);
	} else
		temp = sql;
	q.get_result(temp);
	if (q.fetch_row())
	{
		num = q.getval(0);                                    // 0 - num int(11)
		uid = q.getstr(1);                                    // 1 - uid char(40)
		new_object = 0;
	} else
		clear();
	q.free_result();
}


void Node::spawn(Query *qd,int offset)
{
	clear();

	num = qd -> getval(0 + offset);                                    // 0 - num int(11)
	uid = qd -> getstr(1 + offset);                                    // 1 - uid char(40)
}


// End of implementation of class 'Node'

} // End of namespace
namespace db {

/**
 **  Begin class 'Tag'
 **/

Tag::Tag(Database *db)
{
	database = db;
	new_object = 1;
	clear();
}


Tag::Tag(Database *db,const std::string& sql)
{
	database = db;
	new_object = 1;
	spawn(sql);
}


Tag::Tag(Database *db,Query *qd,int offset)
{
	database = db;
	new_object = 0;
	spawn(qd, offset);
}


Tag::Tag(Database& db,long i_num):database(&db),new_object(1)
{
	Query q(*database);
	std::string sql = "select * from tag where ";
	{
		char slask[100];
		sprintf(slask,"num='%ld'",i_num);
		sql += slask;
	}
	spawn(sql);
}


Tag::~Tag()
{
}


void Tag::select(const std::string& sql)
{
	spawn(sql);
}


my_ulonglong Tag::insert()
{
	Query q(*database);
	std::string sql;

	sql = "insert into tag(num,name)";
	{
		char slask[100];
		sprintf(slask," values(%ld",this -> num);
		sql += slask;
	}
	sql += ", '" + q.safestr(this -> name) + "'";
	sql += ")";
	q.execute(sql);
	new_object = 0;
	my_ulonglong inserted_id = q.insert_id();
	num = inserted_id;
	return inserted_id;
}


void Tag::update()
{
	update(this -> num);
}


void Tag::update(long i_num)
{
	Query q(*database);
	std::string sql;
	{
		char slask[200];
		sprintf(slask,"update tag set num=%ld",this -> num);
		sql += slask;
	}
	sql += ", name='" + q.safestr(this -> name) + "'";
	{
		char slask[200];
		sprintf(slask," where num='%ld'",i_num);
		sql += slask;
	}
	q.execute(sql);
}


void Tag::save()
{
	if (new_object)
		insert();
	else
		update();
}


void Tag::erase()
{
	if (!new_object)
	{
		std::string sql = "delete from tag where";
		Query q(*database);
		{
			char slask[200];
			sprintf(slask," num='%ld'",this -> num);
			sql += slask;
		}
		q.execute(sql);
	}
}


std::string Tag::xml()
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<TAG>";
	sprintf(slask,"<NUM>%ld</NUM>",this -> num);
	dest += slask;
	dest += "<NAME>" + q.xmlsafestr(this -> name) + "</NAME>";
	dest += "</TAG>";
	return dest;
}


std::string Tag::xml(const std::string& tag,const std::string& xvalx)
{
	Query q(*database);
	std::string dest;
	char slask[200];
	dest = "<TAG " + tag + "=\"" + xvalx + "\">";
	sprintf(slask,"<NUM>%ld</NUM>",this -> num);
	dest += slask;
	dest += "<NAME>" + q.xmlsafestr(this -> name) + "</NAME>";
	dest += "</TAG>";
	return dest;
}


size_t Tag::num_cols()
{
	return 2;
}


void Tag::clear()
{
	num = 0;
	// 1 - name varchar(255)
}


void Tag::spawn(const std::string& sql)
{
	Query q(*database);
	std::string temp;

	clear();

	if (!strncasecmp(sql.c_str(),"select * ",9))
	{
		temp = "select num,name " + sql.substr(9);
	} else
		temp = sql;
	q.get_result(temp);
	if (q.fetch_row())
	{
		num = q.getval(0);                                    // 0 - num int(11)
		name = q.getstr(1);                                   // 1 - name varchar(255)
		new_object = 0;
	} else
		clear();
	q.free_result();
}


void Tag::spawn(Query *qd,int offset)
{
	clear();

	num = qd -> getval(0 + offset);                                    // 0 - num int(11)
	name = qd -> getstr(1 + offset);                                   // 1 - name varchar(255)
}


// End of implementation of class 'Tag'

} // End of namespace
