// duct.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include <unistd.h>
#include <libmysqlwrapped.h>
#include <libfd.h>
#include <string>
#include <libcgi++.h>
#include <ListenSocket.h>
#include <Utility.h>

#include "utils.h"
#include "forms.h"
#include "Mime.h"
#include "FinderHandler.h"
#include "win32/MyErrlog.h"
#include "dbd.h"
#include "win32/MySocketsLog.h"
#include "MyMinionSocket.h"
#include "MyMinderSocket.h"


#define BIND_LOCAL "127.0.0.1"
#define LOCAL_PORT 18018

#define MINION_PORT 19696
#define MINDER_HOST "alhem.net"
#define MINDER_PORT 9696

#define JOIN_GROUP "fd"


	bool g_bRestart = true;
	bool g_bWsRunning = false;
	bool g_bQuit = false;


void reg_minder(FinderHandler& h,const std::string& cmd)
{
	std::string group = Utility::base64(JOIN_GROUP);
	MyMinderSocket *m = new MyMinderSocket(h, group);
	m -> Init();

	m -> Function(cmd); // Hello / Goodbye
	m -> SetDeleteByHandler(true);
	bool opened = m -> Open(MINDER_HOST, MINDER_PORT);
	h.Add(m);
	m -> SetLocalIpPort(Utility::GetLocalAddress(),h.GetLocalPort());
	if (opened && !m -> Connecting()) // connected
	{
		m -> SendHello();
	}
	if (!opened && !m->Connecting()) // fatal
	{
		m->SetCloseAndDelete();
	}

}


void minion_connect(FinderHandler& h)
{
	if (h.Count() < 3)
	{
		ipaddr_t a;
		port_t p;
		std::string key;
		long host_id;
		if (h.GetHost(a,p,key,host_id))
		{
			MinionSocket *tmp = new MyMinionSocket(h,key,a,p);
			tmp -> Init();
			ipaddr_t my_ip;
			port_t my_port;
			h.GetMyIpPort(my_ip, my_port);
			tmp -> SetMyIpPort(my_ip,my_port);
			tmp -> SetRemoteHostId(host_id);
			if (tmp -> Open(a,p))
			{
				tmp -> SetDeleteByHandler(true);
				h.Add(tmp);
				//
				tmp -> SendHello("Hello");
			}
			else
			if (tmp -> Connecting())
			{
				tmp -> SetDeleteByHandler(true);
				// check OnConnect
				h.Add(tmp);
			}
			else
			{
				delete tmp;
			}
		}
		else
		{
			h.LogError(NULL, "minion_connect", 0, "GetHost() failed");
		}
	}
}



int main(int argc,char *argv[])
{
//	mysql_thread_init();
	MyErrlog log;
	g_bWsRunning = true;
	{
		Database db("fd",&log);
		while (g_bRestart)
		{
			MySocketsLog log;
			FinderHandler h(db);
			h.RegStdLog(&log);
			ListenSocket<ExecSocket> l(h);
			ListenSocket<MyMinionSocket> l2(h);
			// bind
			l.Bind(BIND_LOCAL, LOCAL_PORT);
			h.Add(&l);
			{
				int port = MINION_PORT;
				while (l2.Bind( port ))
				{
					port++;
				}
				h.Add(&l2);
				h.SetLocalPort( port );
				reg_minder(h, "Hello");
			}
			// times
			time_t tminder = time(NULL);
			time_t tminion = time(NULL) - 30;
			// reg new sockets
			h.Select(1,0);
			// reset restart
			g_bRestart = false;
			while (h.GetCount() && !g_bQuit && !g_bRestart)
			{
				h.Select(1,0);
				time_t tnow = time(NULL);
				{
					if (tnow - tminder > 15 * 60 )
					{
						reg_minder(h, "Hello");
						tminder = tnow;
					}
					if (tnow - tminion > 60 )
					{
						minion_connect(h);
						tminion = tnow;
					}
				} // if (!NoMinder())
			}
			{
				reg_minder(h, "Goodbye");
				h.Select(1,0);
				while (h.MinderSockets())
				{
					h.Select(1,0);
				}
			}
		} // while (g_bRestart)
	}
	//
	g_bWsRunning = false;
//	mysql_thread_end();
	return 0;
}


