/**
 **	File ......... MyApp.cpp
 **	Published ....  2004-09-27
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#pragma warning(disable:4786)
#define _WIN32_WINNT 0x0400
#define _WIN32_IE 0x0500
//#define WINVER 0x0500
#include <windows.h>
//#include <io.h>
#include <ListenSocket.h>
#include <config-win.h>
#include <mysql.h>
#include <libmysqlwrapped.h>
#include <stdio.h>
#include <shellapi.h>
#include "resource.h"
#include <socket_include.h>
#include <SocketHandler.h>
#include <HttpGetSocket.h>
#include <process.h>
#include <commctrl.h>
#include <StdoutLog.h>
#include "Mutex.h"
#include "MyErrlog.h"
#include "MySocketsLog.h"
#include "MenuHandler.h"
#include "MyMenu.h"
#include <Utility.h>
#include <libcgi++.h>
#include "FinderHandler.h"
#include "ExecSocket.h"
#include "MyMinionSocket.h"
#include "MyMinderSocket.h"
#include "dbd.h"

#include "MyApp.h"

//#define STRESS


static  HANDLE g_hD2;

#define D2(x) { \
  Mutex lock(g_hD2); \
  if (lock.Locked()) \
  { \
    FILE *fil = fopen("c:\\deb.log","at"); \
    x; \
    fclose(fil); \
  } \
}


// Statics
static  bool g_bQuit = false;
static  HANDLE g_hMutex;
static  bool g_bRestart = true;
static  HANDLE g_hMutexScan;
static  bool g_bWsRunning = false;
static  MenuHandler g_menuHandler;

// Globals
        MyApp *g_app = NULL;
        HWND g_hwndMain;


MyApp::MyApp(HINSTANCE hInst,HINSTANCE hPrevInst,Database& db) : WinApp(hInst, hPrevInst)
,m_db(db)
,m_quit(false)
,m_local_port(18018)
,m_bind_local(true)
,m_minder_host("localhost")
,m_minder_port(9696)
,m_minion_port(19696)
,m_no_minder(true)
,m_new_minder_host(m_minder_host)
,m_new_minder_port(m_minder_port)
,m_new_no_minder(m_no_minder)
,m_create_top(false)
,m_join_group("fd")
,m_use_password(true)
,m_new_join_group(m_join_group)
,m_new_use_password(m_use_password)
,m_dc(false)
,m_dc_port(m_minion_port)
{
  g_app = this;
}


MyApp::~MyApp()
{
}


//UINT start( LPVOID pParam )
DWORD WINAPI start( LPVOID lpParam )
{
  mysql_thread_init();
  MyErrlog log;
  g_bWsRunning = true;
  {
    Database db("fd",&log);
    while (g_bRestart)
    {
      MySocketsLog log;
      FinderHandler h(db);
      h.RegStdLog(&log);
      h.ResolveLocal();
      ListenSocket<ExecSocket> l(h);
      ListenSocket<MyMinionSocket> l2(h);
      // apply changes
      g_app->ApplyChanges();
      // bind
      std::string address = g_app->BindLocal() ? "127.0.0.1" : "0.0.0.0";
      l.Bind(address, g_app->GetLocalPort());
      h.Add(&l);
      if (!g_app->NoMinder())
      {
        int port = g_app->GetMinionPort();
        while (l2.Bind( port ))
        {
          port++;
        }
        h.Add(&l2);
        h.SetLocalPort( port );
        g_app->reg_minder(h, "Hello");
      }
      // dc
      if (g_app->get_dc())
      {
        MyMinionSocket *p = new MyMinionSocket(h,g_app->get_dc(),g_app->get_dc_host(),g_app->get_dc_port());
        p->SetDeleteByHandler();
        h.Add(p);
        p->Open(g_app->get_dc_host(),g_app->get_dc_port());
      }
      // times
      time_t tminder = time(NULL);
      time_t tminion = time(NULL) - 30;
      time_t ttop = time(NULL);
      // reg new sockets
      h.Select(1,0);
      // reset restart
      g_bRestart = false;
      while (h.GetCount() && !g_bQuit && !g_bRestart)
      {
        h.Select(1,0);
        time_t tnow = time(NULL);
        if (!g_app->NoMinder())
        {
          if (tnow - tminder > 3 * 60 )
          {
            g_app->reg_minder(h, "Hello");
            tminder = tnow;
          }
          if (tnow - tminion > 60 )
          {
            g_app->minion_connect(h);
            tminion = tnow;
          }
          if (g_app->CreateTop())
          {
            if (ttop < tnow)
            {
              h.BeginTop();
              ttop = tnow + 15;
            }
            else
            if (ttop == tnow)
            {
              h.EndTop();
              g_app->SetCreateTop( false );
            }
          }
        } // if (!g_app->NoMinder())
      }
      if (!g_app->NoMinder())
      {
        g_app->reg_minder(h, "Goodbye");
        h.Select(1,0);
        while (h.MinderSockets())
        {
          h.Select(1,0);
        }
      }
    } // while (g_bRestart)
  }
  //
  g_bWsRunning = false;
  mysql_thread_end();
  return 0;
}


static int CALLBACK MyDlgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_INITDIALOG:
		break;

	case WM_SHELLNOTIFY:
    if (lParam == WM_LBUTTONDBLCLK)
		{
      char cmd[100];
      sprintf(cmd, "http://127.0.0.1:%d/", g_app->GetLocalPort());
      ::ShellExecute(NULL, NULL, cmd, NULL, "", SW_SHOW);
    }
    else
    if (lParam == WM_RBUTTONDOWN)
    {
      MyMenu m(g_menuHandler); // 'Menu' constructor adds new object to handler
      POINT pt;

      GetCursorPos(&pt);
      SetForegroundWindow(g_hwndMain);
      int cmd = TrackPopupMenuEx(m.Handle(), 
        TPM_RIGHTALIGN|TPM_BOTTOMALIGN|TPM_RIGHTBUTTON|TPM_RETURNCMD,
        pt.x, pt.y, g_hwndMain, NULL);
      if (cmd)
      {
        if (!g_menuHandler.OnCommand( cmd ))
        {
          ::PostMessage(g_hwndMain, WM_COMMAND, cmd, 0);
        }
      }
      ::PostMessage(g_hwndMain, WM_NULL, 0, 0);
    }
		break; // WM_SHELLNOTIFY
  case WM_INITMENU:
    D2(fprintf(fil,"WM_INITMENU %08lx %08lx\n",wParam,lParam);)
    {
      HMENU hMenu = (HMENU)wParam;
      g_menuHandler.OnInitMenu(hMenu);
    }
    break;
  case WM_INITMENUPOPUP:
    D2(fprintf(fil,"WM_INITMENUPOPUP %08lx %08lx\n",wParam,lParam);)
    {
      HMENU hMenu = (HMENU)wParam;
      int relpos = lParam & 0xffff;
      int winmenu = (lParam >> 16) & 0xffff;
      D2(fprintf(fil,"  relpos: %d  winmenu: %d\n",relpos,winmenu););
      {
        MENUITEMINFO info;
        ::GetMenuItemInfo(hMenu, relpos, true, &info);
      }
      g_menuHandler.OnInitPopupMenu(hMenu, relpos, winmenu ? true : false);
    }
    break;
  case WM_MENUSELECT:
    D2(fprintf(fil,"WM_MENUSELECT %08lx %08lx\n",wParam,lParam);)
    {
      HMENU hMenu = (HMENU)lParam;
      int index = wParam & 0xffff;
      int flags = (wParam >> 16) & 0xffff;
      g_menuHandler.OnMenuSelect(hMenu, index, flags);
    }
    break;
    //
  case WM_CHANGE_ICON:
    g_app->ChangeIcon( wParam );
    break;
	case WM_COMMAND:
		switch (wParam)
		{
    case IDOK:
      g_app->GetDialogData();
    case IDCANCEL:
			ShowWindow(g_hwndMain, SW_HIDE);
      break;
    case ID_POPUP_EXIT:
      g_app->SetQuit();
			break;

    default:
			break;
		}
		break;
	}
	return 0;
}


void MyApp::ApplyChanges()
{
  m_minder_host = m_new_minder_host;
  m_minder_port = m_new_minder_port;
  m_no_minder = m_new_no_minder;
  m_join_group = m_new_join_group;
  m_use_password = m_new_use_password;
  m_group_password = m_new_group_password;

  if (m_no_minder)
  {
    ::PostMessage(g_hwndMain, WM_CHANGE_ICON, IDR_MAIN, 0);
  }
  else
  {
    ::PostMessage(g_hwndMain, WM_CHANGE_ICON, IDI_GREY, 0);
  }
}


void MyApp::SetDialogData()
{
	if (IsWindow(g_hwndMain))
	{
    char slask[1000];
    // local port
    sprintf(slask, "%d", m_local_port);
    SetWindowText(GetDlgItem(g_hwndMain, IDED_LOCAL_PORT), slask);
    // bind local
    ::CheckDlgButton(g_hwndMain, IDRB_BIND_LOCAL, m_bind_local ? 0 : 1);
    // minder host
    SetWindowText(GetDlgItem(g_hwndMain, IDED_MINDER_HOST), m_minder_host.c_str());
    // minder port
    sprintf(slask, "%d", m_minder_port);
    SetWindowText(GetDlgItem(g_hwndMain, IDED_MINDER_PORT), slask);
    // minion port
    sprintf(slask, "%d", m_minion_port);
    SetWindowText(GetDlgItem(g_hwndMain, IDED_MINION_PORT), slask);
    // no minder
    ::CheckDlgButton(g_hwndMain, IDRB_NO_MINDER, m_no_minder ? 0 : 1);
    // join group, password
    SetWindowText(GetDlgItem(g_hwndMain, IDED_JOIN_GROUP), m_join_group.c_str());
    SetWindowText(GetDlgItem(g_hwndMain, IDED_GROUP_PASSWORD), m_group_password.c_str());
    // dc
    ::CheckDlgButton(g_hwndMain, IDRB_DC, m_dc ? 1 : 0);
    // dc host
    SetWindowText(GetDlgItem(g_hwndMain, IDED_DC_HOST), m_dc_host.c_str());
    // dc port
    sprintf(slask, "%d", m_dc_port);
    SetWindowText(GetDlgItem(g_hwndMain, IDED_DC_PORT), slask);
	}
}


void MyApp::GetDialogData()
{
	if (IsWindow(g_hwndMain))
	{
    int old_local_port = m_local_port;
    bool old_bind_local = m_bind_local;
    bool old_dc = m_dc;
    std::string old_dc_host = m_dc_host;
    int old_dc_port = m_dc_port;
    char slask[1000];
    // local port
    GetWindowText(GetDlgItem(g_hwndMain, IDED_LOCAL_PORT), (LPSTR)slask, 1000);
    m_local_port = atoi(slask);
    // bind local
    m_bind_local = ::IsDlgButtonChecked(g_hwndMain, IDRB_BIND_LOCAL) ? false : true;
    // minder host
    GetWindowText(GetDlgItem(g_hwndMain, IDED_MINDER_HOST), (LPSTR)slask, 1000);
    m_new_minder_host = slask;
    // minder port
    GetWindowText(GetDlgItem(g_hwndMain, IDED_MINDER_PORT), (LPSTR)slask, 1000);
    m_new_minder_port = atoi(slask);
    // no minder
    m_new_no_minder = ::IsDlgButtonChecked(g_hwndMain, IDRB_NO_MINDER) ? false : true;
    // create top
    m_create_top = ::IsDlgButtonChecked(g_hwndMain, IDRB_CREATE_TOP) ? true : false;
    // join group, password
    GetWindowText(GetDlgItem(g_hwndMain, IDED_JOIN_GROUP), (LPSTR)slask, 1000);
    m_new_join_group = slask;
    GetWindowText(GetDlgItem(g_hwndMain, IDED_GROUP_PASSWORD), (LPSTR)slask, 1000);
    m_new_group_password = slask;
    // dc
    m_dc = ::IsDlgButtonChecked(g_hwndMain, IDRB_DC) ? true : false;
    // dc host
    GetWindowText(GetDlgItem(g_hwndMain, IDED_DC_HOST), (LPSTR)slask, 1000);
    m_dc_host = slask;
    // dc port
    GetWindowText(GetDlgItem(g_hwndMain, IDED_DC_PORT), (LPSTR)slask, 1000);
    m_dc_port = atoi(slask);
    //
    if (m_local_port != old_local_port ||
      m_bind_local != old_bind_local ||
      m_new_minder_host != m_minder_host ||
      m_new_minder_port != m_minder_port ||
      m_new_no_minder != m_no_minder ||
      m_new_join_group != m_join_group ||
      m_new_group_password != m_group_password ||
      m_dc != old_dc ||
      m_dc_host != old_dc_host ||
      m_dc_port != old_dc_port
      )
    {
      g_bRestart = true;
    }
	}
}


void MyApp::ShowTaskBar(BOOL show)
{
	NOTIFYICONDATA tnid;
	DWORD dwMsg;

	tnid.cbSize = sizeof(NOTIFYICONDATA);
	tnid.hWnd = g_hwndMain;

	if (show)
	{
		tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
		tnid.uCallbackMessage = WM_SHELLNOTIFY;
		tnid.hIcon = (HICON)LoadImage(GetInstance(), MAKEINTRESOURCE(IDR_MAIN), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
		tnid.uID = IDR_MAIN;

		strcpy(tnid.szTip, "Distributed URL Classification Tool");
		dwMsg = NIM_ADD;
	}
	else
	{
		tnid.uFlags = 0;
		tnid.uID = IDR_MAIN;
		dwMsg = NIM_DELETE;
	}

	::Shell_NotifyIcon(dwMsg, &tnid);
}


int MyApp::Init(LPSTR lpCmdLine, int nCmdShow)
{
	if (!(g_hwndMain = CreateDialog(GetInstance(), MAKEINTRESOURCE(IDD_SETTINGS), GetDesktopWindow(), MyDlgProc)))
	{
		::MessageBox(GetDesktopWindow(), "Unable to create dialog", "Error", MB_OK);
		return -1;
	}

  // Create notify changes lock
  g_hMutex = ::CreateMutex(NULL, FALSE, NULL);
  g_hMutexScan = ::CreateMutex(NULL, FALSE, NULL);
  g_hD2 = ::CreateMutex(NULL, FALSE, NULL);

	// set icon
	SendMessage(g_hwndMain, WM_SETICON, TRUE, (LPARAM)LoadIcon(GetInstance(), MAKEINTRESOURCE(IDR_MAIN)));
	ShowTaskBar(true);

  // get node id
  m_node_id = get_id();

  // CreateThread - webserver
	HANDLE h;
	DWORD dwThreadId;
	h = CreateThread(NULL, 0, start, NULL, 0, &dwThreadId);

  // winmain loop
  {
    MSG msg;
	  while (!m_quit && IsWindow(g_hwndMain) && GetMessage(&msg, g_hwndMain, NULL, NULL) != WM_QUIT)
	  {
		  if (!IsDialogMessage(g_hwndMain, &msg))
		  {
			  DispatchMessage(&msg);
		  }
	  }
  }
D2(fprintf(fil,"shutting down\n");)

  // shutdown threads
  g_bQuit = true;

  // End of program
	{
		ShowWindow(g_hwndMain, SW_HIDE);
D2(fprintf(fil,"hide window\n");)
    // %! popup: "Shutting Down" ???
    // %! kolla running status fr varje trd och gr en timeout istllet
    bool bWait = true;
    int timeout = 50; // 5s
    while (bWait && timeout--)
    {
		  Sleep(100);
      bWait = false;
      if (g_bWsRunning)
      {
        bWait = true;
      }
    }
    if (!timeout)
    {
      ::MessageBox(NULL, "Thread wait timeout", "", MB_OK);
    }
#ifdef _DEBUG
    ::MessageBox(NULL, "All threads gone", "", MB_OK);
#endif
    // delete webserver thread handle
		CloseHandle(h);
D2(fprintf(fil,"webserver h closed\n");)
//
		DestroyWindow(g_hwndMain);
D2(fprintf(fil,"g_hwndMain closed\n");)
	}
  // Remove taskbar icon
	ShowTaskBar(false);
D2(fprintf(fil,"taskbar icon removed\n");)
  ::CloseHandle(g_hMutex);
D2(fprintf(fil,"g_hMutex closed\n");)
  ::CloseHandle(g_hMutexScan);
D2(fprintf(fil,"g_hMutexScan closed\n");)
  ::CloseHandle(g_hD2);

  //
D2(fprintf(fil,"MyApp::Init() returns 0\n");)
	return 0;
} // Init


int MyApp::MemoryUsage()
{
  typedef BOOL (_stdcall * GetProcessMemoryInfoPtr)(HANDLE, void*, DWORD);
  struct _PROCESS_MEMORY_COUNTERS 
  {
    DWORD cb;
    DWORD PageFaultCount;
    SIZE_T PeakWorkingSetSize;
    SIZE_T WorkingSetSize;
    SIZE_T QuotaPeakPagedPoolUsage;
    SIZE_T QuotaPagedPoolUsage;
    SIZE_T QuotaPeakNonPagedPoolUsage;
    SIZE_T QuotaNonPagedPoolUsage;
    SIZE_T PagefileUsage;
    SIZE_T PeakPagefileUsage;
  };
  //
  HINSTANCE hLib;
  GetProcessMemoryInfoPtr GetProcessMemoryInfo;
  struct _PROCESS_MEMORY_COUNTERS mem;
  int result = 0;

  memset(&mem, 0, sizeof(mem));
  mem.cb = sizeof(mem);
  if ((hLib = LoadLibrary("psapi.dll")) != NULL)
  {
    if ((GetProcessMemoryInfo = (GetProcessMemoryInfoPtr)GetProcAddress(hLib, "GetProcessMemoryInfo")) != NULL)
    {
      if ((*GetProcessMemoryInfo)(GetCurrentProcess(), &mem, sizeof(mem)))
      {
        result = mem.WorkingSetSize / 1024;
      }
    }
    FreeLibrary(hLib);
  }
  return result;
}


BOOL MyApp::ShowBalloonTip(const std::string& title,const std::string& msg)
{
  NOTIFYICONDATA tnid;
  DWORD uTimeout = 500; // milliseconds
  memset(&tnid, 0, sizeof(tnid));
  tnid.cbSize = sizeof(NOTIFYICONDATA);
  tnid.hWnd = g_hwndMain;
	tnid.uID = IDR_MAIN;
  tnid.uFlags = NIF_INFO;
  tnid.uTimeout = uTimeout;
  tnid.dwInfoFlags = NIIF_INFO;
/*
By default, dwInfoFlags is set to NIIF_INFO to display an information icon
next to the text; other possibilities are NIIF_ERROR for an error,
NIIF_WARNING for a warning, and NIIF_NONE for no icon at all.
*/

  strcpy(tnid.szInfo, msg.c_str() );
  strcpy(tnid.szInfoTitle, title.c_str() );
  return Shell_NotifyIcon(NIM_MODIFY, &tnid);
}


void MyApp::ChangeIcon(int id)
{
  NOTIFYICONDATA tnid;
  DWORD uTimeout = 500; // milliseconds
  memset(&tnid, 0, sizeof(tnid));
  tnid.cbSize = sizeof(NOTIFYICONDATA);
  tnid.hWnd = g_hwndMain;
	tnid.uID = IDR_MAIN;
  tnid.uFlags = NIF_ICON;
	tnid.hIcon = (HICON)LoadImage(GetInstance(), MAKEINTRESOURCE(id), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
  Shell_NotifyIcon(NIM_MODIFY, &tnid);
}


void MyApp::reg_minder(FinderHandler& h,const std::string& cmd)
{
  std::string group = Utility::base64(m_join_group);
  if (m_use_password && m_group_password.size())
  {
    group += "/" + Utility::base64(m_group_password);
  }
	MyMinderSocket *m = new MyMinderSocket(h, group);
	m -> Init();

  ::PostMessage(g_hwndMain, WM_CHANGE_ICON, IDI_YELLOW, 0);
	m -> Function(cmd); // Hello / Goodbye
	m -> SetDeleteByHandler(true);
	bool opened = m -> Open(m_minder_host.c_str(), m_minder_port);
	h.Add(m);
	m -> SetLocalIpPort(h.GetLocalAddress(),h.GetLocalPort());
	if (opened && !m -> Connecting()) // connected
	{
		m -> SendHello();
	}
  if (!opened && !m->Connecting()) // fatal
  {
    ::PostMessage(g_hwndMain, WM_CHANGE_ICON, IDI_RED, 0);
    m->SetCloseAndDelete();
  }

}


void MyApp::minion_connect(FinderHandler& h)
{
	if (h.Count() < 3)
	{
		ipaddr_t a;
		port_t p;
		std::string key;
		long host_id;
		if (h.GetHost(a,p,key,host_id))
		{
			MinionSocket *tmp = new MyMinionSocket(h,key,a,p);
			tmp -> Init();
			ipaddr_t my_ip;
			port_t my_port;
			h.GetMyIpPort(my_ip, my_port);
			tmp -> SetMyIpPort(my_ip,my_port);
			tmp -> SetRemoteHostId(host_id);
			if (tmp -> Open(a,p))
			{
				tmp -> SetDeleteByHandler(true);
				h.Add(tmp);
				//
				tmp -> SendHello("Hello");
			}
			else
			if (tmp -> Connecting())
			{
				tmp -> SetDeleteByHandler(true);
				// check OnConnect
				h.Add(tmp);
			}
			else
			{
				delete tmp;
			}
		}
		else
		{
      h.LogError(NULL, "minion_connect", 0, "GetHost() failed");
		}
	}
}


