/**
 **	File ......... MenuHandler.cpp
 **	Published ....  2004-10-05
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#include "Menu.h"
#include "MenuHandler.h"

#define ID_START 20000
#define ID_SPAN 10000
// id = (ID_START .. ID_START + ID_SPAN - 1)

#ifdef _DEBUG
#define D2(x) { \
  { \
    FILE *fil = fopen("c:\\deb.log","at"); \
    x; \
    fclose(fil); \
  } \
}
#else
#define D2(x)
#endif



// statics
int MenuHandler::m_next_id = 0;


MenuHandler::MenuHandler()
{
}


MenuHandler::~MenuHandler()
{
}


void MenuHandler::Add(Menu *p)
{
  m_menulist.push_back(p);
}


void MenuHandler::Remove(Menu *p)
{
  for (menu_v::iterator it = m_menulist.begin(); it != m_menulist.end(); it++)
  {
    Menu *p0 = *it;
    if (p0 == p)
    {
      m_menulist.erase(it);
      break;
    }
  }
}


void MenuHandler::OnInitMenu(HMENU h)
{
  for (menu_v::iterator it = m_menulist.begin(); it != m_menulist.end(); it++)
  {
    Menu *p0 = *it;
    if (p0->Handle() == h)
    {
      p0->OnInitMenu();
      break;
    }
  }
}


void MenuHandler::OnInitPopupMenu(HMENU h,int relpos,bool winmenu)
{
  for (menu_v::iterator it = m_menulist.begin(); it != m_menulist.end(); it++)
  {
    Menu *p0 = *it;
    if (p0->Handle() == h)
    {
      p0->OnInitPopupMenu(relpos, winmenu);
      break;
    }
  }
}


void MenuHandler::OnMenuSelect(HMENU h,int index,int flags)
{
  for (menu_v::iterator it = m_menulist.begin(); it != m_menulist.end(); it++)
  {
    Menu *p0 = *it;
    if (p0->Handle() == h)
    {
      p0->OnMenuSelect(index, flags);
      break;
    }
  }
}


int MenuHandler::get_next_id(Menu *p)
{
  // %! lock
  int id = ID_START + (++m_next_id % ID_SPAN);
  m_id[id] = p;
D2(fprintf(fil,"new menu id: %d  ptr: %08lx\n",id,(unsigned long)p);)
  return id;
}


bool MenuHandler::Valid(Menu *p)
{
  for (menu_v::iterator it = m_menulist.begin(); it != m_menulist.end(); it++)
  {
    Menu *p0 = *it;
    if (p0 == p)
    {
      return true;
    }
  }
D2(fprintf(fil,"ptr %08lx is not valid\n",(unsigned long)p);)
  return false;
}


bool MenuHandler::OnCommand(int id)
{
  Menu *p = m_id[id];
  if (p && Valid(p))
  {
D2(fprintf(fil,"OnCommand(%d) for menu %08lx\n",id,(unsigned long)p);)
    p->OnCommand( id );
    return true; // %! not exactly true
  }
  return false;
}


