/*
 *	 /usr/devel/include/libfd.h
 *	 Generated by sql2class by (C) AH 2000
 *	 Fri Feb 11 09:16:14 2005
 */

/*
Copyright (C) 2001  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include <libmysqlwrapped.h>
#ifndef WIN32
#include <stdint.h>
#endif
#include <map>

#include <vector>
#include <string>

#ifndef _LIBFD_H
#define _LIBFD_H

#ifdef _WIN32
#define strncasecmp strnicmp
#define strcasecmp stricmp
#endif // _WIN32

/**
 **  Class 'Category' and 'cCategory'
 **/

namespace db
{
class Category {
public:
	Category(Database *);
	Category(Database *,const std::string& );
	Category(Database *,Query *,int = 0 /* offset */);
	Category(Database&,long num);
	~Category();
	my_ulonglong insert();
	void update();
	void save();
	void erase();
	std::string xml();
	std::string xml(const std::string& ,const std::string& );
	size_t num_cols();

	// table columns
	long                     num; // int(11)
	std::string              name; // varchar(255)

private:
	void clear();
	void spawn(const std::string& );
	void spawn(Query *,int = 0 /* offset */);
	void select(const std::string& );
	void update(long num);
	//
	Database *database;
	short new_object;
}; // End of class 'Category'

} // end of namespace

/**
 **  Class 'Item' and 'cItem'
 **/

namespace db
{
class Item {
	// map for ENUM column typ
	std::map<std::string, uint64_t> mmap_typ;

public:
	Item(Database *);
	Item(Database *,const std::string& );
	Item(Database *,Query *,int = 0 /* offset */);
	Item(Database&,long num);
	Item(Database&,long sz,const std::string&  sha1);
	~Item();
	my_ulonglong insert();
	void update();
	void save();
	void erase();
	std::string xml();
	std::string xml(const std::string& ,const std::string& );
	size_t num_cols();

	// table columns
	long                     num; // int(11)
	enum_t                   typ; // enum('File','URL')
	long                     category; // int(11)
	std::string              name; // varchar(255)
	std::vector<std::string> data; // mediumtext
	long                     sz; // int(11)
	std::string              sha1; // varchar(40)

private:
	void clear();
	void spawn(const std::string& );
	void spawn(Query *,int = 0 /* offset */);
	void select(const std::string& );
	void update(long num);
	//
	Database *database;
	short new_object;
}; // End of class 'Item'

} // end of namespace

/**
 **  Class 'Linkitemnode' and 'cLinkitemnode'
 **/

namespace db
{
class Linkitemnode {
public:
	Linkitemnode(Database *);
	Linkitemnode(Database *,const std::string& );
	Linkitemnode(Database *,Query *,int = 0 /* offset */);
	Linkitemnode(Database&,long item,long node);
	~Linkitemnode();
	my_ulonglong insert();
	void update();
	void save();
	void erase();
	std::string xml();
	std::string xml(const std::string& ,const std::string& );
	size_t num_cols();

	// table columns
	long                     item; // int(11)
	long                     node; // int(11)

private:
	void clear();
	void spawn(const std::string& );
	void spawn(Query *,int = 0 /* offset */);
	void select(const std::string& );
	void update(long item,long node);
	//
	Database *database;
	short new_object;
}; // End of class 'Linkitemnode'

} // end of namespace

/**
 **  Class 'Linkitemtag' and 'cLinkitemtag'
 **/

namespace db
{
class Linkitemtag {
public:
	Linkitemtag(Database *);
	Linkitemtag(Database *,const std::string& );
	Linkitemtag(Database *,Query *,int = 0 /* offset */);
	Linkitemtag(Database&,long item,long tag);
	~Linkitemtag();
	my_ulonglong insert();
	void update();
	void save();
	void erase();
	std::string xml();
	std::string xml(const std::string& ,const std::string& );
	size_t num_cols();

	// table columns
	long                     item; // int(11)
	long                     tag; // int(11)

private:
	void clear();
	void spawn(const std::string& );
	void spawn(Query *,int = 0 /* offset */);
	void select(const std::string& );
	void update(long item,long tag);
	//
	Database *database;
	short new_object;
}; // End of class 'Linkitemtag'

} // end of namespace

/**
 **  Class 'Node' and 'cNode'
 **/

namespace db
{
class Node {
public:
	Node(Database *);
	Node(Database *,const std::string& );
	Node(Database *,Query *,int = 0 /* offset */);
	Node(Database&,long num);
	Node(Database&,const std::string&  uid);
	~Node();
	my_ulonglong insert();
	void update();
	void save();
	void erase();
	std::string xml();
	std::string xml(const std::string& ,const std::string& );
	size_t num_cols();

	// table columns
	long                     num; // int(11)
	std::string              uid; // char(40)

private:
	void clear();
	void spawn(const std::string& );
	void spawn(Query *,int = 0 /* offset */);
	void select(const std::string& );
	void update(long num);
	//
	Database *database;
	short new_object;
}; // End of class 'Node'

} // end of namespace

/**
 **  Class 'Tag' and 'cTag'
 **/

namespace db
{
class Tag {
public:
	Tag(Database *);
	Tag(Database *,const std::string& );
	Tag(Database *,Query *,int = 0 /* offset */);
	Tag(Database&,long num);
	~Tag();
	my_ulonglong insert();
	void update();
	void save();
	void erase();
	std::string xml();
	std::string xml(const std::string& ,const std::string& );
	size_t num_cols();

	// table columns
	long                     num; // int(11)
	std::string              name; // varchar(255)

private:
	void clear();
	void spawn(const std::string& );
	void spawn(Query *,int = 0 /* offset */);
	void select(const std::string& );
	void update(long num);
	//
	Database *database;
	short new_object;
}; // End of class 'Tag'

} // end of namespace
#endif // _LIBFD_H
