/* useful hex manipulation routines */
/* Copyright C Qualcomm Inc 1997 */
/* %W% (AHAG) %E% */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "hexlib.h"

/* some useful macros -- little-endian */
#define B(x,i) ((H_UCHAR)(((x) >> (8*i)) & 0xFF))
#define BYTE2WORD(b) ( \
	(((H_WORD)(b)[3] & 0xFF)<<24) | \
	(((H_WORD)(b)[2] & 0xFF)<<16) | \
	(((H_WORD)(b)[1] & 0xFF)<<8) | \
	(((H_WORD)(b)[0] & 0xFF)) \
)
#define WORD2BYTE(w, b) { \
	(b)[3] = B(w,3); \
	(b)[2] = B(w,2); \
	(b)[1] = B(w,1); \
	(b)[0] = B(w,0); \
}


int	nerrors;

static char	*hex = "0123456789abcdef";
#define HEX(c) (strchr(hex, (c)) - hex)

int
hexprint(const char *s, H_UCHAR *p, int n)
{
    printf("%14s:", s);
    while (--n >= 0) {
	if (n % 20 == 19)
	    printf("\n%14s ", "");
	printf(" %02x", *p++);
    }
    printf("\n");
    return 0;
}

int
hexread(H_UCHAR *buf, char *p, int n)
{
    int		i;

    while (--n >= 0) {
	while (*p == ' ') ++p;
	i = HEX(*p++) << 4;
	i += HEX(*p++);
	*buf++ = i;
    }
    return 0;
}

int
hexcheck(H_UCHAR *buf, char *p, int n)
{
    int		i;

    while (--n >= 0) {
	while (*p == ' ') ++p;
	i = HEX(*p++) << 4;
	i += HEX(*p++);
	if (*buf++ != i) {
	    printf("Expected %02x, got %02x.\n", i, buf[-1]);
	    ++nerrors;
	}
    }
    return nerrors;
}

int
hexbulk(H_UCHAR *buf, int n)
{
    int		i;

    for (i = 0; i < n; ++i)
	printf("%02x%c", buf[i], (i%16 == 15 ? '\n' : ' '));
    if (i % 16 != 0)
	putchar('\n');
    return 0;
}

/* word versions */
static H_WORD	w;
static H_UCHAR	b[4];

int
hexwprint(const char *s, H_WORD *p, int n)
{
    printf("%14s:", s);
    while (n > 0) {
	if (n % 20 == 19)
	    printf("\n%14s ", "");
	WORD2BYTE(*p, b);
	++p;
	printf(" %02x %02x %02x %02x", b[0], b[1], b[2], b[3]);
	n -= 4;
    }
    printf("\n");
    return 0;
}

int
hexwread(H_WORD *buf, char *p, int n)
{
    int		i, c;

    for (i = 0; i < n; ++i) {
	while (*p == ' ') ++p;
	c = HEX(*p++) << 4;
	c += HEX(*p++);
	b[i & 0x03] = c;
	if ((i & 0x03) == 0x03)
	    *buf++ = BYTE2WORD(b);
    }
    return 0;
}

int
hexwcheck(H_WORD *buf, char *p, int n)
{
    int		i, c;

    for (i = 0; i < n; ++i) {
	while (*p == ' ') ++p;
	c = HEX(*p++) << 4;
	c += HEX(*p++);
	b[i & 0x03] = c;
	if ((i & 0x03) == 0x03 && *buf++ != BYTE2WORD(b)) {
	    printf("Expected %08lx, got %08lx.\n", BYTE2WORD(b), buf[-1]);
	    ++nerrors;
	}
    }
    return nerrors;
}

int
hexwbulk(H_WORD *buf, int n)
{
    int		i;

    for (i = 0; i < n; ++i) {
	if ((i & 0x03) == 0) {
	    WORD2BYTE(*buf, b);
	    ++buf;
	}
	printf("%02x%c", b[i & 0x03], (i%16 == 15 ? '\n' : ' '));
    }
    if (i % 16 != 0)
	putchar('\n');
    return 0;
}
