#include "hexlib.h"

/* 3.2, figure 2, block function */
H_WORD			h_block(H_WORD X_i0, H_WORD P_i, H_WORD X_i1);

/* 3.7 Key schedule.
 * Could do feistel in place, but this follows description in paper.
 */
void			h_key(unsigned char *U, int U_len);

/* 3.3, nonce setup */
void			h_nonce(H_UCHAR nonce[16]);

/* 3.3, X_i functions */
H_WORD			X(int one);

/* 3.4 initialisation */
void			h_init();

/* 3.5 encryption, and 3.6 compute MAC */
void			h_encrypt(H_UCHAR *buf, int n, H_UCHAR macbuf[16]);

/* 3.8 decryption, and 3.6 compute MAC */
void			h_decrypt(H_UCHAR *buf, int n, H_UCHAR macbuf[16]);


/*
    	h_key(key, keysz);
    	h_nonce(IV);

	h_encrypt(bigbuf, i, macbuf);

	h_nonce(IV);
	h_decrypt(bigbuf, i, macbuf);
*/
