// forms.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifdef WIN32
#include <config-win.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <libmysqlwrapped.h>
#include <libfd.h>
#include <string>
#include <libcgi++.h>
#include <Utility.h>
#include <MinderHandler.h>
#include <openssl/sha.h>

#include "dbd.h"
#include "forms.h"


#ifdef _DEBUG
#define D2(x) { \
	FILE *fil = fopen("c:\\deb.log","at"); \
	x; \
	fclose(fil); \
}
#else
#define D2(x)
#endif


void form_input(Database& db, Query& q, char *sql, Form *form, Cookies *cs, int& flik)
{
	char slask[1000];
	if (form -> getvalue("post_form",slask,20) && *slask && atoi(slask))
	{
		std::string typ = form -> getvalue("typ"); // 'File' / 'URL'
		D2(fprintf(fil," * post form type '%s'\n", typ.c_str());)
		if (typ != "File" && typ != "URL" && typ != "Again")
		{
			return;
		}
		long category = 0;
		if (form -> getvalue("newcategory",slask,1000) && *slask)
		{
			sprintf(sql,"select * from category where name='%s'", db.safestr(slask).c_str());
			db::Category cat(&db,sql);
			cat.name = slask;
			cat.save();
			category = cat.num;
		}
		else
		{
			form -> getvalue("category",slask,20);
			category = atol(slask);
			db::Category cat(db, category);
			category = cat.num;
		}
		if (!category)
		{
			return;
		}
		long itemnum = 0;
		bool bAgain = false;
		// the_file, the_url
		// tagx, newtagx
		db::Node node(db, get_id());
		node.uid = get_id();
		node.save();

		if (typ == "Again")
		{
			form -> getvalue("itemnr",slask,20);
			long itemnr = atol(slask);
			db::Item item(db, itemnr);
			if (item.num)
			{
				item.category = category;
				item.save();
				itemnum = item.num;
				bAgain = true;
			}
		}
		else
		if (typ == "File")
		{
			std::string the_file = form -> getvalue("the_file");
			FILE *fil = fopen(the_file.c_str(), "rb"); // hurrv, safety?
			if (fil)
			{
				size_t sz = 0;
				unsigned char sha1buf[20];
				{
					SHA_CTX ctx;
					SHA1_Init(&ctx);
					size_t n = fread(slask, 1, 1000, fil);
					while (n > 0)
					{
						SHA1_Update(&ctx, slask, n);
						sz += n;
						//
						n = fread(slask, 1, 1000, fil);
					}
					SHA1_Final(sha1buf, &ctx);
				}
				fclose(fil);
				if (sz >= 400000L)
				{
					g_bSize = true;
					return;
				}
				*slask = 0;
				for (int n = 0; n < 20; n++)
				{
					sprintf(slask + strlen(slask),"%02x",sha1buf[n]);
				}
				D2(fprintf(fil, " * file sha1: %s\n", slask);)
				db::Item item(db, sz, slask);
				cgi::Base64 b('@');
				item.typ = typ;
				item.category = category;
				size_t x = 0;
				for (size_t i = 0; i < the_file.size(); i++)
				{
					if (the_file[i] == '\\')
					{
						x = i + 1;
					}
				}
				item.name = the_file.substr(x);
				D2(fprintf(fil, " * encoding base64\n");)
				b.encode_from_file(the_file.c_str(), item.data);
				item.sz = sz;
				item.sha1 = slask;
				item.save();
				itemnum = item.num;
				D2(fprintf(fil, " * new item saved\n");)
			}
		}
		else // typ == "URL"
		{
			std::string the_url = form -> getvalue("the_url");
			if (the_url.size() > 7 && !strncasecmp(the_url.c_str(), "http://", 7))
			{
				size_t sz = the_url.size();
				unsigned char sha1buf[20];
				{
					SHA_CTX ctx;
					SHA1_Init(&ctx);
					SHA1_Update(&ctx, the_url.c_str(), the_url.size());
					SHA1_Final(sha1buf, &ctx);
				}
				*slask = 0;
				for (int n = 0; n < 20; n++)
				{
					sprintf(slask + strlen(slask),"%02x",sha1buf[n]);
				}
				db::Item item(db, sz, slask);
				item.typ = typ;
				item.category = category;
				item.name = the_url;
				item.sz = sz;
				item.sha1 = slask;
				item.save();
				itemnum = item.num;
			}
		}
		if (!itemnum)
		{
			return;
		}
		// link node 
		if (!bAgain)
		{
			db::Linkitemnode xlink(db, itemnum, node.num);
			xlink.item = itemnum;
			xlink.node = node.num;
			xlink.save();
		}
		// tags
		long tag1 = 0;
		long tag2 = 0;
		long tag3 = 0;
		// tag 1
		if (form -> getvalue("newtag1",slask,1000) && *slask)
		{
			sprintf(sql,"select * from tag where name='%s'", db.safestr(slask).c_str());
			db::Tag tag(&db, sql);
			tag.name = slask;
			tag.save();
			db::Linkitemtag x(db, itemnum, tag.num);
			x.item = itemnum;
			x.tag = tag.num;
			x.save();
			tag1 = tag.num;
		}
		else
		{
			form -> getvalue("tag1",slask,20);
			long tagnum = atol(slask);
			db::Tag tag(db, tagnum);
			tagnum = tag.num;
			if (tagnum)
			{
				db::Linkitemtag x(db, itemnum, tagnum);
				x.item = itemnum;
				x.tag = tagnum;
				x.save();
				tag1 = tagnum;
			}
		}
		// tag 2
		if (form -> getvalue("newtag2",slask,1000) && *slask)
		{
			sprintf(sql,"select * from tag where name='%s'", db.safestr(slask).c_str());
			db::Tag tag(&db, sql);
			tag.name = slask;
			tag.save();
			db::Linkitemtag x(db, itemnum, tag.num);
			x.item = itemnum;
			x.tag = tag.num;
			x.save();
			tag2 = tag.num;
		}
		else
		{
			form -> getvalue("tag2",slask,20);
			long tagnum = atol(slask);
			db::Tag tag(db, tagnum);
			tagnum = tag.num;
			if (tagnum)
			{
				db::Linkitemtag x(db, itemnum, tagnum);
				x.item = itemnum;
				x.tag = tagnum;
				x.save();
				tag2 = tagnum;
			}
		}
		// tag 3
		if (form -> getvalue("newtag3",slask,1000) && *slask)
		{
			sprintf(sql,"select * from tag where name='%s'", db.safestr(slask).c_str());
			db::Tag tag(&db, sql);
			tag.name = slask;
			tag.save();
			db::Linkitemtag x(db, itemnum, tag.num);
			x.item = itemnum;
			x.tag = tag.num;
			x.save();
			tag3 = tag.num;
		}
		else
		{
			form -> getvalue("tag3",slask,20);
			long tagnum = atol(slask);
			db::Tag tag(db, tagnum);
			tagnum = tag.num;
			if (tagnum)
			{
				db::Linkitemtag x(db, itemnum, tagnum);
				x.item = itemnum;
				x.tag = tagnum;
				x.save();
				tag3 = tagnum;
			}
		}

		// send message
		//	'post' _ typ : nodeid : 64(category) : 64(name) : data(64) : sz : sha1 : 64(tags)...
		{
			db::Item item(db, itemnum);
			db::Category cat(db, item.category);
			std::string msg = "post_" + item.typ.String();
			msg += ":" + (bAgain ? " null" : get_id()); // get node id
			msg += ":" + Utility::base64(cat.name);
			msg += ":" + Utility::base64(item.name);
			std::string data;
			if (item.typ == "URL")
			{
				data = Utility::base64(item.name);
			}
			else
			{
				for (std::vector<std::string>::iterator it = item.data.begin(); it != item.data.end(); it++)
				{
					data += *it;
				}
			}
			msg += ":" + data;
			msg += ":" + Utility::l2string(item.sz);
			msg += ":" + item.sha1;
			sprintf(sql,"select * from linkitemtag where item=%ld", item.num);
			q.get_result(sql);
			while (q.fetch_row())
			{
				db::Linkitemtag x(&db,&q);
				db::Tag tag(db, x.tag);
				msg += ":" + Utility::base64(tag.name);
			}
			q.free_result();

			D2(fprintf(fil,"Sending message: %s\n", msg.c_str());)

			static_cast<MinderHandler&>(g_pSocket->Handler()).SendMessage(Utility::base64(msg));
		}
		flik = 1; // search
	} // "post_form"

} // form_input



