// dbd.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifdef WIN32
#include <config-win.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <libmysqlwrapped.h>
#include <libfd.h>
#include <string>
#include <libcgi++.h>
#include <Uid.h>

#include "utils.h"
#include "forms.h"
#include "Mime.h"
#include "FinderHandler.h"

#include "dbd.h"


/*
 *
 */

static long searchtag = 0;
static long searchcat = 0;
static std::string m_id = "";

FILE *out = stdout;
ExecSocket *g_pSocket = NULL;
char tmp_path[1000];
bool g_bSize = false;


void valflik(int nr,const std::string& title,int flik)
{
	fprintf(out, "<div style='border: 1px #c0c0c0 solid; background: #e0e0e0;"
		" margin-bottom: 5px; width: 100px;' align='center'>");
	if (flik == nr)
		fprintf(out,"<a style='font-weight: bold;' href='/cgi-bin/exec?flik=%d'>%s</a>", nr, title.c_str());
	else
		fprintf(out,"<a href='/cgi-bin/exec?flik=%d'>%s</a>", nr, title.c_str());
	fprintf(out, "</div>");
}


void run(Database& db,FILE *o,const std::string& input_data)
{
#ifdef WIN32
	::GetTempPath(1000, tmp_path);
	strcat(tmp_path, "\\");
#else
	strcpy(tmp_path, "/tmp/");
#endif

	// output file, stdout or file on disk
	out = o;
	Query q(db);
	Form *form = NULL;
	Cookies *cs;
//	char *r_h = getenv("REMOTE_HOST");
	char *q_s = getenv("QUERY_STRING");
//	char *c_l = getenv("CONTENT_LENGTH");
	char *r_m = getenv("REQUEST_METHOD");
	char *http_cookie = getenv("HTTP_COOKIE");
	char sql[1000];
	char slask[1000];

// before calling Form(), check how we are called - code from webmud@home

	if (!r_m)
	{
		printf("This program is part of a cgi script, and should not be\n");
		printf("be called from the command line\n");
		return;
	}

	if (!strcasecmp(r_m,"get"))
	{
		if (q_s)
			form = new Form(q_s,strlen(q_s));
		else
			form = new Form("", 0); // empty query string...
	}
	else
	if (input_data.size()) // from ExecSocket
	{
		FILE *fil = fopen(input_data.c_str(),"rb");
		form = new Form(fil);
		fclose(fil);
	}
	else
	{
		if (!strcasecmp(r_m,"post"))
			form = new Form();
	}
	if (!form)
	{
		return;
	}

	// reset
	g_bSize = false;

	// retreive cookie(s)
	cs = new Cookies(http_cookie ? http_cookie : (char *)"");
	unpack_cookie(cs);

	cs -> getvalue("flik",slask,20);
	int flik = atoi(slask);

	// receive form data
	form_input(db, q, sql, form, cs, flik);
	if (form -> getvalue("flik",slask,20))
	{
		flik = atoi(slask);
	}
	searchtag = searchcat = 0;
	if (form -> getvalue("tag",slask,20))
	{
		searchtag = atol(slask);
	}
	if (form -> getvalue("cat",slask,20))
	{
		searchcat = atol(slask);
	}
	long again = 0;
	if (form -> getvalue("again",slask,20) && *slask && atoi(slask))
	{
		 again = atol(slask);
		 flik = 2;
	}

	// get file
	long get_file = 0;
	if (form -> getvalue("get_file",slask,20) && *slask && atoi(slask))
	{
		get_file = atol(slask);
	}
	if (get_file)
	{
		db::Item item(db, get_file);
		if (item.num)
		{
			cgi::Base64 b('@');
			std::string mime = static_cast<FinderHandler&>(g_pSocket->Handler()).GetMimeFromFile(item.name);
			std::string data;
			for (std::vector<std::string>::iterator it = item.data.begin(); it != item.data.end(); it++)
			{
				data += *it;
			}
			fprintf(out, "Content-type: %s\r\n", mime.c_str());
			fprintf(out, "Content-length: %d\r\n", b.decode_length(data));
//			fprintf(out, "Content-disposition: attachment; filename=%s\r\n", item.name.c_str());
			fprintf(out, "Content-disposition: filename=%s\r\n", item.name.c_str());
			fprintf(out, "\r\n");
			b.decode_to_stdout(data, out);
			return;
		}
	}

	// http header
	set_cookie(cs,"flik",flik);
	{
		pack_and_set_cookies(cs);
		fprintf(out,"Content-type: text/html; charset=ISO-8859-1\r\n");

		// End of http header
		fprintf(out,"\r\n");
		fflush(out);
	}

	// Create page
	fprintf(out,"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">\n");
	fflush(out);

	fprintf(out,"<html><head><title>Distributed URL Classification Tool</title>");
	fprintf(out,"<link rel='SHORTCUT ICON' href='/favicon.ico'>");
	fprintf(out,
		"<style type='text/css'>"
		"th.x { background: #c0c0c0; padding-left: 8px; padding-right: 8px; }\n"
		"td.x { background: #e0e0e0; padding-left: 8px; padding-right: 8px; }\n"
//		"body { margin: 0; padding: 0; font-family: sans-serif; }\n"
		"a { text-decoration: none; color: #0000ff; padding-left: 8px; padding-right: 8px; }\n"
		"a:hover { text-decoration: none; color: #ffffff; background: #0000ff; padding-left: 8px; padding-right: 8px; }\n"
		"</style>");
	fprintf(out,"</head>");

	// body
	fprintf(out,"<body>");
	fprintf(out, "<div align='center'>");

	// logo
	fprintf(out, "<table width='100%%'><tr><td valign='top'>");
	fprintf(out, "<table cellspacing=5 cellpadding=5><tr><td valign='top'>"
		"<a href='http://www.alhem.net/duct/'>"
		"<img src='/ahl.png' border=0>"
		"</a>");
	fprintf(out,
		"</td><td valign='center'>");
	valflik(1,"Search",flik);
	valflik(2,"Post",flik);
	fprintf(out, "</td></tr></table>");

	if (g_bSize)
	{
		fprintf(out,"<h3 style='color: #800000'>Largest file size allowed is 400000 bytes</h3>");
	}

	switch (flik)
	{
	case 1:
		search(db, q, sql, form, cs);
		break;
	case 2:
		if (again)
		{
			db::Item item(db, again);
			post_form(db, q, sql, &item);
		}
		else
		{
			post_form(db, q, sql);
		}
		break;
	}
	fprintf(out, "</td><td valign='top' align='right'>");
//	fprintf(out, "Categories&nbsp;|&nbsp;Tags");
	showcats(db, q, sql, searchcat, searchtag);
	fprintf(out, "</td></tr></table>");

	// footer
	fprintf(out, "</div>");
	fprintf(out,"</body></html>\n");

	// cleanup	
	delete form;
	delete cs;
}


void post_form(Database& db,Query& q,char *sql,db::Item *p)
{
	fprintf(out,"<form action='/cgi-bin/exec' method='post' enctype='multipart/form-data'>");
	fprintf(out,"<input type=hidden name=post_form value=1>");
	if (p)
	{
		fprintf(out,"<input type=hidden name=typ value='Again'>");
		fprintf(out,"<input type=hidden name=itemnr value=%ld>", p -> num);
		fprintf(out,"<p style='font-weight: bold;'>Send item again</p>");
		fprintf(out,"<p><u>%s</u>: %s</p>",p->typ.c_str(),p->name.c_str());
	}
	else
	{
		fprintf(out,"<p style='font-weight: bold;'>Item type</p>");
		fprintf(out,"<table cellspacing=5><tr>");
		fprintf(out,"<td><input type=radio name=typ value='File'>File</td>");
		fprintf(out,"<td><input type=file name=the_file></td>"
			"</tr><tr>");
		fprintf(out,"<td><input type=radio name=typ value='URL' checked>URL</td>");
		fprintf(out,"<td><input type=text size=40 name=the_url value='http://'></td>");
		fprintf(out,"</tr></table>");
	}

	fprintf(out,"<p style='font-weight: bold;'>Category</p>");

	q.get_result("select * from category order by name");
	if (q.num_rows())
	{
		fprintf(out,"<select name=category><option>");
		while (q.fetch_row())
		{
			db::Category tag(&db, &q);
			fprintf(out,"<option value=%ld%s>%s", tag.num, (p && p->category == tag.num) ? " selected" : "",tag.name.c_str() );
		}
		fprintf(out,"</select> or ");
	}
	q.free_result();
	fprintf(out,"new category <input type=text name=newcategory><br>");

	fprintf(out,"<p style='font-weight: bold;'>Tags (optional)</p>");

	q.get_result("select * from tag order by name");
	if (q.num_rows())
	{
		fprintf(out,"<select name=tag1><option>");
		while (q.fetch_row())
		{
			db::Tag tag(&db, &q);
			fprintf(out,"<option value=%ld>%s", tag.num, tag.name.c_str() );
		}
		fprintf(out,"</select> or ");
	}
	q.free_result();
	fprintf(out,"new tag <input type=text name=newtag1><br>");

	q.get_result("select * from tag order by name");
	if (q.num_rows())
	{
		fprintf(out,"<select name=tag2><option>");
		while (q.fetch_row())
		{
			db::Tag tag(&db, &q);
			fprintf(out,"<option value=%ld>%s", tag.num, tag.name.c_str() );
		}
		fprintf(out,"</select> or ");
	}
	q.free_result();
	fprintf(out,"new tag <input type=text name=newtag2><br>");

	q.get_result("select * from tag order by name");
	if (q.num_rows())
	{
		fprintf(out,"<select name=tag3><option>");
		while (q.fetch_row())
		{
			db::Tag tag(&db, &q);
			fprintf(out,"<option value=%ld>%s", tag.num, tag.name.c_str() );
		}
		fprintf(out,"</select> or ");
	}
	q.free_result();
	fprintf(out,"new tag <input type=text name=newtag3><br>");

	if (p)
	{
		fprintf(out,"<p><input type=submit name=submit value=' Send again '></p>");
	}
	else
	{
		fprintf(out,"<p><input type=submit name=submit value=' Submit new item '></p>");
	}
	//
	fprintf(out,"</form>");
}


void search(Database& db,Query& q,char *sql,Form *form,Cookies *cs)
{
	Query q2(db);

	if (searchtag)
	{
		sprintf(sql,"select item.* from item,linkitemtag where linkitemtag.tag=%ld and item.num=linkitemtag.item",searchtag);
		q.get_result(sql);
	}
	else
	if (searchcat)
	{
		sprintf(sql,"select * from item where category=%ld", searchcat);
		q.get_result(sql);
	}
	else
	{
		q.get_result("select * from item");
	}
	fprintf(out,"<table cellspacing=1>");
	fprintf(out,"<tr>");
	fprintf(out,"<th class='x'>Type</th>"
		"<th class='x'>Category</th>"
		"<th class='x'>Tags</th>"
		"<th class='x'>Link</th>"
		"<th class='x'>Size</th>");
//		"<th class='x'>Checksum</th>");
	fprintf(out,"</tr>");
	while (q.fetch_row())
	{
		db::Item item(&db, &q);
		db::Category cat(db, item.category);

		fprintf(out,"<tr>");
		fprintf(out,"<td class='x'>%s</td>", item.typ.c_str());
		fprintf(out,"<td class='x'><a href='/cgi-bin/exec?cat=%ld'>%s</a></td>", cat.num, cat.name.c_str());
		// tags
		fprintf(out,"<td class='x'>");
		sprintf(sql, "select * from linkitemtag where item=%ld", item.num);
		q2.get_result(sql);
		while (q2.fetch_row())
		{
			db::Linkitemtag x(&db, &q2);
			db::Tag tag(db, x.tag);
			fprintf(out,"&nbsp;<a href='/cgi-bin/exec?tag=%ld'>%s</a>",tag.num,tag.name.c_str());
		}
		q2.free_result();
		fprintf(out,"</td>");
		//
		if (item.typ == "URL")
		{
			fprintf(out,"<td class='x'><a href='%s'>%s</a></td>", item.name.c_str(), item.name.c_str());
		}
		else
		if (item.typ == "File")
		{
			fprintf(out,"<td class='x'><a href='/cgi-bin/exec?get_file=%ld'>%s</a></td>", item.num, item.name.c_str());
		}
		fprintf(out,"<td class='x' align='right'>%ld</td>",item.sz);
//		fprintf(out,"<td class='x'>%s</td>",item.sha1.c_str());
		fprintf(out,"<td><a href='/cgi-bin/exec?again=%ld'>send&nbsp;again</a></td>",item.num);
		fprintf(out,"</tr>");
	}
	q.free_result();
	fprintf(out,"</table>");
}


std::string get_id()
{
	if (!m_id.size())
	{
		FILE *fil = fopen("nodeid.dat","rb");
		if (fil)
		{
			unsigned char buf[16];
			fread(buf, 1, 16, fil);
			fclose(fil);
			Uid uid(buf);
			m_id = uid.GetUid();
		}
		else
		{
			Uid uid;
			fil = fopen("nodeid.dat","wb");
			fwrite(uid.GetBuf(), 1, 16, fil);
			fclose(fil);
			m_id = uid.GetUid();
		}
	}
	return m_id;
}


void showcats(Database& db,Query& q,char *sql,long searchcat,long searchtag)
{
	fprintf(out,"<b>Categories</b><br>");
	q.get_result("select * from category order by name");
	while (q.fetch_row())
	{
		db::Category cat(&db, &q);
		if (cat.num == searchcat)
		{
			fprintf(out,"<a style='font-weight: bold;' href='/cgi-bin/exec?cat=%ld'>%s</a><br>",cat.num,cat.name.c_str());
		}
		else
		{
			fprintf(out,"<a href='/cgi-bin/exec?cat=%ld'>%s</a><br>",cat.num,cat.name.c_str());
		}
	}
	q.free_result();

	fprintf(out,"<b>Tags</b><br>");
	q.get_result("select * from tag order by name");
	while (q.fetch_row())
	{
		db::Tag cat(&db, &q);
		if (cat.num == searchtag)
		{
			fprintf(out,"<a style='font-weight: bold;' href='/cgi-bin/exec?tag=%ld'>%s</a><br>",cat.num,cat.name.c_str());
		}
		else
		{
			fprintf(out,"<a href='/cgi-bin/exec?tag=%ld'>%s</a><br>",cat.num,cat.name.c_str());
		}
	}
	q.free_result();

}


