/**
 **	File ......... MyMinionSocket.h
 **	Published ....  2004-04-19
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _MYMINIONSOCKET_H
#define _MYMINIONSOCKET_H

#include <MinionSocket.h>
#include <NullCrypt.h>
#include "FinderHandler.h"
#include "HCrypt.h"


class MyMinionSocket : public MinionSocket
{
public:
	MyMinionSocket(SocketHandler& );
	MyMinionSocket(SocketHandler& ,bool,const std::string& ,port_t);
	MyMinionSocket(SocketHandler& ,const std::string& ,ipaddr_t,port_t);
	~MyMinionSocket();

	ICrypt *AllocateCrypt() { return new HCrypt; }
	int GetMaxConnections() { return 3; }
	unsigned char *GetKey_m2minion() { return static_cast<FinderHandler&>(Handler()).GetKey_m2minion(); }

	void Notify(const std::string& str) { 
		Handler().LogError(this, "Notify", 0, str.c_str());
	}

	bool OnVerifiedLine(const std::string& cmd,Parse& pa);

	void OnConnect(); // MinionSocket::SendHello("Hello")
	void OnAccept();
	void TryConnect(const std::string& cmd); // connect, accept

protected:
	void OnLine(const std::string& );

private:
	bool m_dc;
	std::string m_dc_host;
	port_t m_dc_port;
};




#endif // _MYMINIONSOCKET_H
