/**
 **	File ......... MyMinionSocket.cpp
 **	Published ....  2004-04-19
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
//#include <stdio.h>
#include "MyMinionSocket.h"
#include "FinderHandler.h"
#include <Utility.h>
#ifdef _WIN32
#include <config-win.h>
#include <mysql.h>
#include <libmysqlwrapped.h>
#define strcasecmp stricmp
#else
#include <mysql/mysql.h>
#include <libmysqlwrapped.h>
#endif
#include <libfd.h>
#ifdef WIN32
#include "win32/MyApp.h"
#endif
#include <Uid.h>

#ifdef _DEBUG
#define D2(x) { \
	FILE *fil = fopen("c:\\deb.log","at"); \
	x; \
	fclose(fil); \
}
#else
#define D2(x)
#endif


MyMinionSocket::MyMinionSocket(SocketHandler& h)
:MinionSocket(h)
{
}


MyMinionSocket::MyMinionSocket(SocketHandler& h,bool dc,const std::string& host,port_t port)
:MinionSocket(h)
,m_dc(dc)
,m_dc_host(host)
,m_dc_port(port)
{
}


MyMinionSocket::MyMinionSocket(SocketHandler& h,const std::string& s,ipaddr_t a,port_t p)
:MinionSocket(h,s,a,p)
{
}


MyMinionSocket::~MyMinionSocket()
{
}


bool MyMinionSocket::OnVerifiedLine(const std::string& cmd,Parse& pa)
{
	FinderHandler& h = static_cast<FinderHandler&>(Handler());
	Database& db = h.GetDatabase();

	D2(fprintf(fil,"MyMinionSocket verified command: %s\n",cmd.c_str());)
	Handler().LogError(this, "my verified line", 0, cmd, LOG_LEVEL_WARNING);

	//	'post' _ typ : nodeid : 64(category) : 64(name) : data(64) : sz : sha1 : 64(tags)...
	if (cmd == "post")
	{
		Query q(db);
		char sql[1000];

		std::string typ = pa.getword();
		D2(fprintf(fil," post.typ == '%s'\n",typ.c_str());)
		if (typ != "File" && typ != "URL")
		{
			return true;
		}
		std::string strNodeid = pa.getword();
		std::string strCategory = Utility::base64d(pa.getword());
		std::string strName = Utility::base64d(pa.getword());
		std::string strData = pa.getword();
		size_t sz = pa.getvalue();
		std::string strSha1 = pa.getword();
		// end of message
		D2(fprintf(fil,
			"category: %s\n"
			"name: %s\n"
			"data: %s\n"
			"size: %d\n"
			"sha1: %s\n", strCategory.c_str(),
			strName.c_str(), strData.c_str(), sz, strSha1.c_str());)

		db::Node node(db, strNodeid);
		node.uid = strNodeid;
		if (strNodeid != " null")
		{
			node.save();
		}

		sprintf(sql,"select * from category where name='%s'", db.safestr(strCategory).c_str());
		db::Category cat(&db, sql);
		cat.name = strCategory;
		cat.save();

		db::Item item(db, sz, strSha1);
		item.typ = typ;
		item.category = cat.num;
		item.name = strName;
		item.data.push_back( strData );
		item.sz = sz;
		item.sha1 = strSha1;
		item.save();

		if (strNodeid != " null")
		{
			db::Linkitemnode xlink(db, item.num, node.num);
			xlink.item = item.num;
			xlink.node = node.num;
			xlink.save();
		}

#ifdef WIN32
		g_app->ShowBalloonTip("Minion", cat.name + ": " + item.name);
#endif

		std::string strTag = pa.getword();
		while (strTag.size())
		{
			std::string tmp = Utility::base64d(strTag);
			sprintf(sql,"select * from tag where name='%s'", db.safestr(tmp).c_str());
			db::Tag tag(&db, sql);
			tag.name = tmp;
			tag.save();
			db::Linkitemtag x(db, item.num, tag.num);
			x.item = item.num;
			x.tag = tag.num;
			x.save();
			//
			strTag = pa.getword();
		}

	}
	else
	{
		return MinionSocket::OnVerifiedLine(cmd, pa);
	}
	return true;
}


void MyMinionSocket::OnConnect()
{
	if (m_dc)
	{
		TryConnect("connect");
	}
	else
	{
		MinionSocket::OnConnect();
	}
#ifdef WIN32
	std::string remote = this->GetRemoteHostname();
	std::string remote_ip = this->GetRemoteAddress();
	g_app->ShowBalloonTip("Minion", "Connected to " + remote + " (" + remote_ip + ")");
#endif
}


void MyMinionSocket::OnAccept()
{
	MinionSocket::OnAccept();
#ifdef WIN32
	std::string remote = this->GetRemoteHostname();
	std::string remote_ip = this->GetRemoteAddress();
	g_app->ShowBalloonTip("Minion", "Incoming connection from " + remote + " (" + remote_ip + ")");
#endif
}


void MyMinionSocket::TryConnect(const std::string& cmd) // connect, accept
{
	std::string remote_id = (cmd == "connect") ? "null" : GetRemoteId();
	std::string str;
	Utility::l2ip(GetMyIP(),str);
	char msg[200];
	sprintf(msg,"%s_%s:%s:%d:%s:%ld\n",
		cmd.c_str(),
		remote_id.c_str(),
		str.c_str(),
		GetMyPort(),
		static_cast<MinderHandler&>(Handler()).GetID().c_str(),
		static_cast<MinderHandler&>(Handler()).GetHostId() );
	{
		Send( msg );
	}
}


void MyMinionSocket::OnLine(const std::string& line)
{
	Parse pa(line, "_:");
	std::string cmd = pa.getword();
	if (cmd == "connect")
	{
		Handler().LogError(this, "dc connect", 0, line, LOG_LEVEL_WARNING);
		std::string my_id = pa.getword(); // "null"
		std::string ipstr = pa.getword(); // remote ip
		port_t port = (port_t)pa.getvalue(); // remote port
		std::string remote_id = pa.getword();
		long remote_host_id = pa.getvalue();
		// end of message
		{
			ipaddr_t ip;
			int max = GetMaxConnections(); //atoi(config["max_connections"].c_str());
			max = (max == 0) ? 4 : max;

			Utility::u2ip(ipstr, ip);

			if (!static_cast<MinderHandler&>(Handler()).FindMinion(remote_id) &&
				static_cast<MinderHandler&>(Handler()).Count() < max * 2 + 1)
			{
				SetRemoteId(remote_id);
				SetIP(ip); // remote ip
				SetPort(port); // remote listen port
				SetIDVerified();
				SetRemoteHostId(remote_host_id);
				TryConnect("accept");
			}
			else
			{
				{
					Uid ruid(remote_id);
					memcpy(GetKey_m2minion() + 8,ruid.GetBuf(),16);
					Send( encrypt(GetKey_m2minion(), "Bye") + "\n" );
				}
				SetCloseAndDelete(true);
			}
		}
	}
	else
	if (cmd == "accept")
	{
		Handler().LogError(this, "dc accept", 0, line, LOG_LEVEL_WARNING);
		std::string id = pa.getword();
		std::string ipstr = pa.getword(); // remote ip
		port_t port = (port_t)pa.getvalue(); // remote port
		std::string remote_id = pa.getword();
		long remote_host_id = pa.getvalue();
		// end of message
		{
			ipaddr_t ip;
			Utility::u2ip(ipstr, ip);

			if (id == static_cast<MinderHandler&>(Handler()).GetID() &&
				!static_cast<MinderHandler&>(Handler()).FindMinion(remote_id))
			{
				SetRemoteId(remote_id);
				SetIP(ip); // remote ip
				SetPort(port); // remote listen port
				SetIDVerified();
				SetRemoteHostId(remote_host_id);
				SendHello("Hi");
			}
			else
			{
				{
					Uid ruid(remote_id);
					memcpy(GetKey_m2minion() + 8,ruid.GetBuf(),16);
					Send( encrypt(GetKey_m2minion(), "Bye") + "\n" );
				}
				SetCloseAndDelete(true);
			}
		}
	}
	else
	{
		MinionSocket::OnLine( line );
	}
}


