/**
 **	File ......... FinderHandler.h
 **	Published ....  2004-09-27
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _FINDERHANDLER_H
#define _FINDERHANDLER_H

#include <MinderHandler.h>
#include "Mime.h"
#include "dbd.h"


class Database;
class MyApp;


class FinderHandler : public MinderHandler
{
public:
	FinderHandler(Database&);
	~FinderHandler();

	Database& GetDatabase() { return m_db; }

	std::string datetime2httpdate(const std::string& dt);
	/** Get server startup datetime in httpdate format */
	std::string GetStart();
	/** Get current datetime yyyy-mm-dd hh:mm:ss */
	std::string GetDate();

	std::string GetMimeFromFile(const std::string& );

	//
	std::string GetVersion() { return static_cast<std::string>(_VERSION); }
	unsigned char *GetKey_m2minion() { return m_m2minion; }

	size_t MinionSockets();

	unsigned long Get_tdiff() { return m_tdiff; }
	unsigned long Get_tdiff2() { return m_tdiff2; }

	void CheckSocketTimeout();
	void BeginTop();
	void EndTop();
	int FinderSockets();


private:
	Database& m_db;
	time_t m_start;
	Mime m_mime;
	static unsigned char m_m2minion[32];
	unsigned long m_tdiff;
	unsigned long m_tdiff2;
};


#endif // _FINDERHANDLER_H
