//#include <stdio.h>
#include <Base64.h>
#include <Uid.h>

#include "helix.h"
#include "HCrypt.h"

#define DEB(x)

#ifdef _WIN32
#define strcasecmp stricmp
#endif


HCrypt::HCrypt()
:ICrypt()
{
}


std::string HCrypt::encrypt(unsigned char *ik,const std::string& msg)
{
	Base64 mb;
DEB(	printf(" decrypted message size in: %d\n",msg.size());)
	Uid nonce;
DEB(	printf(" encrypt nonce '%s'\n",nonce.GetUid().c_str());)
	unsigned char *wtmp = new unsigned char[msg.size() + 32];
	std::string str;
	memcpy(wtmp,msg.c_str(),msg.size());
	h_key(ik, 32);
	h_nonce( (H_UCHAR *)nonce.GetBuf());
	h_encrypt(wtmp, msg.size(), wtmp + msg.size() + 16);
	memcpy(wtmp + msg.size(),nonce.GetBuf(),16);
	mb.encode(wtmp,msg.size() + 32,str,false);
	delete wtmp;
DEB(	printf(" encrypted message size out: %d\n",str.size());)
	return str;
}


bool HCrypt::decrypt(unsigned char *ik,const std::string& msg,std::string& output)
{
	Base64 mb;
DEB(	printf(" encrypted message size in: %d\n",msg.size());)
	unsigned char *wtmp = new unsigned char[msg.size() + 32];
	size_t sz = msg.size();
	mb.decode(msg,wtmp,sz);
	Uid nonce(wtmp + sz - 32);
DEB(	printf(" decrypt nonce '%s'\n",nonce.GetUid().c_str());)
	Uid wmac(wtmp + sz - 16);
	unsigned char mac[16];
	h_key(ik, 32);
	h_nonce( (H_UCHAR *)nonce.GetBuf());
	h_decrypt(wtmp,sz - 32,mac);
	Uid gmac(mac);
	if (!strcasecmp(wmac.GetUid().c_str(),gmac.GetUid().c_str()))
	{
		wtmp[sz - 32] = 0;
		output = (char *)wtmp;
	}
	else
	{
//		fprintf(stderr,"decrypt failed\n");
//		fprintf(stderr," %s\n %s\n",wmac.GetUid().c_str(),gmac.GetUid().c_str());
		output = "";
		delete wtmp;
		return false;
	}
	delete wtmp;
DEB(	printf(" decrypted message size out: %d\n",output.size());)
	return true;
}


