/**
 **	File ......... FinderHandler.cpp
 **	Published ....  2004-09-27
**/
/*
Copyright (C) 2004  Anders Hedstrm (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifdef _WIN32
#pragma warning(disable:4786)
#endif
#include "FinderHandler.h"
#include <sys/types.h>
#include <sys/timeb.h>

#ifdef WIN32
#include <config-win.h>
#include <mysql.h>
#else
#include <mysql/mysql.h>
#endif
#include <libmysqlwrapped.h>
#include <time.h>
#include <libcgi++.h>
#include "ExecSocket.h"
#include <Utility.h>


// statics
unsigned char FinderHandler::m_m2minion[32] =
{
	0x19,0xbc,0xab,0x98, 0x60,0x91,0x4b,0xbc,
	0x8d,0xba,0x8b,0x38, 0xef,0x58,0x67,0x0d,
	0xb7,0x58,0x3f,0x6e, 0xb8,0x9e,0x4e,0x7a,
	0xa4,0x1d,0x2f,0xf0, 0xb1,0x93,0x33,0xf7,
};



FinderHandler::FinderHandler(Database& p) : MinderHandler()
,m_db(p)
,m_start(time(NULL))
,m_mime("mime.types")
{
}


FinderHandler::~FinderHandler()
{
}


std::string FinderHandler::datetime2httpdate(const std::string& dt)
{
	char slask[8];
	struct tm tp;
	time_t t;
	char *days[] = { "Sun","Mon","Tue","Wed","Thu","Fri","Sat" };
	char *months[] = { "Jan","Feb","Mar","Apr","May","Jun",
										 "Jul","Aug","Sep","Oct","Nov","Dec" };
	int i;
	char s[40];

/* 1997-12-16 09:50:40 */

	if (dt.size() == 19) // && (int)strlen(dt) == 19)
	{
		slask[4] = 0;
		tp.tm_year = atoi(strncpy(slask,dt.c_str(),4)) - 1900;
		slask[2] = 0;
		i = atoi(strncpy(slask,dt.c_str() + 5,2)) - 1;
		tp.tm_mon = i >= 0 ? i : 0;
		tp.tm_mday = atoi(strncpy(slask,dt.c_str() + 8,2));
		tp.tm_hour = atoi(strncpy(slask,dt.c_str() + 11,2));
		tp.tm_min = atoi(strncpy(slask,dt.c_str() + 14,2));
		tp.tm_sec = atoi(strncpy(slask,dt.c_str() + 17,2));
		tp.tm_wday = 0;
		tp.tm_yday = 0;
		tp.tm_isdst = 0;
		t = mktime(&tp);
		if (t == -1)
		{
			this->LogError(NULL, "datetime2httpdate", 0, "mktime() failed");
		}

		sprintf(s,"%s, %02d %s %d %02d:%02d:%02d GMT",
		 days[tp.tm_wday],
		 tp.tm_mday,
		 months[tp.tm_mon],
		 tp.tm_year + 1900,
		 tp.tm_hour,tp.tm_min,tp.tm_sec);
	} 
	else
	{
		*s = 0;
	}
	return s;
}


std::string FinderHandler::GetStart()
{
	struct tm* tp = localtime(&m_start);
	char slask[40];
	if (tp)
	{
		sprintf(slask,"%d-%02d-%02d %02d:%02d:%02d",
			tp -> tm_year + 1900,
			tp -> tm_mon + 1,
			tp -> tm_mday,
			tp -> tm_hour,tp -> tm_min,tp -> tm_sec);
	}
	else
	{
		*slask = 0;
	}
	return datetime2httpdate( slask );
}


std::string FinderHandler::GetDate()
{
	time_t t = time(NULL);
	struct tm* tp = localtime(&t);
	char slask[40];
	if (tp)
	{
		sprintf(slask,"%d-%02d-%02d %02d:%02d:%02d",
			tp -> tm_year + 1900,
			tp -> tm_mon + 1,
			tp -> tm_mday,
			tp -> tm_hour,tp -> tm_min,tp -> tm_sec);
	}
	else
	{
		*slask = 0;
	}
	return slask;
}


std::string FinderHandler::GetMimeFromFile(const std::string& name)
{
	return m_mime.GetMimeFromFile(name);
}


size_t FinderHandler::MinionSockets()
{
	size_t qty = 0;
	for (socket_m::iterator it = m_sockets.begin(); it != m_sockets.end(); it++)
	{
		Socket *p0 = (*it).second;
		if (dynamic_cast<MinionSocket *>(p0))
		{
			qty++;
		}
	}
	return qty;
}


void FinderHandler::BeginTop()
{
	std::string msg = "Tip_" + Utility::l2string(GetHostId());
	SendMessage(Utility::base64(msg));
	unlink("top_map.dot");
	FILE *fil;

	if ((fil = fopen("top_map.dot","wt")) != NULL)
	{
		fprintf(fil,"digraph \"G\" {\n");
		fprintf(fil,"\tedge [arrowhead=open]\n");
#ifdef _WIN32
		std::string os = "Win32";
#else
		std::string os = "Linux";
#endif
		fprintf(fil,"\t\"%ld\" [label=\"%ld\\n%s\\n%s\" style=filled fillcolor=\"#e0e0e0\"]\n",
			GetHostId(),
			GetHostId(),
			GetVersion().c_str(),
			os.c_str());
		Tops(fil);
		fclose(fil);
	}
}


void FinderHandler::EndTop()
{
	FILE *fil = fopen("top_map.dot","at");
	char cmd[200];
	if (fil)
	{
		fprintf(fil,"}\n");
		fclose(fil);
		sprintf(cmd, "\\program files\\att\\graphviz\\bin\\DOT.EXE -Tpng -o top_map.png top_map.dot");
		system( cmd );
		unlink("top_map.dot");
	}
}


