// ExecSocket.h
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _EXECSOCKET_H
#define _EXECSOCKET_H

#include <SocketHandler.h>
#include <HTTPSocket.h>


class ExecSocket : public HTTPSocket
{
public:
	ExecSocket(SocketHandler& );
	~ExecSocket();

	void OnFirst();
	void OnHeader(const std::string& ,const std::string& );
	void OnHeaderComplete();
	void OnData(const char *,size_t);

	void Exec();

	const std::string& GetHttpDate();

private:
	void header(FILE *,int,const std::string& );
	void Send64(const std::string& str64, const std::string& type);
	int m_content_length;
static	int m_request_count;
	FILE *m_file;
	int m_received;
	std::string m_tmpname;
	int m_request_id;
	// headers
	std::string m_http_cookie;
	std::string m_content_type;
	std::string m_content_length_str;
	std::string m_if_modified_since;
	std::string m_http_date;
};




#endif // _EXECSOCKET_H
