/*
 *	 /usr/devel/src/libdbd/libdbd.cpp
 *	 Generated by sql2class by (C) AH 2000
 *	 Thu May 27 14:10:44 2004
 */

/*
Copyright (C) 2001  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include <libsql++.h>
#include <libdbd.h>

namespace db {

/**
 **  Begin class 'Access'
 **/

	Access::Access(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Access::Access(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from access where num=%ld",ix);
		spawn(sql);
	}
	Access::Access(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Access::Access(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Access::~Access()
	{
	}

	void Access::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Access::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into access(num,usernum,dbnum,r,w,c,d,rdata,wdata)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",usernum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",dbnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",r);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",w);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",c);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",d);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",rdata);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",wdata);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Access::update()
	{
		Access::update(num);
	}

	void Access::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update access set usernum='%ld'",usernum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", dbnum='%ld'",dbnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", r='%ld'",r);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", w='%ld'",w);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", c='%ld'",c);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", d='%ld'",d);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", rdata='%ld'",rdata);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", wdata='%ld'",wdata);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Access::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Access::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from access where num=%ld",num);
		q.execute(sql);
	}

	std::string Access::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<ACCESS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		sprintf(slask,"<R>%ld</R>",r);
		dest += slask;
		sprintf(slask,"<W>%ld</W>",w);
		dest += slask;
		sprintf(slask,"<C>%ld</C>",c);
		dest += slask;
		sprintf(slask,"<D>%ld</D>",d);
		dest += slask;
		sprintf(slask,"<RDATA>%ld</RDATA>",rdata);
		dest += slask;
		sprintf(slask,"<WDATA>%ld</WDATA>",wdata);
		dest += slask;
		dest += "</ACCESS>";
		return dest;
	}

	std::string Access::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<ACCESS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		sprintf(slask,"<R>%ld</R>",r);
		dest += slask;
		sprintf(slask,"<W>%ld</W>",w);
		dest += slask;
		sprintf(slask,"<C>%ld</C>",c);
		dest += slask;
		sprintf(slask,"<D>%ld</D>",d);
		dest += slask;
		sprintf(slask,"<RDATA>%ld</RDATA>",rdata);
		dest += slask;
		sprintf(slask,"<WDATA>%ld</WDATA>",wdata);
		dest += slask;
		dest += "</ACCESS>";
		return dest;
	}

	int Access::num_cols()
	{
		return 9;
	}

	void Access::clear()
	{
		num = 0;
		usernum = 0;
		dbnum = 0;
		r = 0;
		w = 0;
		c = 0;
		d = 0;
		rdata = 0;
		wdata = 0;
	}
	void Access::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,usernum,dbnum,r,w,c,d,rdata,wdata " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			usernum = q.getval(1);                                // 1 - usernum int(11)
			dbnum = q.getval(2);                                  // 2 - dbnum int(11)
			r = q.getval(3);                                      // 3 - r tinyint(1)
			w = q.getval(4);                                      // 4 - w tinyint(1)
			c = q.getval(5);                                      // 5 - c tinyint(1)
			d = q.getval(6);                                      // 6 - d tinyint(1)
			rdata = q.getval(7);                                  // 7 - rdata tinyint(1)
			wdata = q.getval(8);                                  // 8 - wdata tinyint(1)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Access::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		usernum = qd -> getval(1);                                // 1 - usernum int(11)
		dbnum = qd -> getval(2);                                  // 2 - dbnum int(11)
		r = qd -> getval(3);                                      // 3 - r tinyint(1)
		w = qd -> getval(4);                                      // 4 - w tinyint(1)
		c = qd -> getval(5);                                      // 5 - c tinyint(1)
		d = qd -> getval(6);                                      // 6 - d tinyint(1)
		rdata = qd -> getval(7);                                  // 7 - rdata tinyint(1)
		wdata = qd -> getval(8);                                  // 8 - wdata tinyint(1)
	}

// End of implementation of class 'Access'

} // End of namespace
namespace db {

/**
 **  Begin class 'Appfields'
 **/

	Appfields::Appfields(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Appfields::Appfields(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from appfields where num=%ld",ix);
		spawn(sql);
	}
	Appfields::Appfields(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Appfields::Appfields(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Appfields::~Appfields()
	{
	}

	void Appfields::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Appfields::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into appfields(num,appnum,fldnum,status,tblnum)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",appnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",fldnum);
			sql += slask;
		}
		sql += ", '" + q.safestr(status) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",tblnum);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Appfields::update()
	{
		Appfields::update(num);
	}

	void Appfields::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update appfields set appnum='%ld'",appnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", fldnum='%ld'",fldnum);
			sql += slask;
		}
		sql += ", status='" + q.safestr(status) + "'";
		{
			char slask[200];
			sprintf(slask,", tblnum='%ld'",tblnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Appfields::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Appfields::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from appfields where num=%ld",num);
		q.execute(sql);
	}

	std::string Appfields::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<APPFIELDS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<APPNUM>%ld</APPNUM>",appnum);
		dest += slask;
		sprintf(slask,"<FLDNUM>%ld</FLDNUM>",fldnum);
		dest += slask;
		dest += "<STATUS>" + q.xmlsafestr(status) + "</STATUS>";
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		dest += "</APPFIELDS>";
		return dest;
	}

	std::string Appfields::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<APPFIELDS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<APPNUM>%ld</APPNUM>",appnum);
		dest += slask;
		sprintf(slask,"<FLDNUM>%ld</FLDNUM>",fldnum);
		dest += slask;
		dest += "<STATUS>" + q.xmlsafestr(status) + "</STATUS>";
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		dest += "</APPFIELDS>";
		return dest;
	}

	int Appfields::num_cols()
	{
		return 5;
	}

	void Appfields::clear()
	{
		num = 0;
		appnum = 0;
		fldnum = 0;
		*status = 0;
		tblnum = 0;
	}
	void Appfields::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,appnum,fldnum,status,tblnum " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			appnum = q.getval(1);                                 // 1 - appnum int(11)
			fldnum = q.getval(2);                                 // 2 - fldnum int(11)
			strcpy(status,q.getstr(3));                           // 3 - status enum('Planned','Implemented','Hold')
			tblnum = q.getval(4);                                 // 4 - tblnum int(11)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Appfields::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		appnum = qd -> getval(1);                                 // 1 - appnum int(11)
		fldnum = qd -> getval(2);                                 // 2 - fldnum int(11)
		strcpy(status,qd -> getstr(3));                           // 3 - status enum('Planned','Implemented','Hold')
		tblnum = qd -> getval(4);                                 // 4 - tblnum int(11)
	}

// End of implementation of class 'Appfields'

} // End of namespace
namespace db {

/**
 **  Begin class 'Applications'
 **/

	Applications::Applications(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Applications::Applications(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from applications where num=%ld",ix);
		spawn(sql);
	}
	Applications::Applications(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Applications::Applications(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Applications::~Applications()
	{
	}

	void Applications::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Applications::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into applications(num,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,dbnum,description)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",owner);
			sql += slask;
		}
		sql += ", '" + q.safestr(createdate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",changedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(changedate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",deleted);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",deletedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(deletedate) + "'";
		sql += ", '" + q.safestr(name) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",version);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",dbnum);
			sql += slask;
		}
		sql += ", '" + q.safestr(description) + "'";
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Applications::update()
	{
		Applications::update(num);
	}

	void Applications::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update applications set owner='%ld'",owner);
			sql += slask;
		}
		sql += ", createdate='" + q.safestr(createdate) + "'";
		{
			char slask[200];
			sprintf(slask,", changedby='%ld'",changedby);
			sql += slask;
		}
		sql += ", changedate='" + q.safestr(changedate) + "'";
		{
			char slask[200];
			sprintf(slask,", deleted='%ld'",deleted);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", deletedby='%ld'",deletedby);
			sql += slask;
		}
		sql += ", deletedate='" + q.safestr(deletedate) + "'";
		sql += ", name='" + q.safestr(name) + "'";
		{
			char slask[200];
			sprintf(slask,", version='%ld'",version);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", dbnum='%ld'",dbnum);
			sql += slask;
		}
		sql += ", description='" + q.safestr(description) + "'";
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Applications::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Applications::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from applications where num=%ld",num);
		q.execute(sql);
	}

	std::string Applications::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<APPLICATIONS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		dest += "</APPLICATIONS>";
		return dest;
	}

	std::string Applications::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<APPLICATIONS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		dest += "</APPLICATIONS>";
		return dest;
	}

	int Applications::num_cols()
	{
		return 12;
	}

	void Applications::clear()
	{
		num = 0;
		owner = 0;
		*createdate = 0;
		changedby = 0;
		*changedate = 0;
		deleted = 0;
		deletedby = 0;
		*deletedate = 0;
		*name = 0;
		version = 0;
		dbnum = 0;
		*description = 0;
	}
	void Applications::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,dbnum,description " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			owner = q.getval(1);                                  // 1 - owner int(11)
			strcpy(createdate,q.getstr(2));                       // 2 - createdate datetime
			changedby = q.getval(3);                              // 3 - changedby int(11)
			strcpy(changedate,q.getstr(4));                       // 4 - changedate datetime
			deleted = q.getval(5);                                // 5 - deleted tinyint(1)
			deletedby = q.getval(6);                              // 6 - deletedby int(11)
			strcpy(deletedate,q.getstr(7));                       // 7 - deletedate datetime
			strcpy(name,q.getstr(8));                             // 8 - name char(40)
			version = q.getval(9);                                // 9 - version int(11)
			dbnum = q.getval(10);                                 // 10 - dbnum int(11)
			strcpy(description,q.getstr(11));                     // 11 - description char(40)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Applications::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		owner = qd -> getval(1);                                  // 1 - owner int(11)
		strcpy(createdate,qd -> getstr(2));                       // 2 - createdate datetime
		changedby = qd -> getval(3);                              // 3 - changedby int(11)
		strcpy(changedate,qd -> getstr(4));                       // 4 - changedate datetime
		deleted = qd -> getval(5);                                // 5 - deleted tinyint(1)
		deletedby = qd -> getval(6);                              // 6 - deletedby int(11)
		strcpy(deletedate,qd -> getstr(7));                       // 7 - deletedate datetime
		strcpy(name,qd -> getstr(8));                             // 8 - name char(40)
		version = qd -> getval(9);                                // 9 - version int(11)
		dbnum = qd -> getval(10);                                 // 10 - dbnum int(11)
		strcpy(description,qd -> getstr(11));                     // 11 - description char(40)
	}

// End of implementation of class 'Applications'

} // End of namespace
namespace db {

/**
 **  Begin class 'Apptables'
 **/

	Apptables::Apptables(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Apptables::Apptables(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from apptables where num=%ld",ix);
		spawn(sql);
	}
	Apptables::Apptables(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Apptables::Apptables(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Apptables::~Apptables()
	{
	}

	void Apptables::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Apptables::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into apptables(num,appnum,tblnum,checked)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",appnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",tblnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",checked);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Apptables::update()
	{
		Apptables::update(num);
	}

	void Apptables::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update apptables set appnum='%ld'",appnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", tblnum='%ld'",tblnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", checked='%ld'",checked);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Apptables::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Apptables::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from apptables where num=%ld",num);
		q.execute(sql);
	}

	std::string Apptables::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<APPTABLES>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<APPNUM>%ld</APPNUM>",appnum);
		dest += slask;
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		sprintf(slask,"<CHECKED>%ld</CHECKED>",checked);
		dest += slask;
		dest += "</APPTABLES>";
		return dest;
	}

	std::string Apptables::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<APPTABLES " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<APPNUM>%ld</APPNUM>",appnum);
		dest += slask;
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		sprintf(slask,"<CHECKED>%ld</CHECKED>",checked);
		dest += slask;
		dest += "</APPTABLES>";
		return dest;
	}

	int Apptables::num_cols()
	{
		return 4;
	}

	void Apptables::clear()
	{
		num = 0;
		appnum = 0;
		tblnum = 0;
		checked = 0;
	}
	void Apptables::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,appnum,tblnum,checked " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			appnum = q.getval(1);                                 // 1 - appnum int(11)
			tblnum = q.getval(2);                                 // 2 - tblnum int(11)
			checked = q.getval(3);                                // 3 - checked tinyint(1)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Apptables::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		appnum = qd -> getval(1);                                 // 1 - appnum int(11)
		tblnum = qd -> getval(2);                                 // 2 - tblnum int(11)
		checked = qd -> getval(3);                                // 3 - checked tinyint(1)
	}

// End of implementation of class 'Apptables'

} // End of namespace
namespace db {

/**
 **  Begin class 'Appusers'
 **/

	Appusers::Appusers(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Appusers::Appusers(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from appusers where num=%ld",ix);
		spawn(sql);
	}
	Appusers::Appusers(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Appusers::Appusers(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Appusers::~Appusers()
	{
	}

	void Appusers::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Appusers::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into appusers(num,appnum,usernum,status)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",appnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",usernum);
			sql += slask;
		}
		sql += ", '" + q.safestr(status) + "'";
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Appusers::update()
	{
		Appusers::update(num);
	}

	void Appusers::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update appusers set appnum='%ld'",appnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", usernum='%ld'",usernum);
			sql += slask;
		}
		sql += ", status='" + q.safestr(status) + "'";
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Appusers::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Appusers::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from appusers where num=%ld",num);
		q.execute(sql);
	}

	std::string Appusers::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<APPUSERS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<APPNUM>%ld</APPNUM>",appnum);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		dest += "<STATUS>" + q.xmlsafestr(status) + "</STATUS>";
		dest += "</APPUSERS>";
		return dest;
	}

	std::string Appusers::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<APPUSERS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<APPNUM>%ld</APPNUM>",appnum);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		dest += "<STATUS>" + q.xmlsafestr(status) + "</STATUS>";
		dest += "</APPUSERS>";
		return dest;
	}

	int Appusers::num_cols()
	{
		return 4;
	}

	void Appusers::clear()
	{
		num = 0;
		appnum = 0;
		usernum = 0;
		*status = 0;
	}
	void Appusers::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,appnum,usernum,status " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			appnum = q.getval(1);                                 // 1 - appnum int(11)
			usernum = q.getval(2);                                // 2 - usernum int(11)
			strcpy(status,q.getstr(3));                           // 3 - status enum('Developer','Tester')
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Appusers::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		appnum = qd -> getval(1);                                 // 1 - appnum int(11)
		usernum = qd -> getval(2);                                // 2 - usernum int(11)
		strcpy(status,qd -> getstr(3));                           // 3 - status enum('Developer','Tester')
	}

// End of implementation of class 'Appusers'

} // End of namespace
namespace db {

/**
 **  Begin class 'Dbs'
 **/

	Dbs::Dbs(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Dbs::Dbs(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from dbs where num=%ld",ix);
		spawn(sql);
	}
	Dbs::Dbs(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Dbs::Dbs(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Dbs::~Dbs()
	{
	}

	void Dbs::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Dbs::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into dbs(num,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,description)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",owner);
			sql += slask;
		}
		sql += ", '" + q.safestr(createdate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",changedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(changedate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",deleted);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",deletedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(deletedate) + "'";
		sql += ", '" + q.safestr(name) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",version);
			sql += slask;
		}
		sql += ", '" + q.safestr(description) + "'";
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Dbs::update()
	{
		Dbs::update(num);
	}

	void Dbs::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update dbs set owner='%ld'",owner);
			sql += slask;
		}
		sql += ", createdate='" + q.safestr(createdate) + "'";
		{
			char slask[200];
			sprintf(slask,", changedby='%ld'",changedby);
			sql += slask;
		}
		sql += ", changedate='" + q.safestr(changedate) + "'";
		{
			char slask[200];
			sprintf(slask,", deleted='%ld'",deleted);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", deletedby='%ld'",deletedby);
			sql += slask;
		}
		sql += ", deletedate='" + q.safestr(deletedate) + "'";
		sql += ", name='" + q.safestr(name) + "'";
		{
			char slask[200];
			sprintf(slask,", version='%ld'",version);
			sql += slask;
		}
		sql += ", description='" + q.safestr(description) + "'";
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Dbs::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Dbs::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from dbs where num=%ld",num);
		q.execute(sql);
	}

	std::string Dbs::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<DBS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		dest += "</DBS>";
		return dest;
	}

	std::string Dbs::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<DBS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		dest += "</DBS>";
		return dest;
	}

	int Dbs::num_cols()
	{
		return 11;
	}

	void Dbs::clear()
	{
		num = 0;
		owner = 0;
		*createdate = 0;
		changedby = 0;
		*changedate = 0;
		deleted = 0;
		deletedby = 0;
		*deletedate = 0;
		*name = 0;
		version = 0;
		*description = 0;
	}
	void Dbs::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,description " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			owner = q.getval(1);                                  // 1 - owner int(11)
			strcpy(createdate,q.getstr(2));                       // 2 - createdate datetime
			changedby = q.getval(3);                              // 3 - changedby int(11)
			strcpy(changedate,q.getstr(4));                       // 4 - changedate datetime
			deleted = q.getval(5);                                // 5 - deleted tinyint(1)
			deletedby = q.getval(6);                              // 6 - deletedby int(11)
			strcpy(deletedate,q.getstr(7));                       // 7 - deletedate datetime
			strcpy(name,q.getstr(8));                             // 8 - name char(40)
			version = q.getval(9);                                // 9 - version int(11)
			strcpy(description,q.getstr(10));                     // 10 - description char(80)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Dbs::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		owner = qd -> getval(1);                                  // 1 - owner int(11)
		strcpy(createdate,qd -> getstr(2));                       // 2 - createdate datetime
		changedby = qd -> getval(3);                              // 3 - changedby int(11)
		strcpy(changedate,qd -> getstr(4));                       // 4 - changedate datetime
		deleted = qd -> getval(5);                                // 5 - deleted tinyint(1)
		deletedby = qd -> getval(6);                              // 6 - deletedby int(11)
		strcpy(deletedate,qd -> getstr(7));                       // 7 - deletedate datetime
		strcpy(name,qd -> getstr(8));                             // 8 - name char(40)
		version = qd -> getval(9);                                // 9 - version int(11)
		strcpy(description,qd -> getstr(10));                     // 10 - description char(80)
	}

// End of implementation of class 'Dbs'

} // End of namespace
namespace db {

/**
 **  Begin class 'Flds'
 **/

	Flds::Flds(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Flds::Flds(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from flds where num=%ld",ix);
		spawn(sql);
	}
	Flds::Flds(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Flds::Flds(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Flds::~Flds()
	{
		if (options)
			delete options;
	}

	void Flds::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Flds::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into flds(num,tblnum,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,fieldtype,charlength,minvalue,maxvalue,options,ptrtotblnum,ordning,integerlength,description,fieldstr,fieldflags,decimallength,defaultvalue)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",tblnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",owner);
			sql += slask;
		}
		sql += ", '" + q.safestr(createdate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",changedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(changedate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",deleted);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",deletedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(deletedate) + "'";
		sql += ", '" + q.safestr(name) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",version);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",fieldtype);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",charlength);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",minvalue);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",maxvalue);
			sql += slask;
		}
		sql += ", '" + q.safestr(options) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",ptrtotblnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",ordning);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",integerlength);
			sql += slask;
		}
		sql += ", '" + q.safestr(description) + "'";
		sql += ", '" + q.safestr(fieldstr) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",fieldflags);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",decimallength);
			sql += slask;
		}
		sql += ", '" + q.safestr(defaultvalue) + "'";
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Flds::update()
	{
		Flds::update(num);
	}

	void Flds::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update flds set tblnum='%ld'",tblnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", owner='%ld'",owner);
			sql += slask;
		}
		sql += ", createdate='" + q.safestr(createdate) + "'";
		{
			char slask[200];
			sprintf(slask,", changedby='%ld'",changedby);
			sql += slask;
		}
		sql += ", changedate='" + q.safestr(changedate) + "'";
		{
			char slask[200];
			sprintf(slask,", deleted='%ld'",deleted);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", deletedby='%ld'",deletedby);
			sql += slask;
		}
		sql += ", deletedate='" + q.safestr(deletedate) + "'";
		sql += ", name='" + q.safestr(name) + "'";
		{
			char slask[200];
			sprintf(slask,", version='%ld'",version);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", fieldtype='%ld'",fieldtype);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", charlength='%ld'",charlength);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", minvalue='%ld'",minvalue);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", maxvalue='%ld'",maxvalue);
			sql += slask;
		}
		sql += ", options='" + q.safestr(options) + "'";
		{
			char slask[200];
			sprintf(slask,", ptrtotblnum='%ld'",ptrtotblnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", ordning='%ld'",ordning);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", integerlength='%ld'",integerlength);
			sql += slask;
		}
		sql += ", description='" + q.safestr(description) + "'";
		sql += ", fieldstr='" + q.safestr(fieldstr) + "'";
		{
			char slask[200];
			sprintf(slask,", fieldflags='%ld'",fieldflags);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", decimallength='%ld'",decimallength);
			sql += slask;
		}
		sql += ", defaultvalue='" + q.safestr(defaultvalue) + "'";
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Flds::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Flds::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from flds where num=%ld",num);
		q.execute(sql);
	}

	std::string Flds::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<FLDS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		sprintf(slask,"<FIELDTYPE>%ld</FIELDTYPE>",fieldtype);
		dest += slask;
		sprintf(slask,"<CHARLENGTH>%ld</CHARLENGTH>",charlength);
		dest += slask;
		sprintf(slask,"<MINVALUE>%ld</MINVALUE>",minvalue);
		dest += slask;
		sprintf(slask,"<MAXVALUE>%ld</MAXVALUE>",maxvalue);
		dest += slask;
		dest += "<OPTIONS>" + q.xmlsafestr(options) + "</OPTIONS>";
		sprintf(slask,"<PTRTOTBLNUM>%ld</PTRTOTBLNUM>",ptrtotblnum);
		dest += slask;
		sprintf(slask,"<ORDNING>%ld</ORDNING>",ordning);
		dest += slask;
		sprintf(slask,"<INTEGERLENGTH>%ld</INTEGERLENGTH>",integerlength);
		dest += slask;
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		dest += "<FIELDSTR>" + q.xmlsafestr(fieldstr) + "</FIELDSTR>";
		sprintf(slask,"<FIELDFLAGS>%ld</FIELDFLAGS>",fieldflags);
		dest += slask;
		sprintf(slask,"<DECIMALLENGTH>%ld</DECIMALLENGTH>",decimallength);
		dest += slask;
		dest += "<DEFAULTVALUE>" + q.xmlsafestr(defaultvalue) + "</DEFAULTVALUE>";
		dest += "</FLDS>";
		return dest;
	}

	std::string Flds::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<FLDS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		sprintf(slask,"<FIELDTYPE>%ld</FIELDTYPE>",fieldtype);
		dest += slask;
		sprintf(slask,"<CHARLENGTH>%ld</CHARLENGTH>",charlength);
		dest += slask;
		sprintf(slask,"<MINVALUE>%ld</MINVALUE>",minvalue);
		dest += slask;
		sprintf(slask,"<MAXVALUE>%ld</MAXVALUE>",maxvalue);
		dest += slask;
		dest += "<OPTIONS>" + q.xmlsafestr(options) + "</OPTIONS>";
		sprintf(slask,"<PTRTOTBLNUM>%ld</PTRTOTBLNUM>",ptrtotblnum);
		dest += slask;
		sprintf(slask,"<ORDNING>%ld</ORDNING>",ordning);
		dest += slask;
		sprintf(slask,"<INTEGERLENGTH>%ld</INTEGERLENGTH>",integerlength);
		dest += slask;
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		dest += "<FIELDSTR>" + q.xmlsafestr(fieldstr) + "</FIELDSTR>";
		sprintf(slask,"<FIELDFLAGS>%ld</FIELDFLAGS>",fieldflags);
		dest += slask;
		sprintf(slask,"<DECIMALLENGTH>%ld</DECIMALLENGTH>",decimallength);
		dest += slask;
		dest += "<DEFAULTVALUE>" + q.xmlsafestr(defaultvalue) + "</DEFAULTVALUE>";
		dest += "</FLDS>";
		return dest;
	}

	int Flds::num_cols()
	{
		return 24;
	}

	void Flds::clear()
	{
		num = 0;
		tblnum = 0;
		owner = 0;
		*createdate = 0;
		changedby = 0;
		*changedate = 0;
		deleted = 0;
		deletedby = 0;
		*deletedate = 0;
		*name = 0;
		version = 0;
		fieldtype = 0;
		charlength = 0;
		minvalue = 0;
		maxvalue = 0;
		options = NULL;
		ptrtotblnum = 0;
		ordning = 0;
		integerlength = 0;
		*description = 0;
		*fieldstr = 0;
		fieldflags = 0;
		decimallength = 0;
		*defaultvalue = 0;
	}
	void Flds::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,tblnum,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,fieldtype,charlength,minvalue,maxvalue,options,ptrtotblnum,ordning,integerlength,description,fieldstr,fieldflags,decimallength,defaultvalue " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			tblnum = q.getval(1);                                 // 1 - tblnum int(11)
			owner = q.getval(2);                                  // 2 - owner int(11)
			strcpy(createdate,q.getstr(3));                       // 3 - createdate datetime
			changedby = q.getval(4);                              // 4 - changedby int(11)
			strcpy(changedate,q.getstr(5));                       // 5 - changedate datetime
			deleted = q.getval(6);                                // 6 - deleted tinyint(1)
			deletedby = q.getval(7);                              // 7 - deletedby int(11)
			strcpy(deletedate,q.getstr(8));                       // 8 - deletedate datetime
			strcpy(name,q.getstr(9));                             // 9 - name varchar(40)
			version = q.getval(10);                               // 10 - version int(11)
			fieldtype = q.getval(11);                             // 11 - fieldtype tinyint(1)
			charlength = q.getval(12);                            // 12 - charlength int(11)
			minvalue = q.getval(13);                              // 13 - minvalue int(11)
			maxvalue = q.getval(14);                              // 14 - maxvalue int(11)
			options = new char[strlen(q.getstr(15)) + 1000];
			strcpy(options,q.getstr(15));                         // 15 - options text
			ptrtotblnum = q.getval(16);                           // 16 - ptrtotblnum int(11)
			ordning = q.getval(17);                               // 17 - ordning int(11)
			integerlength = q.getval(18);                         // 18 - integerlength int(11)
			strcpy(description,q.getstr(19));                     // 19 - description varchar(80)
			strcpy(fieldstr,q.getstr(20));                        // 20 - fieldstr varchar(20)
			fieldflags = q.getval(21);                            // 21 - fieldflags tinyint(3)
			decimallength = q.getval(22);                         // 22 - decimallength int(11)
			strcpy(defaultvalue,q.getstr(23));                    // 23 - defaultvalue varchar(40)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Flds::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		tblnum = qd -> getval(1);                                 // 1 - tblnum int(11)
		owner = qd -> getval(2);                                  // 2 - owner int(11)
		strcpy(createdate,qd -> getstr(3));                       // 3 - createdate datetime
		changedby = qd -> getval(4);                              // 4 - changedby int(11)
		strcpy(changedate,qd -> getstr(5));                       // 5 - changedate datetime
		deleted = qd -> getval(6);                                // 6 - deleted tinyint(1)
		deletedby = qd -> getval(7);                              // 7 - deletedby int(11)
		strcpy(deletedate,qd -> getstr(8));                       // 8 - deletedate datetime
		strcpy(name,qd -> getstr(9));                             // 9 - name varchar(40)
		version = qd -> getval(10);                               // 10 - version int(11)
		fieldtype = qd -> getval(11);                             // 11 - fieldtype tinyint(1)
		charlength = qd -> getval(12);                            // 12 - charlength int(11)
		minvalue = qd -> getval(13);                              // 13 - minvalue int(11)
		maxvalue = qd -> getval(14);                              // 14 - maxvalue int(11)
		options = new char[strlen(qd -> getstr(15)) + 1000];
		strcpy(options,qd -> getstr(15));                         // 15 - options text
		ptrtotblnum = qd -> getval(16);                           // 16 - ptrtotblnum int(11)
		ordning = qd -> getval(17);                               // 17 - ordning int(11)
		integerlength = qd -> getval(18);                         // 18 - integerlength int(11)
		strcpy(description,qd -> getstr(19));                     // 19 - description varchar(80)
		strcpy(fieldstr,qd -> getstr(20));                        // 20 - fieldstr varchar(20)
		fieldflags = qd -> getval(21);                            // 21 - fieldflags tinyint(3)
		decimallength = qd -> getval(22);                         // 22 - decimallength int(11)
		strcpy(defaultvalue,qd -> getstr(23));                    // 23 - defaultvalue varchar(40)
	}

// End of implementation of class 'Flds'

} // End of namespace
namespace db {

/**
 **  Begin class 'Grplinks'
 **/

	Grplinks::Grplinks(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Grplinks::Grplinks(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from grplinks where num=%ld",ix);
		spawn(sql);
	}
	Grplinks::Grplinks(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Grplinks::Grplinks(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Grplinks::~Grplinks()
	{
	}

	void Grplinks::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Grplinks::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into grplinks(num,usernum,grpnum,dbnum)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",usernum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",grpnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",dbnum);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Grplinks::update()
	{
		Grplinks::update(num);
	}

	void Grplinks::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update grplinks set usernum='%ld'",usernum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", grpnum='%ld'",grpnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", dbnum='%ld'",dbnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Grplinks::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Grplinks::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from grplinks where num=%ld",num);
		q.execute(sql);
	}

	std::string Grplinks::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<GRPLINKS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		sprintf(slask,"<GRPNUM>%ld</GRPNUM>",grpnum);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		dest += "</GRPLINKS>";
		return dest;
	}

	std::string Grplinks::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<GRPLINKS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		sprintf(slask,"<GRPNUM>%ld</GRPNUM>",grpnum);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		dest += "</GRPLINKS>";
		return dest;
	}

	int Grplinks::num_cols()
	{
		return 4;
	}

	void Grplinks::clear()
	{
		num = 0;
		usernum = 0;
		grpnum = 0;
		dbnum = 0;
	}
	void Grplinks::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,usernum,grpnum,dbnum " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			usernum = q.getval(1);                                // 1 - usernum int(11)
			grpnum = q.getval(2);                                 // 2 - grpnum int(11)
			dbnum = q.getval(3);                                  // 3 - dbnum int(11)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Grplinks::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		usernum = qd -> getval(1);                                // 1 - usernum int(11)
		grpnum = qd -> getval(2);                                 // 2 - grpnum int(11)
		dbnum = qd -> getval(3);                                  // 3 - dbnum int(11)
	}

// End of implementation of class 'Grplinks'

} // End of namespace
namespace db {

/**
 **  Begin class 'Grps'
 **/

	Grps::Grps(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Grps::Grps(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from grps where num=%ld",ix);
		spawn(sql);
	}
	Grps::Grps(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Grps::Grps(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Grps::~Grps()
	{
	}

	void Grps::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Grps::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into grps(num,name,usernum)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		sql += ", '" + q.safestr(name) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",usernum);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Grps::update()
	{
		Grps::update(num);
	}

	void Grps::update(long ix)
	{
		Query q(database);
		std::string sql;
		sql += "update grps set name='" + q.safestr(name) + "'";
		{
			char slask[200];
			sprintf(slask,", usernum='%ld'",usernum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Grps::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Grps::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from grps where num=%ld",num);
		q.execute(sql);
	}

	std::string Grps::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<GRPS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		dest += "</GRPS>";
		return dest;
	}

	std::string Grps::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<GRPS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		dest += "</GRPS>";
		return dest;
	}

	int Grps::num_cols()
	{
		return 3;
	}

	void Grps::clear()
	{
		num = 0;
		*name = 0;
		usernum = 0;
	}
	void Grps::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,name,usernum " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			strcpy(name,q.getstr(1));                             // 1 - name char(40)
			usernum = q.getval(2);                                // 2 - usernum int(11)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Grps::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		strcpy(name,qd -> getstr(1));                             // 1 - name char(40)
		usernum = qd -> getval(2);                                // 2 - usernum int(11)
	}

// End of implementation of class 'Grps'

} // End of namespace
namespace db {

/**
 **  Begin class 'Indexlist'
 **/

	Indexlist::Indexlist(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Indexlist::Indexlist(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from indexlist where num=%ld",ix);
		spawn(sql);
	}
	Indexlist::Indexlist(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Indexlist::Indexlist(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Indexlist::~Indexlist()
	{
	}

	void Indexlist::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Indexlist::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into indexlist(num,indexnum,fldnum,length)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",indexnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",fldnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",length);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Indexlist::update()
	{
		Indexlist::update(num);
	}

	void Indexlist::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update indexlist set indexnum='%ld'",indexnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", fldnum='%ld'",fldnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", length='%ld'",length);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Indexlist::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Indexlist::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from indexlist where num=%ld",num);
		q.execute(sql);
	}

	std::string Indexlist::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<INDEXLIST>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<INDEXNUM>%ld</INDEXNUM>",indexnum);
		dest += slask;
		sprintf(slask,"<FLDNUM>%ld</FLDNUM>",fldnum);
		dest += slask;
		sprintf(slask,"<LENGTH>%ld</LENGTH>",length);
		dest += slask;
		dest += "</INDEXLIST>";
		return dest;
	}

	std::string Indexlist::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<INDEXLIST " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<INDEXNUM>%ld</INDEXNUM>",indexnum);
		dest += slask;
		sprintf(slask,"<FLDNUM>%ld</FLDNUM>",fldnum);
		dest += slask;
		sprintf(slask,"<LENGTH>%ld</LENGTH>",length);
		dest += slask;
		dest += "</INDEXLIST>";
		return dest;
	}

	int Indexlist::num_cols()
	{
		return 4;
	}

	void Indexlist::clear()
	{
		num = 0;
		indexnum = 0;
		fldnum = 0;
		length = 0;
	}
	void Indexlist::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,indexnum,fldnum,length " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			indexnum = q.getval(1);                               // 1 - indexnum int(11)
			fldnum = q.getval(2);                                 // 2 - fldnum int(11)
			length = q.getval(3);                                 // 3 - length int(11)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Indexlist::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		indexnum = qd -> getval(1);                               // 1 - indexnum int(11)
		fldnum = qd -> getval(2);                                 // 2 - fldnum int(11)
		length = qd -> getval(3);                                 // 3 - length int(11)
	}

// End of implementation of class 'Indexlist'

} // End of namespace
namespace db {

/**
 **  Begin class 'Indexs'
 **/

	Indexs::Indexs(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Indexs::Indexs(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from indexs where num=%ld",ix);
		spawn(sql);
	}
	Indexs::Indexs(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Indexs::Indexs(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Indexs::~Indexs()
	{
	}

	void Indexs::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Indexs::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into indexs(num,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,tblnum,typ,description)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",owner);
			sql += slask;
		}
		sql += ", '" + q.safestr(createdate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",changedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(changedate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",deleted);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",deletedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(deletedate) + "'";
		sql += ", '" + q.safestr(name) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",version);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",tblnum);
			sql += slask;
		}
		sql += ", '" + q.safestr(typ) + "'";
		sql += ", '" + q.safestr(description) + "'";
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Indexs::update()
	{
		Indexs::update(num);
	}

	void Indexs::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update indexs set owner='%ld'",owner);
			sql += slask;
		}
		sql += ", createdate='" + q.safestr(createdate) + "'";
		{
			char slask[200];
			sprintf(slask,", changedby='%ld'",changedby);
			sql += slask;
		}
		sql += ", changedate='" + q.safestr(changedate) + "'";
		{
			char slask[200];
			sprintf(slask,", deleted='%ld'",deleted);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", deletedby='%ld'",deletedby);
			sql += slask;
		}
		sql += ", deletedate='" + q.safestr(deletedate) + "'";
		sql += ", name='" + q.safestr(name) + "'";
		{
			char slask[200];
			sprintf(slask,", version='%ld'",version);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", tblnum='%ld'",tblnum);
			sql += slask;
		}
		sql += ", typ='" + q.safestr(typ) + "'";
		sql += ", description='" + q.safestr(description) + "'";
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Indexs::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Indexs::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from indexs where num=%ld",num);
		q.execute(sql);
	}

	std::string Indexs::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<INDEXS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		dest += "<TYP>" + q.xmlsafestr(typ) + "</TYP>";
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		dest += "</INDEXS>";
		return dest;
	}

	std::string Indexs::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<INDEXS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		dest += "<TYP>" + q.xmlsafestr(typ) + "</TYP>";
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		dest += "</INDEXS>";
		return dest;
	}

	int Indexs::num_cols()
	{
		return 13;
	}

	void Indexs::clear()
	{
		num = 0;
		owner = 0;
		*createdate = 0;
		changedby = 0;
		*changedate = 0;
		deleted = 0;
		deletedby = 0;
		*deletedate = 0;
		*name = 0;
		version = 0;
		tblnum = 0;
		*typ = 0;
		*description = 0;
	}
	void Indexs::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,tblnum,typ,description " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			owner = q.getval(1);                                  // 1 - owner int(11)
			strcpy(createdate,q.getstr(2));                       // 2 - createdate datetime
			changedby = q.getval(3);                              // 3 - changedby int(11)
			strcpy(changedate,q.getstr(4));                       // 4 - changedate datetime
			deleted = q.getval(5);                                // 5 - deleted tinyint(1)
			deletedby = q.getval(6);                              // 6 - deletedby int(11)
			strcpy(deletedate,q.getstr(7));                       // 7 - deletedate datetime
			strcpy(name,q.getstr(8));                             // 8 - name char(40)
			version = q.getval(9);                                // 9 - version int(11)
			tblnum = q.getval(10);                                // 10 - tblnum int(11)
			strcpy(typ,q.getstr(11));                             // 11 - typ enum('INDEX','PRIMARY','UNIQUE','FULLTEXT')
			strcpy(description,q.getstr(12));                     // 12 - description char(40)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Indexs::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		owner = qd -> getval(1);                                  // 1 - owner int(11)
		strcpy(createdate,qd -> getstr(2));                       // 2 - createdate datetime
		changedby = qd -> getval(3);                              // 3 - changedby int(11)
		strcpy(changedate,qd -> getstr(4));                       // 4 - changedate datetime
		deleted = qd -> getval(5);                                // 5 - deleted tinyint(1)
		deletedby = qd -> getval(6);                              // 6 - deletedby int(11)
		strcpy(deletedate,qd -> getstr(7));                       // 7 - deletedate datetime
		strcpy(name,qd -> getstr(8));                             // 8 - name char(40)
		version = qd -> getval(9);                                // 9 - version int(11)
		tblnum = qd -> getval(10);                                // 10 - tblnum int(11)
		strcpy(typ,qd -> getstr(11));                             // 11 - typ enum('INDEX','PRIMARY','UNIQUE','FULLTEXT')
		strcpy(description,qd -> getstr(12));                     // 12 - description char(40)
	}

// End of implementation of class 'Indexs'

} // End of namespace
namespace db {

/**
 **  Begin class 'Kommentar'
 **/

	Kommentar::Kommentar(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Kommentar::Kommentar(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from kommentar where num=%ld",ix);
		spawn(sql);
	}
	Kommentar::Kommentar(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Kommentar::Kommentar(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Kommentar::~Kommentar()
	{
		if (kommentar)
			delete kommentar;
	}

	void Kommentar::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Kommentar::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into kommentar(num,dbnum,tblnum,fldnum,usernum,dateposted,reason,kommentar,indexnum,appnum)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",dbnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",tblnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",fldnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",usernum);
			sql += slask;
		}
		sql += ", '" + q.safestr(dateposted) + "'";
		sql += ", '" + q.safestr(reason) + "'";
		sql += ", '" + q.safestr(kommentar) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",indexnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",appnum);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Kommentar::update()
	{
		Kommentar::update(num);
	}

	void Kommentar::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update kommentar set dbnum='%ld'",dbnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", tblnum='%ld'",tblnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", fldnum='%ld'",fldnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", usernum='%ld'",usernum);
			sql += slask;
		}
		sql += ", dateposted='" + q.safestr(dateposted) + "'";
		sql += ", reason='" + q.safestr(reason) + "'";
		sql += ", kommentar='" + q.safestr(kommentar) + "'";
		{
			char slask[200];
			sprintf(slask,", indexnum='%ld'",indexnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", appnum='%ld'",appnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Kommentar::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Kommentar::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from kommentar where num=%ld",num);
		q.execute(sql);
	}

	std::string Kommentar::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<KOMMENTAR>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		sprintf(slask,"<FLDNUM>%ld</FLDNUM>",fldnum);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		dest += "<DATEPOSTED>" + q.xmlsafestr(dateposted) + "</DATEPOSTED>";
		dest += "<REASON>" + q.xmlsafestr(reason) + "</REASON>";
		dest += "<KOMMENTAR>" + q.xmlsafestr(kommentar) + "</KOMMENTAR>";
		sprintf(slask,"<INDEXNUM>%ld</INDEXNUM>",indexnum);
		dest += slask;
		sprintf(slask,"<APPNUM>%ld</APPNUM>",appnum);
		dest += slask;
		dest += "</KOMMENTAR>";
		return dest;
	}

	std::string Kommentar::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<KOMMENTAR " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		sprintf(slask,"<TBLNUM>%ld</TBLNUM>",tblnum);
		dest += slask;
		sprintf(slask,"<FLDNUM>%ld</FLDNUM>",fldnum);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		dest += "<DATEPOSTED>" + q.xmlsafestr(dateposted) + "</DATEPOSTED>";
		dest += "<REASON>" + q.xmlsafestr(reason) + "</REASON>";
		dest += "<KOMMENTAR>" + q.xmlsafestr(kommentar) + "</KOMMENTAR>";
		sprintf(slask,"<INDEXNUM>%ld</INDEXNUM>",indexnum);
		dest += slask;
		sprintf(slask,"<APPNUM>%ld</APPNUM>",appnum);
		dest += slask;
		dest += "</KOMMENTAR>";
		return dest;
	}

	int Kommentar::num_cols()
	{
		return 10;
	}

	void Kommentar::clear()
	{
		num = 0;
		dbnum = 0;
		tblnum = 0;
		fldnum = 0;
		usernum = 0;
		*dateposted = 0;
		*reason = 0;
		kommentar = NULL;
		indexnum = 0;
		appnum = 0;
	}
	void Kommentar::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,dbnum,tblnum,fldnum,usernum,dateposted,reason,kommentar,indexnum,appnum " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			dbnum = q.getval(1);                                  // 1 - dbnum int(11)
			tblnum = q.getval(2);                                 // 2 - tblnum int(11)
			fldnum = q.getval(3);                                 // 3 - fldnum int(11)
			usernum = q.getval(4);                                // 4 - usernum int(11)
			strcpy(dateposted,q.getstr(5));                       // 5 - dateposted datetime
			strcpy(reason,q.getstr(6));                           // 6 - reason varchar(80)
			kommentar = new char[strlen(q.getstr(7)) + 1000];
			strcpy(kommentar,q.getstr(7));                        // 7 - kommentar text
			indexnum = q.getval(8);                               // 8 - indexnum int(11)
			appnum = q.getval(9);                                 // 9 - appnum int(11)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Kommentar::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		dbnum = qd -> getval(1);                                  // 1 - dbnum int(11)
		tblnum = qd -> getval(2);                                 // 2 - tblnum int(11)
		fldnum = qd -> getval(3);                                 // 3 - fldnum int(11)
		usernum = qd -> getval(4);                                // 4 - usernum int(11)
		strcpy(dateposted,qd -> getstr(5));                       // 5 - dateposted datetime
		strcpy(reason,qd -> getstr(6));                           // 6 - reason varchar(80)
		kommentar = new char[strlen(qd -> getstr(7)) + 1000];
		strcpy(kommentar,qd -> getstr(7));                        // 7 - kommentar text
		indexnum = qd -> getval(8);                               // 8 - indexnum int(11)
		appnum = qd -> getval(9);                                 // 9 - appnum int(11)
	}

// End of implementation of class 'Kommentar'

} // End of namespace
namespace db {

/**
 **  Begin class 'Tblgrps'
 **/

	Tblgrps::Tblgrps(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Tblgrps::Tblgrps(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from tblgrps where num=%ld",ix);
		spawn(sql);
	}
	Tblgrps::Tblgrps(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Tblgrps::Tblgrps(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Tblgrps::~Tblgrps()
	{
	}

	void Tblgrps::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Tblgrps::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into tblgrps(num,name,dbnum)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		sql += ", '" + q.safestr(name) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",dbnum);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Tblgrps::update()
	{
		Tblgrps::update(num);
	}

	void Tblgrps::update(long ix)
	{
		Query q(database);
		std::string sql;
		sql += "update tblgrps set name='" + q.safestr(name) + "'";
		{
			char slask[200];
			sprintf(slask,", dbnum='%ld'",dbnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Tblgrps::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Tblgrps::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from tblgrps where num=%ld",num);
		q.execute(sql);
	}

	std::string Tblgrps::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<TBLGRPS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		dest += "</TBLGRPS>";
		return dest;
	}

	std::string Tblgrps::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<TBLGRPS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		dest += "</TBLGRPS>";
		return dest;
	}

	int Tblgrps::num_cols()
	{
		return 3;
	}

	void Tblgrps::clear()
	{
		num = 0;
		*name = 0;
		dbnum = 0;
	}
	void Tblgrps::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,name,dbnum " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			strcpy(name,q.getstr(1));                             // 1 - name char(40)
			dbnum = q.getval(2);                                  // 2 - dbnum int(11)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Tblgrps::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		strcpy(name,qd -> getstr(1));                             // 1 - name char(40)
		dbnum = qd -> getval(2);                                  // 2 - dbnum int(11)
	}

// End of implementation of class 'Tblgrps'

} // End of namespace
namespace db {

/**
 **  Begin class 'Tbls'
 **/

	Tbls::Tbls(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Tbls::Tbls(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from tbls where num=%ld",ix);
		spawn(sql);
	}
	Tbls::Tbls(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Tbls::Tbls(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Tbls::~Tbls()
	{
	}

	void Tbls::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Tbls::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into tbls(num,dbnum,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,description,tblgrpnum)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",dbnum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",owner);
			sql += slask;
		}
		sql += ", '" + q.safestr(createdate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",changedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(changedate) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",deleted);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",deletedby);
			sql += slask;
		}
		sql += ", '" + q.safestr(deletedate) + "'";
		sql += ", '" + q.safestr(name) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",version);
			sql += slask;
		}
		sql += ", '" + q.safestr(description) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",tblgrpnum);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Tbls::update()
	{
		Tbls::update(num);
	}

	void Tbls::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update tbls set dbnum='%ld'",dbnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", owner='%ld'",owner);
			sql += slask;
		}
		sql += ", createdate='" + q.safestr(createdate) + "'";
		{
			char slask[200];
			sprintf(slask,", changedby='%ld'",changedby);
			sql += slask;
		}
		sql += ", changedate='" + q.safestr(changedate) + "'";
		{
			char slask[200];
			sprintf(slask,", deleted='%ld'",deleted);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", deletedby='%ld'",deletedby);
			sql += slask;
		}
		sql += ", deletedate='" + q.safestr(deletedate) + "'";
		sql += ", name='" + q.safestr(name) + "'";
		{
			char slask[200];
			sprintf(slask,", version='%ld'",version);
			sql += slask;
		}
		sql += ", description='" + q.safestr(description) + "'";
		{
			char slask[200];
			sprintf(slask,", tblgrpnum='%ld'",tblgrpnum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Tbls::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Tbls::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from tbls where num=%ld",num);
		q.execute(sql);
	}

	std::string Tbls::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<TBLS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		sprintf(slask,"<TBLGRPNUM>%ld</TBLGRPNUM>",tblgrpnum);
		dest += slask;
		dest += "</TBLS>";
		return dest;
	}

	std::string Tbls::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<TBLS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<DBNUM>%ld</DBNUM>",dbnum);
		dest += slask;
		sprintf(slask,"<OWNER>%ld</OWNER>",owner);
		dest += slask;
		dest += "<CREATEDATE>" + q.xmlsafestr(createdate) + "</CREATEDATE>";
		sprintf(slask,"<CHANGEDBY>%ld</CHANGEDBY>",changedby);
		dest += slask;
		dest += "<CHANGEDATE>" + q.xmlsafestr(changedate) + "</CHANGEDATE>";
		sprintf(slask,"<DELETED>%ld</DELETED>",deleted);
		dest += slask;
		sprintf(slask,"<DELETEDBY>%ld</DELETEDBY>",deletedby);
		dest += slask;
		dest += "<DELETEDATE>" + q.xmlsafestr(deletedate) + "</DELETEDATE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		sprintf(slask,"<VERSION>%ld</VERSION>",version);
		dest += slask;
		dest += "<DESCRIPTION>" + q.xmlsafestr(description) + "</DESCRIPTION>";
		sprintf(slask,"<TBLGRPNUM>%ld</TBLGRPNUM>",tblgrpnum);
		dest += slask;
		dest += "</TBLS>";
		return dest;
	}

	int Tbls::num_cols()
	{
		return 13;
	}

	void Tbls::clear()
	{
		num = 0;
		dbnum = 0;
		owner = 0;
		*createdate = 0;
		changedby = 0;
		*changedate = 0;
		deleted = 0;
		deletedby = 0;
		*deletedate = 0;
		*name = 0;
		version = 0;
		*description = 0;
		tblgrpnum = 0;
	}
	void Tbls::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,dbnum,owner,createdate,changedby,changedate,deleted,deletedby,deletedate,name,version,description,tblgrpnum " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			dbnum = q.getval(1);                                  // 1 - dbnum int(11)
			owner = q.getval(2);                                  // 2 - owner int(11)
			strcpy(createdate,q.getstr(3));                       // 3 - createdate datetime
			changedby = q.getval(4);                              // 4 - changedby int(11)
			strcpy(changedate,q.getstr(5));                       // 5 - changedate datetime
			deleted = q.getval(6);                                // 6 - deleted tinyint(1)
			deletedby = q.getval(7);                              // 7 - deletedby int(11)
			strcpy(deletedate,q.getstr(8));                       // 8 - deletedate datetime
			strcpy(name,q.getstr(9));                             // 9 - name char(40)
			version = q.getval(10);                               // 10 - version int(11)
			strcpy(description,q.getstr(11));                     // 11 - description char(80)
			tblgrpnum = q.getval(12);                             // 12 - tblgrpnum int(11)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Tbls::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		dbnum = qd -> getval(1);                                  // 1 - dbnum int(11)
		owner = qd -> getval(2);                                  // 2 - owner int(11)
		strcpy(createdate,qd -> getstr(3));                       // 3 - createdate datetime
		changedby = qd -> getval(4);                              // 4 - changedby int(11)
		strcpy(changedate,qd -> getstr(5));                       // 5 - changedate datetime
		deleted = qd -> getval(6);                                // 6 - deleted tinyint(1)
		deletedby = qd -> getval(7);                              // 7 - deletedby int(11)
		strcpy(deletedate,qd -> getstr(8));                       // 8 - deletedate datetime
		strcpy(name,qd -> getstr(9));                             // 9 - name char(40)
		version = qd -> getval(10);                               // 10 - version int(11)
		strcpy(description,qd -> getstr(11));                     // 11 - description char(80)
		tblgrpnum = qd -> getval(12);                             // 12 - tblgrpnum int(11)
	}

// End of implementation of class 'Tbls'

} // End of namespace
namespace db {

/**
 **  Begin class 'Users'
 **/

	Users::Users(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Users::Users(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from users where num=%ld",ix);
		spawn(sql);
	}
	Users::Users(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Users::Users(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Users::~Users()
	{
	}

	void Users::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Users::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into users(num,handle,name,password,superuser,email,icq,prevdatum,thisdatum,maxdbs,maxtbls,maxflds,flags,steps,maxindexs,maxapps)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		sql += ", '" + q.safestr(handle) + "'";
		sql += ", '" + q.safestr(name) + "'";
		sql += ", '" + q.safestr(password) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",superuser);
			sql += slask;
		}
		sql += ", '" + q.safestr(email) + "'";
		sql += ", '" + q.safestr(icq) + "'";
		sql += ", '" + q.safestr(prevdatum) + "'";
		sql += ", '" + q.safestr(thisdatum) + "'";
		{
			char slask[100];
			sprintf(slask,", %ld",maxdbs);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",maxtbls);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",maxflds);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",flags);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",steps);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",maxindexs);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",maxapps);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Users::update()
	{
		Users::update(num);
	}

	void Users::update(long ix)
	{
		Query q(database);
		std::string sql;
		sql += "update users set handle='" + q.safestr(handle) + "'";
		sql += ", name='" + q.safestr(name) + "'";
		sql += ", password='" + q.safestr(password) + "'";
		{
			char slask[200];
			sprintf(slask,", superuser='%ld'",superuser);
			sql += slask;
		}
		sql += ", email='" + q.safestr(email) + "'";
		sql += ", icq='" + q.safestr(icq) + "'";
		sql += ", prevdatum='" + q.safestr(prevdatum) + "'";
		sql += ", thisdatum='" + q.safestr(thisdatum) + "'";
		{
			char slask[200];
			sprintf(slask,", maxdbs='%ld'",maxdbs);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", maxtbls='%ld'",maxtbls);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", maxflds='%ld'",maxflds);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", flags='%ld'",flags);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", steps='%ld'",steps);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", maxindexs='%ld'",maxindexs);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", maxapps='%ld'",maxapps);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Users::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Users::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from users where num=%ld",num);
		q.execute(sql);
	}

	std::string Users::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<USERS>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		dest += "<HANDLE>" + q.xmlsafestr(handle) + "</HANDLE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		dest += "<PASSWORD>" + q.xmlsafestr(password) + "</PASSWORD>";
		sprintf(slask,"<SUPERUSER>%ld</SUPERUSER>",superuser);
		dest += slask;
		dest += "<EMAIL>" + q.xmlsafestr(email) + "</EMAIL>";
		dest += "<ICQ>" + q.xmlsafestr(icq) + "</ICQ>";
		dest += "<PREVDATUM>" + q.xmlsafestr(prevdatum) + "</PREVDATUM>";
		dest += "<THISDATUM>" + q.xmlsafestr(thisdatum) + "</THISDATUM>";
		sprintf(slask,"<MAXDBS>%ld</MAXDBS>",maxdbs);
		dest += slask;
		sprintf(slask,"<MAXTBLS>%ld</MAXTBLS>",maxtbls);
		dest += slask;
		sprintf(slask,"<MAXFLDS>%ld</MAXFLDS>",maxflds);
		dest += slask;
		sprintf(slask,"<FLAGS>%ld</FLAGS>",flags);
		dest += slask;
		sprintf(slask,"<STEPS>%ld</STEPS>",steps);
		dest += slask;
		sprintf(slask,"<MAXINDEXS>%ld</MAXINDEXS>",maxindexs);
		dest += slask;
		sprintf(slask,"<MAXAPPS>%ld</MAXAPPS>",maxapps);
		dest += slask;
		dest += "</USERS>";
		return dest;
	}

	std::string Users::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<USERS " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		dest += "<HANDLE>" + q.xmlsafestr(handle) + "</HANDLE>";
		dest += "<NAME>" + q.xmlsafestr(name) + "</NAME>";
		dest += "<PASSWORD>" + q.xmlsafestr(password) + "</PASSWORD>";
		sprintf(slask,"<SUPERUSER>%ld</SUPERUSER>",superuser);
		dest += slask;
		dest += "<EMAIL>" + q.xmlsafestr(email) + "</EMAIL>";
		dest += "<ICQ>" + q.xmlsafestr(icq) + "</ICQ>";
		dest += "<PREVDATUM>" + q.xmlsafestr(prevdatum) + "</PREVDATUM>";
		dest += "<THISDATUM>" + q.xmlsafestr(thisdatum) + "</THISDATUM>";
		sprintf(slask,"<MAXDBS>%ld</MAXDBS>",maxdbs);
		dest += slask;
		sprintf(slask,"<MAXTBLS>%ld</MAXTBLS>",maxtbls);
		dest += slask;
		sprintf(slask,"<MAXFLDS>%ld</MAXFLDS>",maxflds);
		dest += slask;
		sprintf(slask,"<FLAGS>%ld</FLAGS>",flags);
		dest += slask;
		sprintf(slask,"<STEPS>%ld</STEPS>",steps);
		dest += slask;
		sprintf(slask,"<MAXINDEXS>%ld</MAXINDEXS>",maxindexs);
		dest += slask;
		sprintf(slask,"<MAXAPPS>%ld</MAXAPPS>",maxapps);
		dest += slask;
		dest += "</USERS>";
		return dest;
	}

	int Users::num_cols()
	{
		return 16;
	}

	void Users::clear()
	{
		num = 0;
		*handle = 0;
		*name = 0;
		*password = 0;
		superuser = 0;
		*email = 0;
		*icq = 0;
		*prevdatum = 0;
		*thisdatum = 0;
		maxdbs = 0;
		maxtbls = 0;
		maxflds = 0;
		flags = 0;
		steps = 0;
		maxindexs = 0;
		maxapps = 0;
	}
	void Users::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,handle,name,password,superuser,email,icq,prevdatum,thisdatum,maxdbs,maxtbls,maxflds,flags,steps,maxindexs,maxapps " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			strcpy(handle,q.getstr(1));                           // 1 - handle char(20)
			strcpy(name,q.getstr(2));                             // 2 - name char(40)
			strcpy(password,q.getstr(3));                         // 3 - password char(20)
			superuser = q.getval(4);                              // 4 - superuser tinyint(1)
			strcpy(email,q.getstr(5));                            // 5 - email char(60)
			strcpy(icq,q.getstr(6));                              // 6 - icq char(20)
			strcpy(prevdatum,q.getstr(7));                        // 7 - prevdatum datetime
			strcpy(thisdatum,q.getstr(8));                        // 8 - thisdatum datetime
			maxdbs = q.getval(9);                                 // 9 - maxdbs int(11)
			maxtbls = q.getval(10);                               // 10 - maxtbls int(11)
			maxflds = q.getval(11);                               // 11 - maxflds int(11)
			flags = q.getval(12);                                 // 12 - flags int(11)
			steps = q.getval(13);                                 // 13 - steps int(11)
			maxindexs = q.getval(14);                             // 14 - maxindexs int(11)
			maxapps = q.getval(15);                               // 15 - maxapps int(11)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Users::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		strcpy(handle,qd -> getstr(1));                           // 1 - handle char(20)
		strcpy(name,qd -> getstr(2));                             // 2 - name char(40)
		strcpy(password,qd -> getstr(3));                         // 3 - password char(20)
		superuser = qd -> getval(4);                              // 4 - superuser tinyint(1)
		strcpy(email,qd -> getstr(5));                            // 5 - email char(60)
		strcpy(icq,qd -> getstr(6));                              // 6 - icq char(20)
		strcpy(prevdatum,qd -> getstr(7));                        // 7 - prevdatum datetime
		strcpy(thisdatum,qd -> getstr(8));                        // 8 - thisdatum datetime
		maxdbs = qd -> getval(9);                                 // 9 - maxdbs int(11)
		maxtbls = qd -> getval(10);                               // 10 - maxtbls int(11)
		maxflds = qd -> getval(11);                               // 11 - maxflds int(11)
		flags = qd -> getval(12);                                 // 12 - flags int(11)
		steps = qd -> getval(13);                                 // 13 - steps int(11)
		maxindexs = qd -> getval(14);                             // 14 - maxindexs int(11)
		maxapps = qd -> getval(15);                               // 15 - maxapps int(11)
	}

// End of implementation of class 'Users'

} // End of namespace
namespace db {

/**
 **  Begin class 'Valid'
 **/

	Valid::Valid(Database *db)
	{
		database = db;
		new_object = 1;
		clear();
	}
	Valid::Valid(Database *db,long ix)
	{
		char sql[80];
		database = db;
		new_object = 1;
		sprintf(sql,"select * from valid where num=%ld",ix);
		spawn(sql);
	}
	Valid::Valid(Database *db,const std::string& sql)
	{
		database = db;
		new_object = 1;
		spawn(sql);
	}
	Valid::Valid(Database *db,Query *qd)
	{
		database = db;
		new_object = 0;
		spawn(qd);
	}
	Valid::~Valid()
	{
	}

	void Valid::select(const std::string& sql)
	{
		spawn(sql);
	}

	long Valid::insert()
	{
		Query q(database);
		std::string sql;

		sql = "insert into valid(num,usernum,valid)";
		{
			char slask[100];
			sprintf(slask," values(%ld",num);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",usernum);
			sql += slask;
		}
		{
			char slask[100];
			sprintf(slask,", %ld",valid);
			sql += slask;
		}
		sql += ")";
		q.execute(sql);
		new_object = 0;
		return num = q.insert_id();
	}

	void Valid::update()
	{
		Valid::update(num);
	}

	void Valid::update(long ix)
	{
		Query q(database);
		std::string sql;
		{
			char slask[200];
			sprintf(slask,"update valid set usernum='%ld'",usernum);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask,", valid='%ld'",valid);
			sql += slask;
		}
		{
			char slask[200];
			sprintf(slask," where num='%ld'",ix);
			sql += slask;
		}
		q.execute(sql);
	}

	void Valid::save()
	{
		if (new_object)
			insert();
		else
			update();
	}

	void Valid::erase()
	{
		Query q(database);
		char sql[200];
		sprintf(sql,"delete from valid where num=%ld",num);
		q.execute(sql);
	}

	std::string Valid::xml()
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<VALID>";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		sprintf(slask,"<VALID>%ld</VALID>",valid);
		dest += slask;
		dest += "</VALID>";
		return dest;
	}

	std::string Valid::xml(const std::string& tag,const std::string& xvalx)
	{
		Query q(database);
		std::string dest;
		char slask[200];
		dest = "<VALID " + tag + "=\"" + xvalx + "\">";
		sprintf(slask,"<NUM>%ld</NUM>",num);
		dest += slask;
		sprintf(slask,"<USERNUM>%ld</USERNUM>",usernum);
		dest += slask;
		sprintf(slask,"<VALID>%ld</VALID>",valid);
		dest += slask;
		dest += "</VALID>";
		return dest;
	}

	int Valid::num_cols()
	{
		return 3;
	}

	void Valid::clear()
	{
		num = 0;
		usernum = 0;
		valid = 0;
	}
	void Valid::spawn(const std::string& sql)
	{
		Query q(database);
		std::string temp;

		if (!strncasecmp(sql.c_str(),"select * ",9))
		{
			temp = "select num,usernum,valid " + sql.substr(9);
		} else
			temp = sql;
		q.get_result(temp);
		if (q.fetch_row())
		{
			num = q.getval(0);                                    // 0 - num int(11)
			usernum = q.getval(1);                                // 1 - usernum int(11)
			valid = q.getval(2);                                  // 2 - valid int(11)
			new_object = 0;
		} else
			clear();
		q.free_result();
	}

	void Valid::spawn(Query *qd)
	{
		num = qd -> getval(0);                                    // 0 - num int(11)
		usernum = qd -> getval(1);                                // 1 - usernum int(11)
		valid = qd -> getval(2);                                  // 2 - valid int(11)
	}

// End of implementation of class 'Valid'

} // End of namespace
