// pages.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include <libsql++.h>
#include <libdbd.h>
#include <string>
using std::string;
#include <libcgi++.h>

#include "dbd.h"
#include "html.h"
#include "utils.h"
#include "gsql.h"

#include "pages.h"


/*
 *
 */

void objheader(db::Access *a)
{
	printf("<tr>");
	printf("<th bgcolor=#e0e0e0 valign=top align=left><font size=-1> Name </font></th>");
	printf("<th bgcolor=#e0e0e0 valign=top align=left><font size=-1> Description </font></th>");
	printf("<th bgcolor=#e0e0e0 valign=top align=left><font size=-1> Created by </font></th>");
	printf("<th bgcolor=#e0e0e0 valign=top align=left><font size=-1> Date </font></th>");
//	if (a -> w)
//		printf("<th bgcolor=#e0e0e0 valign=top align=left><font size=-1> Edit </font></th>\n");
//	if (a -> d)
//		printf("<th bgcolor=#e0e0e0 valign=top align=left><font size=-1> Delete </font></th>\n");
	printf("<th bgcolor=#e0e0e0 valign=top align=left><font size=-1> Comments </font></th>\n");
	printf("<th bgcolor=#e0e0e0 valign=top align=left><font size=-1> Write </font></th>\n");
	printf("</tr>\n");
}


/*
 *
 */

void objpres(Database *db,long num,char *name,
 long owner,char *createdate,
 long changedby,char *changedate,
 long deletedby,char *deletedate,char *typ,db::Users *user,
 char *description,db::Access *a)
{
	Query *qd = new Query(db);
	long qty;
	char sql[200];
	char date[40];

// num,name,owner,createdate,changedby,changedate,deletedby,deletedate

	printf("<tr>");
	if (a -> w)
		printf("<td valign=top><font size=-1><a href=\"/cgi-bin/dbd/dbd?sel%s=%ld&change%s=0\">%s</a></font></td>\n",typ,num,typ,name);
	else
		printf("<td valign=top><font size=-1><a href=\"/cgi-bin/dbd/dbd?sel%s=%ld\">%s</a></font></td>\n",typ,num,name);
	printf("<td valign=top><font size=-1>%s</font></td>",description);
	printf("<td valign=top align=middle><font size=-1>");
	showuser(db,owner);
	printf("</font></td>\n");
	printf("<td valign=top><font size=-1>%s</font></td>\n",createdate);
//	if (a -> w)
//		printf("<td valign=top align=middle><font size=-1>[<a href=\"/cgi-bin/dbd/dbd?change%s=0\">edit</a>]</font></td>\n",typ);
//	if (a -> d)
//		printf("<td valign=top align=middle><font size=-1>[<a href=\"/cgi-bin/dbd/dbd?delete%s=0\">delete</a>]</font></td>\n",typ);
	sprintf(sql,"select count(*) from kommentar where %snum=%ld",typ,num);
	qty = qd -> get_count(sql);
	sprintf(sql,"select dateposted from kommentar where %snum=%ld order by dateposted desc",typ,num);
	strcpy(date,qd -> get_string(sql));
	printf("<td valign=top align=middle><font size=-1><a href=\"/cgi-bin/dbd/dbd?read%s=0\">%ld</a>",typ,qty);
	if (strcmp(date,user -> prevdatum) > 0)
		printf(" <img src=\"/image/new.gif\" alt=\"New!\">");
	printf("</font></td>\n");
	printf("<td valign=top align=middle><font size=-1>[ <a href=\"/cgi-bin/dbd/dbd?write%s=0\">comment</a> ]</font></td>\n",typ);
	printf("</tr>\n");

	if (changedby)
	{
		printf("<tr>");
		printf("<td valign=top></td><th bgcolor=#e0e0e0 valign=top align=right><font size=-1> Changed by </font></th>");
		printf("<td valign=top align=middle><font size=-1>");
		showuser(db,changedby);
		printf("</font></td>\n");
		printf("<td valign=top><font size=-1>%s</font></td>\n",changedate);
		printf("</tr>\n");
	}

	if (deletedby)
	{
		printf("<tr>");
		printf("<td valign=top></td><th bgcolor=#e0e0e0 valign=top align=right><font size=-1> Deleted by </font></th>");
		printf("<td valign=top align=middle><font size=-1>");
		showuser(db,deletedby);
		printf("</font></td>\n");
		printf("<td valign=top><font size=-1>%s</font></td>\n",deletedate);
		printf("</tr>\n");
	}

	delete qd;
}


/*
 * Page 0: main page
 */

void page_0(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Applications *sapp,db::Flds *sfld,db::Indexs *sindex,db::Users *user,Cookies *cs)
{
	Query q(db),q2(db),q3(db);
	Query *qd = new Query(db);
	db::Flds *tempfld;
	db::Access *a = NULL;
	db::Indexs *tempindex;
	db::Appusers *tempau;
	db::Apptables *tempat;
	db::Appfields *tempaf;
	db::Users *tempuser;
	db::Tbls *temptbl;
	char *sql = new char[500];
	long qk;
	long l;
	int i,j;
	short sd;
	short qty;
	short th;
	short visa_status = 0;
	char slask[200];
	char date[40];

	sprintf(sql,"select * from access where usernum=%ld and dbnum=%ld",user -> num,sdb ? sdb -> num : 0);
	a = new db::Access(db,sql);

	cs -> getvalue("sd",slask,20);
	sd = atoi(slask);

	header0("",1);
fflush(stdout);

// Left column

//	printf("<table width=\"100%%\"><tr><td valign=top>\n");
//	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");

//	left_frame(db,sdb,stbl,sfld,user,cs);


// End of left column, start of right column
//	printf("</td><td valign=top>");
	printf("<table width=\"100%%\">");

// databases
	printf("<tr><td colspan=8>");

	printf("<table width=\"100%%\" cellpadding=0 cellspacing=0><tr><td>");
	if (sdb)
	{
		printf("<a href=\"/cgi-bin/dbd/dbd?tof=%d\">",CF_EXPAND_DB);
		if (cookieflags & CF_EXPAND_DB)
			iexpanded();
		else
			inotexpanded();
		printf("</a>\n");
		printf("Database: <a href=\"/cgi-bin/dbd/dbd?changedb=0\"><b>%s</b></a>\n",sdb -> name);
		if (sdb -> deleted)
			printf("&lt;deleted&gt;\n");
		printf("<a href=\"/cgi-bin/dbd/dbd?seldb=0\"><img border=0 src=\"/image/close2.png\" alt=\"Close\"></a>\n");
	}
	printf("</td>");
	printf("<td align=right>");
	strcpy(slask,"[\n");
	if (a -> c || 1) // alltid skapa databas
	{
		printf("%s<a href=\"/cgi-bin/dbd/dbd?seldb=-1\">create database</a>\n",slask);
		strcpy(slask,"|\n");
	}
	if (sdb && a -> w)
	{
		printf("%s<a href=\"/cgi-bin/dbd/dbd?changedb=0\">edit</a>\n",slask);
		strcpy(slask,"|\n");
	}
	if (sdb && a -> d)
	{
		printf("%s<a href=\"/cgi-bin/dbd/dbd?deletedb=0\">delete</a>\n",slask);
		strcpy(slask,"|\n");
	}
	if (*slask == '|')
		printf("]\n");
	printf("</td></tr></table>\n");

	printf("</td></tr>");

	if (sdb && ((cookieflags & CF_EXPAND_DB) != 0))
	{
		objheader(a);
		objpres(db,sdb -> num,sdb -> name,
		 sdb -> owner,sdb -> createdate,
		 sdb -> changedby,sdb -> changedate,
		 sdb -> deletedby,sdb -> deletedate,"db",user,sdb -> description,a);
//		printf("<tr><td colspan=8>&nbsp;</td></tr>\n");
	}
fflush(stdout);


// applications
	if (sdb)
	{
		printf("<tr><td colspan=8>");

		printf("<table width=\"100%%\" cellpadding=0 cellspacing=0><tr><td>");
		if (sapp)
		{
			printf("<a href=\"/cgi-bin/dbd/dbd?tof=%d\">",CF_EXPAND_APP);
			if (cookieflags & CF_EXPAND_APP)
				iexpanded();
			else
				inotexpanded();
			printf("</a>\n");
			printf("db::Application: <a href=\"/cgi-bin/dbd/dbd?changeapp=0\"><b>%s</b></a>\n",sapp -> name);
			if (sapp -> deleted)
				printf("&lt;deleted&gt;\n");
			printf("<a href=\"/cgi-bin/dbd/dbd?selapp=0\"><img border=0 src=\"/image/close2.png\" alt=\"Close\"></a>\n");
		}
		printf("</td><td align=right>");

		strcpy(slask,"[\n");
		if (a -> c)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?selapp=-1\">create application</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (sapp && a -> w)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?changeapp=0\">edit</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (sapp && a -> d)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?deleteapp=0\">delete</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (*slask == '|')
			printf("]\n");

		printf("</td></tr></table>");

		printf("</td></tr>");

		if (sapp && ((cookieflags & CF_EXPAND_APP) != 0))
		{
			objheader(a);
			objpres(db,sapp -> num,sapp -> name,
			 sapp -> owner,sapp -> createdate,
			 sapp -> changedby,sapp -> changedate,
			 sapp -> deletedby,sapp -> deletedate,"app",user,sapp -> description,a);
//			printf("<tr><td colspan=8>&nbsp;</td></tr>\n");
		}
	} // if (sdb)
fflush(stdout);


// tables
	if (sdb)
	{
		printf("<tr><td colspan=8>");

		printf("<table width=\"100%%\" cellpadding=0 cellspacing=0><tr><td>");
		if (stbl)
		{
			printf("<a href=\"/cgi-bin/dbd/dbd?tof=%d\">",CF_EXPAND_TBL);
			if (cookieflags & CF_EXPAND_TBL)
				iexpanded();
			else
				inotexpanded();
			printf("</a>\n");
			printf("Table: <a href=\"/cgi-bin/dbd/dbd?changetbl=0\"><b>%s</b></a>\n",stbl -> name);
			if (stbl -> deleted)
				printf("&lt;deleted&gt;\n");
			printf("<a href=\"/cgi-bin/dbd/dbd?seltbl=0\"><img border=0 src=\"/image/close2.png\" alt=\"Close\"></a>\n");
		}
		printf("</td><td align=right>");

		strcpy(slask,"[\n");
		if (a -> c)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?seltbl=-1\">create table</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (stbl && a -> w)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?changetbl=0\">edit</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (stbl && a -> d)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?deletetbl=0\">delete</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (*slask == '|')
			printf("]\n");

// TODO: live sync av en enskild tabell
		printf("</td></tr></table>");

		printf("</td></tr>");

		if (stbl && ((cookieflags & CF_EXPAND_TBL) != 0))
		{
			objheader(a);
			objpres(db,stbl -> num,stbl -> name,
			 stbl -> owner,stbl -> createdate,
			 stbl -> changedby,stbl -> changedate,
			 stbl -> deletedby,stbl -> deletedate,"tbl",user,stbl -> description,a);
//			printf("<tr><td colspan=8>&nbsp;</td></tr>\n");
		}
	} // if (sdb)
fflush(stdout);


// tables - application view
	if (sdb && sapp && !stbl)
	{
	// start of main table row
		printf("<tr><td colspan=8>");
	// info
	
	// appusers developer/tester
		printf("<h3>Crew (application development)</h3>\n");
		sprintf(sql,"select num from appusers where appnum=%ld",sapp -> num);
		q.get_result(sql);
		if (q.num_rows())
		{
			printf("<center><table width=95%%><tr><td>");
			printf("<table><tr>");
			printf("<th bgcolor=#e0e0e0 align=left> Individual </th>\n");
			printf("<th bgcolor=#e0e0e0 align=left> Role </th></tr>\n");
		}
		while (q.fetch_row())
		{
			tempau = new db::Appusers(db,q.getval());
			printf("<tr><td>");
			showuser(db,tempau -> usernum);
			printf("</td><td>%s</td></tr>\n",tempau -> status);
			delete tempau;
		}
		if (q.num_rows())
			printf("</table></td></tr></table></center>\n");
		q.free_result();
fflush(stdout);

	// form add user + status
		if (a -> w)
		{
			printf("<form action=/cgi-bin/dbd/dbd method=post target=rf>");
			printf("<input type=hidden name=addappuser value=1>\n");
			sprintf(sql,"select usernum from access where dbnum=%ld",sdb -> num);
			q.get_result(sql);
			printf("<table><td>");
			printf("<select name=usernum>");
			while (q.fetch_row())
			{
				l = q.getval();
				sprintf(sql,"select num from appusers where appnum=%ld and usernum=%ld",sapp -> num,l);
				if (!qd -> get_count(sql))
				{
					tempuser = new db::Users(db,l);
					printf("<option value=%ld>%s\n",tempuser -> num,tempuser -> name);
					delete tempuser;
				}
			}
			q.free_result();
			printf("</select>\n");
			printf("</td><td>");
			printf("<select name=status><option>Developer\n");
			printf("<option>Tester\n");
			printf("</select>\n");
			printf("</td><td>");
			printf("<input type=submit name=submit value=\" Add user \">\n");
			printf("</td></tr></table>");
			printf("</form>\n");
		}
fflush(stdout);

	// apptables checked
		printf("<h3>Tables used by application</h3>\n");

		printf("<form action=/cgi-bin/dbd/dbd method=post target=rf>");
		printf("<input type=hidden name=updtableinfo value=1>\n");
		printf("<center><table width=95%%><tr><td>");
		printf("<table><tr>\n");
		printf("<th bgcolor=#e0e0e0 align=left> Used </th>");
		printf("<th bgcolor=#e0e0e0 align=left> Implemented </th>");
		printf("<th bgcolor=#e0e0e0 align=left> Table </th>\n");
		printf("</tr>\n");

		// tabeller med tblgrpnum=0
		sprintf(sql,"select num from tbls where dbnum=%ld and tblgrpnum=0 and deleted=0 order by name",sdb -> num);
		q.get_result(sql);
		while (q.fetch_row())
		{
			temptbl = new db::Tbls(db,q.getval());
			sprintf(sql,"select num from apptables where appnum=%ld and tblnum=%ld",sapp -> num,temptbl -> num);
			l = qd -> get_count(sql);
			if (!l)
			{
				tempat = new db::Apptables(db);
				tempat -> appnum = sapp -> num;
				tempat -> tblnum = temptbl -> num;
				tempat -> save();
			} else
				tempat = new db::Apptables(db,l);

			printf("<tr><td align=middle><input type=checkbox name=tblnum%ld%s value=1></td>\n",temptbl -> num,tempat -> checked ? " CHECKED" : "");
			sprintf(sql,"select count(*) from appfields where appnum=%ld and tblnum=%ld",sapp -> num,temptbl -> num);
			l = qd -> get_count(sql);
			sprintf(sql,"select count(*) from appfields where appnum=%ld and tblnum=%ld and status='Implemented'",sapp -> num,temptbl -> num);
			if (!l)
				printf("<td align=middle> --- </td>");
			else
				printf("<td align=right>%ld %%</td>\n",100 * qd -> get_count(sql) / l);
			printf("<td><a href=\"/cgi-bin/dbd/dbd?seltbl=%ld\">%s</a></td>",temptbl -> num,temptbl -> name);
			printf("</tr>\n");

			delete tempat;
			delete temptbl;
		}
		q.free_result();
		
		// tblgrupper och dess tabeller...
		sprintf(sql,"select num,name from tblgrps where dbnum=%ld",sdb -> num);
		q2.get_result(sql);
		while (q2.fetch_row())
		{
			l = q2.getval();	// tblgrpnum

			sprintf(sql,"select num from tbls where dbnum=%ld and tblgrpnum=%ld and deleted=0 order by name",sdb -> num,l);
			q.get_result(sql);
			if (q.num_rows())
				printf("<tr><td colspan=3><font size=+1><b>%s</b></font></td></tr>\n",q2.getstr());
			while (q.fetch_row())
			{
				temptbl = new db::Tbls(db,q.getval());
				sprintf(sql,"select num from apptables where appnum=%ld and tblnum=%ld",sapp -> num,temptbl -> num);
				l = qd -> get_count(sql);
				if (!l)
				{
					tempat = new db::Apptables(db);
					tempat -> appnum = sapp -> num;
					tempat -> tblnum = temptbl -> num;
					tempat -> save();
				} else
					tempat = new db::Apptables(db,l);

				printf("<tr><td align=middle><input type=checkbox name=tblnum%ld%s value=1></td>\n",temptbl -> num,tempat -> checked ? " CHECKED" : "");
				sprintf(sql,"select count(*) from appfields where appnum=%ld and tblnum=%ld",sapp -> num,temptbl -> num);
				l = qd -> get_count(sql);
				sprintf(sql,"select count(*) from appfields where appnum=%ld and tblnum=%ld and status='Implemented'",sapp -> num,temptbl -> num);
				if (!l)
					printf("<td align=middle> --- </td>");
				else
					printf("<td align=right>%ld %%</td>\n",100 * qd -> get_count(sql) / l);
				printf("<td><a href=\"/cgi-bin/dbd/dbd?seltbl=%ld\">%s</a></td>",temptbl -> num,temptbl -> name);
				printf("</tr>\n");

				delete tempat;
				delete temptbl;
			}
			q.free_result();
		}
		q2.free_result();

		printf("</table></td></tr></table></center>\n");

	// submit changes to apptables
		printf("<input type=submit name=submit value=\" Update table information \">\n");
		printf("</form>\n");


	// end of main table row
		printf("</td></tr>\n");	
	} else	// if (sapp)


// fields
	if (stbl)
	{
		printf("<tr><td colspan=8>");
		printf("<table width=\"100%%\" cellpadding=0 cellspacing=0><tr><td>");
		if (sfld)
		{
			printf("<a href=\"/cgi-bin/dbd/dbd?tof=%d\">",CF_EXPAND_FLD);
			if (cookieflags & CF_EXPAND_FLD)
				iexpanded();
			else
				inotexpanded();
			printf("</a>\n");
			printf("Field: <a href=\"/cgi-bin/dbd/dbd?changefld=0\"><b>%s</b></a>\n",sfld -> name);
			if (sfld -> deleted)
				printf("&lt;deleted&gt;\n");
			printf("<a href=\"/cgi-bin/dbd/dbd?selfld=0\"><img border=0 src=\"/image/close2.png\" alt=\"Close\"></a>\n");
		}
		printf("</td><td align=right>");
		strcpy(slask,"[\n");
		if (a -> c)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?selfld=-1\">create field</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (sfld && a -> w)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?changefld=0\">edit</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (sfld && a -> d)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?deletefld=0\">delete</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (*slask == '|')
			printf("]\n");
		printf("</td></tr></table>\n");

		printf("</td></tr>");
		if (sfld && ((cookieflags & CF_EXPAND_FLD) != 0))
		{
			objheader(a);
			objpres(db,sfld -> num,sfld -> name,
			 sfld -> owner,sfld -> createdate,
			 sfld -> changedby,sfld -> changedate,
			 sfld -> deletedby,sfld -> deletedate,"fld",user,sfld -> description,a);
//			printf("<tr><td colspan=8>&nbsp;</td></tr>\n");
		}

	/*
	 * index
	 */
		printf("<tr><td colspan=8>");
		printf("<table width=\"100%%\" cellpadding=0 cellspacing=0><tr><td>");
		if (sindex)
		{
			printf("<a href=\"/cgi-bin/dbd/dbd?tof=%d\">",CF_EXPAND_INDEX);
			if (cookieflags & CF_EXPAND_INDEX)
				iexpanded();
			else
				inotexpanded();
			printf("</a>\n");
			printf("Index: <a href=\"/cgi-bin/dbd/dbd?changeindex=0\"><b>%s</b></a>\n",sindex -> name);
			if (sindex -> deleted)
				printf("&lt;deleted&gt;\n");
			printf("<a href=\"/cgi-bin/dbd/dbd?selindex=0\"><img border=0 src=\"/image/close2.png\" alt=\"Close\"></a>\n");
		}
		printf("</td><td align=right>");
		strcpy(slask,"[\n");
		if (a -> c)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?selindex=-1\">create index</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (sindex && a -> w)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?changeindex=0\">edit</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (sindex && a -> d)
		{
			printf("%s<a href=\"/cgi-bin/dbd/dbd?deleteindex=0\">delete</a>\n",slask);
			strcpy(slask,"|\n");
		}
		if (*slask == '|')
			printf("]\n");
		printf("</td></tr></table>\n");

		printf("</td></tr>");
		if (sindex && ((cookieflags & CF_EXPAND_INDEX) != 0))
		{
			objheader(a);
			objpres(db,sindex -> num,sindex -> name,
			 sindex -> owner,sindex -> createdate,
			 sindex -> changedby,sindex -> changedate,
			 sindex -> deletedby,sindex -> deletedate,"index",user,sindex -> description,a);
//			printf("<tr><td colspan=8>&nbsp;</td></tr>\n");
		}

	/*
	 * fields/index-tabell
	 */
	 	printf("<tr><td colspan=8>");

		if (sapp && stbl)
		{
			sprintf(sql,"select checked from apptables where appnum=%ld and tblnum=%ld",sapp -> num,stbl -> num);
			visa_status = qd -> get_count(sql);
		}

	 	sprintf(sql,"select count(*) from indexs where tblnum=%ld",stbl -> num);
	 	l = qd -> get_count(sql);
		sprintf(sql,"select num from flds where tblnum=%ld %s order by ordning",stbl -> num,sd ? "" : "and deleted=0");
		q.get_result(sql);
		if (l || (qty = q.num_rows()) > 0)
		{
			printf("<center><table width=95%%><tr><td><table><tr>");
			printf("<th bgcolor=#e0e0e0 align=left colspan=2><font size=-1> Name </font></th>\n");
			if (visa_status)
				printf("<th bgcolor=#e0e0e0 align=left><font size=-1> Status </font></th>\n");
			printf("<th bgcolor=#e0e0e0 align=left><font size=-1> Description </font></th>\n");
			printf("<th bgcolor=#e0e0e0 align=left><font size=-1> Type </font></th>\n");
			printf("<th bgcolor=#e0e0e0 align=left><font size=-1> Extra </font></th>\n");
			if (a -> w)
				printf("<th bgcolor=#e0e0e0 align=left><font size=-1> Order </font></th>\n");
		// comments................................
			printf("<th bgcolor=#e0e0e0 align=left><font size=-1> Comments </font></th>\n");
			printf("</tr>\n");
			th = 1;
		} else
			th = 0;
		if ((qty = q.num_rows()) > 0)
		{
			i = 0;
			while (q.fetch_row())
			{
				tempfld = new db::Flds(db,q.getval());
				printf("<tr>");
				printf("<td valign=top><font size=-1><a href=\"/cgi-bin/dbd/dbd?selfld=%ld\">%s</a></font></td>\n",tempfld -> num,tempfld -> name);
				if (a -> w)
					printf("<td align=right valign=top><font size=-1>[<a href=\"/cgi-bin/dbd/dbd?selfld=%ld&changefld=0\">edit</a>]</font></td>",tempfld -> num);
				else
					printf("<td valign=top><font size=-1>");
				printf("</font></td>\n");
				// status
				if (visa_status)
				{
					sprintf(sql,"select num from appfields where appnum=%ld and fldnum=%ld",sapp -> num,tempfld -> num);
					l = qd -> get_count(sql);
					if (!l)
					{
						tempaf = new db::Appfields(db);
						tempaf -> appnum = sapp -> num;
						tempaf -> fldnum = tempfld -> num;
						strcpy(tempaf -> status,"Planned");
						tempaf -> tblnum = stbl -> num;
						tempaf -> save();
					} else
						tempaf = new db::Appfields(db,l);
					strcpy(slask,tempaf -> status);
					slask[4] = 0;	// Plan / Impl
					if (!strcmp(slask,"Plan"))
						printf("<td valign=top bgcolor=#ffff80 align=middle><font size=-1>%s</font></td>",slask);
					else
					if (!strcmp(slask,"Impl"))
						printf("<td valign=top bgcolor=#80ff80 align=middle><font size=-1>%s</font></td>",slask);
					else // Hold
						printf("<td valign=top bgcolor=#ff8080 align=middle><font size=-1>%s</font></td>",slask);
					delete tempaf;
				}
				printf("<td valign=top><font size=-1>%s</font></td>\n",tempfld -> description);

				// type string
				printf("<td valign=top><font size=-1>");
				if (tempfld -> fieldtype == 4)
					printf("ENUM ...</td>\n");
				else
				if (tempfld -> fieldtype == 7)
					printf("SET ...</td>\n");
				else
				if (tempfld -> fieldtype == 5)
					printf("ptr to table</td>\n");
				else
				{
					strcpy(slask,typestring(tempfld));
					for (j = 1; j < (int)strlen(slask); j++)
						if (slask[j] == ' ')
							slask[j] = 0;
					printf("%s</td>",slask);
				}
				// extra
				printf("<td valign=top><font size=-1>");
				switch (tempfld -> fieldtype)
				{
				    case 1:
				    	break;
				    case 2:
				    	if (tempfld -> minvalue < tempfld -> maxvalue)
				    		printf("%ld .. %ld",tempfld -> minvalue,tempfld -> maxvalue);
				    	break;
				    case 3:
				    	break;
				    case 4:
				    	printf("%s\n",tempfld -> options);
				    	break;
				    case 5:
				    	sprintf(sql,"select name from tbls where num=%ld",tempfld -> ptrtotblnum);
				    	printf("<a href=\"/cgi-bin/dbd/dbd?seltbl=%ld\">%s</a>",tempfld -> ptrtotblnum,qd -> get_string(sql));
				    	break;
				    case 6: // number
				    	break;
				    case 7:
				    	printf("%s\n",tempfld -> options);
				    	break;
				}
				printf("</font></td>");
				printf("<td valign=top><font size=-1>");
				if (a -> w)
				{
					if (i++)
						printf(" [<a href=\"/cgi-bin/dbd/dbd?up=%ld\">up</a>]",tempfld -> num);
					if (i < qty)
						printf(" [<a href=\"/cgi-bin/dbd/dbd?down=%ld\">down</a>]",tempfld -> num);
				} else
					i++;
				printf("</font></td>");
				// comments................................
				sprintf(sql,"select count(*) from kommentar where fldnum=%ld",tempfld -> num);
				qk = qd -> get_count(sql);
				sprintf(sql,"select dateposted from kommentar where fldnum=%ld order by dateposted desc",tempfld -> num);
				strcpy(date,qd -> get_string(sql));
				printf("<td valign=top align=middle><font size=-1><a href=\"/cgi-bin/dbd/dbd?selfld=%ld&readfld=0\">%ld</a>",tempfld -> num,qk);
				if (strcmp(date,user -> prevdatum) > 0)
					printf(" <img src=\"/image/new.gif\" alt=\"New!\">");
				printf("</font></td>\n");
				if (tempfld -> deleted) // deleted
					printf("<td valign=top><font size=-1>&lt;deleted&gt;</font></td>");
				printf("</tr>\n");
				delete tempfld;
			}
		}
		q.free_result();

		/*
		 * indexs
		 */

		sprintf(sql,"select num from indexs where tblnum=%ld%s",stbl -> num,sd ? "" : " and deleted=0");
		q.get_result(sql);
		while (q.fetch_row())
		{
			tempindex = new db::Indexs(db,q.getval());
			printf("<tr>");
			// name
			printf("<td valign=top><font size=-1>");

			printf("~<a href=\"/cgi-bin/dbd/dbd?selindex=%ld\">%s</a></font></td>",tempindex -> num,tempindex -> name);
			printf("<td align=right valign=top><font size=-1>");
			printf("[<a href=\"/cgi-bin/dbd/dbd?selindex=%ld&changeindex=0\">edit</a>]",tempindex -> num);

			printf("</font></td>\n");
			// status
			if (visa_status)
				printf("<td></td>");
			// description
			printf("<td valign=top><font size=-1>%s</font></td>\n",tempindex -> description);
			// type
			printf("<td valign=top><font size=-1>%s</font></td>\n",tempindex -> typ);
			// extra
			sprintf(sql,"select flds.name from indexlist,flds where indexnum=%ld and flds.num=fldnum",tempindex -> num);
			q2.get_result(sql);
			*slask = 0;
			printf("<td><font size=-1>");
			while (q2.fetch_row())
			{
				printf("%s%s",slask,q2.getstr());
				strcpy(slask,", ");
			}
			q2.free_result();
			printf("</td>");
			// order
			printf("<td></td>\n");
			// comments
			sprintf(sql,"select count(*) from kommentar where indexnum=%ld",tempindex -> num);
			qk = qd -> get_count(sql);
			sprintf(sql,"select dateposted from kommentar where indexnum=%ld order by dateposted desc",tempindex -> num);
			strcpy(date,qd -> get_string(sql));
			printf("<td valign=top align=middle><font size=-1><a href=\"/cgi-bin/dbd/dbd?selindex=%ld&readindex=0\">%ld</a>",tempindex -> num,qk);
			if (strcmp(date,user -> prevdatum) > 0)
				printf(" <img src=\"/image/new.gif\" alt=\"New!\">");
			printf("</font></td>\n");
			// deleted
			if (tempindex -> deleted) // deleted
				printf("<td valign=top><font size=-1>&lt;deleted&gt;</font></td>");
			printf("</tr>\n");
			delete tempindex;
		}
		q.free_result();

		if (th)
			printf("</table></td></tr></table></center>\n");

		printf("</td></tr>\n");
	} // if (stbl)

	printf("</table>\n");
//	printf("</form>\n");
//	printf("</td></tr></table>");
	footer();

	delete sql;
	delete qd;
	delete a;
}


/*
 * create database
 */

void page_1(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Flds *sfld,db::Users *user,Cookies *cs,char *s,short ok)
{
	Query q(db);
	Query *qd = new Query(db);
	long l;
	char slwr[20];
	char slask[200];
	char sql[200];
// s == 'Create' / 'Change' / 'Delete'

	strcpy(slwr,s);
	strlwr(slwr);

    	sprintf(slask,"%s Database",s);
    	header0(slask,1);

	printf("<table><tr><td valign=top>");
//	left_frame(db,sdb,stbl,sfld,user,cs);
	printf("</td><td valign=top>\n");

	printf("<form action=/cgi-bin/dbd/dbd method=post target=_top>\n");
	printf("<input type=hidden name=%sdb value=1>\n",slwr);
	if (sdb)
		printf("<input type=hidden name=num value=%ld>",sdb -> num);

	printf("<table cellpadding=0 cellspacing=0><tr><td valign=top>");
	printf("Database name<br><input type=text name=name value=\"%s\"><br>\n",sdb ? sdb -> name : "");
	printf("</td><td valign=top>");
	printf("Description<br><input type=text name=description size=40 value=\"%s\"><br>\n",
	 sdb ? sdb -> description : "");
	printf("</td></tr></table>\n");

// group select
	printf("In group<br><select name=grpnum>");
	if (sdb)
	{
		sprintf(sql,"select grpnum from grplinks where usernum=%ld and dbnum=%ld",user -> num,sdb -> num);
		l = qd -> get_count(sql);
		sprintf(sql,"select name from grps where num=%ld",l);
		printf("<option value=%ld>%s\n",l,qd -> get_string(sql));
	} else
		l = 0;
	sprintf(sql,"select num,name from grps where (usernum=0 or usernum=%ld) and num<>%ld",user -> num,l);
	q.get_result(sql);
	while (q.fetch_row())
		printf("<option value=%ld>%s\n",q.getval(0),q.getstr(1));
	q.free_result();
	printf("</select>\n");
	printf("<br>");

	printf("Comment<br>\n");
	printf("<textarea name=kommentar rows=8 cols=60 wrap=soft>\n");
	printf("</textarea>\n");
	if (!ok && !strcmp(s,"Create"))
		printf("<h3>Database will not be created - user limit reached</h3>\n");
	printf("<table><tr><td valign=top>");
	printf("<input type=submit name=submit value=\" %s \">\n",s);
	printf("</form>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
//	printf("<input type=hidden name=seldb value=0>\n");
//	printf("<input type=hidden name=seltbl value=0>\n");
//	printf("<input type=hidden name=selfld value=0>\n");
	printf("</td><td valign=top>");
	printf("<input type=submit name=submit value=\" Cancel \">\n");
	printf("</td></tr></table>");
	printf("</form>\n");

	printf("</td></tr></table>\n");
    	footer();

	delete qd;
}

/*
 * create table
 */

void page_2(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Flds *sfld,db::Users *user,Cookies *cs,char *s,short ok)
{
	Query q(db),q2(db);
	db::Dbs *tempdb;
	long tblgrpnum;
	char slwr[20];
	char slask[200];
	char sql[200];
	char tblgrpname[40];

	strcpy(slwr,s);	// 'create' / 'change' / 'delete'
	strlwr(slwr);

    	sprintf(slask,"%s Table",s);
    	header0(slask,1);

	printf("<table><tr><td valign=top>");
//	left_frame(db,sdb,stbl,sfld,user,cs);
	printf("</td><td valign=top>\n");

	printf("<form action=/cgi-bin/dbd/dbd method=post target=_top>\n");
//	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=hidden name=%stbl value=1>\n",slwr);
	if (stbl)
		printf("<input type=hidden name=num value=%ld>",stbl -> num);
	printf("<table cellpadding=0 cellspacing=0><tr><td valign=top>");
	printf("Table name<br><input type=text name=name value=\"%s\"><br>\n",stbl ? stbl -> name : "");
	printf("</td><td valign=top>");
	printf("Description<br><input type=text name=description size=40 value=\"%s\"><br>\n",
	 stbl ? stbl -> description : "");
	printf("</td></tr></table>\n");
	printf("In database<br><select name=dbnum><option value=%ld>%s\n",sdb -> num,sdb -> name);

	// select database
	sprintf(sql,"select dbnum from access where usernum=%ld and c<>0 and dbnum<>%ld",user -> num,sdb -> num);
	q.get_result(sql);
	while (q.fetch_row())
	{
		tempdb = new db::Dbs(db,q.getval());
		if (!tempdb -> deleted)
			printf("<option value=%ld>%s\n",tempdb -> num,tempdb -> name);
		delete tempdb;
	}
	q.free_result();
	printf("</select><br>\n");
	// select tblgrp
	if (stbl)
	{
		sprintf(sql,"select num,name from tblgrps where dbnum=%ld order by name",sdb -> num);
		q.get_result(sql);
		if (q.num_rows())
		{
			sprintf(sql,"select name from tblgrps where num=%ld",stbl -> tblgrpnum);
			printf("Table group<br><select name=tblgrpnum><option value=%ld>%s\n",stbl -> tblgrpnum,q2.get_string(sql));
		} else
			printf("<input type=hidden name=tblgrpnum value=0>\n");
		while (q.fetch_row())
		{
			tblgrpnum = q.getval();
			strcpy(tblgrpname,q.getstr());
			if (tblgrpnum != stbl -> tblgrpnum)
				printf("<option value=%ld>%s\n",tblgrpnum,tblgrpname);
		}
		if (q.num_rows())
		{
			if (stbl -> tblgrpnum)
				printf("<option value=0>\n");
			printf("</select><br>\n");
		}
		q.free_result();
	} else
	{
		sprintf(sql,"select num,name from tblgrps where dbnum=%ld order by name",sdb -> num);
		q.get_result(sql);
		if (q.num_rows())
			printf("Table group<br><select name=tblgrpnum><option value=0>\n");
		else
			printf("<input type=hidden name=tblgrpnum value=0>\n");
		while (q.fetch_row())
		{
			tblgrpnum = q.getval();
			strcpy(tblgrpname,q.getstr());
			printf("<option value=%ld>%s\n",tblgrpnum,tblgrpname);
		}
		if (q.num_rows())
			printf("</select><br>\n");
		q.free_result();
	}

	printf("Comment<br>\n");
	printf("<textarea name=kommentar rows=8 cols=60 wrap=soft>\n");
	printf("</textarea>\n");
	if (!ok && !strcmp(s,"Create"))
		printf("<h3>Table will not be created - user limit reached</h3>\n");
	printf("<table><tr><td valign=top>");
	printf("<input type=submit name=submit value=\" %s \">\n",s);
	printf("</form>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
//	printf("<input type=hidden name=seltbl value=0>\n");
//	printf("<input type=hidden name=selfld value=0>\n");
	printf("</td><td valign=top>");
	printf("<input type=submit name=submit value=\" Cancel \">\n");
	printf("</td></tr></table>");
	printf("</form>\n");

	printf("</td></tr></table>\n");
    	footer();
}


/*
 *
 */

void fieldselect(int num,char *s)
{
	Parse *pa;
	char slask[500];
	char ord[20];

	switch (num)
	{
		case 1: // char
			strcpy(slask,"char varchar tinytext text mediumtext longtext tinyblob blob mediumblob longblob");
			break;
		case 2: // int
			strcpy(slask,"int tinyint smallint mediumint bigint");
			break;
		case 3: // time
			strcpy(slask,"datetime date timestamp time year");
			break;
		case 6: // number
			strcpy(slask,"float double decimal");
			break;
		default:
			*slask = 0;
	}
	strupr(slask);

	printf("<select name=fieldstr%d>",num);

	if (*s)
	{
		strupr(s);
		pa = new Parse(slask);
		pa -> getword(ord);
		while (*ord)
		{
			if (!strcmp(ord,s))
				break;
			pa -> getword(ord);
		}
		delete pa;
		if (*ord)
			printf("<option>%s\n",s);
		else
			printf("<option>\n");
	}
	pa = new Parse(slask);
	pa -> getword(slask);
	while (*slask)
	{
		if (strcmp(slask,s))
			printf("<option>%s\n",slask);
		pa -> getword(slask);
	}
	delete pa;
	printf("</select>\n");
}

/*
 * create field
 */

void page_3(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Flds *sfld,db::Users *user,Cookies *cs,char *s,short ok,db::Applications *sapp)
{
	Query q(db),*qd = new Query(db);
	db::Appfields *tempaf;
	char *typenames[8] = {"",
	 "<b>string/binary column</b>",
	 "<b>integer column</b>",
	 "<b>time column</b>",
	 "<b>enum column</b>",
	 "",
	 "<b>number column</b>",
	 "<b>set column</b>"};
	long l;
	short visa_status = 0;
	char sql[200];
	char slwr[20];
	char slask[200];

	strcpy(slwr,s);	// 'create' / 'change' / 'delete'
	strlwr(slwr);

    	sprintf(slask,"%s Field",s);
    	header0(slask,1);

	if (sapp && strcmp(slwr,"create"))
	{
		sprintf(sql,"select checked from apptables where appnum=%ld and tblnum=%ld",sapp -> num,stbl -> num);
		visa_status = qd -> get_count(sql);
	}

	if (sfld)
	{
		sprintf(sql,"select num from appfields where fldnum=%ld",sfld -> num);
		q.get_result(sql);
		if (q.num_rows())
			printf("<table><tr><td align=right>db::Application:</td>");
		while (q.fetch_row())
		{
			tempaf = new db::Appfields(db,q.getval());
			sprintf(sql,"select name from applications where num=%ld",tempaf -> appnum);
			printf("<th align=middle> %s </th>\n",qd -> get_string(sql));
			delete tempaf;
		}
		q.free_result();

		sprintf(sql,"select num from appfields where fldnum=%ld",sfld -> num);
		q.get_result(sql);
		if (q.num_rows())
			printf("</tr><tr><td align=right>Field status:</td>\n");
		while (q.fetch_row())
		{
			tempaf = new db::Appfields(db,q.getval());
			if (!strncmp(tempaf -> status,"Plan",4))
				printf("<td bgcolor=#ffff80 align=middle><font size=-1>%s</font></td>",tempaf -> status);
			else
			if (!strncmp(tempaf -> status,"Impl",4))
				printf("<td bgcolor=#80ff80 align=middle><font size=-1>%s</font></td>",tempaf -> status);
			else // Hold
				printf("<td bgcolor=#ff8080 align=middle><font size=-1>%s</font></td>",tempaf -> status);
			delete tempaf;
		}
		if (q.num_rows())
			printf("</tr></table>\n");
		q.free_result();
	}

	printf("<table><tr><td valign=top>");
//	left_frame(db,sdb,stbl,sfld,user,cs);
	printf("</td><td valign=top>\n");

//	printf("<form action=/cgi-bin/dbd/dbd method=post target=_top>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=hidden name=%sfld value=1>\n",slwr);
	if (sfld)
		printf("<input type=hidden name=num value=%ld>",sfld -> num);
	printf("<table cellpadding=0 cellspacing=0><tr><td valign=top>");
	printf("Field name<br><input type=text name=name value=\"%s\"><br>\n",sfld ? sfld -> name : "");
	printf("</td><td valign=top colspan=2>");
	printf("Description<br><input type=text name=description size=40 value=\"%s\"><br>\n",
	 sfld ? sfld -> description : "");
//	printf("</td></tr></table>\n");
	printf("</td></tr><tr><td valign=top>\n");
	printf("In table<br><select name=tblnum><option value=%ld>%s\n",stbl -> num,stbl -> name);
	sprintf(sql,"select num,name from tbls where num<>%ld and dbnum=%ld and deleted=0",stbl -> num,sdb -> num);
	q.get_result(sql);
	while (q.fetch_row())
		printf("<option value=%ld>%s\n",q.getval(0),q.getstr(1));
	q.free_result();
	printf("</select>\n");

	printf("</td><td valign=top>");
	if (visa_status)
	{
		sprintf(sql,"select num from appfields where appnum=%ld and fldnum=%ld",sapp -> num,sfld -> num);
		l = qd -> get_count(sql);
		if (!l)
		{
			tempaf = new db::Appfields(db);
			tempaf -> appnum = sapp -> num;
			tempaf -> fldnum = sfld -> num;
			strcpy(tempaf -> status,"Planned");
			tempaf -> tblnum = stbl -> num;
			tempaf -> save();
		} else
			tempaf = new db::Appfields(db,l);

		printf("Status (%s)<br><select name=status><option>%s\n",sapp -> name,tempaf -> status);
		if (strcmp(tempaf -> status,"Planned"))
			printf("<option>Planned\n");
		if (strcmp(tempaf -> status,"Implemented"))
			printf("<option>Implemented\n");
		if (strcmp(tempaf -> status,"Hold"))
			printf("<option>Hold\n");
		printf("</select>\n");

		delete tempaf;
	} // if (visa_status)
	printf("</td><td valign=bottom>");
	printf("<input type=submit name=submit value=\" %s \">\n",s);
	printf("</td></tr></table>\n");


// Database field types:
//  o 1) Char (number of chars [xxx])
//  o 2) Integer (number of digits [xxx] - default 11)
//     		[minvalue]  [maxvalue]	(no values: minvalue=0, maxvalue=-1)
//  o 3) Datetime
//  o 4) Enum field
//     		[options]
//  o 5) Ptr to other table (integer ptr to primary key)
//     		[table]
//  o 6) NUMBER
//  o 7) SET

// fieldtype 1-char,2-int,3-datetime,4-enum/options,5-ptr,6-number,7-set
// * fieldstr - type string (var/varchar etc)
// * fieldflags - bit 0 NULL, bit 1...
// charlength
// integerlength
// * decimallength
// minvalue
// maxvalue
// options
// ptrtotable

//	printf("<br>\n");
//	printf("<br>\n");

	printf("Field type<br>");

	if (sfld)	// edit field
	{
	// 1: char
		printf("<input type=radio name=fieldtype value=1%s>%s\n",
		 (sfld -> fieldtype == 1) ? " CHECKED" : "",typenames[1]);
		fieldselect(1,sfld -> fieldstr);
		printf("(number of characters <input type=text name=charlength size=4 value=%ld> max 255)<br>\n",
		 sfld -> charlength);

	// 2: int
		printf("<input type=radio name=fieldtype value=2%s>%s\n",
		 (sfld -> fieldtype == 2) ? " CHECKED" : "",typenames[2]);
		fieldselect(2,sfld -> fieldstr);
		printf("(number of digits <input type=text name=integerlength size=4 value=%ld> - default 11)<br>\n",
		 sfld -> integerlength);
		if (sfld -> minvalue > sfld -> maxvalue)
		{
			printf("Integer min. value <input type=text name=minvalue size=12>\n");
			printf("Integer max. value <input type=text name=maxvalue size=12><br>\n");
		} else
		{
			printf("Integer min. value <input type=text name=minvalue size=12 value=%ld>\n",
			 sfld -> minvalue);
			printf("Integer max. value <input type=text name=maxvalue size=12 value=%ld><br>\n",
			 sfld -> maxvalue);
		}
		printf("<input type=checkbox name=autoincr value=1%s>Auto increment<br>\n",((sfld -> fieldflags & FF_AUTO_INCREMENT) != 0) ? " CHECKED" : "");

	// 6: number
		printf("<input type=radio name=fieldtype value=6%s>%s\n",
		 (sfld -> fieldtype == 6) ? " CHECKED" : "",typenames[6]);
		fieldselect(6,sfld -> fieldstr);
		printf("( <input type=text name=numberlength size=4 value=%ld> . <input type=text name=decimallength size=4 value=%ld> )\n",
		 sfld -> integerlength,sfld -> decimallength);
		printf("<br>");

	// 3: datetime
		printf("<input type=radio name=fieldtype value=3%s>%s\n",
		 (sfld -> fieldtype == 3) ? " CHECKED" : "",typenames[3]);
		fieldselect(3,sfld -> fieldstr);
		printf("<br>");

	// 4: enum
		printf("<input type=radio name=fieldtype value=4%s>%s (options = OPTION1 / OPTION2 / OPTION3 etc)\n",
		 (sfld -> fieldtype == 4) ? " CHECKED" : "",typenames[4]);
		printf("<br>");

	// 7: set
		printf("<input type=radio name=fieldtype value=7%s>%s\n",
		 (sfld -> fieldtype == 7) ? " CHECKED" : "",typenames[7]);
		printf("<br>");

		printf("<textarea name=options rows=3 cols=60 wrap=soft>\n");
		printf("%s\n",sfld -> options);
		printf("</textarea>\n");
		printf("<br>\n");

	// 5: ptr to table
		printf("<input type=radio name=fieldtype value=5%s><b>ptr</b> to other table (integer ptr to primary key)<br>\n",
		 (sfld -> fieldtype == 5) ? " CHECKED" : "");
		sprintf(sql,"select num,name from tbls where dbnum=%ld and deleted=0 order by name",sdb -> num);
		q.get_result(sql);
		if (q.num_rows())
		{
			printf("<select name=ptrtotable>");
			if (sfld -> ptrtotblnum)
			{
				sprintf(sql,"select name from tbls where num=%ld",sfld -> ptrtotblnum);
				printf("<option value=%ld>%s\n",sfld -> ptrtotblnum,qd -> get_string(sql));
			} else
				printf("<option value=0>\n");
			while (q.fetch_row())
				if (q.getval(0) != sfld -> ptrtotblnum)
					printf("<option value=%ld>%s\n",q.getval(0),q.getstr(1));
			if (sfld -> ptrtotblnum)
				printf("<option value=0>\n");
			printf("</select>\n");
		} else
		{
			printf("<h3>no other tables in database</h3>\n");
			printf("<input type=hidden name=ptrtotable value=0>\n");
		}
		q.free_result();
		printf("<br>");

	} else		// new field
	{
	// 1: char
		printf("<input type=radio name=fieldtype value=1 CHECKED>%s\n",typenames[1]);
		fieldselect(1,"");
		printf("(number of characters <input type=text name=charlength size=4>)<br>\n");

	// 2: int
		printf("<input type=radio name=fieldtype value=2>%s\n",typenames[2]);
		fieldselect(2,"");
		printf("(number of digits <input type=text name=integerlength size=4 value=11> - default 11)<br>\n");
		printf("Integer min. value <input type=text name=minvalue size=12>\n");
		printf("Integer max. value <input type=text name=maxvalue size=12><br>\n");
		printf("<input type=checkbox name=autoincr value=1>Auto increment<br>\n");

	// 6: number
		printf("<input type=radio name=fieldtype value=6>%s\n",typenames[6]);
		fieldselect(6,"");
		printf("( <input type=text name=numberlength size=4> . <input type=text name=decimallength size=4> )\n");
		printf("<br>");

	// 3: datetime
		printf("<input type=radio name=fieldtype value=3>%s\n",typenames[3]);
		fieldselect(3,"");
		printf("<br>");

	// 4: enum
		printf("<input type=radio name=fieldtype value=4>%s (options = OPTION1 / OPTION2 / OPTION3 etc)\n",typenames[4]);
		printf("<br>");


	// 7: set
		printf("<input type=radio name=fieldtype value=7>%s\n",typenames[7]);
		printf("<br>");

		printf("<textarea name=options rows=3 cols=60 wrap=soft>\n");
		printf("</textarea>\n");
		printf("<br>\n");

	// 5: ptr to table
		printf("<input type=radio name=fieldtype value=5><b>ptr</b> to other table (integer ptr to primary key)<br>\n");
		sprintf(sql,"select num,name from tbls where dbnum=%ld and deleted=0 order by name",sdb -> num);
		q.get_result(sql);
		if (q.num_rows())
		{
			printf("<select name=ptrtotable>");
			if (sfld && sfld -> ptrtotblnum)
			{
				sprintf(sql,"select name from tbls where num=%ld",sfld -> ptrtotblnum);
				printf("<option value=%ld>%s\n",sfld -> ptrtotblnum,qd -> get_string(sql));
			} else
				printf("<option value=0>\n");
			while (q.fetch_row())
				if (!sfld || q.getval(0) != sfld -> ptrtotblnum)
					printf("<option value=%ld>%s\n",q.getval(0),q.getstr(1));
			if (sfld && sfld -> ptrtotblnum)
				printf("<option value=0>\n");
			printf("</select>\n");
		} else
		{
			printf("<h3>no other tables in database</h3>\n");
			printf("<input type=hidden name=ptrtotable value=0>\n");
		}
		q.free_result();
		printf("<br>");

	}
	printf("<br>\n");

	printf("Default value<br><input type=text name=defaultvalue size=40 value=\"%s\"><br>\n",sfld ? sfld -> defaultvalue : "");

	printf("<input type=checkbox name=nullok value=1%s>Allow NULL<br>\n",sfld ? ((sfld && ((sfld -> fieldflags & FF_ALLOWNULL) != 0)) ? " CHECKED" : "") : "");

	printf("Comment<br>\n");
	printf("<textarea name=kommentar rows=8 cols=60 wrap=soft>\n");
	printf("</textarea>\n");
	if (!ok && !strcmp(s,"Create"))
		printf("<h3>Field will not be created - user limit reached</h3>\n");
	printf("<table><tr><td valign=top>");
	printf("<input type=submit name=submit value=\" %s \">\n",s);
	printf("</form>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
//	printf("<input type=hidden name=selfld value=0>\n");
	printf("</td><td valign=top>");
	printf("<input type=submit name=submit value=\" Cancel \">\n");
	printf("</td></tr></table>");
	printf("</form>\n");
	
	printf("</td></tr></table>\n");
    	footer();
    	
    	delete qd;
}


/*
 * create index
 */

void page_4(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Indexs *sindex,db::Users *user,Cookies *cs,char *s,short ok)
{
	Query q(db),*qd = new Query(db);
	db::Indexlist *il;
	db::Flds *tempfld;
	long l;
	int j;
	char sql[200];
	char slwr[20];
	char slask[200];

	strcpy(slwr,s);	// 'create' / 'change' / 'delete'
	strlwr(slwr);

    	sprintf(slask,"%s Index",s);
    	header0(slask,1);

	printf("<table><tr><td valign=top>");
	printf("</td><td valign=top>\n");

//	printf("<form action=/cgi-bin/dbd/dbd method=post target=_top>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=hidden name=%sindex value=1>\n",slwr);
	if (sindex)
		printf("<input type=hidden name=num value=%ld>",sindex -> num);
	printf("<table cellpadding=0 cellspacing=0><tr><td valign=top>");
	printf("Index name<br><input type=text name=name value=\"%s\"><br>\n",sindex ? sindex -> name : "");
	printf("</td><td valign=top>");
	printf("Description<br><input type=text name=description size=40 value=\"%s\"><br>\n",
	 sindex ? sindex -> description : "");
	printf("</td></tr></table>\n");
	printf("<input type=hidden name=tblnum value=%ld>\n",stbl -> num);
	printf("Index type<br>");
	if (sindex)
	{
		printf("<select name=typ><option>%s\n",sindex -> typ);
		if (strcmp(sindex -> typ,"INDEX"))
			printf("<option>INDEX\n");
		if (strcmp(sindex -> typ,"PRIMARY"))
			printf("<option>PRIMARY\n");
		if (strcmp(sindex -> typ,"UNIQUE"))
			printf("<option>UNIQUE\n");
		if (strcmp(sindex -> typ,"FULLTEXT"))
			printf("<option>FULLTEXT\n");
	} else
	{
		printf("<select name=typ><option>INDEX\n");
		printf("<option>PRIMARY\n");
		printf("<option>UNIQUE\n");
		printf("<option>FULLTEXT\n");
	}
	printf("</select>\n");
	printf("<br>");

	if (!sindex)
	{
		printf("<table><tr><td valign=top>");
		printf("Field<br><select name=fldnum>\n");
		sprintf(sql,"select num,name from flds where tblnum=%ld and deleted=0 order by ordning",stbl -> num);
		q.get_result(sql);
		while (q.fetch_row())
			printf("<option value=%ld>%s\n",q.getval(0),q.getstr(1));
		q.free_result();
		printf("</select>\n");
		printf("</td><td valign=top>");
		printf("Length<br><input type=text name=length size=4>\n");
		printf("</td></tr></table>\n");
	}

	printf("Comment<br>\n");
	printf("<textarea name=kommentar rows=8 cols=60 wrap=soft>\n");
	printf("</textarea>\n");
	if (!ok && !strcmp(s,"Create"))
		printf("<h3>Index will not be created - user limit reached</h3>\n");
	printf("<table><tr><td valign=top>");
	printf("<input type=submit name=submit value=\" %s \">\n",s);
	printf("</form>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
//	printf("<input type=hidden name=selindex value=0>\n");
	printf("</td><td valign=top>");
	printf("<input type=submit name=submit value=\" Cancel \">\n");
	printf("</td></tr></table>");

	if (sindex)
	{
		printf("<br>");
		printf("<h3>Fields in index</h3>\n");

		printf("<table>");
		printf("<tr><th bgcolor=#e0e0e0> Field </th>");
		printf("<th bgcolor=#e0e0e0> Type </th>\n");
		printf("<th bgcolor=#e0e0e0> Length </th>\n");
		printf("<th bgcolor=#e0e0e0> Delete </th>\n");
		printf("<th bgcolor=#e0e0e0> Change </th>\n");
		printf("</tr>\n");
		sprintf(sql,"select num from indexlist where indexnum=%ld",sindex -> num);
		q.get_result(sql);
		l = q.num_rows();	// antal flds i index
		while (q.fetch_row())
		{
			printf("<tr>");
			il = new db::Indexlist(db,q.getval());
			tempfld = new db::Flds(db,il -> fldnum);
			sprintf(sql,"select name from flds where num=%ld",il -> fldnum);
			strcpy(slask,qd -> get_string(sql));
			printf("<td>%s</td>\n",slask);

				// type string
				printf("<td>");
				if (tempfld -> fieldtype == 4)
					printf("ENUM ...</td>\n");
				else
				if (tempfld -> fieldtype == 7)
					printf("SET ...</td>\n");
				else
				if (tempfld -> fieldtype == 5)
					printf("ptr to table</td>\n");
				else
				{
					strcpy(slask,typestring(tempfld));
					for (j = 1; j < (int)strlen(slask); j++)
						if (slask[j] == ' ')
							slask[j] = 0;
					printf("%s</td>",slask);
				}

			if (il -> length == -1)
				printf("<td><input type=text name=length%ld size=4></td>\n",il -> num);
			else
				printf("<td><input type=text name=length%ld value=%ld size=4></td>\n",il -> num,il -> length);
			if (l > 1)
				printf("<td><input type=submit name=delete%ld value=\" Delete \"></td>\n",il -> num);
			else
				printf("<td></td>");
			printf("<td><input type=submit name=change%ld value=\" Change \"></td>\n",il -> num);
			delete tempfld;
			delete il;
			printf("</tr>\n");
		}
		q.free_result();
		printf("</table>\n");

	// add field
		printf("<br>");
		printf("<h3>Add field</h3>\n");

		printf("<table><tr><td valign=top>");
		printf("Field<br><select name=fldnum>\n");
		sprintf(sql,"select num,name from flds where tblnum=%ld and deleted=0 order by ordning",stbl -> num);
		q.get_result(sql);
		while (q.fetch_row())
		{
			sprintf(sql,"select num from indexlist where indexnum=%ld and fldnum=%ld",sindex -> num,q.getval(0));
			if (!qd -> get_count(sql))
				printf("<option value=%ld>%s\n",q.getval(0),q.getstr(1));
		}
		q.free_result();
		printf("</select>\n");
		printf("</td><td valign=top>");
		printf("Length<br><input type=text name=length size=4>\n");
		printf("</td><td>");
		printf("Add<br><input type=submit name=add value=\" Add \">\n");
		printf("</td>");
		printf("</tr></table>\n");
	} else
	{
	}

	printf("</form>\n");
	
	printf("</td></tr></table>\n");
    	footer();
    	
    	delete qd;
}


/*
 * create app
 */

void page_5(Database *db,db::Dbs *sdb,db::Applications *sapp,db::Users *user,Cookies *cs,char *s,short ok)
{
	Query q(db),q2(db);
	db::Dbs *tempdb;
	char slwr[20];
	char slask[200];
	char sql[200];

	strcpy(slwr,s);	// 'create' / 'change' / 'delete'
	strlwr(slwr);

    	sprintf(slask,"%s db::Application",s);
    	header0(slask,1);

	printf("<table><tr><td valign=top>");
//	left_frame(db,sdb,stbl,sfld,user,cs);
	printf("</td><td valign=top>\n");

	printf("<form action=/cgi-bin/dbd/dbd method=post target=_top>\n");
//	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=hidden name=%sapp value=1>\n",slwr);
	if (sapp)
		printf("<input type=hidden name=num value=%ld>",sapp -> num);
	printf("<table cellpadding=0 cellspacing=0><tr><td valign=top>");
	printf("db::Application name<br><input type=text name=name value=\"%s\"><br>\n",sapp ? sapp -> name : "");
	printf("</td><td valign=top>");
	printf("Description<br><input type=text name=description size=40 value=\"%s\"><br>\n",
	 sapp ? sapp -> description : "");
	printf("</td></tr></table>\n");
	printf("In database<br><select name=dbnum><option value=%ld>%s\n",sdb -> num,sdb -> name);

	// select database
	sprintf(sql,"select dbnum from access where usernum=%ld and c<>0 and dbnum<>%ld",user -> num,sdb -> num);
	q.get_result(sql);
	while (q.fetch_row())
	{
		tempdb = new db::Dbs(db,q.getval());
		if (!tempdb -> deleted)
			printf("<option value=%ld>%s\n",tempdb -> num,tempdb -> name);
		delete tempdb;
	}
	q.free_result();
	printf("</select><br>\n");

	printf("Comment<br>\n");
	printf("<textarea name=kommentar rows=8 cols=60 wrap=soft>\n");
	printf("</textarea>\n");
	if (!ok && !strcmp(s,"Create"))
		printf("<h3>Application will not be created - user limit reached</h3>\n");
	printf("<table><tr><td valign=top>");
	printf("<input type=submit name=submit value=\" %s \">\n",s);
	printf("</form>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("</td><td valign=top>");
	printf("<input type=submit name=submit value=\" Cancel \">\n");
	printf("</td></tr></table>");
	printf("</form>\n");

	printf("</td></tr></table>\n");
    	footer();
}


/*
 * login
 */

void page_4(char *handle)
{
	nullheader("Login",0);
	printf("<hr>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("Login<br><input type=text name=handle value=\"%s\"><br>\n",handle);
	printf("Password<br><input type=password name=password><br>\n");
	printf("<input type=submit name=submit value=\" Log in \">\n");
	printf("</form>\n");
	printf("<br>");
	printf("[\n");
	printf("<a href=\"/\">Home</a>\n|\n");
	printf("<a href=\"/cgi-bin/dbd/dbd?createuser=0\">Create a new user</a> ]<br>\n");
//	footer();
	printf("<br><br>Please send bug reports to <a href=\"mailto:grymse@alhem.net\">Grymse</a>.\n");
//	printf("If you have a problem, please make sure that Grymse has access to your database.\n");
	printf("</body></html>\n");
}

/*
 * create a new user
 */

void page_17(char *handle)
{
	nullheader("Create a new user",0);
	printf("<hr>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=hidden name=createuser value=1>\n");
	printf("Your name<br><input type=text name=name><br>\n");
	printf("New Login<br><input type=text name=handle value=\"%s\"><br>\n",handle);
	printf("Password<br><input type=password name=password><br>\n");
	printf("Repeat password<br><input type=password name=password2><br>\n");
	printf("Your Email<br><input type=text name=email><br>\n");
	printf("Your ICQ#<br><input type=text name=icq><br>\n");
	printf("<table><tr><td valign=top>");
	printf("<input type=submit name=submit value=\" Create user \">\n");
	printf("</form>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("</td><td valign=top>");
	printf("<input type=submit name=submit value=\" Cancel \">\n");
	printf("</td></tr></table>\n");
	printf("</form>\n");
//	footer();
	printf("<br><br>Please send bug reports to <a href=\"mailto:grymse@alhem.net\">Grymse</a>.\n");
//	printf("If you have a problem, please make sure that Grymse has access to your database.\n");
	printf("</body></html>\n");
}


/*
 * page_18(): update personal info
 */

void page_18(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Flds *sfld,db::Users *user,Cookies *cs)
{
	Query *qd = new Query(db);
	Query q(db);
	db::Users *tempuser;
	long qdb,qtbl,qfld,qindex,qapp;
	long usernum = user -> num;
	char sql[200];
	char slask[200];

	header0("User info",3);
	printf("<table><tr><td valign=top>");
//	left_frame(db,sdb,stbl,sfld,user,cs);
	printf("</td><td valign=top>\n");

	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");

	if (user -> superuser)
	{
		if (cs -> getvalue("valduser",slask,20) && *slask)
			usernum = atol(slask);
		sprintf(sql,"select name from users where num=%ld",usernum);
		printf("<select name=valduser><option value=%ld>%s\n",usernum,qd -> get_string(sql));
		sprintf(sql,"select num,name from users where num<>%ld",usernum);
		q.get_result(sql);
		while (q.fetch_row())
			printf("<option value=%ld>%s\n",q.getval(0),q.getstr(1));
		q.free_result();
		printf("</select>\n");
		printf("<input type=submit name=valjuser value=\" Select \"><br>\n");
	}
	tempuser = new db::Users(db,usernum);
	printf("<input type=hidden name=ui value=1>\n");
	printf("<input type=hidden name=usernum value=%ld>\n",usernum);

	sprintf(sql,"select count(*) from dbs where owner=%ld and deleted=0",usernum);
	qdb = qd -> get_count(sql);
	sprintf(sql,"select count(*) from tbls where owner=%ld and deleted=0",usernum);
	qtbl = qd -> get_count(sql);
	sprintf(sql,"select count(*) from flds where owner=%ld and deleted=0",usernum);
	qfld = qd -> get_count(sql);
	sprintf(sql,"select count(*) from indexs where owner=%ld and deleted=0",usernum);
	qindex = qd -> get_count(sql);
	sprintf(sql,"select count(*) from applications where owner=%ld and deleted=0",usernum);
	qapp = qd -> get_count(sql);

	printf("<h3>Personal info</h3>\n");
	printf("<center><table width=95%%>");

	// OBS! tempuser->.... inte user->....
	printf("<tr><td>Your login</td><td><b>%s</b></td></tr>\n",tempuser -> handle);
	printf("<tr><td>Name</td><td><input type=text name=name size=40 value=\"%s\"></td></tr>\n",tempuser -> name);
	printf("<tr><td>Old password</td><td><input type=password name=oldpassword></td></tr>\n");
	printf("<tr><td>New password</td><td><input type=password name=newpassword></td></tr>\n");
	printf("<tr><td>Repeat password</td><td><input type=password name=repeatpassword></td></tr>\n");
	printf("<tr><td>Email</td><td><input type=text name=email size=40 value=\"%s\"></td></tr>\n",tempuser -> email);
	printf("<tr><td>ICQ#</td><td><input type=text name=icq value=\"%s\"></td></tr>\n",tempuser -> icq);
	if (user -> superuser)
	{
		printf("<tr><td>Max databases</td><td><input type=text name=maxdbs size=10 value=%ld></td></tr>\n",tempuser -> maxdbs);
		printf("<tr><td>Max tables</td><td><input type=text name=maxtbls size=10 value=%ld></td></tr>\n",tempuser -> maxtbls);
		printf("<tr><td>Max fields</td><td><input type=text name=maxflds size=10 value=%ld></td></tr>\n",tempuser -> maxflds);
		printf("<tr><td>Max indexes</td><td><input type=text name=maxindexs size=10 value=%ld></td></tr>\n",tempuser -> maxindexs);
		printf("<tr><td>Max applications</td><td><input type=text name=maxapps size=10 value=%ld></td></tr>\n",tempuser -> maxapps);
	}
	printf("<tr><td>Autocreate \"num\" field</td><td><input type=checkbox name=flag0%s value=1></td></tr>\n",(tempuser -> flags & UF_AUTOCREATENUM) ? " CHECKED" : "");
//	printf("<tr><td>Show linked tables</td><td><input type=checkbox name=flag1%s value=1></td></tr>\n",(tempuser -> flags & UF_SHOWLINKED) ? " CHECKED" : "");
	printf("<tr><td>Lines of data to show</td><td><input type=text name=steps size=10 value=%ld></td></tr>\n",tempuser -> steps);
	printf("</table></center>\n");

	printf("<table><tr><td valign=top>");
	printf("<input type=submit name=submit value=\" Update personal info \">\n");
	printf("</td><td valign=top>\n");
	printf("<input type=submit name=submit value=\" Cancel \">\n");
	printf("</td></tr></table>\n");

	printf("</form>\n");

	printf("<h3>Account info</h3>\n");
	printf("<center><table width=95%%>");
	printf("<tr><td>Databases</td>");
	printf("<td align=right>%ld</td>",qdb);
	printf("<td>/</td>\n");
	printf("<td align=right>%ld</td>",tempuser -> maxdbs);
	printf("</tr>\n");
	printf("<tr><td>Tables</td>");
	printf("<td align=right>%ld</td>",qtbl);
	printf("<td>/</td>\n");
	printf("<td align=right>%ld</td>",tempuser -> maxtbls);
	printf("</tr>\n");
	printf("<tr><td>Fields</td>");
	printf("<td align=right>%ld</td>",qfld);
	printf("<td>/</td>\n");
	printf("<td align=right>%ld</td>",tempuser -> maxflds);
	printf("</tr>\n");
	printf("<tr><td>Indexes</td>");
	printf("<td align=right>%ld</td>",qindex);
	printf("<td>/</td>\n");
	printf("<td align=right>%ld</td>",tempuser -> maxindexs);
	printf("</tr>\n");
	printf("<tr><td>db::Applications</td>");
	printf("<td align=right>%ld</td>",qapp);
	printf("<td>/</td>\n");
	printf("<td align=right>%ld</td>",tempuser -> maxapps);
	printf("</tr>\n");
	printf("</table></center>\n");

	printf("</td></tr></table>\n");
	footer();

	delete qd;
	delete tempuser;
}

/*
 * database access
 */

void page_19(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Flds *sfld,db::Users *user,Cookies *cs)
{
	Query *qd = new Query(db);
	Query q(db),q2(db);
	db::Dbs *tempdb;
	db::Users *tempuser;
	db::Access *a;
	long dbnum;
	long l;
	char sql[200];

	header0("Database access",2);
	printf("<table><tr><td valign=top>");
//	left_frame(db,sdb,stbl,sfld,user,cs);
	printf("</td><td valign=top>\n");

	printf("<h3>Your databases</h3>\n");
	printf("<table>");
	sprintf(sql,"select num from dbs where owner=%ld and deleted=0 order by name",user -> num);
	q.get_result(sql);
	while (q.fetch_row())
	{
		dbnum = q.getval();
		tempdb = new db::Dbs(db,dbnum);
		printf("<tr>");
		printf("<td valign=top><b>%s</b></td>\n",tempdb -> name);

// dba=0 view page
// dba=1 add usernum,dbnum to access
// dba=2 change access for usernum,dbnum
// dba=3 remove usernum,dbnum from access

		// add users here
		printf("<td valign=top align=right>");
		printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
		printf("<input type=hidden name=dba value=1>\n");
		printf("<input type=hidden name=dbnum value=%ld>\n",dbnum);
		printf("<select name=usernum><option value=0>&lt;select user&gt;\n");
		sprintf(sql,"select num,name from users where num<>%ld order by name",user -> num);
		q2.get_result(sql);
		while (q2.fetch_row())
		{
			l = q2.getval();
			sprintf(sql,"select num from access where usernum=%ld and dbnum=%ld",l,dbnum);
			if (!qd -> get_count(sql))
				printf("<option value=%ld>%s\n",l,q2.getstr(1));
		}
		q2.free_result();
		printf("</select>");
		printf("</td>\n");
		printf("<td valign=top>");
		printf("<input type=submit name=submit value=\" Add access for user \">\n");
		printf("</form>\n");
		printf("</td>\n");

		sprintf(sql,"select num from access where dbnum=%ld and usernum<>%ld",dbnum,user -> num);
		q2.get_result(sql);
		while (q2.fetch_row())
		{
			a = new db::Access(db,q2.getval());
			tempuser = new db::Users(db,a -> usernum);
			printf("<tr>");
			printf("<td valign=top>");
			showuser(tempuser);
			printf("</td>\n");
			printf("<td valign=top>");
			printf("<form action=/cgi-bin/dbd/dbd method=post>");
			printf("<input type=hidden name=dba value=2>\n");
			printf("<input type=hidden name=usernum value=%ld>\n",tempuser -> num);
			printf("<input type=hidden name=dbnum value=%ld>\n",dbnum);
			printf("<input type=checkbox name=r%s value=1>Copy\n",a -> r ? " CHECKED" : "");
			printf("<input type=checkbox name=w%s value=1>Edit\n",a -> w ? " CHECKED" : "");
			printf("<input type=checkbox name=c%s value=1>Create\n",a -> c ? " CHECKED" : "");
			printf("<input type=checkbox name=d%s value=1>Delete\n",a -> d ? " CHECKED" : "");
			printf("<input type=checkbox name=rdata%s value=1>Edit data\n",a -> rdata ? " CHECKED" : "");
			printf("<input type=checkbox name=wdata%s value=1>Change data\n",a -> wdata ? " CHECKED" : "");
			printf("</td><td valign=top align=middle>");
			printf("<input type=submit name=submit value=\" Change access \">\n");
			printf("</form>\n");
			printf("</td>\n");

			// remove user here
			printf("<td valign=top>");
			printf("[<a href=\"/cgi-bin/dbd/dbd?usernum=%ld&dbnum=%ld&dba=3\">remove</a>]",tempuser -> num,dbnum);
			printf("</td>\n");

			printf("</tr>\n");
			delete tempuser;
			delete a;
		}
		q2.free_result();
		delete tempdb;
		printf("<tr><td>&nbsp;</td></tr>\n");
	}
	q.free_result();
	printf("</table>\n");


	printf("<h3>Other databases</h3>\n");
	printf("<ul>");
	sprintf(sql,"select num from access where usernum=%ld",user -> num);
	q.get_result(sql);
	if (q.num_rows())
	{
		printf("<table><tr>\n");
		printf("<th bgcolor=#e0e0e0 align=left> Database </th>");
		printf("<th bgcolor=#e0e0e0 align=left> Owner </th>");
		printf("<th bgcolor=#e0e0e0 align=left> Your access </th>");
		printf("</tr>\n");
	while (q.fetch_row())
	{
		a = new db::Access(db,q.getval());
		dbnum = a -> dbnum;
		tempdb = new db::Dbs(db,dbnum);
		if (!tempdb -> deleted && tempdb -> owner != user -> num)
		{
			printf("<tr>");
			printf("<td>%s</td>\n",tempdb -> name);
			printf("<td>");
			showuser(db,tempdb -> owner);
			printf("</td>\n");
			printf("<td>");
			if (a -> r)
				printf(" Copy ");
			if (a -> w)
				printf(" Edit ");
			if (a -> c)
				printf(" Create ");
			if (a -> d)
				printf(" Delete ");
			if (a -> rdata)
				printf(" ReadData ");
			if (a -> wdata)
				printf(" ChangeData ");
			printf("</td>\n");
			printf("</tr>\n");
		}
		delete tempdb;
		delete a;
	}
		printf("</table>\n");
	}
	q.free_result();
	printf("</ul>\n");


	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=hidden name=dba value=1>\n");

	printf("<input type=submit name=submit value=\" Cancel \">\n");
	printf("</form>\n");

	printf("</td></tr></table>\n");
	footer();

	delete qd;
}

void read_comments(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Applications *sapp,db::Flds *sfld,db::Indexs *sindex,db::Users *user,Cookies *cs)
{
	Query q(db);
	db::Kommentar *k;
	char sql[500];

	header0("Read comments",1);

	printf("<table><tr><td valign=top>");
//	left_frame(db,sdb,stbl,sfld,user,cs);
	printf("</td><td valign=top>\n");

	if (sapp)
		printf("<h3>Application '%s' in %s</h3>\n",sapp -> name,sdb -> name);
	else
	if (sindex)
		printf("<h3>Index '%s' in %s.%s</h3>\n",sindex -> name,sdb -> name,stbl -> name);
	else
	if (sfld)
		printf("<h3>Field '%s' in %s.%s</h3>\n",sfld -> name,sdb -> name,stbl -> name);
	else
	if (stbl)
		printf("<h3>Table '%s' in %s</h3>\n",stbl -> name,sdb -> name);
	else
	if (sdb)
		printf("<h3>Database '%s'</h3>\n",sdb -> name);

	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=submit name=submit value=\" Go back \">\n");
	printf("</form>\n");

	printf("<table>");
	sprintf(sql,"select num from kommentar where");
	if (sapp)
		sprintf(sql + strlen(sql)," appnum=%ld",sapp -> num);
	else
	if (sindex)
		sprintf(sql + strlen(sql)," indexnum=%ld",sindex -> num);
	else
	if (sfld)
		sprintf(sql + strlen(sql)," fldnum=%ld",sfld -> num);
	else
	if (stbl)
		sprintf(sql + strlen(sql)," tblnum=%ld",stbl -> num);
	else
	if (sdb)
		sprintf(sql + strlen(sql)," dbnum=%ld",sdb -> num);
	sprintf(sql + strlen(sql)," order by dateposted desc");
	q.get_result(sql);
	while (q.fetch_row())
	{
/*
CREATE TABLE kommentar (
  num int(11) DEFAULT '0' NOT NULL auto_increment,
  dbnum int(11) DEFAULT '0' NOT NULL,
  tblnum int(11) DEFAULT '0' NOT NULL,
  fldnum int(11) DEFAULT '0' NOT NULL,
  usernum int(11) DEFAULT '0' NOT NULL,
  dateposted datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  reason varchar(80) DEFAULT '' NOT NULL,
  kommentar text NOT NULL,
  PRIMARY KEY (num)
);
*/
		k = new db::Kommentar(db,q.getval());
		printf("<tr><td><b>%s\n",k -> dateposted);
		if (strcmp(k -> dateposted,user -> prevdatum) > 0)
			printf("<img src=\"/image/new.gif\" alt=\"New!\">\n");
		printf(":: %s by\n",k -> reason);
		showuser(db,k -> usernum);
		printf("</b></td></tr>\n");
		printf("<tr><td>%s</td></tr>\n",k -> kommentar);
		delete k;
	}
	q.free_result();
	printf("</table>\n");

	printf("</td></tr></table>\n");
	footer();
}

void write_comment(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Applications *sapp,db::Flds *sfld,db::Indexs *sindex,db::Users *user,Cookies *cs,char *typ)
{
	header0("Write comment",1);

	printf("<table><tr><td valign=top>");
//	left_frame(db,sdb,stbl,sfld,user,cs);
	printf("</td><td valign=top>\n");

	if (sapp)
		printf("<h3>Application '%s' in %s</h3>\n",sapp -> name,sdb -> name);
	else
	if (sindex)
		printf("<h3>Index '%s' in %s.%s</h3>\n",sindex -> name,sdb -> name,stbl -> name);
	else
	if (sfld)
		printf("<h3>Field '%s' in %s.%s</h3>\n",sfld -> name,sdb -> name,stbl -> name);
	else
	if (stbl)
		printf("<h3>Table '%s' in %s</h3>\n",stbl -> name,sdb -> name);
	else
	if (sdb)
		printf("<h3>Database '%s'</h3>\n",sdb -> name);

/*
CREATE TABLE kommentar (
  num int(11) DEFAULT '0' NOT NULL auto_increment,
  dbnum int(11) DEFAULT '0' NOT NULL,
  tblnum int(11) DEFAULT '0' NOT NULL,
  fldnum int(11) DEFAULT '0' NOT NULL,
  usernum int(11) DEFAULT '0' NOT NULL,
  dateposted datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  reason varchar(80) DEFAULT '' NOT NULL,
  kommentar text NOT NULL,
  PRIMARY KEY (num)
);
*/
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=hidden name=write%s value=1>\n",typ);

	printf("%s :: A comment by\n",datetime());
	showuser(user);
	printf("<br>\n");
	printf("<textarea name=kommentar rows=8 cols=60 wrap=soft>\n");
	printf("</textarea>\n");

	printf("<table><tr><td valign=top>");
	printf("<input type=submit name=submit value=\" Post \">\n");
	printf("</form>\n");

	printf("</td><td valign=top>");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=submit name=submit value=\" Go back \">\n");
	printf("</form>\n");
	printf("</td></tr></table>\n");

	printf("</td></tr></table>\n");
	footer();
}

void warningsync(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Flds *sfld,db::Users *user,Cookies *cs)
{
	header0("Live database sync",1);

	printf("<table><tr><td valign=top>");
//	left_frame(db,sdb,stbl,sfld,user,cs);
	printf("</td><td valign=top>\n");

	printf("<h3>Warning! Live sync will remove all live data from the database</h3>\n");
	printf("<p>Only use if database is broken or unreadable - and remember to do your backups</p>\n");

	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=hidden name=ls value=1>\n");
	printf("<input type=submit name=submit value=\" Live sync \">\n");
	printf("<input type=submit name=submit value=\" Go back \">\n");
	printf("</form>\n");

	printf("</td></tr></table>\n");
	footer();
}


/*
 * Add group
 */

void page_26(Database *db,db::Users *user,db::Dbs *sdb)
{
	header0("Add group",1);

	printf("<form action=/cgi-bin/dbd/dbd method=post target=_top>\n");
	printf("<input type=hidden name=ag value=1>\n");
	if (sdb)
	{
		printf("Type of group<br>\n");
		printf("<input type=radio name=typ value=1 CHECKED>Database group<br>\n");
		printf("<input type=radio name=typ value=2>Table group in database '%s'<br>\n",sdb -> name);
	} else
		printf("<input type=hidden name=typ value=1>\n");
	printf("<br>\n");
	printf("New group name<br><input type=text name=newname><br>\n");
	printf("<table><tr><td valign=top>");
	printf("<input type=submit name=submit value=\" Add new group \">\n");
	printf("</form>\n");
	printf("</td><td valign=top>\n");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=submit name=submit value=\" Cancel \">\n");
	printf("</form>\n");
	printf("</td></tr></table>\n");

	footer();
}


/*
 * Remove group
 */

void page_27(Database *db,db::Users *user)
{
	header0("Remove group",1);
	footer();
}

