// livedb.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include <libsql++.h>
#include <libdbd.h>
#include <string>
using std::string;
#include <libcgi++.h>

#include "dbd.h"
#include "html.h"
#include "utils.h"


#define QTOFLDS 2

void visa_livedata(Database *db,Database *livedb,Query *lq,db::Flds **flds,long qty,short td,char *th,
 long ignorefield,db::Tbls *stbl,short bold,db::Access *a)
{
	Query q(db);
	Query lq2(livedb);
	db::Tbls *totbl;
	db::Flds *toflds[QTOFLDS];
	double d;
	long l;
	long qflds;
	int i,j;
	char sql[999];
	char slask[200];

	printf("<tr>");
	if (*th)
		printf("<th align=right bgcolor=#e0e0e0><font size=-1>%s</font></th>",th);
	for (i = 0; i < qty; i++)	// visa data pa en rad
	if (i != ignorefield)
	{
		if (!td)
		{
			if (!i)
				printf("<td colspan=%ld>",qty - 1);
			else
				printf(", ");
		}
		switch (flds[i] -> fieldtype)
		{
		case 2: // int(x)
			if (td)
			{
				if (i)
					printf("<td align=right valign=top><font size=-1>%ld</font></td>\n",lq -> getval(i));
				else
				{
					printf("<td valign=top>");
					printf("<table width=100%% cellpadding=0 cellspacing=0><tr>");
					printf("<td align=middle><font size=-1>%ld</font></td>\n",lq -> getval(i));
					printf("<td align=right>");

					printf("<font size=-1>");
					strcpy(slask,"[\n");
					if (a -> wdata)
					{
						printf("%s<a href=/cgi-bin/dbd/dbd?ednr=%ld#edit>edit</a>\n",slask,lq -> getval(i));
						strcpy(slask,"|\n");
					}
				// kolla om det finns tabeller som lankar till denna post
					sprintf(sql,"select num from flds where ptrtotblnum=%ld order by tblnum",stbl -> num);
					if (q.get_count(sql))
					{
					// 'links' - visa data
					// 'insert' - insert data
						printf("%s<a href=/cgi-bin/dbd/dbd?linknr=%ld>links</a>\n",slask,lq -> getval(i));
						printf("|\n<a href=/cgi-bin/dbd/dbd?ilinknr=%ld>insert</a>\n",lq -> getval(i));
						strcpy(slask,"|\n");
					} 
					if (*slask == '|')
						printf("]");
					printf("</font></td>\n");

					printf("</tr></table>\n");
					printf("</td>");
				}
				
			} else
			{
				printf("<font size=-1>%ld</font>",lq -> getval(i));
			}
			break;
		case 1: // char(x)
		case 3: // datetime
		case 4: // enum
		case 7: // set
			if (td)
				printf("<td valign=top>");
			if (!strcasecmp(flds[i] -> fieldstr,"char") ||
			    !strcasecmp(flds[i] -> fieldstr,"varchar"))
			{
				strncpy(slask,lq -> getstr(i),40);
				if (strlen(slask) > 24)
				{
					slask[20] = ' ';
					slask[21] = '.';
					slask[22] = '.';
					slask[23] = '.';
					slask[24] = 0;
				}
				printf("<font size=-1>%s</font>",slask);
			} else
				printf("<font size=-1>--- text field ---</font>");
			if (td)
				printf("</td>");
			break;
		case 5: // ptrtotblnum
			if (flds[i] -> ptrtotblnum)
			{
				l = lq -> getval(i); // num in field(0) in table
				totbl = new db::Tbls(db,flds[i] -> ptrtotblnum);
				sprintf(sql,"select num from flds where tblnum=%ld and deleted=0 order by ordning",totbl -> num);
				q.get_result(sql);
				qflds = q.num_rows();
				j = 0;
				while (q.fetch_row())
				{
					if (j < QTOFLDS)
						toflds[j] = new db::Flds(db,q.getval());
					j++;
				}
				q.free_result();

				if (td)
					printf("<td valign=top>");
				printf("<font size=-1>");
				if (l)
				{
					strcpy(slask,"select ");
					*sql = 0;
					for (j = 0; j < (qflds < QTOFLDS ? qflds : QTOFLDS); j++)
					{
						sprintf(sql + strlen(sql),"%s%s",slask,toflds[j] -> name);
						strcpy(slask,",");
					}
					sprintf(sql + strlen(sql)," from %s where %s=%ld",totbl -> name,toflds[0] -> name,l);
					lq2.get_result(sql);
					if (lq2.fetch_row())
					{
						*slask = 0;
						for (j = 0; j < (qflds < QTOFLDS ? qflds : QTOFLDS); j++)
						{
							printf("%s%s",slask,lq2.getstr());
							strcpy(slask," / ");
						}
					}
					lq2.free_result();
				}
				printf("</font>");
				if (td)
					printf("</td>");

				// delete to table stuff
				for (j = 0; j < qflds; j++)
					if (j < QTOFLDS)
						delete toflds[j];
				delete totbl;
			} else
				printf("<td></td>");
			break;
		case 6: // number
			d = atof(lq -> getstr(i));
			sprintf(slask,"<font size=-1>%%.%ldf</font>",flds[i] -> decimallength);
			if (td)
				printf("<td valign=top align=right>");
			printf(slask,d);
			if (td)
				printf("</td>");
			break;
		}
	}
	if (!td)
		printf("</td>\n");
	printf("</tr>\n"); // end of data row
}

void livedata(Database *db,db::Dbs *sdb,db::Tbls *stbl,Form *form,Cookies *cs,db::Users *user,db::Access *a)
{
	Database livedb("localhost","root","",sdb -> name);
	Query q(db),q2(db);
	Query lq(&livedb),lq2(&livedb);
	Query *lqd = new Query(&livedb);
	db::Flds **flds,*toflds[QTOFLDS];
	Parse *pa;
	db::Tbls *totbl;
	db::Tbls *fromtbl;
	db::Flds *tempfld;
	db::Flds **fromflds;
	char *sql = new char[32000];
	char *temp;
	double d;
	long qty;
	long ednr = 0;
	long l;
	long qflds;	// in totbl
	long num;
	long linknr = 0;
	long stepnum;
	long maxnum;
	int i,j;
	short errcode = 0; //livedb.errcode();
	char slask[200];
	char str[80];
	char dbs[999];

// get current start row
	if (cs -> getvalue("stepnum",slask,20))
		stepnum = atol(slask);
	else
		stepnum = 1;

// get fields
	sprintf(sql,"select num from flds where tblnum=%ld and deleted=0 order by ordning",stbl -> num);
	q.get_result(sql);
	qty = q.num_rows();
	flds = new db::Flds *[qty];
	i = 0;
	while (q.fetch_row())
		flds[i++] = new db::Flds(db,q.getval());
	q.free_result();


// edit live data
	*sql = 0;
	if (form -> getvalue("ed",slask,20) && *slask && atoi(slask))
	{
		form -> getvalue("submit",slask,200);
		if (a -> wdata && !strcmp(slask," Delete "))
		{
			if (form -> getvalue("ednr",slask,20))
				ednr = atol(slask);
			if (ednr)
			{
				sprintf(sql,"delete from %s where %s=%ld",
				 stbl -> name,flds[0] -> name,ednr);
				lq.execute(sql);
			}
		} else
		if (a -> wdata && !strcmp(slask," Update "))
		{
			if (form -> getvalue("ednr",slask,20))
				ednr = atol(slask);
			if (ednr)
			{
				sprintf(str,"update %s set ",stbl -> name);
				*sql = 0;
				for (i = 1; i < qty; i++)
				{
					switch (flds[i] -> fieldtype)
					{
						case 1: // char
							if (strstr(flds[i] -> fieldstr,"TEXT"))
							{
								l = form -> getlength(flds[i] -> name);
								temp = new char[l + 1440];
								form -> getvalue(flds[i] -> name,temp,l + 144);
								textareain(temp);
//								dbsafestr2(temp);
								sprintf(sql + strlen(sql),"%s%s='%s'",
								 str,flds[i] -> name,q.safestr(temp).c_str());
								delete temp;
								break;
							}
						case 3: // datetime
						case 4:
							form -> getvalue(flds[i] -> name,slask,200);
							strcpy(dbs,slask);
//							dbsafestr2(dbs);
							sprintf(sql + strlen(sql),"%s%s='%s'",
							 str,flds[i] -> name,q.safestr(dbs).c_str());
							break;
						case 2: // int
						case 5:
							form -> getvalue(flds[i] -> name,slask,200);
							sprintf(sql + strlen(sql),"%s%s=%ld",
							 str,flds[i] -> name,atol(slask));
							break;
						case 6: // number
							form -> getvalue(flds[i] -> name,slask,200);
							d = atof(slask);
							sprintf(slask,"%%s%%s=%%.%ldf",flds[i] -> decimallength);
							sprintf(sql + strlen(sql),slask,
							 str,flds[i] -> name,d);
							break;
						case 7: // set
							form -> getvalue(flds[i] -> name,slask,200);
							break;
					}
					strcpy(str,",");
				}
				sprintf(sql + strlen(sql)," where %s=%ld",flds[0] -> name,ednr);
				if (qty > 1)
					lq.execute(sql);
			}
		} else
		if (a -> wdata && !strcmp(slask," Insert "))
		{
			if (form -> getvalue("ednr",slask,20))
				ednr = atol(slask);
			if (!ednr)
			{
				sprintf(str,"insert into %s (",stbl -> name);
				*sql = 0;
				for (i = 0; i < qty; i++)
				{
					strcat(sql,str);
					strcat(sql,flds[i] -> name);
					strcpy(str,",");
				}
				strcpy(str,") values (");

				for (i = 0; i < qty; i++)
				{
					if ((flds[i] -> fieldflags & FF_AUTO_INCREMENT) != 0)
					{
						sprintf(slask,"select max(%s) from %s",
						 flds[0] -> name,stbl -> name);
						l = lq.get_count(slask);
						sprintf(slask,"%ld",l + 1);
						ednr = l + 1;
					} else
						form -> getvalue(flds[i] -> name,slask,200);
					switch (flds[i] -> fieldtype)
					{
						case 1: // char
							if (strstr(flds[i] -> fieldstr,"TEXT"))
							{
								l = form -> getlength(flds[i] -> name);
								temp = new char[l + 1440];
								form -> getvalue(flds[i] -> name,temp,l + 144);
								textareain(temp);
//								dbsafestr2(temp);
								sprintf(sql + strlen(sql),"%s'%s'",
								 str,q.safestr(temp).c_str());
								delete temp;
								break;
							}
						case 3: // datetime
						case 4:
							strcpy(dbs,slask);
//							dbsafestr2(dbs);
							sprintf(sql + strlen(sql),"%s'%s'",
							 str,q.safestr(dbs).c_str());
							break;
						case 2: // int
						case 5:
							sprintf(sql + strlen(sql),"%s%ld",
							 str,atol(slask));
							break;
						case 6: // number
							d = atof(slask);
							sprintf(slask,"%%s%%s=%%.%ldf",flds[i] -> decimallength);
							sprintf(sql + strlen(sql),slask,
							 str,flds[i] -> name,d);
							break;
					}
					strcpy(str,",");
				}
				strcat(sql,")");

				lq.execute(sql);

			} // if (!ednr)
			ednr = 0;
		}
		ednr = 0;
	}


/*
 * page start
 */

	if (errcode)
		sprintf(errstr,"database error code %d<br>\n",errcode);

	header0("Edit data",5);

	printf("<table><tr><td valign=top>");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=hidden name=ed value=1>\n");
	printf("<b>%s</b> :: Table\n",sdb -> name);
	printf("<select name=seltbl><option value=%ld>%s\n",stbl -> num,stbl -> name);
	sprintf(sql,"select num,name from tbls where dbnum=%ld and deleted=0 and num<>%ld",sdb -> num,stbl -> num);
	q.get_result(sql);
	while (q.fetch_row())
		printf("<option value=%ld>%s\n",q.getval(0),q.getstr(1));
	q.free_result();
	printf("</select>\n");
	printf("<input type=submit name=submit value=\" Select table \">\n");
	printf("</td><td valign=top>");
	printf("<input type=submit name=submit value=\" Go back \">\n");
	printf("</form>\n");
	printf("</td></tr></table>\n");

// navigate buttons up / down in data list

	sprintf(sql,"select max(%s) from %s",flds[0] -> name,stbl -> name);
	maxnum = lqd -> get_count(sql);

	strcpy(slask,"[\n");
	if (stepnum > user -> steps)
	{
		printf("%s<a href=/cgi-bin/dbd/dbd?stepnum=%ld>%ld..%ld</a>\n",slask,stepnum - user -> steps,stepnum - user -> steps,stepnum - 1);
		strcpy(slask,"|\n");
	}
	if (stepnum + user -> steps <= maxnum)
	{
		printf("%s<a href=/cgi-bin/dbd/dbd?stepnum=%ld>%ld..%ld</a>\n",slask,stepnum + user -> steps,stepnum + user -> steps,stepnum + user -> steps * 2 - 1);
		strcpy(slask,"|\n");
	}
	if (*slask == '|')
		printf("]<br>\n");

	printf("<table>");

// build query

	strcpy(slask,"select ");
	*sql = 0;
	for (i = 0; i < qty; i++)
	{
		sprintf(sql + strlen(sql),"%s%s",slask,flds[i] -> name);
		strcpy(slask,",");
	}
	sprintf(sql + strlen(sql)," from %s where %s>=%ld order by %s limit %ld",
	 stbl -> name,flds[0] -> name,stepnum,flds[0] -> name,user -> steps);

// print header line

	printf("<tr>");
	for (i = 0; i < qty; i++)
		printf("<th align=left bgcolor=#e0e0e0><font size=-1>%s</font></th>",flds[i] -> name);
	printf("</tr>\n");


	if (form -> getvalue("ednr",slask,20) && *slask)
		ednr = atol(slask);
	if (form -> getvalue("submit",slask,200) && (!strcmp(slask," Update ") || !strcmp(slask," Delete ") || !strcmp(slask," Cancel ")))
		ednr = 0;
	if (form -> getvalue("linknr",slask,20) && *slask)
		linknr = atol(slask);

	lq.get_result(sql);
	while (lq.fetch_row())
	{
		num = lq.getval(0);

	/*
	 * visa data
	 */
	 	visa_livedata(db,&livedb,&lq,flds,qty,1,"",-1,stbl,(ednr == num ? 1 : 0),a);


	// visa data fran tabeller som pekar pa denna tabell

		if (num == linknr || ((user -> flags & UF_SHOWLINKED) != 0))
		{
			sprintf(sql,"select num from flds where ptrtotblnum=%ld order by tblnum",stbl -> num);
			q.get_result(sql);
			while (q.fetch_row())
			{
				l = q.getval();
				tempfld = new db::Flds(db,l); // fld i tabell som pekar pa aktuell tabell
				fromtbl = new db::Tbls(db,tempfld -> tblnum); // tabell som pekar pa aktuell tabell
				sprintf(sql,"select num from flds where tblnum=%ld and deleted=0 order by ordning",fromtbl -> num);
				q2.get_result(sql);
				qflds = q2.num_rows();
				fromflds = new db::Flds *[qflds];
				j = 0;
				while (q2.fetch_row())
					fromflds[j++] = new db::Flds(db,q2.getval());
				q2.free_result();

				strcpy(slask,"select ");
				*sql = 0;
				l = -1;
				for (j = 0; j < qflds; j++)
				{
					sprintf(sql + strlen(sql),"%s%s",slask,fromflds[j] -> name);
					strcpy(slask,",");
					if (fromflds[j] -> num == tempfld -> num)
						l = j;
				}
				sprintf(sql + strlen(sql)," from %s where %s=%ld",fromtbl -> name,tempfld -> name,num);
				lq2.get_result(sql);
				while (lq2.fetch_row())
				 	visa_livedata(db,&livedb,&lq2,fromflds,qflds,0,fromtbl -> name,l,stbl,0,a);
				lq2.free_result();

				for (j = 0; j < qflds; j++)
					delete fromflds[j];
				delete fromflds;
				delete fromtbl;
				delete tempfld;
			}
			q.free_result();
		} // if (user -> flags & UF_SHOWLINKED)


		if (ednr == num) // visa edit
		{
			printf("<tr><td colspan=%ld>",qty);
			printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
			printf("<a name=edit>\n");
			printf("<input type=hidden name=ed value=1>\n");
			printf("<input type=hidden name=ednr value=%ld>\n",ednr);
			printf("</a>\n");
			printf("<center><table width=95%%>");

			for (i = 0; i < qty; i++)
			{
				printf("<tr>");
				switch (flds[i] -> fieldtype)
				{
				case 1: // char(x)
					printf("<th align=right valign=top>%s</th>",flds[i] -> name);
					if (strstr(flds[i] -> fieldstr,"BLOB"))
					{
						printf("<td valign=top> ---- </td>\n");
					} else
					if (strstr(flds[i] -> fieldstr,"TEXT"))
					{
						printf("<td valign=top><textarea name=%s rows=12 cols=80 wrap=off>\n",flds[i] -> name);
						l = strlen(lq.getstr(i)) + 10000;
						if (l > 32767)
							l = 32767;
						temp = new char[l]; // strlen(lq.getstr(i)) + 10000];
						strcpy(temp,lq.getstr(i));
						remove_br(temp);
						printf("%s",temp);
						delete temp;
						printf("</textarea></td>\n");
					} else
						printf("<td valign=top><input type=text name=%s value=\"%s\" size=%ld></td>\n",
						 flds[i] -> name,lq.getstr(i),(flds[i] -> charlength < 80 ? flds[i] -> charlength + 1 : 80));
					break;
				case 2: // int(x)
					printf("<th align=right>%s</th>",flds[i] -> name);
					if ((flds[i] -> fieldflags & FF_AUTO_INCREMENT) != 0)
						printf("<td> <b>%ld</b> </td>\n",lq.getval(i));
					else
						printf("<td><input type=text name=%s value=%ld size=%ld></td>\n",
						 flds[i] -> name,lq.getval(i),flds[i] -> integerlength + 1);
					break;
				case 3: // datetime
					printf("<th align=right>%s</th>",flds[i] -> name);
					printf("<td><input type=text name=%s value=\"%s\" size=%d></td>\n",
					 flds[i] -> name,lq.getstr(i),40);
					break;
				case 4: // enum
					printf("<th align=right>%s</th>",flds[i] -> name);
					printf("<td><select name=%s>",flds[i] -> name);
					printf("<option value=\"%s\">%s\n",lq.getstr(i),lq.getstr(i));
					pa = new Parse(flds[i] -> options,"/,");
					pa -> getword(slask);
					while (*slask)
					{
						if (name_ok(slask) && strcmp(slask,lq.getstr(i)))
						{
							printf("<option value=\"%s\">%s\n",slask,slask);
						}
						pa -> getword(slask);
					}
					delete pa;
					printf("</select></td>\n");
					break;
				case 5: // ptrtotblnum
					printf("<th align=right>%s</th>",flds[i] -> name);
					if (flds[i] -> ptrtotblnum)
					{
						l = lq.getval(i); // num in field(0) in table
						totbl = new db::Tbls(db,flds[i] -> ptrtotblnum);
						sprintf(sql,"select num from flds where tblnum=%ld and deleted=0 order by ordning",totbl -> num);
						q.get_result(sql);
						qflds = q.num_rows();
						j = 0;
						while (q.fetch_row())
						{
							if (j < QTOFLDS)
								toflds[j] = new db::Flds(db,q.getval());
							j++;
						}
						q.free_result();

						printf("<td><select name=%s>",flds[i] -> name);
						if (l)
						{
							strcpy(slask,"select ");
							*sql = 0;
							for (j = 0; j < (qflds < QTOFLDS ? qflds : QTOFLDS); j++)
							{
								sprintf(sql + strlen(sql),"%s%s",slask,toflds[j] -> name);
								strcpy(slask,",");
							}
							sprintf(sql + strlen(sql)," from %s where %s=%ld",totbl -> name,toflds[0] -> name,l);
							lq2.get_result(sql);
							if (lq2.fetch_row())
							{
								if (qty == 1)
									printf("<option>%s\n",lq2.getstr());
								else
									printf("<option value=%s>%s / %s\n",
									 lq2.getstr(0),lq2.getstr(0),lq2.getstr(1));
							}
							lq2.free_result();
						} else
							printf("<option value=0>\n");

						if (qty == 1)
							sprintf(sql,"select %s from %s where %s<>%ld order by %s",
							 toflds[0] -> name,totbl -> name,toflds[0] -> name,l,toflds[0] -> name);
						else
							sprintf(sql,"select %s,%s from %s where %s<>%ld order by %s",
							 toflds[0] -> name,toflds[1] -> name,totbl -> name,toflds[0] -> name,l,toflds[0] -> name);
						lq2.get_result(sql);
						while (lq2.fetch_row())
						{
							if (qty == 1)
								printf("<option>%s\n",lq2.getstr());
							else
								printf("<option value=%s>%s / %s\n",
								 lq2.getstr(0),lq2.getstr(0),lq2.getstr(1));
						}
						lq2.free_result();
						if (l)
							printf("<option value=0>\n");

						printf("</select></td>\n");

						// delete to table stuff
						for (j = 0; j < qflds; j++)
							if (j < QTOFLDS)
								delete toflds[j];
						delete totbl;
					} else
						printf("<td></td>\n");
					break;
				case 6: // number
					printf("<th align=right>%s</th>",flds[i] -> name);
					printf("<td><input type=text name=%s value=%s size=%ld></td>\n",
					 flds[i] -> name,lq.getstr(i),flds[i] -> integerlength + flds[i] -> decimallength + 1);
					break;
				case 7: // set
					printf("<th align=right>%s</th>",flds[i] -> name);
					break;
				}
				printf("</tr>\n");
			}

			printf("</table></center>\n");
			printf("<table><tr><td>");
			if (a -> wdata)
			{
				printf("<input type=submit name=submit value=\" Update \">\n");
				printf("</td><td>");
				printf("<input type=submit name=submit value=\" Delete \">\n");
				printf("</td><td>");
			}
			printf("<input type=submit name=submit value=\" Cancel \">\n");
			printf("</td></tr></table>\n");
			printf("</form>\n");
			printf("</td></tr>\n");
		}
	}
	lq.free_result();

	printf("<tr><td colspan=%ld><hr></td></tr>\n",qty);

	if (!ednr && a -> wdata)
	{
		printf("<tr><td colspan=%ld>",qty);
		printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
		printf("<input type=hidden name=ed value=1>\n");
		printf("<input type=hidden name=ednr value=0>\n");
		printf("<table>");
		for (i = 0; i < qty; i++)
		{
			printf("<tr>");
			switch (flds[i] -> fieldtype)
			{
				case 1: // char(x)
					printf("<th align=right valign=top>%s</th>",flds[i] -> name);
					if (strstr(flds[i] -> fieldstr,"BLOB"))
					{
						printf("<td valign=top> ---- </td>\n");
					} else
					if (strstr(flds[i] -> fieldstr,"TEXT"))
					{
						printf("<td valign=top><textarea name=%s rows=12 cols=80 wrap=off>\n",flds[i] -> name);
						printf("</textarea></td>\n");
					} else
						printf("<td valign=top><input type=text name=%s size=%ld></td>\n",
						 flds[i] -> name,(flds[i] -> charlength < 80 ? flds[i] -> charlength + 1 : 80));
					break;
				case 2: // int(x)
					printf("<th align=right>%s</th>",flds[i] -> name);
					if ((flds[i] -> fieldflags & FF_AUTO_INCREMENT) != 0)
						printf("<td> ---- </td>\n");
					else
						printf("<td><input type=text name=%s size=%ld></td>\n",
						 flds[i] -> name,flds[i] -> integerlength + 1);
					break;
				case 3: // datetime
					printf("<th align=right>%s</th>",flds[i] -> name);
					printf("<td><input type=text name=%s size=%d></td>\n",
					 flds[i] -> name,40);
					break;
				case 4: // enum
					printf("<th align=right>%s</th>",flds[i] -> name);
					printf("<td><select name=%s>",flds[i] -> name);
					pa = new Parse(flds[i] -> options,"/,");
					pa -> getword(slask);
					while (*slask)
					{
						if (name_ok(slask))
						{
							printf("<option value=\"%s\">%s\n",slask,slask);
						}
						pa -> getword(slask);
					}
					delete pa;
					printf("</select></td>\n");
					break;
				case 5: // ptrtotblnum
					printf("<th align=right>%s</th>",flds[i] -> name);
					if (flds[i] -> ptrtotblnum)
					{
						totbl = new db::Tbls(db,flds[i] -> ptrtotblnum);
						sprintf(sql,"select num from flds where tblnum=%ld and deleted=0 order by ordning",totbl -> num);
						q.get_result(sql);
						qflds = q.num_rows();
						j = 0;
						while (q.fetch_row())
						{
							if (j < QTOFLDS)
								toflds[j] = new db::Flds(db,q.getval());
							j++;
						}
						q.free_result();

						printf("<td><select name=%s><option value=0>\n",flds[i] -> name);

						if (qty == 1)
							sprintf(sql,"select %s from %s order by %s",
							 toflds[0] -> name,totbl -> name,toflds[0] -> name);
						else
							sprintf(sql,"select %s,%s from %s order by %s",
							 toflds[0] -> name,toflds[1] -> name,totbl -> name,toflds[0] -> name);
						lq2.get_result(sql);
						while (lq2.fetch_row())
						{
							if (qty == 1)
								printf("<option>%s\n",lq2.getstr());
							else
								printf("<option value=%s>%s / %s\n",
								 lq2.getstr(0),lq2.getstr(0),lq2.getstr(1));
						}
						lq2.free_result();

						printf("</select></td>\n");

						// delete to table stuff
						for (j = 0; j < qflds; j++)
							if (j < QTOFLDS)
								delete toflds[j];
						delete totbl;
					} else
						printf("<td></td>\n");
					break;
				case 6: // number
					printf("<th align=right>%s</th>",flds[i] -> name);
					printf("<td><input type=text name=%s size=%ld></td>\n",
					 flds[i] -> name,flds[i] -> integerlength + flds[i] -> decimallength + 1);
					break;
				case 7: // set
					printf("<th align=right>%s</th>",flds[i] -> name);
					break;
			}
			printf("</tr>\n");
		}
		printf("</table>\n");
		printf("<input type=submit name=submit value=\" Insert \">\n");
		printf("</form>\n");
		printf("</td></tr>\n");
	}


	printf("</table>\n");
	footer();

	for (i = 0; i < qty; i++)
		delete flds[i];
	delete sql;
	delete flds;
	delete lqd;
}
