// lf.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include <libsql++.h>
#include <libdbd.h>
#include <string>
using std::string;
#include <libcgi++.h>

#include "dbd.h"
#include "html.h"
#include "utils.h"

#include "pages.h"


	char *viewdb;
	char *viewgrp;
	char *viewtbl;
	char *viewtblgrp;

short inlist(char *s,long val)
{
	Parse *pa;
	char ord[100];

	pa = new Parse(s,",");
	pa -> getword(ord);
	while (*ord)
	{
		if (atol(ord) == val)
		{
			delete pa;
			return 1;
		}
		pa -> getword(ord);
	}
	delete pa;
	return 0;
}

void show_table(Database *db,char *sql,long qgrps,long qdbs,Query *qd,Cookies *cs,db::Users *user,
 short sd,long qtblgrps,short cont)
{
	Query q2(db),q3(db);
	db::Tbls *temptbl;
	db::Flds *tempfld;
	db::Indexs *tempindex;
	long qtbls,qty,qflds,qindexs;
	long tblnum;
	long l;
	long fldnum;
	long indexnum;
	int i;
	char s1[10],s2[20];
//	char slask[200];

			q2.get_result(sql);
			qtbls = q2.num_rows();
			while (q2.fetch_row())
			{
				tblnum = q2.getval();
				qtbls--;

				sprintf(sql,"select count(*) from flds where tblnum=%ld",tblnum);
				l = qd -> get_count(sql);

				temptbl = new db::Tbls(db,tblnum);
				if (strcmp(temptbl -> changedate,user -> prevdatum) > 0)
				{
					strcpy(s1,"<i>");
					strcpy(s2,"</i>");
				} else
					*s1 = *s2 = 0;

				printf("<!-- nobr -->");
				if (!qgrps)
					iempty();
				else
					ivertline();
				if (!qdbs)
					iempty();
				else
					ivertline();

				if (qtblgrps >= 0)
				{
					if (!qtblgrps)
						iempty();
					else
						ivertline();
				}

//				sprintf(slask,"viewtbl%ld",tblnum);
				if (!l || !inlist(viewtbl,tblnum)) // !cs -> getvalue(slask,slask,20) || !atoi(slask))
				{
					if (l)
					{
						printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&toggletbl=%ld&v=1\">",tblnum);
						if (!qtbls && !cont)
							iplusend();
						else
							iplus();
						iglobe();
						printf("</a>");
					} else
					{
						if (!qtbls && !cont)
							ibranchend();
						else
							ibranchcont();
						iglobe();
					}
					printf("&nbsp;<a target=rf href=\"/cgi-bin/dbd/dbd?seltbl=%ld\">%s%s%s</a>",tblnum,s1,temptbl -> name,s2);
//					if (strcmp(temptbl -> changedate,user -> prevdatum) > 0)
//						printf("&nbsp;<img src=\"/image/new.gif\" alt=\"New!\">");
					if (temptbl -> deleted)
						printf("&nbsp;&lt;deleted&gt;");
					printf("<!-- /nobr --><br>");
				} else
				{
					printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&toggletbl=%ld&v=0\">",tblnum);
					if (!qtbls && !cont)
						iminusend();
					else
						iminus();
					iglobe();
					printf("</a>");
					printf("&nbsp;<a target=rf href=\"/cgi-bin/dbd/dbd?seltbl=%ld\">%s%s%s</a>",tblnum,s1,temptbl -> name,s2);
//					if (strcmp(temptbl -> changedate,user -> prevdatum) > 0)
//						printf("&nbsp;<img src=\"/image/new.gif\" alt=\"New!\">");
					if (temptbl -> deleted)
						printf("&nbsp;&lt;deleted&gt;");
					printf("<!-- /nobr --><br>");

//					printf("<ul>");

					sprintf(sql,"select count(*) from indexs where tblnum=%ld",tblnum);
					qindexs = qd -> get_count(sql);

					sprintf(sql,"select num from flds where tblnum=%ld %s order by ordning",
					 tblnum,
					 sd ? "" : "and deleted=0");
					q3.get_result(sql);
					qty = qflds = q3.num_rows();
					i = 0;
					while (q3.fetch_row())
					{
						fldnum = q3.getval();
						qflds--;

						tempfld = new db::Flds(db,fldnum);
						if (strcmp(tempfld -> changedate,user -> prevdatum) > 0)
						{
							strcpy(s1,"<i>");
							strcpy(s2,"</i>");
						} else
							*s1 = *s2 = 0;

						printf("<!-- nobr -->");
						if (!qgrps)
							iempty();
						else
							ivertline();
						if (!qdbs)
							iempty();
						else
							ivertline();
						if (qtblgrps >= 0)
						{
							if (!qtblgrps)
								iempty();
							else
								ivertline();
						}
						if (!qtbls && !cont)
							iempty();
						else
							ivertline();

						if (!qflds && !qindexs)
							ibranchend();
						else
							ibranchcont();
//						if (sfld && fldnum == sfld -> num)
//							printf("&nbsp;<a target=rf href=\"/cgi-bin/dbd/dbd?selfld=%ld\">%s%s%s</a>",fldnum,s1,tempfld -> name,s2);
//						else
						printf("&nbsp;<a target=rf href=\"/cgi-bin/dbd/dbd?selfld=%ld\">%s%s%s</a>",fldnum,s1,tempfld -> name,s2);
//						if (strcmp(tempfld -> changedate,user -> prevdatum) > 0)
//							printf("&nbsp;<img src=\"/image/new.gif\" alt=\"New!\">");
						if (tempfld -> deleted) // deleted
							printf("&nbsp;&lt;deleted&gt;");
						printf("<!-- /nobr --><br>");
//						printf("\n");
						delete tempfld;
					}
					q3.free_result();
//					printf("</ul>");

				/*
				 * repeat above for indexs
				 */
fflush(stdout);
					sprintf(sql,"select num from indexs where tblnum=%ld %s",
					 tblnum,
					 sd ? "" : "and deleted=0");
					q3.get_result(sql);
					qty = qindexs = q3.num_rows();
//printf("%ld indexes<br>\n",qty);
fflush(stdout);
					i = 0;
					while (q3.fetch_row())
					{
						indexnum = q3.getval();
						qindexs--;

						tempindex = new db::Indexs(db,indexnum);
						if (strcmp(tempindex -> changedate,user -> prevdatum) > 0)
						{
							strcpy(s1,"<i>");
							strcpy(s2,"</i>");
						} else
							*s1 = *s2 = 0;

						printf("<!-- nobr -->");
						if (!qgrps)
							iempty();
						else
							ivertline();
						if (!qdbs)
							iempty();
						else
							ivertline();
						if (qtblgrps >= 0)
						{
							if (!qtblgrps)
								iempty();
							else
								ivertline();
						}
						if (!qtbls && !cont)
							iempty();
						else
							ivertline();

						if (!qindexs)
							ibranchend();
						else
							ibranchcont();
						printf("&nbsp;~<a target=rf href=\"/cgi-bin/dbd/dbd?selindex=%ld\">%s%s%s</a>",indexnum,s1,tempindex -> name,s2);
						if (tempindex -> deleted) // deleted
							printf("&nbsp;&lt;deleted&gt;");
						printf("<!-- /nobr --><br>");
//						printf("\n");
						delete tempindex;
					}
					q3.free_result();

				/*
				 * show indexs end
				 */
				}
				delete temptbl;
			}
			q2.free_result();
} // show_table()

void show_apps(Database *db,char *sql,long qgrps,long qdbs,Query *qd,Cookies *cs,db::Users *user,
 short sd,long qtblgrps,short cont)
{
	Query q2(db),q3(db);
	db::Applications *tempapp;
	long qapps;
	long appnum;
	char s1[10],s2[20];

	q2.get_result(sql);
	qapps = q2.num_rows();
	while (q2.fetch_row())
	{
		appnum = q2.getval();
		qapps--;

		tempapp = new db::Applications(db,appnum);
		if (strcmp(tempapp -> changedate,user -> prevdatum) > 0)
		{
			strcpy(s1,"<i>");
			strcpy(s2,"</i>");
		} else
			*s1 = *s2 = 0;

		printf("<!-- nobr -->");
		if (!qgrps)
			iempty();
		else
			ivertline();
		if (!qdbs)
			iempty();
		else
			ivertline();

		if (qtblgrps >= 0)
		{
			if (!qtblgrps)
				iempty();
			else
				ivertline();
		}


		if (!qapps && !cont)
			ibranchend();
		else
			ibranchcont();
		iglobe();
		printf("&nbsp;<a target=rf href=\"/cgi-bin/dbd/dbd?selapp=%ld\">%s%s%s</a>",appnum,s1,tempapp -> name,s2);
		if (tempapp -> deleted)
			printf("&nbsp;&lt;deleted&gt;");
		printf("<!-- /nobr --><br>");

		delete tempapp;
	}
	q2.free_result();
} // show_apps()

void left_frame(Database *db,db::Dbs *sdb,db::Tbls *stbl,db::Flds *sfld,db::Users *user,Cookies *cs)
{
	Query q(db),q2(db),q3(db),q4(db);
	Query *qd = new Query(db);
	db::Dbs *tempdb;
	char *sql = new char[500];
	long dbnum;
	long qgrps,qdbs,qtblgrps;
	long grpnum;
	long tblgrpnum;
	long l;
	short sd;
	char slask[200];
	char s1[20],s2[20];
	char grpname[40];
	char tblgrpname[40];

	cs -> getvalue("sd",slask,20);	// show deleted
	sd = atoi(slask);

	l = cs -> getlength("viewgrp");
	viewgrp = new char[l + 1];
	cs -> getvalue("viewgrp",viewgrp,l + 1);

	l = cs -> getlength("viewdb");
	viewdb = new char[l + 1];
	cs -> getvalue("viewdb",viewdb,l + 1);

	l = cs -> getlength("viewtbl");
	viewtbl = new char[l + 1];
	cs -> getvalue("viewtbl",viewtbl,l + 1);

	l = cs -> getlength("viewtblgrp");
	viewtblgrp = new char[l + 1];
	cs -> getvalue("viewtblgrp",viewtblgrp,l + 1);


// fix grplinks

	sprintf(sql,"select dbnum from access where usernum=%ld",user -> num);
	q.get_result(sql);
	while (q.fetch_row())
	{
		dbnum = q.getval();
		sprintf(sql,"select num from grplinks where usernum=%ld and dbnum=%ld",user -> num,dbnum);
		if (!qd -> get_count(sql))
		{
			tempdb = new db::Dbs(db,dbnum);
			if (tempdb -> owner == user -> num)
				sprintf(sql,"insert into grplinks values(0,%ld,1,%ld)",user -> num,dbnum);
			else
				sprintf(sql,"insert into grplinks values(0,%ld,2,%ld)",user -> num,dbnum);
			qd -> execute(sql);
			delete tempdb;
		} else
		{
			// ok
		}
	}
	q.free_result();


/*
 * Group / Database / Table / Field structure (left frame/column)
 */

	printf("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">\n");
	fflush(stdout);
	printf("<html>");
	printf("<head><base target=rf></head>");
	printf("<body>"); // BGPROPERTIES=fixed bgcolor=#66ddfe background=/image/dbdsida2.gif>");

// small font
	printf("<font size=-1>");

// top icon
	iopen();
	printf("&nbsp;<a href=\"/cgi-bin/dbd/dbd?lf=0\" target=lf><b>Your Groups</b></a><br>");

// select groups...
// till att borja med finns bara en grupp, alltid oppen "databases"

//	sprintf(sql,"select 1,'Databases'");
	sprintf(sql,"select num,name from grps where usernum=0 or usernum=%ld",user -> num);
	q4.get_result(sql);	// query groups
	qgrps = q4.num_rows();
//printf("# of groups: %ld<br>",qgrps);
	while (q4.fetch_row())	// while (query-groups.fetch_row())
	{
		grpnum = q4.getval();
		strcpy(grpname,q4.getstr());
		qgrps--;

		sprintf(sql,"select count(*) from grplinks,dbs where usernum=%ld and grpnum=%ld and dbs.num=dbnum%s",
		 user -> num,grpnum,sd ? "" : " and dbs.deleted=0");
		l = qd -> get_count(sql);
		if (l)
		{

	printf("<!-- nobr -->");
//	sprintf(slask,"viewgrp%ld",grpnum);
	if (!l || !inlist(viewgrp,grpnum)) // !cs -> getvalue(slask,slask,20) || !atoi(slask))
	{
		if (l)
		{
			printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&togglegrp=%ld&v=1\">",grpnum);
			if (!qgrps)	// last group
				iplusend();
			else
				iplus();
			iglobe0();
			printf("</a>");
		} else
		{
			if (!qgrps)	// last group
				ibranchend();
			else
				ibranchcont();
			iglobe0();
		}
		printf("&nbsp;%s<!-- /nobr --><br>",grpname);
	} else
	{
		printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&togglegrp=%ld&v=0\">",grpnum);
		if (!qgrps)
			iminusend();
		else
			iminus();
		iglobe0();
		printf("</a>");
		printf("&nbsp;%s<!-- /nobr --><br>",grpname);


//	printf("<ul>");
	sprintf(sql,"select dbnum from access,dbs where usernum=%ld and dbs.num=dbnum %s order by dbs.name",
	 user -> num,
	 sd ? "" : "and deleted=0");

	sprintf(sql,"select dbnum from grplinks,dbs where grplinks.usernum=%ld and grplinks.grpnum=%ld and dbs.num=grplinks.dbnum%s order by dbs.name",
	 user -> num,grpnum,sd ? "" : " and dbs.deleted=0");
	q.get_result(sql);
	qdbs = q.num_rows();
	while (q.fetch_row())
	{
		dbnum = q.getval();
		qdbs--;
		
		sprintf(sql,"select count(*) from tbls where dbnum=%ld",dbnum);
		l = qd -> get_count(sql);

		tempdb = new db::Dbs(db,dbnum);
		if (strcmp(tempdb -> changedate,user -> prevdatum) > 0)
		{
			strcpy(s1,"<i>");
			strcpy(s2,"</i>");
		} else
			*s1 = *s2 = 0;

		printf("<!-- nobr -->");
		if (!qgrps)
			iempty();
		else
			ivertline();

//		sprintf(slask,"viewdb%ld",dbnum);
		if (!l || !inlist(viewdb,dbnum)) // !cs -> getvalue(slask,slask,20) || !atoi(slask))
		{
			if (l)
			{
				printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&toggledb=%ld&v=1\">",dbnum);
				if (!qdbs)
					iplusend();
				else
					iplus();
				iclosed();
				printf("</a>");
			} else
			{
				if (!qdbs)
					ibranchend();
				else
					ibranchcont();
				iclosed();
			}
			printf("&nbsp;<a target=rf href=\"/cgi-bin/dbd/dbd?seldb=%ld\">%s%s%s</a>",dbnum,s1,tempdb -> name,s2);
//			if (strcmp(tempdb -> changedate,user -> prevdatum) > 0)
//				printf("&nbsp;<img src=\"/image/new.gif\" alt=\"New!\">");
			if (tempdb -> deleted)
				printf("&nbsp;&lt;deleted&gt;");
			printf("<!-- /nobr --><br>");
		} else
		{
			printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&toggledb=%ld&v=0\">",dbnum);
			if (!qdbs)
				iminusend();
			else
				iminus();
			iopen();
			printf("</a>");
			printf("&nbsp;<a target=rf href=\"/cgi-bin/dbd/dbd?seldb=%ld\">%s%s%s</a>",dbnum,s1,tempdb -> name,s2);
//			if (strcmp(tempdb -> changedate,user -> prevdatum) > 0)
//				printf("&nbsp;<img src=\"/image/new.gif\" alt=\"New!\">");
			if (tempdb -> deleted)
				printf("&nbsp;&lt;deleted&gt;");
			printf("<!-- /nobr --><br>");


// -------------------- db::Applications ----------------------------
//  (show appl grp icon + applications if any for this database)

			sprintf(sql,"select count(*) from tbls where dbnum=%ld",dbnum);
			qtblgrps = qd -> get_count(sql);

			sprintf(sql,"select count(*) from applications where dbnum=%ld",dbnum);
			l = qd -> get_count(sql);

			if (l)
			{
			printf("<!-- nobr -->");
			if (!qgrps)		// antal databasegrupper kvar
				iempty();
			else
				ivertline();
			if (!qdbs)		// antal databaser i aktuell dbgrp kvar
				iempty();
			else
				ivertline();

			if (!l || !inlist(viewtblgrp,-1)) 
			{
				if (l)
				{
					printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&toggletblgrp=-1&v=1\">");
					if (!qtblgrps)
						iplusend();
					else
						iplus();
					iclosed();
					printf("</a>");
				} else
				{
					if (!qtblgrps)
						ibranchend();
					else
						ibranchcont();
					iclosed();
				}
				printf("&nbsp;<b>Applications</b>");
				printf("<!-- /nobr --><br>");
			} else
			{
				printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&toggletblgrp=-1&v=0\">");
				if (!qtblgrps)
					iminusend();
				else
					iminus();
				iopen();
				printf("</a>");
				printf("&nbsp;<b>Applications</b>");
				printf("<!-- /nobr --><br>");

				sprintf(sql,"select num from applications where dbnum=%ld %s order by name",
				 dbnum,sd ? "" : "and deleted=0");

				show_apps(db,sql,qgrps,qdbs,qd,cs,user,sd,qtblgrps,0);
			}
			} // if (l) -- no tbls in group - don't show group


// -------------------- End db::Applications ------------------------
//  (show tables, then tblgrps for this database)


//			printf("<ul>");
			sprintf(sql,"select count(*) from tbls where dbnum=%ld and tblgrpnum>0",dbnum);
			l = qd -> get_count(sql); // l>0 om det finns tabeller i tblgrps i denna databas

			sprintf(sql,"select num from tbls where dbnum=%ld and tblgrpnum=0 %s order by name",
			 dbnum,sd ? "" : "and deleted=0");

			show_table(db,sql,qgrps,qdbs,qd,cs,user,sd,-1,l ? 1 : 0);
fflush(stdout);
			sprintf(sql,"select num,name from tblgrps where dbnum=%ld order by name",dbnum);
			q2.get_result(sql);
			qtblgrps = q2.num_rows();
			while (q2.fetch_row())
			{
				tblgrpnum = q2.getval();
				strcpy(tblgrpname,q2.getstr());
				qtblgrps--;

				sprintf(sql,"select count(*) from tbls where tblgrpnum=%ld",tblgrpnum);
				l = qd -> get_count(sql);

// ------------------------
				if (l)
				{
				printf("<!-- nobr -->");
				if (!qgrps)
					iempty();
				else
					ivertline();
				if (!qdbs)
					iempty();
				else
					ivertline();

//				sprintf(slask,"viewtblgrp%ld",tblgrpnum);
				if (!l || !inlist(viewtblgrp,tblgrpnum)) // !cs -> getvalue(slask,slask,20) || !atoi(slask))
				{
					if (l)
					{
						printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&toggletblgrp=%ld&v=1\">",tblgrpnum);
						if (!qtblgrps)
							iplusend();
						else
							iplus();
						iclosed();
						printf("</a>");
					} else
					{
						if (!qtblgrps)
							ibranchend();
						else
							ibranchcont();
						iclosed();
					}
					printf("&nbsp;<b>%s</b>",tblgrpname);
					printf("<!-- /nobr --><br>");
				} else
				{
					printf("<a target=lf href=\"/cgi-bin/dbd/dbd?lf=0&toggletblgrp=%ld&v=0\">",tblgrpnum);
					if (!qtblgrps)
						iminusend();
					else
						iminus();
					iopen();
					printf("</a>");
					printf("&nbsp;<b>%s</b>",tblgrpname);
					printf("<!-- /nobr --><br>");
// ------------------------

					sprintf(sql,"select num from tbls where dbnum=%ld and tblgrpnum=%ld %s order by name",
					 dbnum,tblgrpnum,sd ? "" : "and deleted=0");

					show_table(db,sql,qgrps,qdbs,qd,cs,user,sd,qtblgrps,0);
				}
				} // if (l) -- no tbls in group - don't show group
			}
			q2.free_result();
//			printf("</ul>");
		}
		delete tempdb;
	}
	q.free_result();
//	printf("</ul>");

	} // if (group open)
		} // if databases in group (l)
	} // while (query-groups.fetch_row())
	q4.free_result();

	printf("</font>");

	printf("<br>");
	printf("<table width=\"100%%\"><tr><td align=middle>");
	printf("<form target=lf action=\"/cgi-bin/dbd/dbd\">");
	printf("<input type=hidden name=lf value=0>");
	if (sd)
		printf("<input type=submit name=sd value=\" Do not show deleted \">");
	else
		printf("<input type=submit name=sd value=\" Show deleted \">");
	printf("</form>");
	printf("</td></tr>");
	printf("<tr><td align=middle>[\n");
	printf("<a href=\"/cgi-bin/dbd/dbd?ag=0\" target=rf>add group</a>\n]<br>");
	printf("[\n<a href=\"/cgi-bin/dbd/dbd?rg=0\" target=rf>remove group</a>\n]");
	printf("</td></tr>");
	printf("</table>");

	printf("</body></html>\n");

	delete qd;
	delete viewgrp;
	delete viewdb;
	delete viewtbl;
	delete viewtblgrp;
}


