// gsql.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include <libsql++.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <libdbd.h>
#include <string>
using std::string;
#include <libcgi++.h>

#include "dbd.h"
#include "utils.h"
#include "html.h"


//static	short debug = 1;



char *typestring(db::Flds *sfld)
{
	Parse *pa;
static	char s[200];
	char slask[200];
	char str[10];

	*s = 0;
	strupr(sfld -> fieldstr);
	switch (sfld -> fieldtype)
	{
	    case 1: // char
	    	if (!strcasecmp(sfld -> fieldstr,"char") || !strcasecmp(sfld -> fieldstr,"varchar"))
			sprintf(s," %s(%ld) DEFAULT '%s'",
			 sfld -> fieldstr,sfld -> charlength,sfld -> defaultvalue);
		else
			sprintf(s," %s DEFAULT '%s'",
			 sfld -> fieldstr,sfld -> defaultvalue);
	    	break;
	    case 2: // integer
		if ((sfld -> fieldflags & FF_AUTO_INCREMENT) != 0)
			sprintf(s," %s(%ld) auto_increment",sfld -> fieldstr,sfld -> integerlength);
		else
			sprintf(s," %s(%ld) DEFAULT %ld",sfld -> fieldstr,sfld -> integerlength,atol(sfld -> defaultvalue));
	    	break;
	    case 3: // datetime
		sprintf(s," %s",sfld -> fieldstr);
		// TODO: defaultvalue, timestamp(x), year(2|4)
	    	break;
	    case 4: // enum
	    	pa = new Parse(sfld -> options,"/,");
	    	pa -> getword(slask);
	    	strcpy(str,"ENUM(");
	    	*s = 0;
	    	while (*slask)
	    	{
	    		if (name_ok(slask))
		    		sprintf(s + strlen(s),"%s'%s'",str,slask);
	    		strcpy(str,",");
	    		pa -> getword(slask);
	    	}
	    	delete pa;
	    	strcat(s,")");
	    	break;
	    case 5: // ptr
	    	sprintf(s," INT(11) DEFAULT 0");
	    	break;
	    case 6: // number
	    	sprintf(slask,"%%s(%%ld,%%ld) DEFAULT %%.%ldf",sfld -> decimallength);
		sprintf(s,slask,
		 sfld -> fieldstr,sfld -> integerlength,sfld -> decimallength,atof(sfld -> defaultvalue));
	    	break;
	    case 7: // set
	    	pa = new Parse(sfld -> options,"/,");
	    	pa -> getword(slask);
	    	strcpy(str,"SET(");
	    	*s = 0;
	    	while (*slask)
	    	{
	    		if (name_ok(slask))
		    		sprintf(s + strlen(s),"%s'%s'",str,slask);
	    		strcpy(str,",");
	    		pa -> getword(slask);
	    	}
	    	delete pa;
	    	strcat(s,")");
	    	break;
	}
	if ((sfld -> fieldflags & FF_ALLOWNULL) == 0)
		strcat(s," NOT NULL");
	return s;
}

void generate_sqlfile(Database *db,db::Dbs *sdb)
{
	FILE *fil;
	Database livedb("localhost","root","",sdb -> name);
	Query q(db),q2(db),q3(db),q4(db);
	Query lq(&livedb);
	db::Tbls *stbl;
	db::Flds *sfld;
	db::Flds **flds;
	db::Indexs *tempindex;
	db::Indexlist *il;
	db::Flds *tempfld;
	long qty;
	long qindexs;
	int i;
	char *sql = new char[32000];
	char filename[40];
	char slask[200];
	char *dbs = new char[32000];

	sprintf(filename,"/tmp/sql.%d",getpid());
	fil = fopen(filename,"wt");
	fprintf(fil,"#\n"
"# Copyright (C) 2001  Anders Hedstrom (grymse@alhem.net)\n"
"#\n"
"# This program is free software; you can redistribute it and/or\n"
"# modify it under the terms of the GNU General Public License\n"
"# as published by the Free Software Foundation; either version 2\n"
"# of the License, or (at your option) any later version.\n"
"#\n"
"# This program is distributed in the hope that it will be useful,\n"
"# but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"# GNU General Public License for more details.\n"
"#\n"
"# You should have received a copy of the GNU General Public License\n"
"# along with this program; if not, write to the Free Software\n"
"# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n"
"#\n");
	fprintf(fil,"\n");

	sprintf(sql,"select num from tbls where dbnum=%ld and deleted=0 order by name",sdb -> num);
	q.get_result(sql);
	while (q.fetch_row())
	{
		stbl = new db::Tbls(db,q.getval());

		sprintf(sql,"select num from flds where tblnum=%ld and deleted=0 order by ordning",stbl -> num);
		q2.get_result(sql);
		if (q2.num_rows())
		{
			fprintf(fil,"#\n# Table structure for table '%s'\n#\n\n",stbl -> name);
			fprintf(fil,"create table %s (\n",stbl -> name);
			while (q2.fetch_row())
			{
				sfld = new db::Flds(db,q2.getval());
				if (sfld -> fieldtype == 5) // ptrtotable
				{
					sprintf(sql,"select name from tbls where num=%ld",sfld -> ptrtotblnum);
					fprintf(fil,"  %s %s, /* ptrtotable: %s */\n",sfld -> name,typestring(sfld),q3.get_string(sql));
				} else
				if (*sfld -> description && 0)
				{
					strcpy(slask,sfld -> description);
//					dbsafestr(slask);
					fprintf(fil,"  %s %s, /* %s */\n",sfld -> name,typestring(sfld),slask);
				} else
					fprintf(fil,"  %s %s,\n",sfld -> name,typestring(sfld));
				delete sfld;
			}

		/*
		 * index
		 */
			sprintf(sql,"select num from indexs where tblnum=%ld",stbl -> num);
			q3.get_result(sql);
			qindexs = q3.num_rows();
			while (q3.fetch_row())
			{
				tempindex = new db::Indexs(db,q3.getval());
				qindexs--;
				if (!strcmp(tempindex -> typ,"PRIMARY"))
				{
					strcpy(slask,"  PRIMARY KEY(");
				} else
				{
					sprintf(slask,"  %s %s(",tempindex -> typ,tempindex -> name);
				}
				sprintf(sql,"select num from indexlist where indexnum=%ld",tempindex -> num);
				q4.get_result(sql);
				while (q4.fetch_row())
				{
					il = new db::Indexlist(db,q4.getval());
					tempfld = new db::Flds(db,il -> fldnum);
					fprintf(fil,"%s%s",slask,tempfld -> name);
					if (il -> length > 0)
						fprintf(fil,"(%ld)",il -> length);
					strcpy(slask,",");

					delete tempfld;
					delete il;
				}
				if (q4.num_rows())
				{
					fprintf(fil,")");
					if (qindexs)
						fprintf(fil,",");
					if (*tempindex -> description && 0)
					{
						strcpy(slask,tempindex -> description);
//						dbsafestr(slask);
						fprintf(fil," /* %s */",slask);
					}
					fprintf(fil,"\n");
				}
				q4.free_result();
				delete tempindex;
			}
			q3.free_result();

		// End of Create table
			strcpy(slask,stbl -> description);
//			dbsafestr2(slask);
			fprintf(fil,") COMMENT='%s';\n\n",q.safestr(slask).c_str());
		} else
			fprintf(fil,"# Empty table '%s'\n\n",stbl -> name);
		q2.free_result();

		fprintf(fil,"#\n# Data for table '%s'\n#\n\n",stbl -> name);
//		if (!livedb.errcode())
		{
		// get fields
			sprintf(sql,"select num from flds where tblnum=%ld and deleted=0 order by ordning",stbl -> num);
			q3.get_result(sql);
			qty = q3.num_rows();
			flds = new db::Flds *[qty];
			i = 0;
			while (q3.fetch_row())
				flds[i++] = new db::Flds(db,q3.getval());
			q3.free_result();

		// build query

			strcpy(slask,"select ");
			*sql = 0;
			for (i = 0; i < qty; i++)
			{
				sprintf(sql + strlen(sql),"%s%s",slask,flds[i] -> name);
				strcpy(slask,",");
			}
			sprintf(sql + strlen(sql)," from %s",stbl -> name);

			lq.get_result(sql);
			while (lq.fetch_row())
			{
				sprintf(slask,"insert into %s values (",stbl -> name);
				*sql = 0;
				for (i = 0; i < qty; i++)
				{
					switch (flds[i] -> fieldtype)
					{
						case 1: // char
						case 3:
						case 4:
						case 7: // set
							strcpy(dbs,lq.getstr(i));
//							dbsafestr2(dbs);
							sprintf(sql + strlen(sql),"%s'%s'",
							 slask,q.safestr(dbs).c_str());
							break;
						case 2: // int
						case 5:
							sprintf(sql + strlen(sql),"%s%ld",
							 slask,lq.getval(i));
							break;
						case 6: // number
							sprintf(sql + strlen(sql),"%s%s",
							 slask,lq.getstr(i));
							break;
					}
					strcpy(slask,",");
				}
				strcat(sql,");");
				fprintf(fil,"%s\n",sql);
			}
			lq.free_result();

			for (i = 0; i < qty; i++)
				delete flds[i];
			delete flds;
			fprintf(fil,"\n");
		}
		fprintf(fil,"\n");

		delete stbl;
	}
	q.free_result();
	fclose(fil);

	delete dbs;
	delete sql;
}

void generate_sql(Database *db,db::Dbs *sdb)
{
	FILE *fil;
	Database livedb("localhost","root","",sdb -> name);
	Query q(db),q2(db),q3(db);
	Query lq(&livedb);
	long l;
	int i;
	char sql[999];
	char filename[40];
	char sqlfilename[40];
	char *files = new char[2000];

	generate_sqlfile(db,sdb);

	sprintf(filename,"/tmp/sql.%d",getpid());
	sprintf(sql,"cd /tmp ; /usr/devel/bin/sql2class %s -overwrite",filename);
	syscall(sql);

	sprintf(sqlfilename,"/tmp/%s.sql",sdb -> name);
	sprintf(sql,"cp %s %s",filename,sqlfilename);
	syscall(sql);

	sprintf(files,"tar cvzf %s/%s.tar.gz %s > /dev/null 2>/dev/null",APACHEDLPATH,sdb -> name,sqlfilename);

// generate page
	header0("Generate code",6);

	printf("<table><tr><td>");
	printf("<form action=/cgi-bin/dbd/dbd method=post>\n");
	printf("<input type=submit name=submit value=\" Go back \">\n");
	printf("</form>\n");
	printf("</td></tr></table>\n");

	printf("<h3>Download</h3>\n");
	printf("<p>Download a .tar.gz archive with all files <a href=%s/%s.tar.gz>here</a>.</p>\n",APACHEPATH,sdb -> name);
	printf("<br>\n");

	printf("<h3>%s.sql</h3>\n",sdb -> name);
	printf("<pre>\n");
	if ((fil = fopen(filename,"rt")) != NULL)
	{
		fgets(sql,200,fil);
		while (!feof(fil))
		{
			sql[strlen(sql) - 1] = 0;
			for (i = 0; i < (int)strlen(sql); i++)
				if (sql[i] == '<')
					printf("&lt;");
				else
				if (sql[i] == '>')
					printf("&gt;");
				else
					printf("%c",sql[i]);
			printf("\n");
			fgets(sql,200,fil);
		}
		fclose(fil);
	}
	printf("</pre>\n");
	unlink(filename);		// /tmp/sql.xxx

	printf("<h3>Database.h</h3>\n");
	printf("<pre>\n");
	if ((fil = fopen("/tmp/Database.h","rt")) != NULL)
	{
		fgets(sql,200,fil);
		while (!feof(fil))
		{
			sql[strlen(sql) - 1] = 0;
			for (i = 0; i < (int)strlen(sql); i++)
				if (sql[i] == '<')
					printf("&lt;");
				else
				if (sql[i] == '>')
					printf("&gt;");
				else
					printf("%c",sql[i]);
			printf("\n");
			fgets(sql,200,fil);
		}
		fclose(fil);
		sprintf(files + strlen(files)," /tmp/Database.h");
	}
	printf("</pre>\n");

	printf("<h3>Query.h</h3>\n");
	printf("<pre>\n");
	if ((fil = fopen("/tmp/Query.h","rt")) != NULL)
	{
		fgets(sql,200,fil);
		while (!feof(fil))
		{
			sql[strlen(sql) - 1] = 0;
			for (i = 0; i < (int)strlen(sql); i++)
				if (sql[i] == '<')
					printf("&lt;");
				else
				if (sql[i] == '>')
					printf("&gt;");
				else
					printf("%c",sql[i]);
			printf("\n");
			fgets(sql,200,fil);
		}
		fclose(fil);
		sprintf(files + strlen(files)," /tmp/Query.h");
	}
	printf("</pre>\n");

	sprintf(sql,"select num,name from tbls where dbnum=%ld and deleted=0 order by name",sdb -> num);
	q.get_result(sql);
	while (q.fetch_row())
	{
		l = q.getval();

		sprintf(sql,"select count(*) from flds where tblnum=%ld",l);
		if (q2.get_count(sql))
		{
			strcpy(sql,q.getstr(1));
			strlwr(sql);
			if (*sql >= 'a' && *sql <= 'z')
				*sql -= 32;
			sprintf(filename,"sqlTbl%s.h",sql);
			printf("<h3>%s</h3>\n",filename);
			sprintf(filename,"/tmp/sqlTbl%s.h",sql);
			printf("<pre>\n");
			if ((fil = fopen(filename,"rt")) != NULL)
			{
				fgets(sql,200,fil);
				while (!feof(fil))
				{
					sql[strlen(sql) - 1] = 0;
					for (i = 0; i < (int)strlen(sql); i++)
						if (sql[i] == '<')
							printf("&lt;");
						else
						if (sql[i] == '>')
							printf("&gt;");
						else
							printf("%c",sql[i]);
					printf("\n");
					fgets(sql,200,fil);
				}
				fclose(fil);
				sprintf(files + strlen(files)," %s",filename);
			}
			printf("</pre>\n");
		}
	}
	q.free_result();

	mkdir(APACHEDLPATH,0750);
	syscall(files);		// create .tar.gz file
	unlink(sqlfilename);

// delete sqlTbl*.h

	sprintf(sql,"select num,name from tbls where dbnum=%ld and deleted=0 order by name",sdb -> num);
	q.get_result(sql);
	while (q.fetch_row())
	{
		l = q.getval();

		sprintf(sql,"select count(*) from flds where tblnum=%ld",l);
		if (q2.get_count(sql))
		{
			strcpy(sql,q.getstr(1));
			strlwr(sql);
			if (*sql >= 'a' && *sql <= 'z')
				*sql -= 32;
			sprintf(filename,"sqlTbl%s.h",sql);
			unlink(filename);
		}
	}
	q.free_result();
//	printf("</body></html>\n");
	footer();

	delete files;
}
