// dbd.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include <unistd.h>
#include <libsql++.h>
#include <libdbd.h>
#include <string>
using std::string;
#include <libcgi++.h>

#include "dbd.h"
#include "utils.h"
#include "html.h"
#include "gsql.h"
#include "livedb.h"
#include "lf.h"
#include "pages.h"
#include "checks.h"
#include "diagram.h"


/*
 *
 */

static	short ddebug = 0;
	char errstr[200];
	char warningstr[200];
	short cookieflags;

void togglelist(char *slask,long val,short on)
{
	Parse *pa;
	char ord[100];

	pa = new Parse(slask,",");
	pa -> getword(ord);
	*slask = 0;
	while (*ord)
	{
		if (atol(ord) && atol(ord) != val)
		{
			if (*slask)
				strcat(slask,",");
			strcat(slask,ord);
		}
		pa -> getword(ord);
	}
	delete pa;
	if (on)
	{
		if (*slask)
			strcat(slask,",");
		sprintf(slask + strlen(slask),"%ld",val);
	}
}


int main(int argc,char *argv[])
{
	Database db("localhost","root","","dbd");
	Query q(&db);
	Query *qd = new Query(&db);
	Form *form = NULL;
	Cookies *cs;
	db::Dbs *sdb = NULL;
	db::Tbls *stbl = NULL;
	db::Applications *sapp = NULL;
	db::Flds *sfld = NULL;
	db::Indexs *sindex = NULL;
	db::Users *user = NULL;
	db::Users *tempuser;
	db::Access *a = NULL,*a2;
	db::Grps *grp;
	db::Tblgrps *tblgrp;
	db::Appusers *tempau;
//	char *r_h = getenv("REMOTE_HOST");
	char *q_s = getenv("QUERY_STRING");
//	char *c_l = getenv("CONTENT_LENGTH");
	char *r_m = getenv("REQUEST_METHOD");
	char *http_cookie = getenv("HTTP_COOKIE");
	char *sql = new char[500];
	char *kommentar = NULL;
	long usernum = 0,valid = 0;	// 'u' and 'v' cookies
	long seldb = 0,seltbl = 0,selfld = 0;	// selected...
	long selindex = 0;
	long selapp = 0;
	long l = 0;
	long dbnum = 0;			// dbaccess
	long maxdbs = 0,maxtbls = 0,maxflds = 0;
	long maxindexs = 0;
	long maxapps = 0;
	long flags;
	short page = 0;
	short i = 0;
	short r,w,c,d,rdata,wdata;
	short steps;
	short login_ok_send_frameset = 0;
	short refresh_frames = 0;
	short ci = 0;			// changeindex
	char slask[300];
	char handle[20];
	char password[20];
	char password2[20];
	char email[60];
	char icq[20];
	char name[40];
	char oldpassword[20];
	char newname[40];

//	db.debug(1);

// before calling Form(), check how we are called - code from webmud@home

	if (!r_m)
	{
		printf("This program is part of a cgi script, and should not be\n");
		printf("be called from the command line\n");
		exit(0);
	}

// return type from this code is always 'text/html'

//
//	printf("\n");
	if (ddebug) printf("\nddebugging<br>\n");
	fflush(stdout);

	if (!strcasecmp(r_m,"get"))
	{
		if (q_s)
			form = new Form(q_s,strlen(q_s));
		else
			error("q_s undefined");
	} else
		if (!strcasecmp(r_m,"post"))
			form = new Form();
		else
  			error("unknown request_method");

	*errstr = 0;
	*warningstr = 0;
	if (ddebug) printf("Form() ok<br>\n");
	fflush(stdout);

// retreive cookie(s)
	cs = new Cookies(http_cookie ? http_cookie : (char *)"");
	if (ddebug) printf("Cookies() ok<br>\n");
	fflush(stdout);
	cs -> getvalue("cof",slask,20);
	cookieflags = atoi(slask);

	if (form -> getvalue("tof",slask,20))
	{
		cookieflags ^= atoi(slask);
		set_cookie(cs,"cof",(long)cookieflags);
	}
	if (ddebug) printf("cookieflags ok<br>\n");
	fflush(stdout);

// ok, go ahead and parse form input

//#define VIEW
#ifdef VIEW
printf("\n");
form -> getfirst(slask,300);
while (*slask)
{
	printf("%s",slask);
	form -> getvalue(slask,slask,300);
	printf(" = '%s'<br>\n",slask);
	form -> getnext(slask,300);
}
#endif

	// create a new user
	if (form -> getvalue("createuser",slask,20) && *slask && atoi(slask))
	{
		if (!form -> getvalue("name",name,40))
			error("name");
		if (!form -> getvalue("handle",handle,20))
			error("handle");
		if (!form -> getvalue("password",password,20))
			error("password");
		if (!form -> getvalue("password2",password2,20))
			error("password2");
		if (!form -> getvalue("email",email,60))
			error("email");
		if (!form -> getvalue("icq",icq,60))
			error("icq");
		sprintf(sql,"select num from users where handle='%s'",qd -> safestr(handle).c_str());
		if (!qd -> get_count(sql) && !strcmp(password,password2) && *handle && *password)
		{
			user = new db::Users(&db);
			strcpy(user -> handle,handle);
			strcpy(user -> name,name);
			strcpy(user -> password,password);
			user -> superuser = 0;
			strcpy(user -> email,email);
			strcpy(user -> icq,icq);
			user -> maxdbs = 1;
			user -> maxtbls = 3;
			user -> maxflds = 25;
			user -> maxindexs = 5;
			user -> maxapps = 1;
			user -> flags = UF_AUTOCREATENUM;
			user -> steps = 10;
			user -> insert();
			delete user;
			// login done below with info from new user form
		}
/*
CREATE TABLE users (
  num int(11) DEFAULT '0' NOT NULL auto_increment,
  handle char(20) DEFAULT '' NOT NULL,
  name char(40) DEFAULT '' NOT NULL,
  password char(20) DEFAULT '' NOT NULL,
  superuser tinyint(1) DEFAULT '0' NOT NULL,
  email char(60) DEFAULT '' NOT NULL,
  icq char(20) DEFAULT '' NOT NULL,
  prevdatum datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  thisdatum datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  maxdbs int(11) DEFAULT '0' NOT NULL,
  maxtbls int(11) DEFAULT '0' NOT NULL,
  maxflds int(11) DEFAULT '0' NOT NULL,
  PRIMARY KEY (num)
);
*/
	}

	// login 

	if (cs -> getvalue("u",slask,200))
		usernum = atol(slask);
	if (cs -> getvalue("v",slask,200))
		valid = atol(slask);
	*handle = 0;
	if (form -> getvalue("handle",handle,20) && *handle)
	{
		if (!form -> getvalue("password",password,20))
			error("password");
		sprintf(sql,"select num from users where handle='%s' and password='%s'",qd -> safestr(handle).c_str(),qd -> safestr(password).c_str());
		usernum = qd -> get_count(sql);
		if (usernum)
		{
			sprintf(sql,"update users set prevdatum=thisdatum where num=%ld",usernum);
			qd -> execute(sql);
			sprintf(sql,"update users set thisdatum='%s' where num=%ld",datetime(),usernum);
			qd -> execute(sql);
			valid = reg_valid(&db,usernum);
			set_cookie(cs,"u",usernum);
			set_cookie(cs,"v",valid);
			set_cookie(cs,"seldb",0L);
			set_cookie(cs,"seltbl",0L);
			set_cookie(cs,"selfld",0L);
			set_cookie(cs,"selindex","0");
			login_ok_send_frameset = 1;
		}
	}
	if (usernum)
	{
		sprintf(sql,"select num from valid where usernum=%ld and valid=%ld",usernum,valid);
		if (!qd -> get_count(sql))
			usernum = valid = 0;
	}

	// logout
	if (form -> getvalue("logout",slask,20) && *slask && !atoi(slask))
	{
		sprintf(sql,"delete from valid where usernum=%ld and valid=%ld",
		 usernum,valid);
		qd -> execute(sql);
		usernum = valid = 0;
	}

	user = new db::Users(&db,usernum);

	if (usernum)
	{

#ifdef WEPOKFWEF
	// patcha auto_increment flag + index tables

		sprintf(sql,"select num from tbls");
		q.get_result(sql);
		while (q.fetch_row())
		{
			l = q.getval();
			sprintf(sql,"select count(*) from flds where tblnum=%ld and fieldflags&2 <> 0",l);
			if (!qd -> get_count(sql))
			{
				sprintf(sql,"select num from flds where tblnum=%ld order by ordning limit 1",l);
				l = qd -> get_count(sql);
				sprintf(sql,"update flds set fieldflags=2 where num=%ld",l);
				qd -> execute(sql);
			}
		}
		q.free_result();

/*
CREATE TABLE indexs (
  num int(11) DEFAULT '0' NOT NULL auto_increment,
  name char(40) DEFAULT '' NOT NULL,
  tblnum int(11) DEFAULT '0' NOT NULL,
  typ enum('primary','index','unique') DEFAULT 'primary' NOT NULL,
  PRIMARY KEY (num)
);
CREATE TABLE indexlist (
  num int(11) DEFAULT '0' NOT NULL auto_increment,
  indexnum int(11) DEFAULT '0' NOT NULL,
  fldnum int(11) DEFAULT '0' NOT NULL,
  length int(11) DEFAULT '0' NOT NULL,
  PRIMARY KEY (num)
);
*/
		sprintf(sql,"select num from tbls");
		q.get_result(sql);
		while (q.fetch_row())
		{
			tblnum = q.getval();
			sprintf(sql,"select num from flds where tblnum=%ld order by ordning limit 1",tblnum);
			l = qd -> get_count(sql);
			sprintf(sql,"select num from indexs where tblnum=%ld",tblnum);
			if (l && !qd -> get_count(sql))
			{
				index = new Indexs(&db);
				sprintf(sql,"select owner from tbls where num=%ld",tblnum);
				index -> owner = qd -> get_count(sql);
				strcpy(index -> name,"PrimaryKey");
				strcpy(index -> description,"Auto-created by dbdesigner");
				index -> tblnum = tblnum;
 				strcpy(index -> typ,"PRIMARY");
				index -> save();
				il = new Indexlist(&db);
				il -> indexnum = index -> num;
				il -> fldnum = l;
				il -> length = -1;
				il -> save();
				delete index;
				delete il;
			}
		}
		q.free_result();
#endif


	// left frame functions

		if (form -> getvalue("togglegrp",slask,20) && *slask && atol(slask))
		{
			l = atol(slask);
			form -> getvalue("v",slask,20);
			i = atoi(slask);
			cs -> getvalue("viewgrp",slask,300);
			togglelist(slask,l,i);
			set_cookie(cs,"viewgrp",slask);
//			sprintf(slask,"viewgrp%ld",l);
//			set_cookie(cs,slask,(long)i);
		}
		if (form -> getvalue("toggledb",slask,20) && *slask && atol(slask))
		{
			l = atol(slask);
			form -> getvalue("v",slask,20);
			i = atoi(slask);
			cs -> getvalue("viewdb",slask,300);
			togglelist(slask,l,i);
			set_cookie(cs,"viewdb",slask);
//			sprintf(slask,"viewdb%ld",l);
//			set_cookie(cs,slask,(long)i);
		}
		if (form -> getvalue("toggletbl",slask,20) && *slask && atol(slask))
		{
			l = atol(slask);
			form -> getvalue("v",slask,20);
			i = atoi(slask);
			cs -> getvalue("viewtbl",slask,300);
			togglelist(slask,l,i);
			set_cookie(cs,"viewtbl",slask);
//			sprintf(slask,"viewtbl%ld",l);
//			set_cookie(cs,slask,(long)i);
		}
		if (form -> getvalue("toggletblgrp",slask,20) && *slask && atol(slask))
		{
			l = atol(slask);
			form -> getvalue("v",slask,20);
			i = atoi(slask);
			cs -> getvalue("viewtblgrp",slask,300);
			togglelist(slask,l,i);
			set_cookie(cs,"viewtblgrp",slask);
//			sprintf(slask,"viewtblgrp%ld",l);
//			set_cookie(cs,slask,(long)i);
		}
		// %! toggleapp...


	// return to page_0
		if (form -> getvalue("design",slask,20) && *slask && !atoi(slask))
		{
			set_cookie(cs,"ui",0L);
			set_cookie(cs,"dba","0");
			set_cookie(cs,"ed","0");
		}

	// select database / table / field / app

		if (form -> getvalue("selapp",slask,20))
		{
			selapp = atol(slask);
			if (selapp >= 0)
			{
				set_cookie(cs,"selapp",selapp);
				if (selapp > 0)
				{
					sprintf(sql,"select dbnum from applications where num=%ld",selapp);
					set_cookie(cs,"seldb",qd -> get_count(sql));
				}
				set_cookie(cs,"ui","0");
				set_cookie(cs,"dba","0");
				set_cookie(cs,"stepnum","1");
			}
		} else
		if (cs -> getvalue("selapp",slask,20))
			selapp = atol(slask);

		if (form -> getvalue("selindex",slask,20))
		{
			selindex = atol(slask);
			if (selindex >= 0)
			{
				set_cookie(cs,"selindex",selindex);
				if (selindex > 0)
				{
					sprintf(sql,"select tblnum from indexs where num=%ld",selindex);
					set_cookie(cs,"seltbl",seltbl = qd -> get_count(sql));
					sprintf(sql,"select dbnum from tbls where num=%ld",seltbl);
					set_cookie(cs,"seldb",seldb = qd -> get_count(sql));
				}
				set_cookie(cs,"ui","0");
				set_cookie(cs,"dba","0");
				set_cookie(cs,"stepnum","1");
			}
		} else
		if (cs -> getvalue("selindex",slask,20))
			selindex = atol(slask);

		if (form -> getvalue("selfld",slask,20))
		{
			selfld = atol(slask);
			if (selfld >= 0)
			{
				set_cookie(cs,"selfld",selfld);
				if (selfld > 0)
				{
					sprintf(sql,"select tblnum from flds where num=%ld",selfld);
					set_cookie(cs,"seltbl",seltbl = qd -> get_count(sql));
					sprintf(sql,"select dbnum from tbls where num=%ld",seltbl);
					set_cookie(cs,"seldb",seldb = qd -> get_count(sql));
				}
				set_cookie(cs,"ui","0");
				set_cookie(cs,"dba","0");
				set_cookie(cs,"stepnum","1");
			}
		} else
		if (cs -> getvalue("selfld",slask,20))
			selfld = atol(slask);

		if (form -> getvalue("seltbl",slask,20))
		{
			seltbl = atol(slask);
			if (seltbl >= 0)
			{
				selfld = 0;
				selindex = 0;
				set_cookie(cs,"seltbl",seltbl);
				set_cookie(cs,"selfld",selfld);
				set_cookie(cs,"selindex",selindex);
				if (seltbl > 0)
				{
					sprintf(sql,"select dbnum from tbls where num=%ld",seltbl);
					set_cookie(cs,"seldb",qd -> get_count(sql));
				}
				set_cookie(cs,"ui",0L);
				set_cookie(cs,"dba","0");
				set_cookie(cs,"stepnum","1");
			}
		} else
		if (cs -> getvalue("seltbl",slask,20))
			seltbl = atol(slask);

		if (form -> getvalue("seldb",slask,20))
		{
			seldb = atol(slask);
			seltbl = 0;
			selapp = 0;
			selfld = 0;
			selindex = 0;
			if (seldb >= 0)
			{
				set_cookie(cs,"seldb",seldb);
				set_cookie(cs,"seltbl",seltbl);
				set_cookie(cs,"selapp",selapp);
				set_cookie(cs,"selfld",selfld);
				set_cookie(cs,"selindex",selindex);
				set_cookie(cs,"ui",0L);
				set_cookie(cs,"dba","0");
			}
		} else
		if (cs -> getvalue("seldb",slask,20))
			seldb = atol(slask);


	// ta emot create / change / delete - forms

		sdb = check_db(&db,q,form,cs,seldb,user,&refresh_frames);
		if (sdb)
			seldb = sdb -> num;

		if (sdb)
		{
			sprintf(sql,"select * from access where usernum=%ld and dbnum=%ld",user -> num,sdb -> num);
			a = new db::Access(&db,sql);
			if (sdb -> owner == user -> num && !a -> wdata)
			{
				a -> r = a -> w = a -> c = a -> d = a -> rdata = a -> wdata = 1;
				a -> save();
			}
		}

		stbl = check_tbl(&db,q,form,cs,sdb,seltbl,user,&refresh_frames);
		if (stbl)
		{
			seltbl = stbl -> num;
		}

		sapp = check_app(&db,q,form,cs,sdb,selapp,user,&refresh_frames);
		if (sapp)
			selapp = sapp -> num;

		sfld = check_fld(&db,q,form,cs,sdb,stbl,selfld,user,&refresh_frames,sapp);
		if (sfld)
			selfld = sfld -> num;

		sindex = check_index(&db,q,form,cs,sdb,stbl,selindex,user,&refresh_frames,&ci);
		if (sindex)
			selindex = sindex -> num;


	// Application

// addappuser=1, (sapp), usernum, status
		if (sdb && sapp && form -> getvalue("addappuser",slask,20) && *slask && atoi(slask))
		{
		// %! access checks....
			if (!form -> getvalue("usernum",slask,20))
				error("usernum");
			l = atol(slask);
			if (!form -> getvalue("status",slask,200))
				error("status");

			sprintf(sql,"select num from access where usernum=%ld and dbnum=%ld",l,sdb -> num);
			if (qd -> get_count(sql))
			{
				tempau = new db::Appusers(&db);
				tempau -> appnum = sapp -> num;
				tempau -> usernum = l;
				strcpy(tempau -> status,slask);
				tempau -> save();
			}
		}

// updtableinfo=1, (sapp), tblnum
		if (sdb && sapp && form -> getvalue("updtableinfo",slask,20) && *slask && atoi(slask))
		{
			sprintf(sql,"update apptables set checked=0 where appnum=%ld",sapp -> num);
			qd -> execute(sql);

			sprintf(sql,"select tblnum from apptables where appnum=%ld",sapp -> num);
			q.get_result(sql);
			while (q.fetch_row())
			{
				l = q.getval();
				sprintf(slask,"tblnum%ld",l);
				if (form -> getvalue(slask,slask,20) && *slask && atoi(slask))
				{
					sprintf(sql,"update apptables set checked=1 where appnum=%ld and tblnum=%ld",sapp -> num,l);
					qd -> execute(sql);
				}
			}
			q.free_result();
		}


	// remove downloadable file 
	// TODO - fixa 
		if (sdb)
		{
			sprintf(slask,"%s/%s.tar.gz",APACHEDLPATH,sdb -> name);
			unlink(slask);
		}


	// toggle show deleted flag
		if (form -> getvalue("sd",slask,20))
		{
			if (cs -> getvalue("sd",slask,20) && *slask && atoi(slask))
				set_cookie(cs,"sd",0L);
			else
				set_cookie(cs,"sd",1L);
		}

	// forms - user info / db access
		if (form -> getvalue("ui",slask,20) && *slask && !atoi(slask))
		{
			set_cookie(cs,"ui",1L);
			set_cookie(cs,"dba","0");
			set_cookie(cs,"ed",0L);
		}
		if (form -> getvalue("dba",slask,20) && *slask && !atoi(slask))
		{
			set_cookie(cs,"dba",1L);
			set_cookie(cs,"ui","0");
			set_cookie(cs,"ed",0L);
		}

	// edit data
		if (sdb && stbl && form -> getvalue("ed",slask,20) && *slask && !atoi(slask))
		{
			if (a -> rdata)
			{
				set_cookie(cs,"stepnum","1");	// rad 1
				set_cookie(cs,"ed",1L);
				set_cookie(cs,"ui",0L);
				set_cookie(cs,"dba","0");
			}
		}


	// update info (ui=1 && submit=' Update personal info ')
		if (form -> getvalue("ui",slask,20) && *slask && atoi(slask))
		{
		if (user -> superuser && form -> getvalue("valjuser",slask,200) && *slask)
		{
			if (!form -> getvalue("valduser",slask,20))
				error("valduser");
			set_cookie(cs,"valduser",slask);
		} else
		if (form -> getvalue("submit",slask,200) && !strcmp(slask," Update personal info "))
		{
			if (!form -> getvalue("usernum",slask,20))
				error("usernum");
			l = atol(slask);
			if (!form -> getvalue("name",name,40))
				error("name");
			if (!form -> getvalue("oldpassword",oldpassword,20))
				error("oldpassword");
			if (!form -> getvalue("newpassword",password,20))
				error("newpassword");
			if (!form -> getvalue("repeatpassword",password2,20))
				error("repeatpassword");
			if (!form -> getvalue("email",email,60))
				error("email");
			if (!form -> getvalue("icq",icq,20))
				error("icq");
			if (!form -> getvalue("steps",slask,20))
				error("steps");
			steps = atoi(slask);
			if (user -> superuser)
			{
				if (!form -> getvalue("maxdbs",slask,20))
					error("maxdbs");
				maxdbs = atol(slask);
				if (!form -> getvalue("maxtbls",slask,20))
					error("maxtbls");
				maxtbls = atol(slask);
				if (!form -> getvalue("maxflds",slask,20))
					error("maxflds");
				maxflds = atol(slask);
				if (!form -> getvalue("maxindexs",slask,20))
					error("maxindexs");
				maxindexs = atol(slask);
				if (!form -> getvalue("maxapps",slask,20))
					error("maxapps");
				maxapps = atol(slask);
			}
			flags = 0;
			if (form -> getvalue("flag0",slask,20) && *slask && atoi(slask))
				flags |= UF_AUTOCREATENUM;
			if (form -> getvalue("flag1",slask,20) && *slask && atoi(slask))
				flags |= UF_SHOWLINKED;

			tempuser = new db::Users(&db,l);
			strcpy(tempuser -> name,name);
			if (!strcmp(tempuser -> password,oldpassword) && *password && !strcmp(password,password2))
				strcpy(tempuser -> password,password);
			strcpy(tempuser -> email,email);
			strcpy(tempuser -> icq,icq);
			if (user -> superuser)
			{
				tempuser -> maxdbs = maxdbs;
				tempuser -> maxtbls = maxtbls;
				tempuser -> maxflds = maxflds;
				tempuser -> maxindexs = maxindexs;
				tempuser -> maxapps = maxapps;
			}
			tempuser -> flags = flags;
			tempuser -> steps = steps;
			tempuser -> update();
			delete tempuser;
			delete user;
			user = new db::Users(&db,usernum);
		} else
			set_cookie(cs,"ui",0L);
		}


	// db access - ta emot kommandon

		if (form -> getvalue("dba",slask,20) && *slask && (i = atoi(slask)) > 0)
		{
			if (form -> getvalue("submit",slask,200) && !strcmp(slask," Cancel "))
			{
				set_cookie(cs,"dba",0L);
				i = 0;
			} else
			{
				if (!form -> getvalue("usernum",slask,20))
					error("usernum");
				l = atol(slask);
				if (!form -> getvalue("dbnum",slask,20))
					error("dbnum");
				dbnum = atol(slask);
				sprintf(sql,"select owner from dbs where num=%ld",dbnum);
				if (qd -> get_count(sql) != user -> num)
				{
					i = 0;
				}
				if (l == user -> num)
				{
					i = 0;
				}
			}
			switch (i)
			{
			    case 1: // add user
			    	a2 = new db::Access(&db);
			    	a2 -> usernum = l;
			    	a2 -> dbnum = dbnum;
			    	a2 -> insert();
			    	delete a2;
			    	break;
			    case 2: // change access
			    	form -> getvalue("r",slask,20);
			    	r = atoi(slask);
			    	form -> getvalue("w",slask,20);
			    	w = atoi(slask);
			    	form -> getvalue("c",slask,20);
			    	c = atoi(slask);
			    	form -> getvalue("d",slask,20);
			    	d = atoi(slask);
			    	form -> getvalue("rdata",slask,20);
			    	rdata = atoi(slask);
			    	form -> getvalue("wdata",slask,20);
			    	wdata = atoi(slask);
			    	sprintf(sql,"select * from access where usernum=%ld and dbnum=%ld",l,dbnum);
			    	a2 = new db::Access(&db,sql);
			    	a2 -> r = r;
			    	a2 -> w = w;
			    	a2 -> c = c;
			    	a2 -> d = d;
			    	a2 -> rdata = rdata;
			    	a2 -> wdata = wdata;
			    	a2 -> update();
			    	delete a2;
			    	break;
			    case 3: // remove user
			    	sprintf(sql,"delete from access where usernum=%ld and dbnum=%ld",l,dbnum);
			    	qd -> execute(sql);
			    	break;
			}
		}

	// edit live data - go back
		if (form -> getvalue("ed",slask,20) && *slask && (i = atoi(slask)) > 0)
		{
			if (form -> getvalue("submit",slask,200) && !strcmp(slask," Go back "))
			{
				set_cookie(cs,"ed",0L);
				i = 0;
			}
		}

	// live sync - huuuga
		if (sdb && form -> getvalue("ls",slask,20) && *slask && atoi(slask))
		{
			sprintf(sql,"select * from access where usernum=%ld and dbnum=%ld",user -> num,sdb -> num);
			if (a -> r && a -> w && a -> c && a -> d && a -> rdata && a -> wdata)
			{
				form -> getvalue("submit",slask,200);
				if (!strcmp(slask," Live sync "))
				{
					sprintf(slask,"/tmp/backup.%s.%d",sdb -> name,getpid());
					sprintf(sql,"%s %s > %s",MYSQLDUMP,sdb -> name,slask);
					syscall(sql);

					sprintf(sql,"echo y | %s drop %s > /dev/null 2>/dev/null",MYSQLADMIN,sdb -> name);
					syscall(sql);

					sprintf(sql,"%s create %s > /dev/null 2>/dev/null",MYSQLADMIN,sdb -> name);
					syscall(sql);

					generate_sqlfile(&db,sdb);
					sprintf(slask,"/tmp/sql.%d",getpid());
					sprintf(sql,"%s %s < %s",MYSQL,sdb -> name,slask);
					syscall(sql);
				}
			} else
				strcpy(errstr,"You don't have enough access to that database");
		}

	// get current start row (edit data)
		if (form -> getvalue("stepnum",slask,20))
			set_cookie(cs,"stepnum",slask);

	// 'ag' - add group
		if (form -> getvalue("ag",slask,20) && *slask)
		{
			if (!atoi(slask))
				page = 26;
			else
			{
				if (!form -> getvalue("typ",slask,20))
					error("typ");
				i = atoi(slask);
				if (!form -> getvalue("newname",newname,40))
					error("newname");
				if (i == 2 && !sdb)
					i = 0;
				switch (i)
				{
				case 1:
					sprintf(sql,"select num from grps where (usernum=0 or usernum=%ld) and name='%s'",usernum,qd -> safestr(newname).c_str());
					if (qd -> get_count(sql))
						sprintf(errstr,"The group name '%s' is already used",newname);
					else
					{
						grp = new db::Grps(&db);
						strcpy(grp -> name,newname);
						grp -> usernum = usernum;
						grp -> save();
						delete grp;
						refresh_frames++;
					}
					break;
				case 2:
					sprintf(sql,"select num from tblgrps where dbnum=%ld and name='%s'",sdb -> num,qd -> safestr(newname).c_str());
					if (qd -> get_count(sql))
						sprintf(errstr,"The group name '%s' is already used",newname);
					else
					{
						tblgrp = new db::Tblgrps(&db);
						strcpy(tblgrp -> name,newname);
						tblgrp -> dbnum = sdb -> num;
						tblgrp -> save();
						refresh_frames++;
						delete tblgrp;
					}
					break;
				}
			}
		}


	// 'rg' - remove group
		if (form -> getvalue("rg",slask,20) && *slask)
		{
			if (!atoi(slask))
				page = 27;
			else
			{
			}
		}



	// Select page to view

	// create
		if (seldb == -1)
			page = 1;	// create db
		if (sdb && seltbl == -1)
			page = 2;	// create tbl
		if (sdb && stbl && selfld == -1)
			page = 3;	// create field
		if (sdb && stbl && selindex == -1)
			page = 28;	// create index
		if (sdb && selapp == -1)
			page = 33;	// create application

	// change
		if (sdb && form -> getvalue("changedb",slask,20) && *slask && !atoi(slask))
			page = 5;
		if (sdb && stbl && form -> getvalue("changetbl",slask,20) && *slask && !atoi(slask))
			page = 6;
		if (sdb && stbl && sfld && form -> getvalue("changefld",slask,20) && *slask && !atoi(slask))
			page = 7;
		if (sdb && stbl && sindex && (ci || (form -> getvalue("changeindex",slask,20) && *slask && !atoi(slask))))
			page = 29;
		if (sdb && sapp && form -> getvalue("changeapp",slask,20) && *slask && !atoi(slask))
			page = 34;

	// delete
		if (sdb && form -> getvalue("deletedb",slask,20) && *slask && !atoi(slask))
			page = 8;
		if (sdb && stbl && form -> getvalue("deletetbl",slask,20) && *slask && !atoi(slask))
			page = 9;
		if (sdb && stbl && sfld && form -> getvalue("deletefld",slask,20) && *slask && !atoi(slask))
			page = 10;
		if (sdb && stbl && sindex && form -> getvalue("deleteindex",slask,20) && *slask && !atoi(slask))
			page = 30;
		if (sdb && sapp && form -> getvalue("deleteapp",slask,20) && *slask && !atoi(slask))
			page = 35;

	// read comments
		if (sdb && form -> getvalue("readdb",slask,20) && *slask && !atoi(slask))
			page = 11;
		if (sdb && stbl && form -> getvalue("readtbl",slask,20) && *slask && !atoi(slask))
			page = 12;
		if (sdb && stbl && sfld && form -> getvalue("readfld",slask,20) && *slask && !atoi(slask))
			page = 13;
		if (sdb && stbl && sindex && form -> getvalue("readindex",slask,20) && *slask && !atoi(slask))
			page = 31;
		if (sdb && sapp && form -> getvalue("readapp",slask,20) && *slask && !atoi(slask))
			page = 36;

	// write comment
		if (sdb && form -> getvalue("writedb",slask,20) && *slask && !atoi(slask))
			page = 14;
		if (sdb && stbl && form -> getvalue("writetbl",slask,20) && *slask && !atoi(slask))
			page = 15;
		if (sdb && stbl && sfld && form -> getvalue("writefld",slask,20) && *slask && !atoi(slask))
			page = 16;
		if (sdb && stbl && sindex && form -> getvalue("writeindex",slask,20) && *slask && !atoi(slask))
			page = 32;
		if (sdb && sapp && form -> getvalue("writeapp",slask,20) && *slask && !atoi(slask))
			page = 37;

	// misc
		if (cs -> getvalue("ui",slask,20) && *slask && atoi(slask))
			page = 18;	// user info
		if (cs -> getvalue("dba",slask,20) && *slask && atoi(slask))
			page = 19;	// db access

		if (sdb && form -> getvalue("sql",slask,20) && *slask && atoi(slask))
		{
			set_cookie(cs,"ed","0");
			page = 20;
		}
		if (sdb && stbl && a -> rdata && cs -> getvalue("ed",slask,20) && *slask && atoi(slask))
			page = 21;
		if (sdb && form -> getvalue("ls",slask,20) && *slask && !atoi(slask))
			page = 22;
		if (sdb && form -> getvalue("diagram",slask,20) && *slask)
		{
			page = atoi(slask) ? 39 : 38;
		}

		if (refresh_frames || login_ok_send_frameset || 
		    (form -> getvalue("repair",slask,20) && *slask && !atoi(slask)))
			page = 25;
	} // if (usernum)

	if (!usernum)
	{
		if (form -> getvalue("createuser",slask,20) && *slask && !atoi(slask))
			page = 17;	// create a new user
		else
			page = 4;	// login page
	}

// show left frame (from page 25 repair frames)
	if (form -> getvalue("lf",slask,20) && *slask && !atoi(slask))
		page = 23;
// show upper frame ...
	if (form -> getvalue("uf",slask,20) && *slask && !atoi(slask))
		page = 24;

// content type
	if (page == 39)
	{
//		printf("Content-type: image/png\n");
	}
	else
	{
		printf("Content-type: text/html; charset=ISO-8859-1\n");
// End of http header

		printf("\n");
		fflush(stdout);

	}


// 4.01

	printf("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">\n");
	fflush(stdout);

// Create page

if (ddebug) printf("view page(%d)<br>\n",page);
fflush(stdout);

	switch (page)
	{
	    case 0: // main page select / create / edit db / tbl / field
	    	page_0(&db,sdb,stbl,sapp,sfld,sindex,user,cs);
		break;
	    case 1: // create db page
	    	sprintf(sql,"select count(*) from dbs where owner=%ld",usernum);
	    	page_1(&db,NULL,NULL,NULL,user,cs,"Create",user -> superuser || (qd -> get_count(sql) < user -> maxdbs));
	    	break;
	    case 2: // create tbl page
	    	sprintf(sql,"select count(*) from tbls where owner=%ld",usernum);
	    	page_2(&db,sdb,NULL,NULL,user,cs,"Create",user -> superuser || (qd -> get_count(sql) < user -> maxtbls));
	    	break;
	    case 3: // create fld page
	    	sprintf(sql,"select count(*) from flds where owner=%ld",usernum);
	    	page_3(&db,sdb,stbl,NULL,user,cs,"Create",user -> superuser || (qd -> get_count(sql) < user -> maxflds),sapp);
	    	break;
	    case 4: // login page
	    	page_4(handle);
	    	break;
	    case 5: // change db page
	    	page_1(&db,sdb,stbl,sfld,user,cs,"Change",0);
	    	break;
	    case 6: // change tbl page
	    	page_2(&db,sdb,stbl,sfld,user,cs,"Change",0);
	    	break;
	    case 7: // change fld page
	    	page_3(&db,sdb,stbl,sfld,user,cs,"Change",0,sapp);
	    	break;
	    case 8: // delete db page
	    	page_1(&db,sdb,stbl,sfld,user,cs,"Delete",0);
	    	break;
	    case 9: // delete tbl page
	    	page_2(&db,sdb,stbl,sfld,user,cs,"Delete",0);
	    	break;
	    case 10: // delete fld page
	    	page_3(&db,sdb,stbl,sfld,user,cs,"Delete",0,sapp);
	    	break;
	    case 11: // read db
	    	read_comments(&db,sdb,NULL,sapp,NULL,NULL,user,cs);
	    	break;
	    case 12: // read tbl
	    	read_comments(&db,sdb,stbl,sapp,NULL,NULL,user,cs);
	    	break;
	    case 13: // read fld
	    	read_comments(&db,sdb,stbl,sapp,sfld,NULL,user,cs);
	    	break;
	    case 14: // write db
	    	write_comment(&db,sdb,NULL,sapp,NULL,NULL,user,cs,"db");
	    	break;
	    case 15: // write tbl
	    	write_comment(&db,sdb,stbl,sapp,NULL,NULL,user,cs,"tbl");
	    	break;
	    case 16: // write fld
	    	write_comment(&db,sdb,stbl,sapp,sfld,NULL,user,cs,"fld");
	    	break;
	    case 17: // create a new user
	    	page_17(handle);
	    	break;
	    case 18: // user info
	    	page_18(&db,sdb,stbl,sfld,user,cs);
	    	break;
	    case 19: // dbaccess
	    	page_19(&db,sdb,stbl,sfld,user,cs);
	    	break;
	    case 20: // generate sql page
if (ddebug) printf("\nGenerate SQL<br>\n");
fflush(stdout);
	    	generate_sql(&db,sdb);
	    	break;
	    case 21: // edit data
	    	livedata(&db,sdb,stbl,form,cs,user,a);
	    	break;
	    case 22: // live sync
	    	warningsync(&db,sdb,stbl,sfld,user,cs);
	    	break;
	    case 23: // left frame
	    	left_frame(&db,sdb,stbl,sfld,user,cs);
	    	break;
	    case 24: // upper frame
	    	header("",1);
	    	break;
	    case 25: // send frameset
	    	printf("<HTML><HEAD><TITLE>%s</TITLE></HEAD>\n",TITLE);
	    	printf("<frameset rows=80,* frameborder=0 border=0 framespacing=0>"
"<frame scrolling=NO noresize marginheight=0 marginwidth=5 src=/cgi-bin/dbd/dbd?uf=0 name=uf>"
"<FRAMESET COLS=200,* FRAMEBORDER=0 BORDER=0 FRAMESPACING=0>"
"<FRAME SCROLLING=auto NORESIZE MARGINHEIGHT=0 MARGINWIDTH=5 SRC=/cgi-bin/dbd/dbd?lf=0 NAME=lf>"
"<FRAME SCROLLING=auto NORESIZE MARGINHEIGHT=0 MARGINWIDTH=10 SRC=/cgi-bin/dbd/dbd?design=0 NAME=rf>"
"</frameset>"
"</frameset>"
"<noframes>"
"</noframes>"
"</html>\n");
	    	break;
	    case 26: // add group
	    	page_26(&db,user,sdb);
	    	break;
	    case 27: // remove group
	    	page_27(&db,user);
	    	break;

	// index
	    case 28: // create index page
	    	sprintf(sql,"select count(*) from indexs where owner=%ld",usernum);
	    	page_4(&db,sdb,stbl,NULL,user,cs,"Create",user -> superuser || (qd -> get_count(sql) < user -> maxindexs));
	    	break;
	    case 29: // change index page
	    	page_4(&db,sdb,stbl,sindex,user,cs,"Change",0);
	    	break;
	    case 30: // delete index page
	    	page_4(&db,sdb,stbl,sindex,user,cs,"Delete",0);
	    	break;
	    case 31: // read index
	    	read_comments(&db,sdb,stbl,sapp,sfld,sindex,user,cs);
	    	break;
	    case 32: // write index
	    	write_comment(&db,sdb,stbl,sapp,sfld,sindex,user,cs,"index");
	    	break;

	// applications
	    case 33: // create app page
	    	sprintf(sql,"select count(*) from applications where owner=%ld",usernum);
	    	page_5(&db,sdb,sapp,user,cs,"Create",user -> superuser || (qd -> get_count(sql) < user -> maxapps));
	    	break;
	    case 34: // change app page
	    	page_5(&db,sdb,sapp,user,cs,"Change",0);
	    	break;
	    case 35: // delete app page
	    	page_5(&db,sdb,sapp,user,cs,"Delete",0);
	    	break;
	    case 36: // read app
	    	read_comments(&db,sdb,stbl,sapp,sfld,sindex,user,cs);
	    	break;
	    case 37: // write app
	    	write_comment(&db,sdb,stbl,sapp,sfld,sindex,user,cs,"app");
	    	break;
	    case 38: // diagram
	    	generate_diagram(db,q,sql,sdb);
	    	break;
	    case 39: // dot -> png
	    	make_dot_png(db,q,sql,sdb);
	    	break;
	}
	if (ddebug) printf("<b>End.</b><br>\n");
	fflush(stdout);


// End 
	delete form;
	delete cs;
	delete sql;
	delete qd;
	if (sdb)
		delete sdb;
	if (stbl)
		delete stbl;
	if (sapp)
		delete sapp;
	if (sfld)
		delete sfld;
	if (sindex)
		delete sindex;
	if (kommentar)
		delete kommentar;
	delete user;
	if (a)
		delete a;
	return 0;
}

