// checks.cpp
/*
Copyright (C) 2001-2004  Anders Hedstrom (grymse@alhem.net)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include <unistd.h>
#include <libsql++.h>
#include <libdbd.h>
#include <string>
using std::string;
#include <libcgi++.h>

#include "dbd.h"
#include "utils.h"
#include "html.h"
#include "gsql.h"
#include "reserved.h"
#include "pages.h"


/*
 * check database, table, field
 */

db::Dbs *check_db(Database *db,Query& qin,Form *form,Cookies *cs,long sel,db::Users *user,short *refresh)
{
	Query *qd = new Query(db);
	db::Dbs *sdb = NULL;
	db::Access *a;
	db::Kommentar *k;
	db::Grplinks *gl;
	char *kommentar = NULL;
	long seldb = sel;
	long l,q;
	long usernum = user -> num;
	long grpnum;
	short ir;		// is_reserved(newname)
	short ok = 0;
	char slask[300];
	char newname[40];
	char sql[200];
	char description[80];
	char oldname[40];
	char tmp[80];

	// create database
	if (form -> getvalue("createdb",slask,20) && *slask && atoi(slask))
	{
		if (!form -> getvalue("name",newname,40))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");
		if (!form -> getvalue("grpnum",slask,20))
			error("grpnum");
		grpnum = atol(slask);
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(kommentar);

		ir = is_reserved(newname);
		if (ir)
			sprintf(errstr,"'%s' is a reserved word",newname);

		sprintf(sql,"select num from dbs where name='%s'",qin.safestr(newname).c_str());
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"There already exists a database with the name '%s'",newname);
		if (!name_ok(newname))
			sprintf(errstr,"Invalid characters in name '%s'",newname);

		sprintf(sql,"select count(*) from dbs where owner=%ld",user -> num);
		q = qd -> get_count(sql);

		if (q >= user -> maxdbs && !user -> superuser)
			sprintf(errstr,"Allowed number of databases already created");

		if (!ir && !l && name_ok(newname) && (user -> superuser || q < user -> maxdbs))
		{
			sdb = new db::Dbs(db);	// create empty object
			sdb -> owner = usernum;
			strcpy(sdb -> createdate,datetime());
			strcpy(sdb -> name,newname);
			strcpy(sdb -> description,description);
			seldb = sdb -> insert();
			set_cookie(cs,"seldb",seldb);
			delete sdb;
			sdb = NULL;

			a = new db::Access(db);
			a -> usernum = usernum;
			a -> dbnum = seldb;
			a -> r = 1;		// copy access
			a -> w = 1;
			a -> c = 1;
			a -> d = 1;
			a -> rdata = 1;
			a -> wdata = 1;
			a -> insert();
			delete a;

			gl = new db::Grplinks(db);
			gl -> usernum = user -> num;
			gl -> grpnum = grpnum;
			gl -> dbnum = seldb;
			gl -> save();
			delete gl;

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> dbnum = seldb;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Created");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
#ifdef LIVEDB
		// mysqladmin create database
			sprintf(slask,"%s create %s > /dev/null 2>/dev/null",MYSQLADMIN,newname);
			syscall(slask);
#endif
			*refresh = *refresh + 1;
		}
	}

	if (seldb > 0)
	{
		sprintf(sql,"select num from access where usernum=%ld and dbnum=%ld",user -> num,seldb);
		if (qd -> get_count(sql))
			sdb = new db::Dbs(db,seldb);
		else
			seldb = 0;
	}

	sprintf(sql,"select * from access where usernum=%ld and dbnum=%ld",user -> num,seldb);
	a = new db::Access(db,sql);

	// change database
	if (sdb && form -> getvalue("changedb",slask,20) && *slask && atoi(slask) && a -> w)
	{
		if (!form -> getvalue("num",slask,20))
			error("num");
		l = atol(slask);
		if (l != sdb -> num)
			error("sdb num mismatch");
		if (!form -> getvalue("name",newname,20))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");
		if (!form -> getvalue("grpnum",slask,20))
			error("grpnum");
		grpnum = atol(slask);
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(kommentar);

		ir = is_reserved(newname);
		if (ir)
		{
			if (!strcmp(newname,sdb -> name))	// no change
			{
				sprintf(warningstr,"'%s' is a reserved word",newname);
				ok++;
			} else
				sprintf(errstr,"'%s' is a reserved word",newname);
		}

		sprintf(sql,"select num from dbs where name='%s' and num<>%ld",qin.safestr(newname).c_str(),sdb -> num);
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"There already exists a database with the name '%s'",newname);
		if (!name_ok(newname))
			sprintf(errstr,"Invalid characters in name '%s'",newname);

		if ((ok || !ir) && !l && name_ok(newname))
		{
			strcpy(oldname,sdb -> name);

			sdb -> changedby = usernum;
			strcpy(sdb -> changedate,datetime());
			strcpy(sdb -> name,newname);
			strcpy(sdb -> description,description);
			sdb -> version++;
			sdb -> update();

			sprintf(sql,"update grplinks set grpnum=%ld where usernum=%ld and dbnum=%ld",grpnum,user -> num,sdb -> num);
//strcpy(errstr,sql);
			qd -> execute(sql);

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> dbnum = seldb;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Changed");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
#ifdef LIVEDB
		// mysqldump olddb > tmp
		// mysqladmin create newdb
		// mysql newdb < tmp
		// mysqladmin drop olddb
			if (strcmp(oldname,newname))
			{
				sprintf(tmp,"/tmp/mysqldump.%d",getpid());
				sprintf(slask,"%s %s > %s",MYSQLDUMP,oldname,tmp);
				syscall(slask);
				sprintf(slask,"%s create %s > /dev/null 2>/dev/null",MYSQLADMIN,newname);
				syscall(slask);
				sprintf(slask,"%s %s < %s",MYSQL,newname,tmp);
				syscall(slask);
				sprintf(slask,"echo y | %s drop %s > /dev/null 2>/dev/null",MYSQLADMIN,oldname);
				syscall(slask);
			}
#endif
			*refresh = *refresh + 1;
		}
	}

	// delete database
	if (sdb && form -> getvalue("deletedb",slask,20) && *slask && atoi(slask) && a -> d)
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(sdb -> name);
//		dbsafestr(sdb -> description);
//		dbsafestr(kommentar);

		sdb -> deleted = !sdb -> deleted;
		sdb -> deletedby = usernum;
		strcpy(sdb -> deletedate,datetime());
		sdb -> version++;
		sdb -> update();

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> dbnum = seldb;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"Deleted");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
#ifdef LIVEDB
		// TODO:

		if (sdb -> deleted)
		{
		// drop database

		} else
		{
		// create and resync?

		}
#endif
		*refresh = *refresh + 1;
	}

// write comment
	if (sdb && form -> getvalue("writedb",slask,20) && *slask && atoi(slask))
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(kommentar);

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> dbnum = seldb;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"A comment");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
	}


	if (kommentar)
		delete kommentar;
	delete qd;
	delete a;
	return sdb;
}

db::Tbls *check_tbl(Database *db,Query& qin,Form *form,Cookies *cs,db::Dbs *sdb,long sel,db::Users *user,short *refresh)
{
	Query *qd = new Query(db);
	db::Tbls *stbl = NULL;
	db::Kommentar *k;
	db::Access *a;
	db::Flds *sfld;
	db::Dbs *tempdb;
	db::Indexs *tempindex;
	db::Indexlist *il;
	char *kommentar = NULL;
	long seltbl = sel;
	long l,q;
	long usernum = user -> num;
	long dbnum;
	long olddbnum;
	long tblgrpnum;
	short ir;		// is_reserved(newname)
	short ok = 0;
	char slask[300];
	char newname[40];
	char sql[200];
	char description[80];
	char oldname[40];

	sprintf(sql,"select * from access where usernum=%ld and dbnum=%ld",user -> num,sdb ? sdb -> num : 0);
	a = new db::Access(db,sql);

	// create table
	if (sdb && form -> getvalue("createtbl",slask,20) && *slask && atoi(slask) && a -> c)
	{
		if (!form -> getvalue("name",newname,40))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");
		if (!form -> getvalue("tblgrpnum",slask,20))
			error("tblgrpnum");
		tblgrpnum = atol(slask);
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(kommentar);

		ir = is_reserved(newname);
		if (ir)
			sprintf(errstr,"'%s' is a reserved word",newname);

		sprintf(sql,"select num from tbls where dbnum=%ld and name='%s'",sdb -> num,qin.safestr(newname).c_str());
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"Table '%s' already exists in database '%s' (may be deleted)",newname,sdb -> name);

		if (!name_ok(newname))
			sprintf(errstr,"Invalid characters in name '%s'",newname);

		sprintf(sql,"select count(*) from tbls where owner=%ld",user -> num);
		q = qd -> get_count(sql);

		if (q >= user -> maxtbls && !user -> superuser)
			sprintf(errstr,"Allowed number of tables already created");

		if (!ir && !l && name_ok(newname) && (user -> superuser || q < user -> maxtbls))
		{
			stbl = new db::Tbls(db);	// create empty object
			stbl -> dbnum = sdb -> num;
			stbl -> owner = usernum;
			strcpy(stbl -> createdate,datetime());
			strcpy(stbl -> name,newname);
			strcpy(stbl -> description,description);
			stbl -> tblgrpnum = tblgrpnum;
			seltbl = stbl -> insert();
			set_cookie(cs,"seltbl",seltbl);

			sdb -> changedby = usernum;
			strcpy(sdb -> changedate,datetime());
			sdb -> version++;
			sdb -> update();

			// create field "num" if (user -> autocreatenum)
			if (user -> flags & UF_AUTOCREATENUM)
			{
				sfld = new db::Flds(db);	// create empty object
				sfld -> tblnum = stbl -> num;
				sfld -> owner = usernum;
				strcpy(sfld -> createdate,datetime());
				strcpy(sfld -> name,"num");
				strcpy(sfld -> description,"autocreated primary key auto_increment field");
				sfld -> fieldtype = 2;
				strcpy(sfld -> fieldstr,"INT");
				sfld -> fieldflags = FF_AUTO_INCREMENT;
				sfld -> decimallength = 0;
				*sfld -> defaultvalue = 0;
				sfld -> charlength = 0;
				sfld -> integerlength = 11;
				sfld -> minvalue = 0;
				sfld -> maxvalue = -1;
				sfld -> options = new char[1];
				strcpy(sfld -> options,"");
				sfld -> ptrtotblnum = 0;
				sfld -> ordning = 1;
				set_cookie(cs,"selfld",sfld -> insert());
				
				tempindex = new db::Indexs(db);
				tempindex -> tblnum = stbl -> num;
				tempindex -> owner = usernum;
				strcpy(tempindex -> createdate,datetime());
				strcpy(tempindex -> description,"autocreated primary key");
				strcpy(tempindex -> name,"PrimaryKey");
				strcpy(tempindex -> typ,"PRIMARY");
				tempindex -> save();
				
				il = new db::Indexlist(db);
				il -> indexnum = tempindex -> num;
				il -> fldnum = sfld -> num;
				il -> length = -1;
				il -> save();
				
				delete tempindex;
				delete il;
			} else
				sfld = NULL;

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> tblnum = seltbl;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Created");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
#ifdef LIVEDB
		// TODO: OK
		// mysql 'create db'
			if (sfld)
			{
				strcpy(description,typestring(sfld));
				sprintf(slask,"echo \"create table %s ( %s %s, primary key(%s) )\" | %s %s > /dev/null 2>/dev/null",
				 stbl -> name,
				 sfld -> name,
				 description,
				 sfld -> name,
				 MYSQL,sdb -> name);
//printf("\nsyscall '%s'<br>\n",slask);
				syscall(slask);
			}
#endif
			delete stbl;
			stbl = NULL;
			if (sfld)
			{
				delete sfld;
				sfld = NULL;
			}
			*refresh = *refresh + 1;
		}
	}

	if (seltbl > 0)
	{
		stbl = new db::Tbls(db,seltbl);
		sprintf(sql,"select num from access where usernum=%ld and dbnum=%ld",user -> num,stbl -> dbnum);
		if (!qd -> get_count(sql))
		{
			seltbl = 0;
			delete stbl;
			stbl = NULL;
		}
	}

	// change table
	if (sdb && stbl && form -> getvalue("changetbl",slask,20) && *slask && atoi(slask) && a -> w)
	{
		if (!form -> getvalue("num",slask,20))
			error("num");
		l = atol(slask);
		if (l != stbl -> num)
			error("stbl num mismatch");
		if (!form -> getvalue("name",newname,20))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");
		if (!form -> getvalue("dbnum",slask,20))
			error("dbnum");
		dbnum = atol(slask);
		if (!form -> getvalue("tblgrpnum",slask,20))
			error("tblgrpnum");
		tblgrpnum = atol(slask);
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(kommentar);

		ir = is_reserved(newname);
		if (ir)
		{
			if (!strcmp(newname,stbl -> name))
			{
				sprintf(warningstr,"'%s' is a reserved word",newname);
				ok++;
			} else
				sprintf(errstr,"'%s' is a reserved word",newname);
		}

		sprintf(sql,"select num from tbls where dbnum=%ld and name='%s' and num<>%ld",sdb -> num,qin.safestr(newname).c_str(),stbl -> num);
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"Table '%s' already exists in database '%s' (may be deleted)",newname,sdb -> name);

		if (!name_ok(newname))
			sprintf(errstr,"Invalid characters in name '%s'",newname);

		if ((ok || !ir) && !l && name_ok(newname))
		{
			olddbnum = stbl -> dbnum;
			strcpy(oldname,stbl -> name);

			stbl -> dbnum = dbnum;
			stbl -> changedby = usernum;
			strcpy(stbl -> changedate,datetime());
			strcpy(stbl -> name,newname);
			strcpy(stbl -> description,description);
			stbl -> tblgrpnum = tblgrpnum;
			stbl -> version++;
			stbl -> update();

			sdb -> changedby = usernum;
			strcpy(sdb -> changedate,datetime());
			sdb -> version++;
			sdb -> update();

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> tblnum = seltbl;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Changed");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
#ifdef LIVEDB
			// TODO: OK 
			// kolla om table flyttats till annan databas
			//  ... mysqldump sdb stbl > tmp
			//  ... mysql drop stbl
			//  ... mysql newdb < tmp
			if (stbl -> dbnum != olddbnum)
			{
				tempdb = new db::Dbs(db,stbl -> dbnum);
				sprintf(slask,"%s %s %s > /tmp/table.%s.sql",
				 MYSQLDUMP,sdb -> name,stbl -> name,stbl -> name);
				syscall(slask);
				sprintf(slask,"%s %s < /tmp/table.%s.sql",MYSQL,tempdb -> name,stbl -> name);
				if (!syscall(slask))
				{
					sprintf(slask,"echo \"drop table %s\" | %s %s",stbl -> name,MYSQL,sdb -> name);
					syscall(slask);
				}
				delete tempdb;
			}

		// mysql 'alter table ... rename'
			if (strcmp(oldname,newname))
			{
				sprintf(sql,"select count(*) from flds where tblnum=%ld",stbl -> num);
				if (qd -> get_count(sql))
				{
					sprintf(slask,"echo \"alter table %s rename %s\" | %s %s > /dev/null 2>/dev/null",
					 oldname,newname,MYSQL,sdb -> name);
					syscall(slask);
				}
			}
#endif
			*refresh = *refresh + 1;
		}
	}

	// delete table
	if (sdb && stbl && form -> getvalue("deletetbl",slask,20) && *slask && atoi(slask) && a -> d)
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(stbl -> name);
//		dbsafestr(stbl -> description);
//		dbsafestr(kommentar);

		stbl -> deleted = !stbl -> deleted;
		stbl -> deletedby = usernum;
		strcpy(stbl -> deletedate,datetime());
		stbl -> version++;
		stbl -> update();

		sdb -> changedby = usernum;
		strcpy(sdb -> changedate,datetime());
		sdb -> version++;
		sdb -> update();

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> tblnum = seltbl;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"Deleted");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
#ifdef LIVEDB
		if (stbl -> deleted)
		{
		// TODO: mysqldump sdb stbl > sdb.stbl.backup.sql
		//  mysql drop stbl

		} else
		{
		// TODO: mysql sdb < sdb.stbl.backup.sql
		
		}
#endif
		*refresh = *refresh + 1;
	}

// write comment
	if (sdb && stbl && form -> getvalue("writetbl",slask,20) && *slask && atoi(slask))
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(kommentar);

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> tblnum = seltbl;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"A comment");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
	}

	if (kommentar)
		delete kommentar;
	delete qd;
	delete a;
	return stbl;
}

db::Flds *check_fld(Database *db,Query& qin,Form *form,Cookies *cs,db::Dbs *sdb,db::Tbls *stbl,long sel,db::Users *user,short *refresh,db::Applications *sapp)
{
	Query q(db);
	Query *qd = new Query(db);
	db::Flds *sfld = NULL;
	db::Kommentar *k;
	db::Access *a;
	db::Flds *tempfld;
	db::Tbls *temptbl;
	char *kommentar = NULL;
	char *sql = new char[500];
	long selfld = sel;
	long l,qq,prevl = 0;
	long usernum = user -> num;
	long tblnum;
	long charlength,minvalue,maxvalue;
	long ptrtotblnum;
	long integerlength;
	long fieldtype;
	long fldnum = 0;
	long oldtblnum;
	long fieldflags;
	long decimallength;
	long numberlength;
	short ordning,prevordning = 0;
	short ir;		// is_reserved(newname)
	short ok = 0;
	short visa_status = 0;
	char slask[300];
	char newname[40];
	char *options = NULL;
	char description[80];
	char oldname[40];
	char fieldstr[40];
	char defaultvalue[40];
	char status[40];

	sprintf(sql,"select * from access where usernum=%ld and dbnum=%ld",user -> num,sdb ? sdb -> num : 0);
	a = new db::Access(db,sql);

	if (sapp && stbl && !form -> getvalue("createfld",slask,20))
	{
		sprintf(sql,"select checked from apptables where appnum=%ld and tblnum=%ld",sapp -> num,stbl -> num);
		visa_status = qd -> get_count(sql);
	}

	// create field
	if (sdb && stbl && form -> getvalue("createfld",slask,20) && *slask && atoi(slask) && a -> c)
	{
		fieldflags = 0;

		if (!form -> getvalue("name",newname,40))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");

// fieldtype 1-char,2-int,3-datetime,4-enum/options,5-ptr
// charlength
// integerlength
// minvalue
// maxvalue
// options
// ptrtotable

		if (!form -> getvalue("fieldtype",slask,20))
			error("fieldtype");
		fieldtype = atol(slask);

		sprintf(slask,"fieldstr%ld",fieldtype);
		form -> getvalue(slask,fieldstr,40);
		if (!form -> getvalue("defaultvalue",defaultvalue,40))
			error("defaultvalue");
		if (!form -> getvalue("numberlength",slask,20))
			error("numberlength");
		numberlength = atol(slask);
		if (!form -> getvalue("decimallength",slask,20))
			error("decimallength");
		decimallength = atol(slask);
		if (form -> getvalue("nullok",slask,20) && *slask && atoi(slask))
			fieldflags |= FF_ALLOWNULL;
		if (form -> getvalue("autoincr",slask,20) && *slask && atoi(slask))
			fieldflags |= FF_AUTO_INCREMENT;

		if (!form -> getvalue("charlength",slask,20))
			error("length");
		charlength = atol(slask);
		if (!strcmp(fieldstr,"CHAR") || !strcmp(fieldstr,"VARCHAR"))
			if (charlength > 255)
			{
				charlength = 255;
				sprintf(errstr,"Max string length for type %s is 255 characters - modified",fieldstr);
			}
		if (!form -> getvalue("integerlength",slask,20))
			error("length");
		integerlength = atol(slask);
		if (!form -> getvalue("minvalue",slask,20))
			error("minvalue");
		minvalue = atol(slask);
		if (!form -> getvalue("maxvalue",slask,20))
			error("maxvalue");
		if (*slask)
			maxvalue = atol(slask);
		else
			maxvalue = -1;
		l = form -> getlength("options");
		options = new char[l + 144];
		if (!form -> getvalue("options",options,l + 144))
			error("options");
		if (!form -> getvalue("ptrtotable",slask,20))
			error("ptrtotable");
		ptrtotblnum = atol(slask);
		if (visa_status)
		{
			if (!form -> getvalue("status",status,40))
				error("status");
		}
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(options);
//		dbsafestr(defaultvalue);
//		dbsafestr(kommentar);

		ir = is_reserved(newname);
		if (ir)
			sprintf(errstr,"'%s' is a reserved word",newname);

		sprintf(sql,"select num from flds where tblnum=%ld and name='%s'",stbl -> num,qin.safestr(newname).c_str());
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"Field '%s' already exists in table '%s' (may be deleted)",newname,stbl -> name);

		if (!name_ok(newname))
			sprintf(errstr,"Invalid characters in name '%s'",newname);

		sprintf(sql,"select count(*) from flds where owner=%ld",user -> num);
		qq = qd -> get_count(sql);

		if (qq >= user -> maxflds && !user -> superuser)
			sprintf(errstr,"Allowed number of fields already created");

		if (!ir && !l && name_ok(newname) && (user -> superuser || qq < user -> maxflds))
		{
			sprintf(sql,"select max(ordning) from flds where tblnum=%ld",stbl -> num);
			ordning = qd -> get_count(sql);

/*
CREATE TABLE flds (
  num int(11) DEFAULT '0' NOT NULL auto_increment,
  tblnum int(11) DEFAULT '0' NOT NULL,
  owner int(11) DEFAULT '0' NOT NULL,
  createdate datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  changedby int(11) DEFAULT '0' NOT NULL,
  changedate datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  deleted tinyint(1) DEFAULT '0' NOT NULL,
  deletedby int(11) DEFAULT '0' NOT NULL,
  deletedate datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  name varchar(40) DEFAULT '' NOT NULL,
  version int(11) DEFAULT '0' NOT NULL,
  fieldtype tinyint(1) DEFAULT '0' NOT NULL,
  charlength int(11) DEFAULT '0' NOT NULL,
  minvalue int(11) DEFAULT '0' NOT NULL,
  maxvalue int(11) DEFAULT '0' NOT NULL,
  options text NOT NULL,
  ptrtotblnum int(11) DEFAULT '0' NOT NULL,
  ordning int(11) DEFAULT '0' NOT NULL,
  integerlength int(11) DEFAULT '0' NOT NULL,
  description varchar(80) DEFAULT '' NOT NULL,
  fieldstr varchar(20) DEFAULT '' NOT NULL,
  fieldflags tinyint(3) DEFAULT '0' NOT NULL,
  decimallength int(11) DEFAULT '0' NOT NULL,
  defaultvalue varchar(40) DEFAULT '' NOT NULL,
  PRIMARY KEY (num)
);
*/
			sfld = new db::Flds(db);	// create empty object
			sfld -> tblnum = stbl -> num;
			sfld -> owner = usernum;
			strcpy(sfld -> createdate,datetime());
			strcpy(sfld -> name,newname);
			strcpy(sfld -> description,description);
			sfld -> fieldtype = fieldtype;
			strcpy(sfld -> fieldstr,fieldstr);
			sfld -> fieldflags = fieldflags;
			sfld -> decimallength = decimallength;
			strcpy(sfld -> defaultvalue,defaultvalue);
			sfld -> charlength = charlength;
			sfld -> integerlength = (fieldtype == 2) ? integerlength : numberlength;
			sfld -> minvalue = minvalue;
			sfld -> maxvalue = maxvalue;
			sfld -> options = new char[strlen(options) + 1];
			strcpy(sfld -> options,options);
			sfld -> ptrtotblnum = ptrtotblnum;
			sfld -> ordning = ordning + 1;
//			strcpy(sfld -> status,status);
			if (visa_status)
			{
				sprintf(sql,"update appfields set status='%s' where appnum=%ld and fldnum=%ld",status,sapp -> num,sfld -> num);
				qd -> execute(sql);
			}
			selfld = sfld -> insert();
			set_cookie(cs,"selfld",selfld);

			stbl -> changedby = usernum;
			strcpy(stbl -> changedate,datetime());
			stbl -> version++;
			stbl -> update();

			sdb -> changedby = usernum;
			strcpy(sdb -> changedate,datetime());
			sdb -> version++;
			sdb -> update();

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> fldnum = selfld;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Created");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
#ifdef LIVEDB
			sprintf(sql,"select count(*) from flds where tblnum=%ld",stbl -> num);
			if (qd -> get_count(sql) == 1)
			{
				strcpy(description,typestring(sfld));
				sprintf(slask,"echo \"create table %s ( %s %s )\" | %s %s > /dev/null 2>/dev/null",
				 stbl -> name,
				 newname,
				 description,
				 MYSQL,sdb -> name);
				syscall(slask);
			} else
			{
				strcpy(description,typestring(sfld));
				sprintf(slask,"echo \"alter table %s add column %s %s\" | %s %s > /dev/null 2>/dev/null",
				 stbl -> name,newname,description,MYSQL,sdb -> name);
				syscall(slask);
			}
#endif
			delete sfld;
			sfld = NULL;
			*refresh = *refresh + 0;
		}
	}

	if (selfld > 0)
	{
		sfld = new db::Flds(db,selfld);
		sprintf(sql,"select dbnum from tbls where num=%ld",sfld -> tblnum);
		l = qd -> get_count(sql);
		sprintf(sql,"select num from access where usernum=%ld and dbnum=%ld",user -> num,l);
		if (!qd -> get_count(sql))
		{
			selfld = 0;
			delete sfld;
			sfld = NULL;
		}
	}

	// change field
	if (sdb && stbl && sfld && form -> getvalue("changefld",slask,20) && *slask && atoi(slask) && a -> w)
	{
		fieldflags = 0;

		if (!form -> getvalue("num",slask,20))
			error("num");
		l = atol(slask);
		if (l != sfld -> num)
			error("sfld num mismatch");
		if (!form -> getvalue("name",newname,20))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");
		if (!form -> getvalue("tblnum",slask,20))
			error("tblnum");
		tblnum = atol(slask);

// fieldtype 1-char,2-int,3-datetime,4-enum/options,5-ptr
// charlength
// integerlength
// minvalue
// maxvalue
// options
// ptrtotable

		if (!form -> getvalue("fieldtype",slask,20))
			error("fieldtype");
		fieldtype = atol(slask);

		sprintf(slask,"fieldstr%ld",fieldtype);
		form -> getvalue(slask,fieldstr,40);
		if (!form -> getvalue("defaultvalue",defaultvalue,40))
			error("defaultvalue");
		if (!form -> getvalue("numberlength",slask,20))
			error("numberlength");
		numberlength = atol(slask);
		if (!form -> getvalue("decimallength",slask,20))
			error("decimallength");
		decimallength = atol(slask);
		if (form -> getvalue("nullok",slask,20) && *slask && atoi(slask))
			fieldflags |= FF_ALLOWNULL;
		if (form -> getvalue("autoincr",slask,20) && *slask && atoi(slask))
			fieldflags |= FF_AUTO_INCREMENT;

		if (!form -> getvalue("charlength",slask,20))
			error("length");
		charlength = atol(slask);
		if (!strcmp(fieldstr,"CHAR") || !strcmp(fieldstr,"VARCHAR"))
			if (charlength > 255)
			{
				charlength = 255;
				sprintf(errstr,"Max string length for type %s is 255 characters - modified",fieldstr);
			}
		if (!form -> getvalue("integerlength",slask,20))
			error("length");
		integerlength = atol(slask);
		if (!form -> getvalue("minvalue",slask,20))
			error("minvalue");
		minvalue = atol(slask);
		if (!form -> getvalue("maxvalue",slask,20))
			error("maxvalue");
		if (*slask)
			maxvalue = atol(slask);
		else
			maxvalue = -1;
		l = form -> getlength("options");
		options = new char[l + 144];
		if (!form -> getvalue("options",options,l + 144))
			error("options");
		if (!form -> getvalue("ptrtotable",slask,20))
			error("ptrtotable");
		ptrtotblnum = atol(slask);
		if (visa_status)
		{
			if (!form -> getvalue("status",status,40))
				error("status");
		}
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(options);
//		dbsafestr(defaultvalue);
//		dbsafestr(kommentar);

		ir = is_reserved(newname);
		if (ir)
		{
			if (!strcmp(newname,sfld -> name))
			{
				sprintf(warningstr,"'%s' is a reserved word",newname);
				ok++;
			} else
				sprintf(errstr,"'%s' is a reserved word",newname);
		}

		sprintf(sql,"select num from flds where tblnum=%ld and name='%s' and num<>%ld",stbl -> num,qin.safestr(newname).c_str(),sfld -> num);
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"Field '%s' already exists in table '%s' (may be deleted)",newname,stbl -> name);

		if (!name_ok(newname))
			sprintf(errstr,"Invalid characters in name '%s'",newname);

		if ((ok || !ir) && !l && name_ok(newname))
		{
			oldtblnum = sfld -> tblnum;
			strcpy(oldname,sfld -> name);

			sfld -> tblnum = tblnum;
			sfld -> changedby = usernum;
			strcpy(sfld -> changedate,datetime());
			strcpy(sfld -> name,newname);
			strcpy(sfld -> description,description);
			sfld -> fieldtype = fieldtype;
			strcpy(sfld -> fieldstr,fieldstr);
			sfld -> fieldflags = fieldflags;
			sfld -> decimallength = decimallength;
			strcpy(sfld -> defaultvalue,defaultvalue);
			sfld -> charlength = charlength;
			sfld -> integerlength = (fieldtype == 2) ? integerlength : numberlength;
			sfld -> minvalue = minvalue;
			sfld -> maxvalue = maxvalue;
			if (strcmp(sfld -> options,options))
			{
				delete sfld -> options;
				sfld -> options = new char[strlen(options) + 1];
				strcpy(sfld -> options,options);
			}
			sfld -> ptrtotblnum = ptrtotblnum;
//			strcpy(sfld -> status,status);
			if (visa_status)
			{
				sprintf(sql,"update appfields set status='%s' where appnum=%ld and fldnum=%ld",status,sapp -> num,sfld -> num);
				qd -> execute(sql);
			}
			sfld -> version++;
			sfld -> update();

			stbl -> changedby = usernum;
			strcpy(stbl -> changedate,datetime());
			stbl -> version++;
			stbl -> update();

			sdb -> changedby = usernum;
			strcpy(sdb -> changedate,datetime());
			sdb -> version++;
			sdb -> update();

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> fldnum = selfld;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Changed");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
#ifdef LIVEDB
			// TODO OK:
			// kolla om sfld byter table....
			//  i sa fall
			//  mysql stbl drop column sfld
			//  mysql newtbl add column sfld..
			if (sfld -> tblnum != oldtblnum)
			{
				temptbl = new db::Tbls(db,sfld -> tblnum);
				sprintf(slask,"echo \"alter table %s add column %s %s\" | %s %s > /dev/null 2>/dev/null",
				 temptbl -> name,sfld -> name,typestring(sfld),MYSQL,sdb -> name);
				syscall(slask);
				sprintf(slask,"echo \"alter table %s drop column %s\" | %s %s > /dev/null 2>/dev/null",
				 stbl -> name,sfld -> name,MYSQL,sdb -> name);
				syscall(slask);
				delete temptbl;
			}

			strcpy(description,typestring(sfld));
			sprintf(slask,"echo \"alter table %s change column %s %s %s\" | %s %s > /dev/null 2>/dev/null",
			 stbl -> name,oldname,newname,description,MYSQL,sdb -> name);
			syscall(slask);
#endif
			*refresh = *refresh + 0;
		}
	}

	// delete field
	if (sdb && stbl && sfld && form -> getvalue("deletefld",slask,20) && *slask && atoi(slask) && a -> d)
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(sfld -> name);
//		dbsafestr(sfld -> description);
//		dbsafestr(sfld -> options);
//		dbsafestr(sfld -> defaultvalue);
//		dbsafestr(kommentar);

		sfld -> deleted = !sfld -> deleted;
		sfld -> deletedby = usernum;
		strcpy(sfld -> deletedate,datetime());
		sfld -> version++;
		sfld -> update();

		stbl -> changedby = usernum;
		strcpy(stbl -> changedate,datetime());
		stbl -> version++;
		stbl -> update();

		sdb -> changedby = usernum;
		strcpy(sdb -> changedate,datetime());
		sdb -> version++;
		sdb -> update();

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> fldnum = selfld;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"Deleted");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
#ifdef LIVEDB
		if (sfld -> deleted)
		{
			sprintf(slask,"echo \"alter table %s drop column %s\" | %s %s",
			 stbl -> name,sfld -> name,MYSQL,sdb -> name);
			syscall(slask);
		} else
		{
		// stoppa tillbaka efter fg field
			sprintf(sql,"select num from flds where tblnum=%ld and ordning<%ld order by ordning desc limit 1",
			 stbl -> num,sfld -> ordning);
			l = qd -> get_count(sql);
			if (!l)	// first
			{
				strcpy(description,typestring(sfld));
				sprintf(slask,"echo \"alter table %s add column %s %s first\" | %s %s > /dev/null 2>/dev/null",
				 stbl -> name,sfld -> name,description,MYSQL,sdb -> name);
				syscall(slask);
			} else // after
			{
				tempfld = new db::Flds(db,l);
				strcpy(description,typestring(sfld));
				sprintf(slask,"echo \"alter table %s add column %s %s after %s\" | %s %s > /dev/null 2>/dev/null",
				 stbl -> name,sfld -> name,description,tempfld -> name,MYSQL,sdb -> name);
				syscall(slask);
				delete tempfld;
			}
		}
#endif
		*refresh = *refresh + 0;
	}

// write comment
	if (sdb && stbl && sfld && form -> getvalue("writefld",slask,20) && *slask && atoi(slask))
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(kommentar);

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> fldnum = selfld;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"A comment");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
	}


// up
	if (sdb && stbl && form -> getvalue("up",slask,20) && *slask && (fldnum = atol(slask)) != 0)
	{
// drop column [fldnum]
		sprintf(sql,"select num,ordning from flds where tblnum=%ld order by ordning",stbl -> num);
		q.get_result(sql);
		while (q.fetch_row())
		{
			l = q.getval();
			ordning = q.getval();
			if (l == fldnum)
			{
				sprintf(sql,"update flds set ordning=%d where num=%ld",
				 ordning,prevl);
				qd -> execute(sql);
				sprintf(sql,"update flds set ordning=%d where num=%ld",
				 prevordning,l);
				qd -> execute(sql);
				break;
			}
			prevl = l;
			prevordning = ordning;
		}
		q.free_result();
	}

// down
	if (sdb && stbl && form -> getvalue("down",slask,20) && *slask && (fldnum = atol(slask)) != 0)
	{
// drop column [fldnum]
		sprintf(sql,"select num,ordning from flds where tblnum=%ld order by ordning",stbl -> num);
		q.get_result(sql);
		while (q.fetch_row())
		{
			l = q.getval();
			ordning = q.getval();
			if (prevl == fldnum)
			{
				sprintf(sql,"update flds set ordning=%d where num=%ld",
				 ordning,prevl);
				qd -> execute(sql);
				sprintf(sql,"update flds set ordning=%d where num=%ld",
				 prevordning,l);
				qd -> execute(sql);
				break;
			}
			prevl = l;
			prevordning = ordning;
		}
		q.free_result();
	}


	if (kommentar)
		delete kommentar;
	if (options)
		delete options;
	delete sql;
	delete qd;
	delete a;
	return sfld;
}

db::Indexs *check_index(Database *db,Query& qin,Form *form,Cookies *cs,db::Dbs *sdb,db::Tbls *stbl,long sel,db::Users *user,short *refresh,short *ci)
{
	Query q(db);
	Query *qd = new Query(db);
	db::Indexs *sindex = NULL;
	db::Access *a;
	db::Kommentar *k;
	db::Indexlist *il;
	char *kommentar = NULL;
	long selindex = sel;
	long l,qty;
	long usernum = user -> num;
	long fldnum,length;
	short ir;		// is_reserved(newname)
	char slask[300];
	char newname[40];
	char sql[200];
	char description[80];
	char oldname[40];
	char typ[40];

	sprintf(sql,"select * from access where usernum=%ld and dbnum=%ld",user -> num,sdb ? sdb -> num : 0);
	a = new db::Access(db,sql);

	// create index
	if (form -> getvalue("createindex",slask,20) && *slask && atoi(slask))
	{
		if (!form -> getvalue("name",newname,40))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");
		if (!form -> getvalue("typ",typ,40))
			error("typ");
		if (!form -> getvalue("fldnum",slask,20))
			error("fldnum");
		fldnum = atol(slask);
		if (!form -> getvalue("length",slask,20))
			error("length");
		if (*slask)
			length = atol(slask);
		else
			length = -1;
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(kommentar);

		ir = is_reserved(newname);
		if (ir)
			sprintf(errstr,"'%s' is a reserved word",newname);

		sprintf(sql,"select num from indexs where tblnum=%ld and name='%s'",stbl -> num,qin.safestr(newname).c_str());
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"There already exists a index with the name '%s'",newname);
		if (!name_ok(newname))
			sprintf(errstr,"Invalid characters in name '%s'",newname);

		sprintf(sql,"select count(*) from indexs where owner=%ld",user -> num);
		qty = qd -> get_count(sql);

		if (qty >= user -> maxindexs && !user -> superuser)
			sprintf(errstr,"Allowed number of indexes already created");

		if (!ir && !l && name_ok(newname) && (user -> superuser || qty < user -> maxindexs))
		{
			sindex = new db::Indexs(db);	// create empty object
			sindex -> owner = usernum;
			strcpy(sindex -> createdate,datetime());
			strcpy(sindex -> name,newname);
			strcpy(sindex -> description,description);
			strcpy(sindex -> typ,typ);
			sindex -> tblnum = stbl -> num;
			selindex = sindex -> insert();
			set_cookie(cs,"selindex",selindex);

			il = new db::Indexlist(db);
			il -> indexnum = sindex -> num;
			il -> fldnum = fldnum;
			il -> length = length;
			il -> save();
			delete il;
			delete sindex;
			sindex = NULL;

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> indexnum = selindex;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Created");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
#ifdef LIVEDB
#endif
			*refresh = *refresh + 0;
		}
	}

	if (selindex > 0)
	{
		sindex = new db::Indexs(db,selindex);
		sprintf(sql,"select dbnum from tbls where num=%ld",sindex -> tblnum);
		l = qd -> get_count(sql);
		sprintf(sql,"select num from access where usernum=%ld and dbnum=%ld",user -> num,l);
		if (!qd -> get_count(sql))
		{
			selindex = 0;
			delete sindex;
			sindex = NULL;
		}
	} else
		l = 0;

	// change index
	if (sindex && form -> getvalue("changeindex",slask,20) && *slask && atoi(slask) && a -> w)
	{
		if (!form -> getvalue("num",slask,20))
			error("num");
		l = atol(slask);
		if (l != sindex -> num)
			error("sindex num mismatch");
		if (!form -> getvalue("name",newname,20))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");
		if (!form -> getvalue("typ",typ,40))
			error("typ");
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(kommentar);

		ir = is_reserved(newname);
		if (ir)
			sprintf(errstr,"'%s' is a reserved word",newname);

		sprintf(sql,"select num from indexs where name='%s' and tblnum=%ld and num<>%ld",qin.safestr(newname).c_str(),stbl -> num,sindex -> num);
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"There already exists an index with the name '%s'",newname);
		if (!name_ok(newname))
			sprintf(errstr,"Invalid characters in name '%s'",newname);

		if (!ir && !l && name_ok(newname))
		{
			strcpy(oldname,sindex -> name);

			sindex -> changedby = usernum;
			strcpy(sindex -> changedate,datetime());
			strcpy(sindex -> name,newname);
			strcpy(sindex -> description,description);
			strcpy(sindex -> typ,typ);
			sindex -> version++;
			sindex -> update();

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> indexnum = selindex;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Changed");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
#ifdef LIVEDB
#endif
			*refresh = *refresh + 0;
		}
	}

	// delete index
	if (sindex && form -> getvalue("deleteindex",slask,20) && *slask && atoi(slask) && a -> d)
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(sindex -> name);
//		dbsafestr(sindex -> description);
//		dbsafestr(kommentar);

		sindex -> deleted = !sindex -> deleted;
		sindex -> deletedby = usernum;
		strcpy(sindex -> deletedate,datetime());
		sindex -> version++;
		sindex -> update();

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> indexnum = selindex;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"Deleted");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
#ifdef LIVEDB
#endif
		*refresh = *refresh + 0;
	}

// write comment
	if (sindex && form -> getvalue("writeindex",slask,20) && *slask && atoi(slask))
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(kommentar);

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> indexnum = selindex;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"A comment");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
	}


// add field
	if (sindex && form -> getvalue("add",slask,20) && *slask)
	{
		if (!form -> getvalue("fldnum",slask,20))
			error("fldnum");
		fldnum = atol(slask);
		if (!form -> getvalue("length",slask,20))
			error("length");
		if (*slask)
			length = atol(slask);
		else
			length = -1;

		il = new db::Indexlist(db);
		il -> indexnum = sindex -> num;
		il -> fldnum = fldnum;
		il -> length = length;
		il -> save();

		*ci = 1;
	}


// check change indexlist
	if (sindex)
	{
		sprintf(sql,"select num from indexlist where indexnum=%ld",sindex -> num);
		q.get_result(sql);
		while (q.fetch_row())
		{
			l = q.getval();
			sprintf(slask,"change%ld",l);
			if (form -> getvalue(slask,slask,20) && *slask)
			{
				sprintf(slask,"length%ld",l);
				if (!form -> getvalue(slask,slask,20))
					error("length");
				length = atol(slask);
				sprintf(sql,"update indexlist set length=%ld where num=%ld",length,l);
				qd -> execute(sql);
				*ci = 1;
			}
			sprintf(slask,"delete%ld",l);
			if (form -> getvalue(slask,slask,20) && *slask)
			{
				sprintf(sql,"delete from indexlist where num=%ld",l);
				qd -> execute(sql);
				*ci = 1;
			}
		}
		q.free_result();
#ifdef LIVEDB
#endif
	}

	if (kommentar)
		delete kommentar;
	delete qd;
	delete a;
	return sindex;
}

db::Applications *check_app(Database *db,Query& qin,Form *form,Cookies *cs,db::Dbs *sdb,long sel,db::Users *user,short *refresh)
{
	Query *qd = new Query(db);
	db::Applications *sapp = NULL;
	db::Kommentar *k;
	db::Access *a;
	char *kommentar = NULL;
	long selapp = sel;
	long l,q;
	long usernum = user -> num;
	long dbnum;
	long olddbnum;
	char slask[300];
	char newname[40];
	char sql[200];
	char description[80];
	char oldname[40];

	sprintf(sql,"select * from access where usernum=%ld and dbnum=%ld",user -> num,sdb ? sdb -> num : 0);
	a = new db::Access(db,sql);

	// create application
	if (sdb && form -> getvalue("createapp",slask,20) && *slask && atoi(slask) && a -> c)
	{
		if (!form -> getvalue("name",newname,40))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(kommentar);

		sprintf(sql,"select num from applications where dbnum=%ld and name='%s'",sdb -> num,qin.safestr(newname).c_str());
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"db::Application '%s' already exists in database '%s' (may be deleted)",newname,sdb -> name);

		sprintf(sql,"select count(*) from applications where owner=%ld",user -> num);
		q = qd -> get_count(sql);

		if (q >= user -> maxapps && !user -> superuser)
			sprintf(errstr,"Allowed number of applications already created");

		if (!l && (user -> superuser || q < user -> maxapps))
		{
			sapp = new db::Applications(db);	// create empty object
			sapp -> dbnum = sdb -> num;
			sapp -> owner = usernum;
			strcpy(sapp -> createdate,datetime());
			strcpy(sapp -> name,newname);
			strcpy(sapp -> description,description);
			selapp = sapp -> insert();
			set_cookie(cs,"selapp",selapp);

			sdb -> changedby = usernum;
			strcpy(sdb -> changedate,datetime());
			sdb -> version++;
			sdb -> update();

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> appnum = selapp;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Created");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
			delete sapp;
			sapp = NULL;
			*refresh = *refresh + 1;
		}
	}

	if (selapp > 0)
	{
		sapp = new db::Applications(db,selapp);
		sprintf(sql,"select num from access where usernum=%ld and dbnum=%ld",user -> num,sapp -> dbnum);
		if (!qd -> get_count(sql))
		{
			selapp = 0;
			delete sapp;
			sapp = NULL;
		}
	}

	// change application
	if (sdb && sapp && form -> getvalue("changeapp",slask,20) && *slask && atoi(slask) && a -> w)
	{
		if (!form -> getvalue("num",slask,20))
			error("num");
		l = atol(slask);
		if (l != sapp -> num)
			error("sapp num mismatch");
		if (!form -> getvalue("name",newname,20))
			error("name");
		if (!form -> getvalue("description",description,80))
			error("description");
		if (!form -> getvalue("dbnum",slask,20))
			error("dbnum");
		dbnum = atol(slask);
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(newname);
//		dbsafestr(description);
//		dbsafestr(kommentar);

		sprintf(sql,"select num from applications where dbnum=%ld and name='%s' and num<>%ld",sdb -> num,qin.safestr(newname).c_str(),sapp -> num);
		l = qd -> get_count(sql);

		if (l)
			sprintf(errstr,"db::Application '%s' already exists in database '%s' (may be deleted)",newname,sdb -> name);

		if (!l)
		{
			olddbnum = sapp -> dbnum;
			strcpy(oldname,sapp -> name);

			sapp -> dbnum = dbnum;
			sapp -> changedby = usernum;
			strcpy(sapp -> changedate,datetime());
			strcpy(sapp -> name,newname);
			strcpy(sapp -> description,description);
			sapp -> version++;
			sapp -> update();

			sdb -> changedby = usernum;
			strcpy(sdb -> changedate,datetime());
			sdb -> version++;
			sdb -> update();

			if (*kommentar)
			{
				k = new db::Kommentar(db);
				k -> appnum = selapp;
				k -> usernum = usernum;
				strcpy(k -> dateposted,datetime());
				strcpy(k -> reason,"Changed");
				k -> kommentar = new char[strlen(kommentar) + 1];
				strcpy(k -> kommentar,kommentar);
				k -> insert();
				delete k;
			}
			*refresh = *refresh + 1;
		}
	}

	// delete application
	if (sdb && sapp && form -> getvalue("deleteapp",slask,20) && *slask && atoi(slask) && a -> d)
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(sapp -> name);
//		dbsafestr(sapp -> description);
//		dbsafestr(kommentar);

		sapp -> deleted = !sapp -> deleted;
		sapp -> deletedby = usernum;
		strcpy(sapp -> deletedate,datetime());
		sapp -> version++;
		sapp -> update();

		sdb -> changedby = usernum;
		strcpy(sdb -> changedate,datetime());
		sdb -> version++;
		sdb -> update();

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> appnum = selapp;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"Deleted");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
		*refresh = *refresh + 1;
	}

// write comment
	if (sdb && sapp && form -> getvalue("writeapp",slask,20) && *slask && atoi(slask))
	{
		l = form -> getlength("kommentar");
		kommentar = new char[l + 144];
		form -> getvalue("kommentar",kommentar,l + 144);
		textareain(kommentar);

//		dbsafestr(kommentar);

		if (*kommentar)
		{
			k = new db::Kommentar(db);
			k -> appnum = selapp;
			k -> usernum = usernum;
			strcpy(k -> dateposted,datetime());
			strcpy(k -> reason,"A comment");
			k -> kommentar = new char[strlen(kommentar) + 1];
			strcpy(k -> kommentar,kommentar);
			k -> insert();
			delete k;
		}
	}

	if (kommentar)
		delete kommentar;
	delete qd;
	delete a;
	return sapp;
}
